/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2004-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */


#include "log.h"


int log_level = 1;


void set_log_level (int log_lvl)
{
    log_level = log_lvl;
}


int get_log_level (void)
{
    return log_level;
}


#define ENABLE_LCMAPS_LOGGING

void Log( int msg_level, const char *fmt, ...)
{
    va_list argp;
    
#ifndef ENABLE_LCMAPS_LOGGING
    
    if ( log_level >= msg_level )
    {
        if (msg_level == L_WARN )  fprintf( stderr, "Warning: " );
        if (msg_level == L_INFO )  fprintf( stderr, "Info:    " );
        if (msg_level == L_DEBUG ) fprintf( stderr, "Debug:   " );
        
        va_start( argp, fmt );
        vfprintf (stderr, fmt, argp);
        vsprintf (bericht, fmt, argp);
        va_end( argp );
        fprintf( stderr, "\n" );
    }
#else
    char bericht[VERIFY_LOG_BUFFER_SIZE];
    int  num = 0; 
    
    va_start( argp, fmt );
    num = vsnprintf (bericht, VERIFY_LOG_BUFFER_SIZE, fmt, argp);
    va_end( argp );

    if (num > strlen (bericht))
    {
        /* Adding to "..." to end of bericht */
        bericht [VERIFY_LOG_BUFFER_SIZE - 4] = bericht [VERIFY_LOG_BUFFER_SIZE - 3] = bericht [VERIFY_LOG_BUFFER_SIZE - 2] = '.';
        bericht [VERIFY_LOG_BUFFER_SIZE - 1] = '\0';
    }
    

    if (msg_level == L_WARN)
        lcmaps_log(LOG_WARNING, "Warning: %s\n", bericht);
        /* lcmaps_log_debug (msg_level + 1, "Warning: %s\n", bericht); */
    else if (msg_level == L_INFO)
        lcmaps_log_debug (msg_level + 1, "Info:    %s\n", bericht);
    else if (msg_level == L_DEBUG)
        lcmaps_log_debug (msg_level + 1, "Debug:   %s\n", bericht);
#endif
}

void Error( const char *operation, const char *fmt, ...)
{
    va_list argp;

#ifndef ENABLE_LCMAPS_LOGGING
    fprintf( stderr, "ERROR:  %s: ", operation );
    va_start( argp, fmt );
    vfprintf( stderr, fmt, argp );
    va_end( argp );
    fprintf( stderr, "\n" );
    
#else
    char bericht[VERIFY_LOG_BUFFER_SIZE];
    int  num = 0; 

    
    va_start( argp, fmt );
    num = vsnprintf (bericht, VERIFY_LOG_BUFFER_SIZE, fmt, argp);
    va_end( argp );

    if (num > strlen (bericht))
    {
        /* Adding to "..." to end of bericht */
        bericht [VERIFY_LOG_BUFFER_SIZE - 4] = bericht [VERIFY_LOG_BUFFER_SIZE - 3] = bericht [VERIFY_LOG_BUFFER_SIZE - 2] = '.';
        bericht [VERIFY_LOG_BUFFER_SIZE - 1] = '\0';
    }

    lcmaps_log (LOG_ERR, "Error: %s: %s\n", operation, bericht);
#endif
}

