#include <stdio.h>
#include <stdlib.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>

/* Minimum time between getting filesystem usages */
#define DUINTERVAL 10
/* Max no of filesystems we can watch */
#define MAXFILESYSTEMS 20
/* Default window geometry */
#define DEFAULTWIDTH 40
#define DEFAULTHEIGHT 100
/* Minimum window size */
#define MINWIDTH 25
#define MINHEIGHT 75
/* Default filesystem usage% before highlighting */
#define DEFAULTWARNPCT 90
/* Default hostname font */
#define HOSTFONT "-schumacher-clean-medium-r-*-*-7-*-*-*-*-*-*-*"
/* Default font for stats popup window */
#define POPUPFONT "-misc-fixed-medium-r-*-*-10-*-*-*-*-*-*-*"
/* Default load digit font */
#define DIGITFONT "6x10"

Bool dosync;
char hostname[25];
GC gc, rgc, ggc, ygc, blgc, ptextgc;
GC tgc, bgc, bkgc;
GC popgc, poptgc, popbgc;
GC warngc, hlgc, metergc;
Display *disp;
Window win, popup, root, info;
XFontStruct *pfont, *font2, *font;
int screen, depth;
int fontheight;
unsigned int width, height, pw, ph;
unsigned int pwidth, pheight;
unsigned int rwidth, rheight;
double load, avg, davg;
int processes;
int warnpct;
Bool menuhl;
Bool shrinkpopup;


unsigned int yel;
XColor popbg;


void Doinit(), GetLoadPoint(), GetUptime(), Getgeom(), ShowInfo();
void GetMemInfo(), GetDiskUsage(), draw_popup(), do_popup(), do_popdown();
void dobevels(), infodown();
char * commanum();
Window MakePopup();


/* Structure to hold the maximum load info */
typedef struct _maxload {
	int num;		/* Where we are on the bar graph */
	float load;	/* Actual load - unused */
	long time;	/* Time it  was recorded - unused */
} _maxload;

/* Holds info for disk usages */
typedef struct _use {
	char *path;	/* Mount point */
	char *dev;	/* Actual device */
	char *type;	/* Type of fs */
	long blocks;	/* Total blocks */
	long bfree;	/* Free blocks */
} Diskusage;

typedef struct _muse {
	char *muse;
	char *suse;
	long shared;
	long cached;
	long swaptotal;
	long swapfree;
	long memtotal;
	long memfree;
} Memusage;

Memusage memory;

Diskusage usages[MAXFILESYSTEMS];
_maxload maxload;

#ifndef LINUX
long boot_time;
#endif
