/* error.hh - error and warning handling
 * Copyright 2004 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "error.hh"
#include <glibmm.h>
#include <iostream>

namespace shevek
{
  static bool _break_on_error = true;

  void _error_impl (Glib::ustring const &message, bool is_error, char const *file, unsigned line, char const *fun)
  {
    std::cerr << file << " (" << fun << "):" << line
	      << (is_error ? ":Error: " : ":Warning: ") << message
	      << '\n';
    if (is_error && _break_on_error)
      {
	throw message;
      }
    /*
    else
      {
	std::cerr << (is_error ? "Error: " : "Warning: ") << message << '\n';
      }
    */
  }

  bool fatal_errors (bool fatal)
  {
    bool retval = _break_on_error;
    _break_on_error = fatal;
    return retval;
  }
}
