/*############################################################################*/
/*#                                                                          #*/
/*#  Ambisonic C++ Library                                                   #*/
/*#  Copyright © 2017 Videolabs                                              #*/
/*#                                                                          #*/
/*#  Filename:      AmbisonicProcessor.cpp                                   #*/
/*#  Version:       0.2                                                      #*/
/*#  Date:          19/05/2007                                               #*/
/*#  Author(s):     Peter Stitt                                              #*/
/*#  Licence:       LGPL                                                     #*/
/*#                                                                          #*/
/*############################################################################*/

// Decoder coefficients for Ambisonics to stereo. Useful for conversion to 2-channels when not using headphone.
const float decoder_coefficient_stereo[][16] =
{
{0.5f, 0.5f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f},
{0.5f, -0.5f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};

// First order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_first_5_0[][4] =
{
{0.30052038200428266f, 0.405f, 0.f, 0.36f},
{0.30052038200428266f, -0.405f, 0.f, 0.36f},
{0.33234018715767727f, 0.415f, 0.f, -0.33f},
{0.33234018715767727f, -0.415f, 0.f, -0.33f},
{0.1414213562373095f, 0.f, 0.f, 0.16f},
{1.f, 0.f, 0.f, 0.f}
};

// Second order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_second_5_0[][9] =
{
{0.28637824638055176f, 0.31f, 0.f, 0.32f, 0.125f, 0.f, 0.f, 0.f, 0.085f},
{0.28637824638055176f, -0.31f, 0.f, 0.32f, -0.125f, 0.f, 0.f, 0.f, 0.085f},
{0.44901280605345767f, 0.28f, 0.f, -0.335f, 0.08f, 0.f, 0.f, 0.f, -0.08f},
{0.44901280605345767f, -0.28f, 0.f, -0.335f, -0.08f, 0.f, 0.f, 0.f, -0.08f},
{0.060104076400856542f, 0.f, 0.f, 0.04f, 0.f, 0.f, 0.f, 0.f, 0.045f},
{1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};

// Third order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_third_5_0[][16] =
{
{0.21920310216782971f, 0.285f, 0.f, 0.31f, 0.185f, 0.f, 0.f, 0.f, 0.005f, 0.06f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.025f},
{0.21920310216782971f, -0.285f, 0.f, 0.31f, -0.185f, 0.f, 0.f, 0.f, 0.005f, -0.06f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.025f},
{0.417193000900063, 0.385f, 0.f, -0.335f, 0.02f, 0.f, 0.f, 0.f, -0.025f, -0.065f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.025f},
{0.417193000900063, -0.385f, 0.f, -0.335f, -0.02f, 0.f, 0.f, 0.f, -0.025f, 0.065f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.025f},
{0.095459415460183911f, 0.f, 0.f, 0.265f, 0.f, 0.f, 0.f, 0.f, 0.215f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.105f},
{1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};

// 7.1 Decoders
// First order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_first_7_0[][4] =
{
{0.30308181575488646f, 0.28787490443249214f, 0.f, 0.34272772121390443f},
{0.30308181575488646f, -0.28787490443249214f, 0.f, 0.34272772121390443f},
{0.30009778241942736f, 0.37430033313047179f, 0.f, -0.0523422745233887f},
{0.30009778241942736f, -0.37430033313047179f, 0.f, -0.0523422745233887f},
{0.25945829376797824f, 0.15979898864340947f, 0.f, -0.35198623716283389f},
{0.25945829376797824f, -0.15979898864340947f, 0.f, -0.35198623716283389f},
{0.06626228564058137f, 0.f, 0.f, 0.095210812676599921f},
{1.f, 0.f, 0.f, 0.f}
};

// Second order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_second_7_0[][9] =
{
{0.26896393630070314f, 0.2709745668854639f, 0.f, 0.33307200497530487f, 0.22433488075008498f, 0.f, 0.f, 0.f, 0.078679822045804593f},
{0.26896393630070314f, -0.2709745668854639f, 0.f, 0.33307200497530487f, -0.22433488075008498f, 0.f, 0.f, 0.f, 0.078679822045804593f},
{0.22948297665554251f, 0.41008280179471662f, 0.f, -0.054360126227611147f, -0.10476597132557182f, 0.f, 0.f, 0.f, -0.2450067176493739f},
{0.22948297665554251f, -0.41008280179471662f, 0.f, -0.054360126227611147f, 0.10476597132557182f, 0.f, 0.f, 0.f, -0.2450067176493739f},
{0.21645598391364895f, 0.12603526868653919f, 0.f, -0.34865953106709735f, -0.19439141860648643f, 0.f, 0.f, 0.f, 0.16002559219324736f},
{0.21645598391364895f, -0.12603526868653919f, 0.f, -0.34865953106709735f, 0.19439141860648643f, 0.f, 0.f, 0.f, 0.16002559219324736f},
{0.058222192649695928f, 0.f, 0.f, 0.14679885940974668f, 0.f, 0.f, 0.f, 0.f, 0.12646383057249522f},
{1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};

// Third order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_third_7_0[][16] =
{
{0.23847510284225448f, 0.25761751778631614f, 0.f, 0.34463028654078742f, 0.27286527097797886f, 0.f, 0.f, 0.f, 0.075817007084867383f, 0.043776344516003145f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.043292764924363215f},
{0.23847510284225448f, -0.25761751778631614f, 0.f, 0.34463028654078742f, -0.27286527097797886f, 0.f, 0.f, 0.f, 0.075817007084867383f, -0.043776344516003145f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.043292764924363215f},
{0.21488180395671747f, 0.37212604986843822f, 0.f, -0.052740545567596789f, -0.090318754761869027f, 0.f, 0.f, 0.f, -0.30127480640031568f, -0.083356938191225013f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.057110836888053296f},
{0.21488180395671747f, -0.37212604986843822f, 0.f, -0.052740545567596789f, 0.090318754761869027f, 0.f, 0.f, 0.f, -0.30127480640031568f, 0.083356938191225013f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.057110836888053296f},
{0.19790378665445343f, 0.13006961576227122f, 0.f, -0.347019896114917f, -0.24181954278731474f, 0.f, 0.f, 0.f, 0.17064607963676698f, 0.12038634953113594f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.013078288693401134f},
{0.19790378665445343f, -0.13006961576227122f, 0.f, -0.347019896114917f, 0.24181954278731474f, 0.f, 0.f, 0.f, 0.17064607963676698f, -0.12038634953113594f, 0.f, 0.f, 0.f, 0.f, 0.f, -0.013078288693401134f},
{0.0771438313771552f, 0.f, 0.f, 0.13686146076905328f, 0.f, 0.f, 0.f, 0.f, 0.15274132598684534f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.17729960735428124f},
{1.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};
