/*
 * Copyright (C) 2009, 2015 XStream Committers.
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 * 
 * Created on 30. April 2009 by Joerg Schaible
 */
package com.thoughtworks.xstream.tools.benchmark.products;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;

import java.io.Writer;

/**
 * Uses XStream with the DOM4J driver for parsing XML.
 *
 * @author Joe Walnes
 * @author J&ouml;rg Schaible
 * @see com.thoughtworks.xstream.tools.benchmark.Harness
 * @see com.thoughtworks.xstream.tools.benchmark.Product
 * @see com.thoughtworks.xstream.XStream
 * @see Dom4JDriver
 * @deprecated As of 1.4.9 use JMH instead
 */
public class XStreamDom4J extends XStreamDriver {

    public XStreamDom4J() {
        super(new Dom4JDriver() {

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out);
            }
            
        }, "XML with DOM4J parser");
    }
}
