
if(RPM_INCLUDE_DIR AND RPM_LIBRARY)
	# Already in cache, be silent
	set(RPM_FIND_QUIETLY TRUE)
endif(RPM_INCLUDE_DIR AND RPM_LIBRARY)

set(RPM_LIBRARY)
set(RPM_INCLUDE_DIR)

FIND_PATH(RPM_INCLUDE_DIR rpm/rpmdb.h
	/usr/include
	/usr/local/include
)

set(RPM_SUSPECT_VERSION "RPM_SUSPECT_VERSION-NOTFOUND" )
if ( RPM_INCLUDE_DIR )
	FIND_PATH(RPM_SUSPECT_VERSION rpm/rpm4compat.h
		${RPM_INCLUDE_DIR}
		NO_DEFAULT_PATH
	)
	if ( RPM_SUSPECT_VERSION )
		set(RPM_SUSPECT_VERSION "5.x" )
	else ( RPM_SUSPECT_VERSION )
		set(RPM_SUSPECT_VERSION "4.x" )
	endif ( RPM_SUSPECT_VERSION )
endif ( RPM_INCLUDE_DIR )


FIND_LIBRARY(RPM_LIBRARY NAMES rpm
	PATHS
	/usr/lib
	/usr/local/lib
)

if(RPM_INCLUDE_DIR AND RPM_LIBRARY)
   MESSAGE( STATUS "rpm found: includes in ${RPM_INCLUDE_DIR}, library in ${RPM_LIBRARY} (suspect ${RPM_SUSPECT_VERSION})")
   set(RPM_FOUND TRUE)
else(RPM_INCLUDE_DIR AND RPM_LIBRARY)
   MESSAGE( STATUS "rpm not found")
endif(RPM_INCLUDE_DIR AND RPM_LIBRARY)

MARK_AS_ADVANCED(RPM_INCLUDE_DIR RPM_LIBRARY)
