\name{computeResidualLm}
\alias{computeResidualLm}
\title{Computes a linear model's residuals}
\description{
This ROT function, called from a LinearModelFactory, is given two
samples and a parameter vector. It is used to predict the values   
corresponding to the explanatory variables through the linear model, then  
compare them with the second sample. It returns the difference between both 
samples.                                                                    
}
\usage{
computeResidualLm(x, beta, y)
}
\arguments{
  \item{x}{A m-by-n matrix containing the explanatory variables.}
  \item{beta}{A n-by-1 vector containing the linear model parameters.}
  \item{y}{A n-by-1 vector containing the response variables.}
}
\value{
A m-by-1 vector is returned, containing the difference between 
predicted and response values.}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
set.seed(1)
x <- matrix(runif(40), 10, 4)
r <- matrix(c(1,2,3,4), 4, 1)
y <- x \%*\% r 
e <- matrix(rnorm(10, 0, 0.05), 10, 1)
LM <- computeLinearModel(x, y + e)
computeResidualLm(x, LM$parameterEstimate, y)
}
\keyword{ multivariate }
