# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1512-1 (evolution)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60497);
 script_cve_id("CVE-2008-0072");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1512-1 (evolution)";
 script_name(name);

 desc = "The remote host is missing an update to evolution
announced via advisory DSA 1512-1.

Ulf Hrnhammar discovered that Evolution, the e-mail and groupware suite,
had a format string vulnerability in the parsing of encrypted mail messages.
If the user opened a specially crafted email message, code execution was
possible.

For the stable distribution (etch), this problem has been fixed in version
2.6.3-6etch2.

For the old stable distribution (sarge), this problem has been fixed in
version 2.0.4-2sarge3. Some architectures have not yet completed building
the updated package for sarge at this time, they will be added as they
come available.

For the unstable distribution (sid), this problem has been fixed in
version 2.12.3-1.1.

We recommend that you upgrade your evolution package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201512-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1512-1 (evolution)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"evolution-dev", ver:"2.0.4-2sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution", ver:"2.0.4-2sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-common", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-dev", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-plugins-experimental", ver:"2.6.3-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
