###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_dos_vuln_nov09_lin.nasl 5567 2009-11-02 14:15:33Z nov $
#
# Mozilla Firefox Denial Of Service Vulnerability Nov-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801135);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3382");
  script_bugtraq_id(36866);
  script_name("Mozilla Firefox Denial Of Service Vulnerability Nov-09 (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Firefox and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  A memory corruption error in layout/base/nsCSSFrameConstructor.cpp in the
  browser engine can be exploited to potentially execute arbitrary code or
  crash the browser.

  Impact:
  Denial of Service or arbitrary code execution.

  Impact Level: Application/System

  Affected Software/OS:
  Firefox version 3.0 before 3.0.15 on Linux.

  Fix: Upgrade to Firefox version 3.0.15
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  https://bugzilla.mozilla.org/show_bug.cgi?id=514960
  http://www.mozilla.org/security/announce/2009/mfsa2009-64.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Check for Firefox version 3.0 < 3.0.15
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.14")) {
  security_hole(0);
}
