###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_reflection_secureit_unix_mult_vuln_lin.nasl 936 2009-02-06 17:03:29Z feb $
#
# Reflection for Secure IT Multiple Vulnerabilities (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800228);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-6021");
  script_bugtraq_id(30723);
  script_name("Reflection for Secure IT Multiple Vulnerabilities (Linux)");
  desc = "

  Overview: This host is installed with Reflections for Secure IT and is prone
  to Multiple vulnerabilities.

  Vulnerability Insight: Unknow Vector.

  Impact:
  Attacker can get admin privileges.

  Impact level: Application/System

  Affected Software/OS:
  Reflections for Secure IT version prior to 7.0 SP1 on Linux.

  Fix: Apply the security update SP1.
  http://www.attachmate.com/Evals/Evaluate.htm

  References:
  http://support.attachmate.com/techdocs/2288.html
  http://support.attachmate.com/techdocs/2374.html#Security_Updates_in_7.0_SP1

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Reflection for Secure IT");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_reflection_secureit_unix_detect_lin.nasl");
  script_require_keys("Reflection/SecureIT/Linux/Ver");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("version_func.inc");

sshPort = get_kb_item("Services/ssh");
if(!sshPort){
  sshPort = 22;
}

secureItVer = get_kb_item("Reflection/SecureIT/Linux/Ver");
if(!secureItVer){
  exit(0);
}

#Grep for Secure IT for Unix prior to 7.0.1.575 (SP1)
if(version_is_less(version:secureItVer, test_version:"7.0.1.575")){
  security_hole(sshPort);
}
