##############################################################################
#
#  Windows Kernel Elevation of Privilege Vulnerability (954211)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0331
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900051);
  script_bugtraq_id(31651, 31652, 31653);
  script_cve_id("CVE-2008-2250", "CVE-2008-2251", "CVE-2008-2252");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Windows Kernel Elevation of Privilege Vulnerability (954211)");
  script_summary("Check for Hotfix and version of Windows Kernel File");
  desc = "
  MS08-061

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-061.

  Vulnerability Insight:
  Multiple flaws are due to,
  - an error within the processing of window properties passed from
    a parent to a child window when a new window is created.
  - an error while processing unspecified user mode input.
  - a double-free error within the handling of system calls from multiple
    threads.

  Impact: Successfull local exploitation could result in denial of service
  condition due to memory corruption and can execute arbitrary code with
  elevated privileges.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-061.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-061.mspx

  CVSS Score:
    CVSS Base Score     : 4.6 (AV:L/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 3.4
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 954211 (MS08-061)
if(hotfix_missing(name:"954211") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Win32k.sys");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Win32k.sys version < 5.0.2195.7194
  if(egrep(pattern:"^5\.0\.2195\.([0-6]?[0-9]?[0-9]?[0-9]|7(0[0-9][0-9]|" +
                   "1[0-8][0-9]|19[0-3]))$", string:sysVer)){
    security_warning(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.3446
    if(egrep(pattern:"^5\.1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-3][0-9][0-9]|" +
                     "4([0-3][0-9]|4[0-5])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.5676
    if(egrep(pattern:"^5\.1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-5][0-9][0-9]|" +
                     "6([0-6][0-9]|7[0-5])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.3212
    if(egrep(pattern:"^5\.2\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3([01][0-9][0-9]|" +
                     "2(0[0-9]|1[01])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.4375
    if(egrep(pattern:"^5\.2\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|" +
                     "3([0-6][0-9]|7[0-4])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}
