/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef DIALOGWIDGET_H
#define DIALOGWIDGET_H

#include <QtGui/QGraphicsWidget>

class QGraphicsLinearLayout;
class QStringList;
namespace Plasma {
    class Slider;
};
class RatingWidget;
class WolfLabel;

class DialogWidget : public QGraphicsWidget
{
    Q_OBJECT

    public:
        DialogWidget(QGraphicsWidget *parent);
        ~DialogWidget(void);

	void updateContents();

    public slots:
	void setVolume(const int& volume);
	void setRating(const int& rating);
	void setPlaylist(const QStringList& playlist);
// 	void setMeterValue(const int, const int);

    signals:
	void ratingChanged(const int& rating);
	void volumeChanged(const int& volume);

    private slots:
	void sliderChanged(int value);

    private:
	QGraphicsLinearLayout *layout;
	Plasma::Slider *volumeSlider;
	RatingWidget *ratingWidget;
	WolfLabel *firstNextSong;
	WolfLabel *secondNextSong;
	WolfLabel *thirdNextSong;
	bool acceptSliderSignal;

};

#endif
