% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{largest_eafdiff}
\alias{largest_eafdiff}
\title{Identify largest EAF differences}
\usage{
largest_eafdiff(data, maximise = FALSE, intervals = 5, reference, ideal = NULL)
}
\arguments{
\item{data}{(\code{list(1)}) A list of matrices with at least 3 columns}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}

\item{intervals}{(\code{integer(1)}) \cr The absolute range of the differences
\eqn{[0, 1]} is partitioned into the number of intervals provided.}

\item{reference}{(\code{numeric()}) \cr Reference point as a vector of numerical values.}

\item{ideal}{(\code{numeric()}) \cr Ideal point as a vector of numerical values.}
}
\value{
(\code{list()}) A list with two components \code{best_pair} and \code{best_value}.
}
\description{
Given a list of datasets, return the indexes of the pair with the largest
EAF differences according to the method proposed by \citet{DiaLop2020ejor}.
}
\examples{
# FIXME: This example is too large, we need a smaller one.
files <- c("wrots_l100w10_dat","wrots_l10w100_dat")
data <- lapply(files, function(x)
               read_datasets(file.path(system.file(package="eaf"),
                             "extdata", x)))
nadir <- apply(do.call(rbind, data)[,1:2], 2, max)
x <- largest_eafdiff(data, reference = nadir)
str(x)

}
\references{
\insertAllCited{}
}
