% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-tile.R
\name{grd_tile}
\alias{grd_tile}
\alias{grd_tile.wk_grd_rct}
\alias{grd_tile.wk_grd_xy}
\title{Extract normalized grid tiles}
\usage{
grd_tile(grid, level, i, j = NULL)

\method{grd_tile}{wk_grd_rct}(grid, level, i, j = NULL)

\method{grd_tile}{wk_grd_xy}(grid, level, i, j = NULL)
}
\arguments{
\item{grid}{A \code{\link[=grd_xy]{grd_xy()}}, \code{\link[=grd_rct]{grd_rct()}}, or other object
implementing \verb{grd_*()} methods.}

\item{level}{An integer describing the overview level. This is related to
the \code{step} value by a power of 2 (i.e., a level of \code{1} indicates a step of
\code{2}, a level of \code{2} indicates a step of \code{4}, etc.).}

\item{i, j}{1-based index values. \code{i} indices correspond to decreasing
\code{y} values; \code{j} indices correspond to increasing \code{x} values.
Values outside the range \code{1:nrow|ncol(data)} will be censored to
\code{NA} including 0 and negative values.}
}
\value{
A \code{\link[=grd_subset]{grd_subset()}}ed version
}
\description{
Unlike \code{\link[=grd_tile_template]{grd_tile_template()}}, which returns a \code{\link[=grd]{grd()}} whose elements are
the boundaries of the specified tiles with no data attached, \code{\link[=grd_tile]{grd_tile()}}
returns the actual tile with the data.
}
\examples{
grid <- grd_rct(volcano)
plot(grd_tile(grid, 4, 1, 1))

plot(grd_tile(grid, 3, 1, 1), add = TRUE)
plot(grd_tile(grid, 3, 1, 2), add = TRUE)
plot(grd_tile(grid, 3, 2, 1), add = TRUE)
plot(grd_tile(grid, 3, 2, 2), add = TRUE)

grid <- as_grd_xy(grd_tile(grid, 4, 1, 1))
plot(grid, add = TRUE, pch = ".")
plot(grd_tile(grid, 3, 1, 1), add = TRUE, col = "green", pch = ".")
plot(grd_tile(grid, 3, 1, 2), add = TRUE, col = "red", pch = ".")
plot(grd_tile(grid, 3, 2, 1), add = TRUE, col = "blue", pch = ".")
plot(grd_tile(grid, 3, 2, 2), add = TRUE, col = "magenta", pch = ".")

}
