<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  version="1.0" >

  <!-- docbook customization layer -->

  <xsl:import href="http://docbook.sourceforge.net/release/xsl/current/fo/docbook.xsl"/>

  
  <!-- general settings -->
    
  <xsl:param name="xep.extensions"          select="'1'"/>
  <xsl:param name="region.before.extent"    select="'1.5cm'"/>
  <xsl:param name="body.margin.top"         select="'1.8cm'"/>
  <xsl:param name="header.column.widths"    select="'1 0 1'"/>  
  <xsl:param name="toc.indent.width"        select="'10'"/>
  <xsl:param name="insert.xref.page.number" select="'1'"/>
  <xsl:param name="section.autolabel"       select="'1'"/>
  <xsl:param name="section.label.includes.component.label" select="'1'"/>
  <xsl:param name="paper.type" select="'A4'"/>


  <!-- add logo to page header -->
    
  <xsl:template name="header.content">
    <xsl:param name="pageclass"/>
    <xsl:param name="sequence"/>
    <xsl:param name="position"/>
    <xsl:param name="gentext-key"/>

    <fo:block>
      <xsl:choose>
        <xsl:when test="$position='right'">
          Subcommander  <fo:external-graphic content-width="25%" src="url(images/logo.png)"/>
        </xsl:when>
      </xsl:choose>
    </fo:block>
    
  </xsl:template>


  <!-- change xref page display  -->
  <xsl:template name="page.citation" text=" (p. %p)"/>


  <!-- do not indent the first line of the first paragraph -->
  
  <xsl:template match="para[1]">
     <fo:block text-indent="0em">
       <xsl:apply-imports/>
     </fo:block>
  </xsl:template>
  
  <xsl:template match="para">
     <fo:block text-indent="1em">
       <xsl:apply-imports/>
     </fo:block>
  </xsl:template>
  

  <!-- titlepage customization -->
  <!-- copied and modified from fo/titlepage.templates.xsl -->
  
  <xsl:attribute-set name="book.titlepage.recto.style">
    <xsl:attribute name="text-align">right</xsl:attribute>
  </xsl:attribute-set>

  <xsl:template match="title" mode="book.titlepage.recto.auto.mode"> 
    <fo:block
      space-before="10mm"
      xsl:use-attribute-sets="book.titlepage.recto.style"
      font-size="24.8832pt" 
      font-weight="bold" 
      font-family="{$title.font.family}">
      <xsl:call-template name="division.title">
        <xsl:with-param name="node" select="ancestor-or-self::book[1]"/>
      </xsl:call-template>
    </fo:block>
    <fo:block text-align="right">
      <fo:external-graphic src="url(images/logo.png)"/>
    </fo:block>
  </xsl:template>

  <xsl:template match="subtitle" mode="book.titlepage.recto.auto.mode">
    <fo:block
      xsl:use-attribute-sets="book.titlepage.recto.style"
      font-size="20.736pt"
      space-before="30mm"
      font-family="{$title.fontset}">
      <xsl:apply-templates select="." mode="book.titlepage.recto.mode"/>
    </fo:block>
  </xsl:template>

<!--
  <xsl:template match="authorgroup" mode="book.titlepage.recto.auto.mode"> 
  </xsl:template>

  <xsl:param name="draft.mode" select="'no'"/>
  <xsl:param name="paper.type" select="'A4'"/>
  <xsl:param name="region.before.extent" select="'1.5cm'"/>
  <xsl:param name="body.margin.top"      select="'1.8cm'"/>
  <xsl:param name="header.column.widths" select="'1 0 1'"/>  
  <xsl:param name="body.font.family" select="'Helvetica'"/>
  <xsl:param name="body.font.master" select="'10'"/>
  <xsl:param name="callout.graphics" select="'0'"/>
-->
  
</xsl:stylesheet>
