/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIRENTRYLVI_H
#define _SC_DIRENTRYLVI_H

// sc
#include "svn/DirEntry.h"

// qt
#include <Qt3Support/Q3ListView>
class QMimeSource;

class DirEntryLvi : public Q3ListViewItem
{
  typedef Q3ListViewItem super;

public:
  DirEntryLvi( Q3ListView* parent, svn::DirEntryPtr entry );
  DirEntryLvi( Q3ListViewItem* parent, svn::DirEntryPtr entry );

  void okRename( int col );

  bool acceptDrop( const QMimeSource* mime ) const;
  
  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( Q3ListViewItem* i, int col, bool ascending ) const;

  void setParentUrl( const QString& parentUrl );
  const QString& getParentUrl() const;
  const svn::DirEntryPtr getEntry() const;

private:
  void init();
  const QString& getSortPrefix() const;

  QString          _parentUrl;
  svn::DirEntryPtr _entry;

  bool             _rename;      ///< we are in a rename?
};

#endif //  _SC_DIRENTRYLVI_H
