/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#ifndef DEFINEGROUPITEMINTEL_H
#define DEFINEGROUPITEMINTEL_H

#include <QWidget>
#include <QFrame>
#include <QMouseEvent>

class QLabel;
class QPushButton;

class DefineGroupItemIntel : public QFrame
{
    Q_OBJECT

public:
    explicit DefineGroupItemIntel(QString groupName);
    ~DefineGroupItemIntel();

public:
    QWidget * widgetComponent();
    QLabel * labelComponent();
    QPushButton * editBtnComponent();
    QPushButton * delBtnComponent();

public:
    void setDeleteable(bool deleteable);
    void setUpdateable(bool updateable);
    void setEditable(bool editable);

    void setShortcutName(QString newName);
    void setShortcutBinding(QString newBinding);

protected:
    virtual void mousePressEvent(QMouseEvent * e);
    virtual void mouseDoubleClickEvent(QMouseEvent * e);


private:
    QWidget * pWidget;
    QLabel * pLabel;
    QPushButton * pEditBtn;
    QPushButton * pDelBtn;

private:
    bool _deleteable;
    bool _editable;
    bool _updateable;

Q_SIGNALS:
    void updateShortcutSignal();

};

#endif // DEFINEGROUPITEMINTEL_H
