#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os

from winswitch.util.simple_logger import Logger
from winswitch.ui.capture_util import screen_capture, PILCaptureDisplay, PyGTKCaptureDisplay, ExecCaptureDisplay
from winswitch.util.main_loop import test_loop, callLater

logger = Logger("capture_util_test")

DISPLAY = os.environ.get("DISPLAY")
FILENAME = "./test.png"
screen_capture_command = ["import -screen -silent -window root -compress JPEG jpeg:"]

def ok_callback(data):
	logger.slog(None, "[%s bytes]" % len(data))
def err_callback(*args):
	logger.serror(None, *args)

def test_capture_default():
	logger.slog()
	screen_capture(None, DISPLAY, None, FILENAME, ok_callback, err_callback)

def test_capture_PIL():
	logger.slog()
	c = PILCaptureDisplay(DISPLAY, FILENAME, ok_callback, err_callback)
	c.capture()

def test_capture_PyGTK():
	logger.slog()
	c = PyGTKCaptureDisplay(FILENAME, ok_callback, err_callback)
	c.capture()

def test_capture_Exec():
	logger.slog()
	env = os.environ.copy()
	del env["DISPLAY"]
	c = ExecCaptureDisplay(screen_capture_command, DISPLAY, os.environ, FILENAME, ok_callback, err_callback)
	c.capture()


def test_all_capture():
	callLater(0, test_capture_default)
	callLater(5, test_capture_PIL)
	callLater(10, test_capture_PyGTK)
	callLater(15, test_capture_Exec)

def main():
	test_loop(test_all_capture)

if __name__ == "__main__":
	main()
