
/***************************************************************************
 *                    __            __ _ ___________                       *
 *                    \ \          / /| |____   ____|                      *
 *                     \ \        / / | |    | |                           *
 *                      \ \  /\  / /  | |    | |                           *
 *                       \ \/  \/ /   | |    | |                           *
 *                        \  /\  /    | |    | |                           *
 *                         \/  \/     |_|    |_|                           *
 *                                                                         *
 *                           Wiimms ISO Tools                              *
 *                         https://wit.wiimm.de/                           *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This file is part of the WIT project.                                 *
 *   Visit https://wit.wiimm.de/ for project details and sources.          *
 *                                                                         *
 *   Copyright (c) 2009-2017 by Dirk Clemens <wiimm@wiimm.de>              *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   See file gpl-2.0.txt or http://www.gnu.org/licenses/gpl-2.0.txt       *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   >>>  This file is automatically generated by './src/gen-ui.c'.  <<<   *
 *   >>>                   Do not edit this file!                    <<<   *
 *                                                                         *
 ***************************************************************************/

#include <getopt.h>
#include "ui-wfuse.h"

//
///////////////////////////////////////////////////////////////////////////////
///////////////                  OptionInfo[]                   ///////////////
///////////////////////////////////////////////////////////////////////////////

static const InfoOption_t OptionInfo[OPT__N_TOTAL+1] =
{
    {0,0,0,0,0,0,0,0}, // OPT_NONE,

    {	OPT_VERSION, false, false, false, false, 'V', "version",
	0,
	"Stop parsing the command line, print a version info and exit."
    },

    {	OPT_HELP, false, false, false, false, 'h', "help",
	0,
	"Stop parsing the command line, print a help message and exit."
    },

    {	OPT_XHELP, false, false, false, false, 0, "xhelp",
	0,
	"Same as --help."
    },

    {	OPT_HELP_FUSE, false, false, false, false, 'H', "help-fuse",
	0,
	"Stop parsing the command line and print a FUSE help message."
    },

    {	OPT_WIDTH, false, false, false, false, 0, "width",
	"width",
	"Define the width (number of columns) for help and some other messages"
	" and disable the automatic detection of the terminal width."
    },

    {	OPT_QUIET, false, false, false, false, 'q', "quiet",
	0,
	"Be quiet and print only error messages."
    },

    {	OPT_VERBOSE, true, false, false, false, 'v', "verbose",
	0,
	"Be verbose and print more progress information."
    },

    {	OPT_IO, true, false, false, false, 0, "io",
	"flags",
	"Setup the IO mode for experiments. The standard file IO is based on"
	" open() function. The value '1' defines that WBFS IO is based on"
	" fopen() function. The value '2' defines the same for ISO files and"
	" value '4' for WIA files. You can combine the values by adding them."
    },

    {	OPT_PARAM, false, false, false, true, 'p', "param",
	"param",
	"The parameter is forwarded to the FUSE command line scanner."
    },

    {	OPT_OPTION, false, false, false, false, 'o', "option",
	"param",
	"This option is forwarded to FUSE command line scanner as '-o param'."
    },

    {	OPT_ALLOW_OTHER, false, false, false, false, 'O', "allow-other",
	0,
	"This option is a short cut for '-o allow_other'. It enables"
	" re-exporting of the mounted file system for example by a samba"
	" server."
    },

    {	OPT_CREATE, false, false, false, false, 'c', "create",
	0,
	"If the mount point does not exist, create it and remove it on"
	" unmount."
    },

    {	OPT_REMOUNT, false, false, false, false, 'r', "remount",
	0,
	"If the mount point is already mounted, try silently to unmount it"
	" first."
    },

    {	OPT_UMOUNT, false, false, false, true, 'u', "umount",
	0,
	"Enter 'unmount mode' and unmount each entered directory by calling"
	" 'fusermount -u mountdir' or alternatively 'umount mountdir'."
    },

    {	OPT_LAZY, false, false, false, false, 'l', "lazy",
	0,
	"Lazy unmount: Detach the mounted file system from the file system"
	" hierarchy now, and cleanup all references to the file system as soon"
	" as it is not busy anymore."
    },

    {0,0,0,0,0,0,0,0} // OPT__N_TOTAL == 16

};

//
///////////////////////////////////////////////////////////////////////////////
///////////////            OptionShort & OptionLong             ///////////////
///////////////////////////////////////////////////////////////////////////////

static const char OptionShort[] = "VhHqvp:o:Ocrul";

static const struct option OptionLong[] =
{
	{ "version",		0, 0, 'V' },
	{ "help",		0, 0, 'h' },
	{ "xhelp",		0, 0, GO_XHELP },
	{ "help-fuse",		0, 0, 'H' },
	 { "helpfuse",		0, 0, 'H' },
	{ "width",		1, 0, GO_WIDTH },
	{ "quiet",		0, 0, 'q' },
	{ "verbose",		0, 0, 'v' },
	{ "io",			1, 0, GO_IO },
	{ "param",		1, 0, 'p' },
	{ "option",		1, 0, 'o' },
	{ "allow-other",	0, 0, 'O' },
	 { "allowother",	0, 0, 'O' },
	{ "create",		0, 0, 'c' },
	{ "remount",		0, 0, 'r' },
	{ "umount",		0, 0, 'u' },
	 { "unmount",		0, 0, 'u' },
	{ "lazy",		0, 0, 'l' },

	{0,0,0,0}
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////            OptionUsed & OptionIndex             ///////////////
///////////////////////////////////////////////////////////////////////////////

static u8 OptionUsed[OPT__N_TOTAL+1] = {0};

static const OptionIndex_t OptionIndex[UIOPT_INDEX_SIZE] = 
{
	/* 0x00   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x10   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x20   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x30   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x40   */	 0,0,0,0, 0,0,0,0, 
	/* 0x48 H */	OPT_HELP_FUSE,
	/* 0x49   */	 0,0,0,0, 0,0,
	/* 0x4f O */	OPT_ALLOW_OTHER,
	/* 0x50   */	 0,0,0,0, 0,0,
	/* 0x56 V */	OPT_VERSION,
	/* 0x57   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 
	/* 0x63 c */	OPT_CREATE,
	/* 0x64   */	 0,0,0,0, 
	/* 0x68 h */	OPT_HELP,
	/* 0x69   */	 0,0,0,
	/* 0x6c l */	OPT_LAZY,
	/* 0x6d   */	 0,0,
	/* 0x6f o */	OPT_OPTION,
	/* 0x70 p */	OPT_PARAM,
	/* 0x71 q */	OPT_QUIET,
	/* 0x72 r */	OPT_REMOUNT,
	/* 0x73   */	 0,0,
	/* 0x75 u */	OPT_UMOUNT,
	/* 0x76 v */	OPT_VERBOSE,
	/* 0x77   */	 0,0,0,0, 0,0,0,0, 0,
	/* 0x80   */	OPT_XHELP,
	/* 0x81   */	OPT_WIDTH,
	/* 0x82   */	OPT_IO,
	/* 0x83   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,
	/* 0x90   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xa0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xb0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xc0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xd0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xe0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xf0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                 InfoOption tabs                 ///////////////
///////////////////////////////////////////////////////////////////////////////

static const InfoOption_t * option_tab_tool[] =
{
	OptionInfo + OPT_VERSION,
	OptionInfo + OPT_HELP,
	OptionInfo + OPT_XHELP,
	OptionInfo + OPT_HELP_FUSE,
	OptionInfo + OPT_WIDTH,
	OptionInfo + OPT_QUIET,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_PARAM,
	OptionInfo + OPT_OPTION,
	OptionInfo + OPT_ALLOW_OTHER,
	OptionInfo + OPT_CREATE,
	OptionInfo + OPT_REMOUNT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_UMOUNT,
	OptionInfo + OPT_LAZY,

	0
};


//
///////////////////////////////////////////////////////////////////////////////
///////////////                   InfoCommand                   ///////////////
///////////////////////////////////////////////////////////////////////////////

static const InfoCommand_t CommandInfo[CMD__N+1] =
{
    {	0,
	false,
	false,
	false,
	"wfuse",
	0,
	"wfuse [option]... source mountdir\n"
	"wfuse --umount mountdir...",
	"Mount a Wii or GameCube image or a WBFS file or partition to a mount"
	" point using FUSE (Filesystem in USErspace). Use 'wfuse --umount"
	" mountdir' for unmounting.",
	0,
	13,
	option_tab_tool,
	0
    },

    {0,0,0,0,0,0,0,0,0,00,}
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                     InfoUI                      ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoUI_t InfoUI_wfuse =
{
	"wfuse",
	0, // n_cmd
	0, // cmd_tab
	CommandInfo,
	0, // n_opt_specific
	OPT__N_TOTAL,
	OptionInfo,
	OptionUsed,
	OptionIndex,
	OptionShort,
	OptionLong
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                       END                       ///////////////
///////////////////////////////////////////////////////////////////////////////

