/* dircompareop.h
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2017 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DIRCOMPAREOP_H
#define DIRCOMPAREOP_H

#include "wdefines.h"
#include "functionproto.h"
#include "nwc_dir.hh"
#include <vector>

class DirCompareWin;

class DirCompareOp : public FunctionProto
{
public:
    DirCompareOp();
    ~DirCompareOp();
    DirCompareOp( const DirCompareOp &other );
    DirCompareOp &operator=( const DirCompareOp &other );
    
    DirCompareOp *duplicate() const;
    bool isName( const char * );
    const char *getName();

    using FunctionProto::run;
    int run( WPUContext *wpu, ActionMessage* );

    const char *getDescription();

    static const char *name;
private:
    enum compare_mode {
        COMPARE_SIZE,
        COMPARE_SIZE_AND_MDATE,
        COMPARE_CONTENT
    };

    enum compare_mode m_compare_mode;

    enum result_mode {
        CHANGE_SELECTION_STATE,
        SHOW_AS_VIRTUAL_DIR
    };

    enum result_mode m_result_mode;

    DirCompareWin *m_progress_win;

    bool m_stop;

    static int s_vdir_number;

    int doConfigure();

    int compareDirs( std::shared_ptr< NWC::Dir > my_dir,
                     std::shared_ptr< NWC::Dir > other_dir,
                     std::vector< bool > *my_equal,
                     std::vector< bool > *other_equal,
                     std::unique_ptr< NWC::Dir > &my_res_vdir,
                     std::unique_ptr< NWC::Dir > &other_res_vdir );
    int compareEntry( NWC::FSEntry *my_entry,
                      NWC::FSEntry *other_entry,
                      std::unique_ptr< NWC::Dir > &my_res_vdir,
                      std::unique_ptr< NWC::Dir > &other_res_vdir );
    int compareFile( NWC::FSEntry *my_entry,
                     NWC::FSEntry *other_entry );
};

#endif
