c
c----------------------------------------------------------------------
      subroutine pwError( routin, messag, ierr )
c----------------------------------------------------------------------
c
c    This is a simple routine which writes an error message to
c    output. If ierr = 0 it does nothing, if ierr < 0 it
c    writes the message but does not stop, if ierr > 0 stops.
c
c    **** Important note for parallel execution ***
c    in parallel execution unit 6 is written only by the first node;
c    all other nodes have unit 6 redirected to nothing (/dev/null).
c    As a consequence an error non occurring on the first node
c    will be invisible. For t3e and origin machines, this problem 
c    is solved by writing an error message to unit * instead of 6.
c    For ibm sp machines, we write to the standard error, unit 0
c    (this will appear in the error files produced by loadleveler).
c
      implicit none


      character*(*) 
     +          routin,       ! the name of the calling routine
     +          messag        ! the output message
      integer 
     +          ierr          ! the error flag

      if(ierr.eq.0) return
      write(6,*) ' '
      write(6,'(1x,78(''%''))')
      write(*,'(5x,''from '',a,'' : error #'',i10)') routin, ierr
      write(*,'(5x,a)') messag
      write(6,'(1x,78(''%''))')

      if(ierr.gt.0) then
         write(*,'(''     stopping ...'')')


         stop
      else
         write(6,*) ' '
         return
      end if
      end
