/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.Paper;

public class PageFormat
implements Cloneable {
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int REVERSE_LANDSCAPE = 2;
    private Paper mPaper = new Paper();
    private int mOrientation = 1;

    public Object clone() {
        PageFormat pageFormat;
        try {
            pageFormat = (PageFormat)super.clone();
            pageFormat.mPaper = (Paper)this.mPaper.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            pageFormat = null;
        }
        return pageFormat;
    }

    public double getWidth() {
        int n = this.getOrientation();
        double d = n == 1 ? this.mPaper.getWidth() : this.mPaper.getHeight();
        return d;
    }

    public double getHeight() {
        int n = this.getOrientation();
        double d = n == 1 ? this.mPaper.getHeight() : this.mPaper.getWidth();
        return d;
    }

    public double getImageableX() {
        double d;
        switch (this.getOrientation()) {
            case 0: {
                d = this.mPaper.getHeight() - (this.mPaper.getImageableY() + this.mPaper.getImageableHeight());
                break;
            }
            case 1: {
                d = this.mPaper.getImageableX();
                break;
            }
            case 2: {
                d = this.mPaper.getImageableY();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return d;
    }

    public double getImageableY() {
        double d;
        switch (this.getOrientation()) {
            case 0: {
                d = this.mPaper.getImageableX();
                break;
            }
            case 1: {
                d = this.mPaper.getImageableY();
                break;
            }
            case 2: {
                d = this.mPaper.getWidth() - (this.mPaper.getImageableX() + this.mPaper.getImageableWidth());
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return d;
    }

    public double getImageableWidth() {
        double d = this.getOrientation() == 1 ? this.mPaper.getImageableWidth() : this.mPaper.getImageableHeight();
        return d;
    }

    public double getImageableHeight() {
        double d = this.getOrientation() == 1 ? this.mPaper.getImageableHeight() : this.mPaper.getImageableWidth();
        return d;
    }

    public Paper getPaper() {
        return (Paper)this.mPaper.clone();
    }

    public void setPaper(Paper paper) {
        this.mPaper = (Paper)paper.clone();
    }

    public void setOrientation(int n) throws IllegalArgumentException {
        if (0 > n || n > 2) {
            throw new IllegalArgumentException();
        }
        this.mOrientation = n;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public double[] getMatrix() {
        double[] dArray = new double[6];
        switch (this.mOrientation) {
            case 0: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
                dArray[3] = 0.0;
                dArray[4] = 0.0;
                dArray[5] = this.mPaper.getHeight();
                break;
            }
            case 1: {
                dArray[0] = 1.0;
                dArray[1] = 0.0;
                dArray[2] = 0.0;
                dArray[3] = 1.0;
                dArray[4] = 0.0;
                dArray[5] = 0.0;
                break;
            }
            case 2: {
                dArray[0] = 0.0;
                dArray[1] = 1.0;
                dArray[2] = -1.0;
                dArray[3] = 0.0;
                dArray[4] = this.mPaper.getWidth();
                dArray[5] = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return dArray;
    }
}

