# $NetBSD: doc.docbook.dsssl.mk,v 1.20 2020/06/29 12:23:48 rillig Exp $

# This file is included by doc.docbook.mk and is not intended to be
# included directly.

JADE?=		env ${JADE_ENV} ${JADE_BIN} ${JADE_OPTS}
JADE_ENV?=	SP_ENCODING=${SP_ENCODING} \
		SGML_CATALOG_FILES=
JADE_BIN?=	openjade
JADE_OPTS=	-d ${DSSSL}
JADE_OPTS+=	${CATALOGS:S,^,-c ,}
JADE_OPTS+=	-i sgml.includes
JADE_OPTS+=	-V %generate-article-toc%
JADE_OPTS+=	-t tex
JADE_OPTS+=	-i output.print
JADE_OPTS+=	-i output.print.tex
JADE_OPTS+=	-i output.print.niceheaders

JADETEX?=	jadetex
PDFJADETEX?=	pdfjadetex

DSSSL?=		${.CURDIR}/share/default.dsl

.if ${FORMATS:Mps} || ${FORMATS:Mpdf}
CLEANFILES+=	${DOC}.tex
CLEANFILES+=	${DOC}.aux
CLEANFILES+=	${DOC}.dvi
CLEANFILES+=	${DOC}.log
CLEANFILES+=	${DOC}.out
.endif
.if ${FORMATS:Mps}
CLEANFILES+=	${DOC}.ps
.endif
.if ${FORMATS:Mpdf}
CLEANFILES+=	${DOC}.pdf
.endif

.xml.tex:
	${JADE} -o $@ ${XML_DECL} $<

.tex.ps:
	-${JADETEX} $*.tex
	-${JADETEX} $*.tex
	-${JADETEX} $*.tex
	${DVIPS} -f $*.dvi > $@
	rm -f *.log *.aux

.tex.pdf:
	-${PDFJADETEX} $*.tex
	-${PDFJADETEX} $*.tex
	-${PDFJADETEX} $*.tex
	rm -f *.log *.aux
