/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapSchemaParser;
import com.sun.jndi.toolkit.dir.HierMemDirCtx;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;

final class LdapSchemaCtx
extends HierMemDirCtx {
    private static final boolean debug = false;
    private static final int LEAF = 0;
    private static final int SCHEMA_ROOT = 1;
    static final int OBJECTCLASS_ROOT = 2;
    static final int ATTRIBUTE_ROOT = 3;
    static final int SYNTAX_ROOT = 4;
    static final int MATCHRULE_ROOT = 5;
    static final int OBJECTCLASS = 6;
    static final int ATTRIBUTE = 7;
    static final int SYNTAX = 8;
    static final int MATCHRULE = 9;
    private SchemaInfo info = null;
    private boolean setupMode = true;
    private int objectType;

    static DirContext createSchemaTree(Hashtable hashtable, String string, LdapCtx ldapCtx, Attributes attributes, boolean bl) throws NamingException {
        try {
            LdapSchemaParser ldapSchemaParser = new LdapSchemaParser(bl);
            SchemaInfo schemaInfo = new SchemaInfo(string, ldapCtx, ldapSchemaParser);
            LdapSchemaCtx ldapSchemaCtx = new LdapSchemaCtx(1, hashtable, schemaInfo);
            LdapSchemaParser.LDAP2JNDISchema(attributes, ldapSchemaCtx);
            return ldapSchemaCtx;
        }
        catch (NamingException namingException) {
            ldapCtx.close();
            throw namingException;
        }
    }

    private LdapSchemaCtx(int n, Hashtable hashtable, SchemaInfo schemaInfo) {
        super(hashtable, true);
        this.objectType = n;
        this.info = schemaInfo;
    }

    @Override
    public void close() throws NamingException {
        this.info.close();
    }

    @Override
    public final void bind(Name name, Object object, Attributes attributes) throws NamingException {
        if (!this.setupMode) {
            if (object != null) {
                throw new IllegalArgumentException("obj must be null");
            }
            this.addServerSchema(attributes);
        }
        LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(name, attributes);
    }

    @Override
    protected final void doBind(Name name, Object object, Attributes attributes, boolean bl) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doBind(name, object, attributes, false);
    }

    @Override
    public final void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        try {
            this.doLookup(name, false);
            throw new SchemaViolationException("Cannot replace existing schema object");
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.bind(name, object, attributes);
            return;
        }
    }

    @Override
    protected final void doRebind(Name name, Object object, Attributes attributes, boolean bl) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doRebind(name, object, attributes, false);
    }

    @Override
    protected final void doUnbind(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)this.doLookup(name, false);
                this.deleteServerSchema(ldapSchemaCtx.attrs);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
        }
        super.doUnbind(name);
    }

    @Override
    protected final void doRename(Name name, Name name2) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot rename a schema object");
        }
        super.doRename(name, name2);
    }

    @Override
    protected final void doDestroySubcontext(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)this.doLookup(name, false);
                this.deleteServerSchema(ldapSchemaCtx.attrs);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
        }
        super.doDestroySubcontext(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LdapSchemaCtx setup(int n, String string, Attributes attributes) throws NamingException {
        try {
            this.setupMode = true;
            LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(new CompositeName(string), attributes);
            ldapSchemaCtx.objectType = n;
            ldapSchemaCtx.setupMode = false;
            LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx;
            return ldapSchemaCtx2;
        }
        finally {
            this.setupMode = false;
        }
    }

    @Override
    protected final DirContext doCreateSubcontext(Name name, Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            throw new SchemaViolationException("Must supply attributes describing schema");
        }
        if (!this.setupMode) {
            this.addServerSchema(attributes);
        }
        LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(name, attributes);
        return ldapSchemaCtx;
    }

    private static final Attributes deepClone(Attributes attributes) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            basicAttributes.put((Attribute)namingEnumeration.next().clone());
        }
        return basicAttributes;
    }

    @Override
    protected final void doModifyAttributes(ModificationItem[] modificationItemArray) throws NamingException {
        if (this.setupMode) {
            super.doModifyAttributes(modificationItemArray);
        } else {
            Attributes attributes = LdapSchemaCtx.deepClone(this.attrs);
            LdapSchemaCtx.applyMods(modificationItemArray, attributes);
            this.modifyServerSchema(this.attrs, attributes);
            this.attrs = attributes;
        }
    }

    @Override
    protected final HierMemDirCtx createNewCtx() {
        LdapSchemaCtx ldapSchemaCtx = new LdapSchemaCtx(0, this.myEnv, this.info);
        return ldapSchemaCtx;
    }

    private final void addServerSchema(Attributes attributes) throws NamingException {
        Attribute attribute;
        switch (this.objectType) {
            case 2: {
                attribute = this.info.parser.stringifyObjDesc(attributes);
                break;
            }
            case 3: {
                attribute = this.info.parser.stringifyAttrDesc(attributes);
                break;
            }
            case 4: {
                attribute = this.info.parser.stringifySyntaxDesc(attributes);
                break;
            }
            case 5: {
                attribute = this.info.parser.stringifyMatchRuleDesc(attributes);
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot create new entry under schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot create child of schema object");
            }
        }
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(attribute);
        this.info.modifyAttributes(this.myEnv, 1, basicAttributes);
    }

    private final void deleteServerSchema(Attributes attributes) throws NamingException {
        Attribute attribute;
        switch (this.objectType) {
            case 2: {
                attribute = this.info.parser.stringifyObjDesc(attributes);
                break;
            }
            case 3: {
                attribute = this.info.parser.stringifyAttrDesc(attributes);
                break;
            }
            case 4: {
                attribute = this.info.parser.stringifySyntaxDesc(attributes);
                break;
            }
            case 5: {
                attribute = this.info.parser.stringifyMatchRuleDesc(attributes);
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot delete schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot delete child of schema object");
            }
        }
        ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.info.modifyAttributes(this.myEnv, modificationItemArray);
    }

    private final void modifyServerSchema(Attributes attributes, Attributes attributes2) throws NamingException {
        Attribute attribute;
        Attribute attribute2;
        switch (this.objectType) {
            case 6: {
                attribute2 = this.info.parser.stringifyObjDesc(attributes);
                attribute = this.info.parser.stringifyObjDesc(attributes2);
                break;
            }
            case 7: {
                attribute2 = this.info.parser.stringifyAttrDesc(attributes);
                attribute = this.info.parser.stringifyAttrDesc(attributes2);
                break;
            }
            case 8: {
                attribute2 = this.info.parser.stringifySyntaxDesc(attributes);
                attribute = this.info.parser.stringifySyntaxDesc(attributes2);
                break;
            }
            case 9: {
                attribute2 = this.info.parser.stringifyMatchRuleDesc(attributes);
                attribute = this.info.parser.stringifyMatchRuleDesc(attributes2);
                break;
            }
            default: {
                throw new SchemaViolationException("Cannot modify schema root");
            }
        }
        ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, attribute2), new ModificationItem(1, attribute)};
        this.info.modifyAttributes(this.myEnv, modificationItemArray);
    }

    private static final class SchemaInfo {
        private LdapCtx schemaEntry;
        private String schemaEntryName;
        LdapSchemaParser parser;
        private String host;
        private int port;
        private boolean hasLdapsScheme;

        SchemaInfo(String string, LdapCtx ldapCtx, LdapSchemaParser ldapSchemaParser) {
            this.schemaEntryName = string;
            this.schemaEntry = ldapCtx;
            this.parser = ldapSchemaParser;
            this.port = ldapCtx.port_number;
            this.host = ldapCtx.hostname;
            this.hasLdapsScheme = ldapCtx.hasLdapsScheme;
        }

        synchronized void close() throws NamingException {
            if (this.schemaEntry != null) {
                this.schemaEntry.close();
                this.schemaEntry = null;
            }
        }

        private LdapCtx reopenEntry(Hashtable hashtable) throws NamingException {
            return new LdapCtx(this.schemaEntryName, this.host, this.port, hashtable, this.hasLdapsScheme);
        }

        synchronized void modifyAttributes(Hashtable hashtable, ModificationItem[] modificationItemArray) throws NamingException {
            if (this.schemaEntry == null) {
                this.schemaEntry = this.reopenEntry(hashtable);
            }
            this.schemaEntry.modifyAttributes("", modificationItemArray);
        }

        synchronized void modifyAttributes(Hashtable hashtable, int n, Attributes attributes) throws NamingException {
            if (this.schemaEntry == null) {
                this.schemaEntry = this.reopenEntry(hashtable);
            }
            this.schemaEntry.modifyAttributes("", n, attributes);
        }
    }
}

