package ONVIF::Analytics::Types::Space2DDescription;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %URI_of :ATTR(:get<URI>);
my %XRange_of :ATTR(:get<XRange>);
my %YRange_of :ATTR(:get<YRange>);

__PACKAGE__->_factory(
    [ qw(        URI
        XRange
        YRange

    ) ],
    {
        'URI' => \%URI_of,
        'XRange' => \%XRange_of,
        'YRange' => \%YRange_of,
    },
    {
        'URI' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'XRange' => 'ONVIF::Analytics::Types::FloatRange',
        'YRange' => 'ONVIF::Analytics::Types::FloatRange',
    },
    {

        'URI' => 'URI',
        'XRange' => 'XRange',
        'YRange' => 'YRange',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::Space2DDescription

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Space2DDescription from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * URI


=item * XRange


=item * YRange




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::Space2DDescription
   URI =>  $some_value, # anyURI
   XRange =>  { # ONVIF::Analytics::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   YRange =>  { # ONVIF::Analytics::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

