package ONVIF::Device::Types::Service;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Namespace_of :ATTR(:get<Namespace>);
my %XAddr_of :ATTR(:get<XAddr>);
my %Capabilities_of :ATTR(:get<Capabilities>);
my %Version_of :ATTR(:get<Version>);

__PACKAGE__->_factory(
    [ qw(        Namespace
        XAddr
        Capabilities
        Version

    ) ],
    {
        'Namespace' => \%Namespace_of,
        'XAddr' => \%XAddr_of,
        'Capabilities' => \%Capabilities_of,
        'Version' => \%Version_of,
    },
    {
        'Namespace' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',

        'Capabilities' => 'ONVIF::Device::Types::Service::_Capabilities',
        'Version' => 'ONVIF::Device::Types::OnvifVersion',
    },
    {

        'Namespace' => 'Namespace',
        'XAddr' => 'XAddr',
        'Capabilities' => 'Capabilities',
        'Version' => 'Version',
    }
);

} # end BLOCK




package ONVIF::Device::Types::Service::_Capabilities;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}







1;


=pod

=head1 NAME

ONVIF::Device::Types::Service

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Service from the namespace http://www.onvif.org/ver10/device/wsdl.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Namespace


=item * XAddr


=item * Capabilities


=item * Version




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::Service
   Namespace =>  $some_value, # anyURI
   XAddr =>  $some_value, # anyURI
   Capabilities =>  {
   },
   Version =>  { # ONVIF::Device::Types::OnvifVersion
     Major =>  $some_value, # int
     Minor =>  $some_value, # int
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

