
package ONVIF::Media::Elements::SetVideoSourceMode;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' }

__PACKAGE__->__set_name('SetVideoSourceMode');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %VideoSourceToken_of :ATTR(:get<VideoSourceToken>);
my %VideoSourceModeToken_of :ATTR(:get<VideoSourceModeToken>);

__PACKAGE__->_factory(
    [ qw(        VideoSourceToken
        VideoSourceModeToken

    ) ],
    {
        'VideoSourceToken' => \%VideoSourceToken_of,
        'VideoSourceModeToken' => \%VideoSourceModeToken_of,
    },
    {
        'VideoSourceToken' => 'ONVIF::Media::Types::ReferenceToken',
        'VideoSourceModeToken' => 'ONVIF::Media::Types::ReferenceToken',
    },
    {

        'VideoSourceToken' => 'VideoSourceToken',
        'VideoSourceModeToken' => 'VideoSourceModeToken',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Media::Elements::SetVideoSourceMode

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetVideoSourceMode from the namespace http://www.onvif.org/ver10/media/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * VideoSourceToken

 $element->set_VideoSourceToken($data);
 $element->get_VideoSourceToken();




=item * VideoSourceModeToken

 $element->set_VideoSourceModeToken($data);
 $element->get_VideoSourceModeToken();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::SetVideoSourceMode->new($data);

Constructor. The following data structure may be passed to new():

 {
   VideoSourceToken => $some_value, # ReferenceToken
   VideoSourceModeToken => $some_value, # ReferenceToken
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

