/*
 * Copyright © 2009-2020 Frictional Games
 *
 * This file is part of Amnesia: The Dark Descent.
 *
 * Amnesia: The Dark Descent is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * Amnesia: The Dark Descent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Amnesia: The Dark Descent.  If not, see <https://www.gnu.org/licenses/>.
 */

// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "launcherCz.h"
extern tString gsGameLanguageFolder;
extern tString gsDefaultGameLanguage;
#include "Main.h"
#include "LauncherHelper.h"

void cUserInterface::cb_AddResolutionWindow_i(Fl_Window* o, void*) {
  cLauncherHelper::ReselectResolution(mvVModes, mpConfigFile, CBResolution);
o->hide();
}
void cUserInterface::cb_AddResolutionWindow(Fl_Window* o, void* v) {
  ((cUserInterface*)(o->user_data()))->cb_AddResolutionWindow_i(o,v);
}

void cUserInterface::cb_BAddCustomResolution_i(Fl_Return_Button*, void*) {
  if (cLauncherHelper::AddCustomResolution(mvVModes, mpConfigFile, CBResolution, this, ICustomWidth->value(), ICustomHeight->value())) {
	AddResolutionWindow->hide();
};
}
void cUserInterface::cb_BAddCustomResolution(Fl_Return_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->user_data()))->cb_BAddCustomResolution_i(o,v);
}

void cUserInterface::cb_Cancel_i(Fl_Button*, void*) {
  AddResolutionWindow->do_callback();
}
void cUserInterface::cb_Cancel(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

#include <FL/Fl_JPEG_Image.H>
static unsigned char idata_launcher_bg_cz[] =
{255,216,255,224,0,16,74,70,73,70,0,1,1,1,0,72,0,72,0,0,255,219,0,67,0,5,3,
4,4,4,3,5,4,4,4,5,5,5,6,7,12,8,7,7,7,7,15,11,11,9,12,17,15,18,18,17,15,17,17,
19,22,28,23,19,20,26,21,17,17,24,33,24,26,29,29,31,31,31,19,23,34,36,34,30,36,
28,30,31,30,255,219,0,67,1,5,5,5,7,6,7,14,8,8,14,30,20,17,20,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,255,192,0,17,8,2,42,2,
182,3,1,34,0,2,17,1,3,17,1,255,196,0,29,0,0,2,2,2,3,1,0,0,0,0,0,0,0,0,0,0,3,4,2,
5,1,6,0,7,8,9,255,196,0,76,16,0,2,1,3,2,3,6,4,4,3,5,6,5,3,1,9,1,2,3,0,4,17,5,
33,6,18,49,7,19,34,65,81,97,8,50,113,129,20,66,145,161,35,82,177,21,51,98,193,
209,9,22,36,130,146,225,67,114,162,240,241,52,99,178,23,37,83,194,115,68,131,
147,163,210,255,196,0,26,1,0,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,255,
196,0,46,17,0,2,2,2,2,2,2,1,2,5,5,1,1,0,0,0,0,1,2,17,3,33,18,49,4,65,34,81,19,
50,97,5,20,35,113,129,66,161,177,193,240,145,209,255,218,0,12,3,1,0,2,17,3,17,
0,63,0,242,61,22,33,129,154,16,162,244,74,232,137,44,136,220,212,165,31,196,
35,210,165,2,230,65,92,109,216,159,122,180,180,77,153,85,240,138,44,98,135,233,
244,162,41,53,162,64,59,0,1,87,235,154,196,199,36,10,196,71,3,232,181,197,241,
75,244,173,249,104,146,46,119,197,113,87,39,122,144,92,181,100,14,166,167,176,
37,2,14,241,125,170,112,255,0,124,15,190,107,144,131,226,111,65,92,141,78,73,
246,166,144,131,46,214,82,55,155,189,70,1,128,199,218,159,93,62,234,107,40,82,
40,178,78,91,5,128,39,233,158,180,169,142,72,121,210,72,217,27,56,33,134,13,
110,160,211,86,43,11,100,156,211,160,247,169,206,66,18,79,155,96,15,82,105,206,
31,130,6,186,89,111,25,210,221,65,45,201,243,55,178,231,250,249,84,238,221,53,
107,248,161,134,222,214,198,11,124,178,14,133,207,144,44,122,159,115,93,113,198,
248,235,178,108,93,226,39,0,121,10,138,219,147,229,87,86,119,26,93,178,188,87,
54,95,140,105,14,30,65,33,83,24,255,0,7,145,62,230,155,93,32,200,166,230,193,
154,238,208,48,28,225,112,203,159,38,30,70,186,161,131,151,68,185,20,241,219,
226,112,49,209,104,119,16,224,99,30,66,175,141,148,139,113,33,40,70,6,212,141,
220,36,205,200,6,119,2,180,150,6,180,43,20,181,180,103,228,0,122,154,83,83,180,
112,122,103,2,182,205,62,201,139,31,14,2,161,168,235,26,92,182,182,15,119,60,14,
177,242,22,86,43,128,106,223,135,113,182,28,142,185,132,115,92,63,160,218,155,
41,208,99,202,151,211,208,191,122,248,243,166,119,231,197,120,112,90,179,102,
73,208,115,129,232,40,114,227,154,136,231,248,130,131,38,75,154,169,118,73,48,
185,141,254,148,156,171,130,54,233,79,70,164,196,231,233,65,146,50,78,226,179,
113,176,24,211,44,109,164,177,188,190,185,231,117,183,3,17,161,193,36,236,15,
210,129,51,233,141,11,20,183,184,73,60,148,176,43,250,211,218,48,149,39,112,170,
123,151,140,172,187,109,140,85,75,38,50,60,171,89,70,160,169,2,236,205,197,145,
48,45,197,177,105,98,63,48,252,200,125,8,165,237,252,51,33,244,97,69,141,164,
133,249,227,114,141,237,86,9,121,105,49,83,119,99,205,32,198,94,54,229,39,234,
43,37,8,201,247,76,123,43,174,87,150,238,65,254,42,106,56,203,190,20,19,145,86,
151,209,104,210,78,243,98,226,13,129,40,48,217,251,212,13,228,106,17,108,224,16,
167,78,98,114,199,234,107,85,137,71,182,43,18,54,142,156,172,248,65,239,81,146,
56,199,231,207,218,167,114,206,231,153,152,147,154,27,238,160,208,235,210,25,
23,40,177,237,185,205,14,228,150,144,49,243,81,83,101,202,176,246,205,98,84,37,
16,253,170,27,177,10,183,70,30,162,150,83,137,23,235,78,72,132,17,75,148,254,
32,250,214,51,41,11,184,240,159,102,161,226,153,100,254,240,125,232,92,166,177,
99,36,158,43,71,31,202,217,161,227,108,211,54,201,144,233,234,181,24,211,195,
140,83,106,193,0,140,97,200,163,242,97,213,234,44,188,174,167,212,102,153,229,
204,57,244,169,72,98,183,9,203,33,244,161,242,248,105,171,129,144,15,181,9,69,
14,59,4,45,131,68,131,230,35,212,84,138,110,106,81,169,86,13,232,106,18,105,
141,145,147,200,251,98,139,110,114,10,250,138,36,144,156,56,30,91,138,28,32,171,
3,90,46,201,15,16,205,74,67,176,172,129,203,32,244,235,68,146,42,218,43,66,2,
199,40,71,165,66,98,88,171,255,0,58,224,253,69,50,177,31,74,17,140,247,110,190,
104,121,133,41,193,130,17,199,139,239,70,135,96,234,122,17,89,145,48,217,245,
172,198,60,96,122,237,88,241,162,129,100,244,52,41,183,90,51,41,230,62,162,160,
84,212,176,23,43,181,71,7,173,49,201,177,30,149,2,42,120,142,204,41,37,113,89,
207,239,89,3,7,62,149,146,54,62,213,105,1,16,106,121,193,246,52,63,58,225,233,
84,152,131,7,60,163,212,81,99,122,81,78,255,0,90,154,182,42,163,33,80,196,167,
63,125,234,13,184,13,246,53,128,217,31,74,146,110,10,254,149,79,96,102,45,182,
166,99,165,144,224,209,145,168,90,1,168,199,151,149,66,84,235,234,43,49,190,212,
102,195,12,213,118,32,42,54,205,73,70,14,107,3,194,197,124,141,77,55,24,166,128,
13,208,240,103,210,171,229,171,55,28,202,84,253,42,190,69,57,34,179,152,208,
171,86,20,111,69,40,115,92,229,197,99,69,2,101,243,168,26,57,220,80,152,111,82,
208,204,10,193,21,33,214,184,69,32,33,92,205,113,170,52,152,201,121,215,43,149,
202,144,8,163,44,40,141,210,177,24,223,53,38,25,192,173,18,208,137,195,176,45,
232,42,34,136,6,33,250,214,21,106,132,113,69,21,6,77,96,45,18,33,185,246,171,66,
12,131,194,104,144,46,17,159,218,135,143,225,211,40,152,182,81,252,198,173,8,
10,41,36,126,181,197,90,60,75,158,115,232,42,3,148,122,154,164,172,65,162,79,
224,182,7,83,82,132,247,121,42,1,99,208,227,56,168,150,61,210,143,46,184,169,
193,226,117,30,166,186,35,75,161,48,218,145,37,226,12,73,42,128,228,154,131,93,
207,36,106,146,220,51,99,167,49,206,213,155,246,230,187,112,63,40,197,12,196,
146,42,171,40,53,165,190,78,132,61,167,176,46,217,126,102,228,219,122,204,35,50,
143,109,235,22,17,36,54,242,114,14,189,77,30,210,34,197,142,60,171,174,41,180,
172,150,13,119,108,251,214,201,193,154,165,206,153,121,36,150,178,114,179,167,
46,8,202,159,168,170,46,224,133,39,52,246,146,166,56,110,167,43,146,137,177,
244,201,174,156,55,7,100,179,110,182,214,109,174,132,130,246,210,53,36,255,0,
121,10,224,245,244,232,104,6,219,75,150,232,220,73,123,31,112,27,32,39,206,79,
166,15,74,212,109,46,100,193,44,228,111,80,181,188,63,137,201,32,245,53,209,252,
218,246,133,196,236,61,54,247,72,182,121,166,134,25,46,93,84,5,89,112,20,31,127,
90,169,227,158,40,188,126,30,187,180,188,147,241,9,114,2,34,19,129,31,208,86,
185,109,126,226,222,87,7,118,147,246,170,14,35,190,107,171,145,31,54,66,123,249,
212,249,30,92,127,3,251,97,24,190,67,60,51,96,110,52,217,156,12,156,245,164,117,
20,123,89,82,86,31,194,45,202,254,222,134,183,78,201,237,225,212,109,46,236,22,
69,91,145,188,104,223,159,212,15,122,174,227,77,38,104,191,225,17,63,141,60,
156,129,8,223,110,187,123,87,47,242,241,151,139,25,199,180,85,190,84,107,207,17,
239,7,165,9,163,201,171,143,192,60,40,145,190,73,81,130,77,27,72,209,174,53,77,
78,13,62,209,3,75,59,114,175,160,243,36,251,98,177,151,138,239,160,228,71,132,
173,97,151,80,255,0,137,136,73,18,43,57,67,208,224,26,86,105,109,38,97,205,98,
17,143,94,73,8,31,167,149,108,111,111,167,232,182,211,155,107,191,199,93,146,
98,5,83,149,19,200,159,122,214,161,78,107,168,211,27,243,12,213,79,31,227,138,
143,176,78,217,25,94,46,232,194,177,184,136,156,159,22,249,164,218,24,148,115,
247,128,227,162,227,122,118,69,80,14,221,9,165,92,100,237,92,243,99,66,248,70,
108,52,99,7,166,60,171,152,59,169,85,250,226,139,201,181,73,156,48,241,1,145,
231,89,80,236,45,220,121,86,111,254,218,154,93,62,65,236,105,220,135,141,199,95,
224,15,235,72,6,1,105,49,146,113,144,212,51,242,159,106,40,96,115,238,40,50,156,
57,30,163,53,45,140,228,120,47,143,81,138,201,35,186,30,212,183,120,85,193,244,
53,195,38,204,61,13,71,32,39,54,224,26,89,135,143,52,102,124,165,1,154,166,123,
26,50,87,248,140,61,65,161,34,110,71,181,48,72,231,70,245,21,5,24,147,30,245,
13,1,203,97,135,6,164,168,4,140,190,245,200,246,147,21,63,252,112,125,69,9,0,
25,211,8,15,161,34,143,102,129,209,151,218,165,58,127,13,199,220,80,236,159,
150,90,26,166,7,39,139,192,61,133,43,203,131,244,171,41,199,136,138,85,147,168,
162,81,4,193,20,201,233,82,88,193,24,162,132,240,3,89,139,231,197,46,32,21,16,
17,27,145,177,24,63,211,253,41,121,160,238,228,43,239,86,48,40,49,50,250,28,
253,142,213,139,164,230,141,36,243,59,31,168,170,224,43,17,198,99,83,233,181,29,
48,209,169,243,7,6,134,70,1,95,90,205,177,207,50,122,140,143,173,56,105,128,
212,72,9,197,101,224,196,160,249,48,193,168,35,96,131,78,100,60,96,249,138,238,
132,20,213,19,209,81,52,68,28,17,210,132,99,35,245,171,91,216,199,55,56,31,48,
205,41,34,237,154,230,203,134,138,76,86,116,196,156,216,217,134,106,28,184,29,
41,169,0,104,129,243,83,138,3,244,205,114,184,208,197,156,0,223,90,19,13,190,
148,89,104,110,118,207,173,65,68,65,222,164,190,148,18,219,209,35,111,16,62,187,
26,113,118,12,140,171,202,213,17,233,76,74,185,21,219,63,10,60,95,192,156,25,
218,20,218,135,29,216,44,214,242,219,24,173,110,158,14,249,109,100,36,101,138,
111,212,100,100,2,71,222,140,151,21,105,2,217,211,163,210,165,159,58,237,143,
137,51,217,206,171,197,135,138,59,56,213,35,123,93,64,179,94,216,24,90,38,130,
80,126,116,82,0,228,110,184,29,14,118,193,173,127,178,174,1,94,63,139,93,178,
177,213,86,29,118,202,196,221,233,250,123,69,147,127,201,188,136,173,157,152,40,
200,24,223,236,107,53,53,199,147,29,108,210,163,108,26,48,240,176,161,219,195,
60,183,2,222,56,100,121,139,114,132,85,37,137,244,199,92,209,100,142,72,157,
162,149,26,57,16,149,117,97,130,164,117,4,121,26,218,44,150,98,77,143,177,220,
87,3,237,92,109,211,233,66,201,27,81,32,67,73,37,51,20,158,70,171,163,106,60,
109,131,68,100,13,13,201,251,138,148,109,190,125,106,25,202,131,233,88,67,134,
199,233,90,8,147,28,53,10,120,178,220,222,180,87,30,117,53,28,209,99,204,80,213,
128,147,70,0,160,73,181,59,37,43,50,249,214,82,69,33,115,177,168,53,73,234,29,
69,98,202,68,115,89,39,106,139,117,174,84,128,54,53,144,107,140,43,10,55,169,
246,51,44,107,149,134,21,202,77,128,250,46,16,154,207,47,138,136,23,194,162,178,
139,153,0,174,154,32,228,163,1,86,176,163,106,156,155,200,107,56,242,167,91,2,
52,72,182,66,125,78,43,24,162,32,217,69,53,216,172,46,58,10,114,97,201,2,15,62,
90,89,70,92,15,122,106,243,121,121,71,69,24,173,18,208,136,70,184,129,143,169,
197,1,182,56,167,74,114,218,175,189,46,98,37,192,171,226,6,36,234,0,242,20,123,
5,205,194,103,215,53,6,76,185,166,172,99,195,72,255,0,202,134,180,130,216,152,
187,248,165,145,189,90,143,26,28,143,165,98,20,245,243,53,97,103,16,45,205,143,
165,116,226,133,178,89,152,162,43,9,24,235,87,186,62,146,94,201,174,174,29,32,
183,4,41,119,56,201,62,64,121,159,165,19,68,180,130,94,253,165,136,202,209,196,
90,56,193,199,51,15,90,75,136,110,231,107,8,165,115,136,226,149,112,163,162,
138,244,84,86,56,115,145,29,186,9,172,27,11,9,161,185,179,134,107,184,119,91,
132,111,8,113,228,192,13,198,42,180,234,15,115,20,203,12,70,40,113,211,151,0,
127,173,90,221,32,238,211,7,98,160,254,180,156,137,139,89,15,243,48,20,100,229,
186,122,26,43,35,86,238,152,159,32,105,125,59,151,191,148,16,67,5,56,218,172,
157,63,225,152,143,165,6,221,57,45,167,145,182,1,107,134,113,105,162,197,103,
159,184,211,67,14,172,199,21,70,65,96,206,119,36,213,133,251,23,180,143,29,9,
218,131,20,7,186,143,111,153,235,143,52,220,157,13,42,44,120,110,121,44,47,150,
72,221,149,129,7,32,224,131,229,93,157,162,235,186,116,247,147,93,235,86,107,
127,113,112,0,123,146,113,42,40,232,171,228,7,183,159,157,117,135,47,37,225,3,
203,21,121,106,156,224,14,102,92,142,170,112,107,214,240,114,210,226,215,68,73,
27,95,25,92,240,117,190,141,115,113,111,45,248,188,117,229,183,137,163,92,51,
159,82,60,135,90,123,132,245,237,63,135,32,138,93,27,70,91,157,69,163,85,123,
139,190,128,99,196,2,143,90,211,227,210,109,158,229,36,101,121,28,28,130,236,77,
111,220,27,195,114,106,82,145,206,145,71,24,231,150,87,249,81,125,107,209,92,
165,39,41,244,102,244,180,43,199,218,5,180,177,65,173,216,64,144,218,106,25,126,
237,6,4,110,7,137,113,245,173,33,244,85,150,230,2,174,209,186,184,229,97,229,93,
201,198,178,89,201,165,89,105,26,112,105,45,172,131,102,86,24,239,24,245,32,122,
86,129,60,29,221,204,71,31,156,82,158,5,146,22,215,254,244,46,84,205,25,244,
235,172,73,248,134,77,156,227,151,207,126,180,185,178,197,109,19,68,91,188,31,
226,53,94,97,110,102,24,232,107,206,126,50,178,185,50,136,218,145,158,189,40,15,
110,195,122,216,187,141,240,71,90,86,75,111,11,96,116,169,159,143,64,164,84,198,
220,153,30,169,138,174,203,18,106,240,89,179,72,54,168,29,56,41,109,171,146,88,
37,232,180,209,85,19,120,151,210,163,114,113,202,125,177,250,83,239,105,141,
192,160,94,219,55,35,31,70,207,234,43,25,99,146,42,202,153,78,230,178,78,114,
106,115,194,192,154,18,41,193,30,213,205,36,211,41,28,44,113,138,38,149,99,125,
170,234,80,105,186,109,180,183,87,151,50,8,225,134,33,150,118,61,0,30,180,77,46,
208,95,106,118,182,79,113,29,178,220,76,145,25,164,207,44,97,136,28,199,27,224,
103,59,87,170,180,79,133,46,41,225,158,58,208,120,135,135,56,187,78,186,130,202,
238,27,166,121,225,120,164,94,86,12,64,3,155,57,25,243,21,150,92,188,59,236,168,
198,205,55,137,126,26,184,155,135,251,22,147,138,175,3,79,196,16,72,39,159,78,
128,243,8,45,112,121,137,35,230,113,177,56,216,0,122,215,64,179,127,19,63,122,
250,161,218,77,203,89,246,121,196,119,72,188,205,22,151,114,202,61,72,137,177,
95,42,179,158,83,89,224,201,41,93,142,73,32,227,105,179,239,69,113,128,141,233,
181,13,190,96,125,168,189,97,62,198,186,145,152,87,28,201,246,164,226,240,202,
63,74,114,31,20,84,180,169,203,33,170,146,213,130,25,125,213,90,132,195,15,71,
139,197,17,30,155,212,36,30,33,69,88,17,143,117,101,161,244,96,104,169,180,163,
222,135,56,229,98,61,13,38,180,3,54,178,1,32,7,163,108,104,204,115,20,136,122,
143,16,254,134,171,149,233,161,46,88,63,147,12,159,190,198,154,96,45,54,115,88,
133,185,36,13,82,148,111,80,81,189,47,99,28,144,96,100,125,104,150,207,177,83,
67,83,205,8,245,27,80,227,110,86,174,172,115,167,100,50,195,33,237,240,122,169,
199,218,145,155,4,81,163,148,9,10,231,102,24,165,101,124,177,21,174,89,38,129,
16,67,146,203,234,40,77,208,212,131,97,195,123,215,39,0,110,43,207,145,66,114,
26,11,31,9,20,73,78,230,128,199,29,107,158,76,180,9,206,244,88,55,218,134,70,
77,22,45,136,167,14,193,141,157,212,55,168,165,228,24,106,60,103,170,250,110,
40,83,138,218,93,9,16,78,67,34,247,153,228,200,230,229,235,143,60,87,209,142,
205,251,24,236,182,8,248,75,141,248,54,209,237,230,180,129,110,45,238,146,118,
111,197,43,166,15,123,190,9,220,238,49,131,183,77,171,231,30,107,213,223,8,93,
191,240,223,9,112,176,224,126,53,186,158,206,24,174,25,236,111,153,75,196,136,
248,38,54,198,235,134,230,32,227,27,249,87,30,120,182,180,92,89,233,62,31,236,
115,179,253,11,180,27,158,58,211,52,99,6,179,112,238,236,194,102,49,43,56,241,
149,143,60,163,57,39,167,157,117,231,196,23,195,94,141,199,51,106,28,77,195,51,
29,55,137,103,61,236,136,237,255,0,15,116,224,121,143,200,199,31,48,219,61,71,
157,119,127,13,113,14,133,196,218,112,212,120,123,87,178,213,45,9,199,123,107,
50,200,160,250,28,116,62,198,173,43,157,54,157,162,234,207,145,250,141,149,214,
155,168,220,105,215,240,61,189,213,180,173,12,209,56,195,35,169,193,7,232,69,40,
227,206,187,71,226,162,125,62,231,183,222,42,151,77,145,94,47,197,5,144,170,149,
196,170,138,178,13,255,0,196,14,254,117,214,77,184,250,215,161,23,202,41,152,
189,48,43,177,163,161,220,80,48,119,30,148,88,142,106,87,101,49,200,78,87,21,53,
27,253,40,112,236,65,163,145,130,15,173,116,36,65,150,3,31,90,138,28,28,81,174,
173,238,109,89,82,230,222,88,25,208,58,9,16,169,101,61,8,207,80,125,104,37,124,
232,123,0,114,141,233,121,122,111,78,56,200,205,43,58,214,114,67,66,50,245,161,
19,76,76,180,6,21,207,36,90,34,107,21,32,43,4,84,1,193,189,112,46,245,197,169,
83,2,14,185,174,84,141,114,147,67,44,241,189,22,222,60,177,111,65,80,69,44,73,
3,111,90,114,21,69,132,146,249,207,160,174,216,196,206,197,210,34,205,156,123,
209,4,24,27,138,102,30,235,29,26,152,137,226,87,5,211,40,118,57,220,226,173,65,
10,202,190,232,230,141,4,68,183,74,126,59,56,89,131,27,184,132,125,73,57,230,
31,242,211,246,112,233,236,36,142,36,153,216,70,204,174,204,6,72,25,232,42,163,
139,96,217,85,4,95,198,92,143,58,228,132,180,172,125,77,55,221,224,151,3,160,
205,2,8,153,230,85,3,169,164,215,160,26,157,0,72,211,216,80,81,71,121,244,167,
231,143,254,39,31,202,13,2,24,93,153,185,81,155,232,51,90,113,16,176,76,182,106,
198,210,32,44,229,111,230,33,104,150,154,101,228,206,22,43,73,228,99,208,44,100,
154,114,107,105,45,109,146,9,162,120,164,230,37,145,151,4,125,69,116,226,197,
246,38,86,247,0,40,0,117,53,101,105,0,85,3,20,24,144,201,112,145,162,150,61,112,
42,238,218,194,239,149,91,240,179,114,231,25,228,56,207,165,122,24,49,34,36,
195,233,40,32,38,229,137,240,55,132,15,51,254,148,13,66,213,110,109,94,3,202,59,
222,185,25,198,77,61,46,35,142,56,182,230,94,163,210,184,169,153,80,122,87,116,
224,156,120,144,141,103,146,235,79,148,218,78,146,79,10,156,36,201,190,7,161,30,
84,89,206,109,99,3,62,34,78,227,21,97,121,187,177,247,164,239,23,2,53,244,95,
235,92,143,31,5,87,162,174,196,174,33,38,0,200,197,31,204,129,215,235,73,223,55,
119,165,186,150,44,93,128,36,213,133,251,136,173,193,39,0,13,205,81,221,151,158,
217,91,7,149,156,226,188,236,242,81,181,236,180,98,242,44,91,219,2,202,185,92,
239,76,3,18,165,162,179,175,34,140,158,83,131,159,90,91,85,57,186,72,135,68,140,
10,35,119,34,68,89,149,153,66,1,225,59,230,184,223,101,14,201,17,146,224,207,
24,239,20,224,12,28,254,181,111,102,132,48,3,161,25,21,71,111,21,197,188,131,
186,46,170,224,237,159,42,187,209,156,200,85,119,56,218,187,188,87,242,37,244,
95,105,112,151,156,109,190,64,21,189,240,206,175,6,158,46,109,103,143,188,180,
157,66,72,1,193,216,231,32,253,107,86,208,160,60,206,224,110,170,77,66,232,186,
49,32,154,247,212,87,13,152,251,59,27,251,34,11,248,154,77,54,234,59,180,198,
123,178,193,100,30,216,243,173,87,89,210,251,137,81,192,219,152,2,15,145,244,
170,91,45,98,226,213,187,200,89,132,136,114,184,108,28,253,106,226,27,235,222,
43,214,173,102,212,210,59,104,172,215,154,20,14,9,186,155,201,159,27,120,70,
113,239,89,172,146,142,150,197,196,214,222,209,75,200,87,109,233,7,183,196,236,
49,187,0,127,173,110,34,29,42,218,71,184,213,230,144,115,19,201,109,1,28,237,
238,79,144,170,187,251,141,25,181,203,57,172,96,184,22,192,127,22,41,91,57,57,
245,30,85,117,6,250,13,148,63,130,110,96,113,231,82,77,59,196,193,135,90,221,56,
147,78,183,183,212,31,240,168,22,9,21,100,136,3,144,1,25,170,41,71,44,231,108,
10,214,56,161,37,102,118,211,40,38,182,72,134,195,165,86,58,134,149,133,92,106,
210,133,14,58,85,44,110,12,153,53,197,229,70,41,210,52,139,23,120,186,210,215,
42,12,110,54,221,1,253,41,155,137,2,146,41,54,144,101,115,238,43,202,203,70,
168,171,185,80,64,56,242,165,99,79,226,99,214,155,157,135,41,30,134,151,139,251,
213,62,134,184,167,86,104,119,175,193,151,103,220,59,197,252,117,62,167,174,221,
193,51,232,193,110,32,211,8,60,211,54,118,145,188,138,41,198,222,100,140,237,
215,221,245,229,239,131,78,201,53,45,18,234,110,63,215,146,230,202,89,163,104,
116,251,82,74,22,141,177,205,35,143,48,118,229,7,235,233,91,39,198,63,104,92,85,
192,26,103,11,220,112,189,241,179,146,226,246,67,51,114,43,9,2,40,194,48,35,112,
121,183,250,87,145,155,231,150,162,236,218,58,71,92,252,105,118,187,171,175,18,
201,217,198,131,117,45,149,157,188,64,234,114,198,216,107,134,117,200,143,35,
242,5,35,35,204,159,106,242,113,82,23,232,106,227,138,181,253,67,137,120,162,
255,0,136,53,105,17,239,175,238,26,121,217,87,149,121,137,242,30,67,218,171,37,
199,51,253,115,93,88,224,161,10,246,102,221,179,45,242,169,246,162,68,217,87,30,
217,161,245,132,123,26,228,100,6,250,138,219,216,134,237,14,196,26,197,202,248,
179,80,180,62,60,122,140,81,103,221,51,233,90,45,196,159,103,45,78,14,13,102,97,
183,208,208,163,56,57,169,204,115,159,113,72,100,73,216,31,74,229,224,241,6,29,
8,168,70,114,49,68,152,102,17,234,54,163,180,2,135,57,163,194,121,163,193,242,
56,251,26,17,27,81,109,190,126,95,38,24,169,160,36,227,35,39,173,8,236,104,206,
127,122,4,134,134,3,16,55,85,245,20,41,27,13,66,73,10,144,222,134,163,118,254,
61,186,83,83,208,80,119,115,128,65,220,86,38,7,188,230,29,14,245,11,80,93,72,
163,186,255,0,9,79,152,218,181,79,146,176,22,99,138,195,63,50,111,81,157,232,40,
249,4,87,52,228,172,104,132,157,104,78,54,163,73,215,62,180,54,25,172,26,40,30,
42,104,54,169,20,216,26,146,45,92,80,88,68,56,229,111,67,189,102,225,54,200,
172,198,187,227,214,139,203,207,22,60,250,86,213,161,8,17,189,96,175,157,21,151,
6,178,163,202,178,226,51,119,236,79,181,13,127,178,206,42,93,99,73,110,254,
210,108,37,245,139,177,17,220,39,249,48,242,111,47,161,34,189,181,217,191,196,
159,103,60,97,96,207,117,168,167,14,222,198,127,137,109,168,200,23,111,230,71,
249,88,123,108,125,171,231,99,13,170,2,177,201,133,72,165,42,59,39,226,72,219,
55,110,124,87,61,156,145,201,111,61,241,154,57,35,110,100,112,234,173,204,15,
152,36,154,235,220,237,138,143,51,49,28,204,91,3,3,39,165,101,189,107,88,174,49,
72,151,178,62,121,169,196,48,213,20,25,162,170,249,210,173,128,210,15,13,122,
207,224,179,179,46,29,213,120,90,251,141,184,167,72,183,188,43,119,221,216,53,
206,241,198,177,140,187,242,157,186,156,100,255,0,45,121,46,35,176,21,221,124,
19,218,80,225,31,135,109,119,134,237,181,9,219,86,214,175,204,16,64,24,242,219,
91,148,29,236,131,208,182,74,255,0,241,79,50,148,161,81,8,246,87,252,80,113,
254,151,218,15,104,255,0,141,209,109,86,45,59,78,183,22,48,75,202,1,156,43,49,
231,199,144,201,216,122,87,85,237,140,87,109,112,183,17,240,55,5,118,99,126,137,
166,67,175,113,150,187,111,36,6,73,99,204,26,108,14,57,113,147,214,66,60,91,122,
129,145,130,15,81,57,34,175,30,151,20,180,132,206,22,242,160,205,138,227,181,13,
155,34,137,48,64,100,160,48,163,61,9,133,97,34,144,51,214,184,69,100,215,42,40,
100,107,62,85,194,55,172,129,72,8,176,200,174,81,57,118,174,83,160,31,50,59,124,
204,79,181,24,49,17,170,210,201,189,48,189,64,244,174,164,217,1,163,36,81,11,29,
177,80,137,115,138,63,38,245,104,64,89,136,220,83,122,109,203,65,50,73,140,224,
238,15,152,243,20,25,19,56,2,163,202,67,128,42,163,105,216,139,201,81,20,183,33,
38,55,80,200,125,141,57,162,218,194,36,19,202,156,225,91,10,189,1,56,206,254,
213,89,107,115,113,29,176,68,153,130,231,97,233,76,217,94,76,210,177,146,70,112,
136,72,4,249,215,92,28,110,196,88,27,164,73,167,149,109,173,249,128,192,37,73,
235,237,154,65,110,103,193,2,105,48,79,147,80,22,86,123,119,111,230,106,36,11,
176,170,87,46,132,57,20,147,114,224,75,38,79,248,141,94,234,40,68,112,45,249,
121,228,49,2,185,111,18,3,211,39,252,170,171,79,132,201,52,105,140,243,16,49,79,
113,12,253,221,212,167,57,42,2,15,168,24,174,236,112,227,27,100,182,86,219,120,
238,228,238,129,11,144,1,61,113,87,214,82,220,91,134,238,174,38,78,101,193,229,
114,50,42,167,70,131,146,16,91,114,199,38,174,161,80,72,24,174,223,30,63,27,126,
201,144,165,181,228,13,118,109,221,140,114,131,242,201,183,55,184,62,117,101,19,
163,179,178,16,121,65,220,116,169,27,56,39,194,205,10,72,23,113,204,185,197,16,
219,36,118,229,99,69,69,232,2,140,10,210,167,123,22,138,153,99,205,35,168,133,
73,88,177,194,174,196,211,122,149,218,90,114,171,110,199,160,255,0,58,215,228,
153,238,204,210,78,114,63,40,62,91,215,31,149,150,49,84,187,46,42,196,117,139,
182,185,152,40,200,137,122,15,95,122,204,146,127,10,210,5,133,143,175,220,208,
111,198,38,1,49,181,102,39,156,106,8,57,135,42,215,129,57,59,109,154,208,43,160,
242,234,18,176,140,252,220,181,137,92,173,230,254,76,40,176,206,162,118,149,242,
64,147,39,30,123,213,116,247,42,247,15,32,230,25,98,122,86,92,232,116,90,95,
221,242,106,103,14,160,169,192,223,214,174,180,11,165,91,198,64,70,73,200,30,
254,98,181,125,58,52,184,187,83,40,14,25,198,75,86,197,113,109,101,6,160,235,4,
111,12,188,251,114,63,50,255,0,218,183,241,179,53,52,201,146,209,217,250,98,198,
145,219,199,27,2,100,101,103,62,231,160,251,85,94,171,224,148,143,34,118,164,52,
125,94,41,237,150,33,35,41,0,14,101,56,63,99,86,147,193,61,245,182,45,109,35,
133,99,35,158,65,39,54,71,175,47,92,159,90,250,167,53,40,174,59,48,72,162,18,35,
59,50,72,167,31,48,207,74,216,248,78,31,197,92,160,103,43,18,102,87,97,249,85,
70,115,84,183,86,17,60,131,241,16,43,48,232,72,173,151,129,102,138,218,249,146,
120,203,219,203,19,69,32,94,161,72,198,213,140,45,55,99,102,183,51,247,247,82,
200,113,226,98,106,190,238,224,91,73,17,97,158,102,197,109,218,239,11,220,105,
151,92,240,63,226,45,220,115,199,34,142,171,254,181,215,188,105,63,225,239,32,
136,229,88,18,216,165,147,34,199,23,32,74,206,206,225,221,66,13,87,78,77,46,241,
213,100,3,254,26,83,249,79,242,147,232,106,151,91,87,181,149,146,69,42,233,179,
3,228,69,107,58,21,220,164,96,18,25,112,71,211,214,182,171,251,143,237,155,88,
229,199,252,90,47,44,163,249,241,209,133,111,139,58,146,181,236,137,64,210,117,
123,146,211,176,206,213,87,36,197,122,86,207,168,104,87,82,73,222,8,185,23,29,
92,224,86,191,123,105,36,50,180,114,41,86,21,231,249,14,77,151,20,138,249,221,
140,134,131,41,33,62,135,52,220,209,30,109,189,40,83,68,68,100,145,94,124,226,
217,162,101,100,224,243,184,173,247,225,187,132,109,120,215,181,253,27,70,212,
21,154,201,29,174,110,20,15,153,35,28,220,167,216,144,1,250,214,147,44,121,112,
125,69,122,59,224,19,78,70,227,142,34,212,30,32,205,6,158,145,163,145,242,151,
144,19,143,168,90,224,242,46,48,108,210,59,103,178,128,10,0,0,0,54,0,87,91,252,
68,246,111,105,218,79,103,183,26,121,12,186,165,144,107,157,54,69,242,148,15,
148,143,48,195,195,247,7,202,187,34,185,94,66,109,109,27,31,41,116,77,54,196,
241,189,166,145,196,115,205,167,217,155,213,183,189,145,57,67,192,57,185,88,248,
182,219,223,210,183,159,136,158,203,236,59,51,214,244,200,244,174,33,143,89,211,
245,91,99,61,187,96,119,138,160,129,146,84,149,32,146,112,71,161,169,118,151,
192,188,73,196,221,190,113,86,137,195,58,37,213,245,215,246,156,242,24,227,76,4,
82,228,243,49,56,10,55,234,107,79,237,35,132,120,135,130,56,132,112,247,18,170,
37,244,48,35,247,105,56,144,34,176,200,25,29,62,149,218,164,220,147,191,240,
101,90,53,216,142,81,150,160,24,214,98,217,254,181,7,24,98,43,118,254,40,84,49,
110,216,144,31,122,117,134,67,10,173,133,176,213,98,31,112,125,69,105,142,90,19,
64,163,223,43,92,118,200,6,162,135,19,129,239,81,152,242,179,47,189,39,32,163,
145,182,28,138,103,170,17,72,115,30,112,105,244,35,144,31,181,16,144,80,187,10,
138,28,31,222,137,38,41,126,108,55,90,78,84,58,25,155,169,35,161,220,125,232,50,
122,209,3,102,53,246,56,168,144,10,209,118,20,3,4,154,204,139,205,16,62,155,84,
136,241,81,57,118,43,234,51,74,59,27,51,167,108,228,31,58,53,195,0,24,125,233,
123,95,9,205,102,237,143,54,107,104,202,160,77,10,77,184,63,90,18,156,53,23,148,
149,161,58,145,92,179,251,41,18,127,148,251,84,87,230,250,211,58,93,149,214,169,
168,218,233,214,48,188,247,87,82,172,48,198,163,37,157,142,0,253,77,108,125,172,
240,212,60,27,199,119,156,43,17,103,109,53,99,134,105,72,199,123,47,32,46,195,
219,152,144,61,128,168,82,92,168,43,70,179,26,103,43,247,21,149,74,148,71,112,
124,197,31,148,115,237,208,238,43,170,17,36,8,92,26,34,224,55,179,86,92,96,212,
9,240,227,204,85,181,64,14,225,64,125,186,29,232,61,14,105,137,124,81,231,204,
111,75,177,244,172,100,52,114,65,157,199,157,49,161,105,90,134,181,172,90,233,
58,85,164,183,119,215,114,136,160,134,49,150,118,61,0,165,211,196,49,233,93,
133,240,245,197,58,111,3,246,189,161,241,30,175,27,53,140,18,58,76,202,185,49,
135,70,78,112,61,185,179,250,214,114,186,109,13,9,246,183,217,174,187,217,150,
179,99,164,235,239,110,247,55,118,73,118,59,134,230,84,201,32,166,124,200,32,
140,244,173,45,151,53,221,157,181,89,246,135,218,118,171,117,218,119,251,187,
168,183,14,207,55,225,116,178,19,152,136,84,144,156,168,60,68,29,201,32,99,36,
215,80,220,217,220,90,93,73,107,119,111,45,188,241,55,43,197,42,21,100,62,132,
29,193,165,143,229,29,189,131,18,137,119,6,153,72,143,76,84,210,31,23,214,172,
34,183,202,3,91,199,25,45,149,241,161,13,91,111,103,92,19,174,113,239,19,90,
232,58,37,187,73,44,204,4,146,149,61,220,9,230,238,124,128,25,250,244,20,78,2,
224,221,75,140,248,199,79,225,221,42,50,103,188,144,6,124,100,68,131,119,115,
236,6,77,125,11,236,187,179,190,26,236,235,65,26,95,15,218,242,179,224,220,92,
200,115,45,195,255,0,51,31,232,6,194,178,207,147,241,105,118,84,99,103,65,255,0,
250,13,194,125,146,240,198,175,198,188,91,168,193,196,166,198,208,155,59,57,224,
238,225,107,131,178,134,28,199,159,44,70,7,214,188,143,119,153,37,121,10,170,
150,98,216,81,128,61,128,244,175,110,252,83,112,239,24,113,198,149,123,248,67,
14,153,195,60,59,111,37,220,146,92,73,131,168,78,171,184,81,228,170,50,1,61,73,
56,21,226,139,148,193,200,233,75,198,249,197,201,187,97,61,21,146,13,232,88,
222,155,149,48,104,14,5,92,144,144,7,20,51,70,99,181,5,171,22,82,6,70,245,204,
84,177,82,85,218,166,172,96,241,82,85,169,1,189,100,237,77,32,35,210,185,88,45,
189,114,152,135,162,77,197,49,26,249,208,227,166,16,86,209,68,176,176,174,40,
160,100,253,106,9,210,138,163,165,109,68,156,84,203,102,162,203,227,52,212,75,
177,250,80,138,229,182,171,72,9,231,150,53,20,107,109,160,153,189,64,20,41,17,
139,0,60,133,55,12,39,240,184,3,118,106,181,118,42,34,136,127,15,26,129,239,86,
90,101,182,95,153,151,194,131,39,52,104,173,128,85,24,232,41,238,236,91,218,41,
99,135,148,231,30,138,60,254,231,250,87,126,28,117,182,75,15,166,205,34,92,41,
94,68,229,4,243,42,128,122,122,214,191,117,49,188,213,22,16,224,0,217,36,158,
166,159,158,241,45,237,167,144,31,16,140,129,247,173,114,202,85,18,247,210,43,
48,206,112,13,87,145,153,42,136,210,54,219,5,34,53,200,193,171,27,127,156,102,
170,180,39,239,108,193,39,112,72,53,107,22,199,53,232,97,154,112,77,25,181,178,
210,212,13,207,218,161,175,173,200,209,166,252,8,83,115,201,148,7,204,215,45,91,
192,7,189,99,81,185,17,65,35,157,194,33,53,166,73,174,44,71,90,174,175,253,171,
118,242,78,157,205,196,99,149,226,63,151,29,72,251,212,193,82,201,150,219,169,
21,79,170,45,199,246,143,246,133,180,124,242,49,61,226,143,60,211,22,55,78,242,
114,205,107,52,108,61,178,43,230,30,86,219,82,239,239,236,232,160,215,142,166,
109,134,6,104,17,221,1,60,143,129,144,14,43,51,146,210,182,223,173,38,232,233,4,
206,8,233,138,231,201,38,52,18,59,192,176,130,98,39,114,104,49,223,218,227,18,
199,34,159,81,189,65,36,147,240,227,196,54,82,119,165,110,11,196,80,56,25,101,
230,27,249,86,13,180,50,251,74,150,201,238,98,88,175,162,76,176,217,212,175,157,
90,106,43,58,220,206,241,176,149,121,206,29,55,197,106,145,218,75,28,144,188,
177,236,196,29,170,80,95,93,89,95,73,53,164,239,25,231,35,0,236,126,163,206,174,
19,173,49,52,95,105,247,51,217,48,46,72,30,100,87,96,112,198,171,46,23,12,114,
60,193,197,104,86,186,181,182,161,23,37,212,98,27,129,213,128,240,183,218,182,
46,23,230,91,160,155,140,14,149,237,120,25,154,154,87,163,57,45,29,139,45,180,
90,156,25,0,44,216,200,96,62,111,175,189,98,195,75,33,51,206,232,70,112,200,
112,65,245,20,110,31,80,100,0,182,49,191,214,173,99,190,179,78,112,246,172,58,
244,146,190,135,38,37,37,102,73,152,225,253,71,84,184,144,104,186,149,156,38,56,
142,86,255,0,200,198,127,195,252,217,242,233,231,93,47,218,247,118,120,222,230,
8,10,148,139,192,8,233,181,118,182,177,196,214,90,77,164,151,86,214,225,38,3,
248,101,156,177,7,216,116,205,116,62,183,117,53,238,162,247,46,196,188,141,146,
115,189,120,222,127,194,60,44,214,27,101,174,141,115,53,187,193,51,18,234,135,
14,9,206,69,118,117,159,15,75,168,233,107,170,105,89,154,22,243,95,35,233,236,
107,170,108,172,136,181,158,85,144,150,139,5,147,212,31,74,236,111,135,254,36,
188,211,248,169,116,114,225,172,111,118,116,115,182,113,177,172,188,92,142,46,
152,73,90,57,119,101,118,177,42,77,111,42,242,156,30,96,106,163,83,181,86,30,52,
206,43,208,124,89,125,194,246,54,193,181,121,224,181,13,176,0,229,155,232,163,
115,90,7,18,240,221,149,194,155,141,42,110,249,64,203,12,116,30,68,122,138,244,
93,100,84,103,84,117,44,182,123,2,169,73,221,90,200,84,142,94,162,183,203,125,
14,230,73,10,8,78,199,115,228,41,123,219,27,120,102,43,221,135,3,108,177,59,
212,63,17,180,46,70,134,246,98,27,116,154,85,230,102,249,23,233,230,107,218,255,
0,7,156,41,22,129,217,90,106,242,91,180,119,218,220,205,113,43,176,220,198,9,
88,192,246,198,79,252,213,231,158,202,184,20,241,239,30,217,104,238,165,44,34,
61,237,219,39,229,133,122,143,169,56,31,122,247,93,172,16,218,218,197,107,109,
18,197,12,40,35,141,20,96,42,129,128,7,176,21,243,159,197,228,160,214,37,253,
217,209,135,123,9,92,174,87,43,197,55,40,116,46,31,131,77,226,174,33,214,209,71,
125,171,188,12,228,15,40,226,8,7,245,253,107,231,111,196,76,11,31,109,220,93,26,
77,36,202,53,57,124,82,63,49,235,146,51,236,78,62,213,244,75,180,61,126,46,21,
224,125,107,136,165,233,97,103,36,195,108,229,130,158,81,247,108,15,189,124,188,
189,184,185,212,47,101,189,187,153,230,184,184,145,164,150,71,57,44,196,228,146,
107,127,26,45,182,201,145,93,140,28,138,228,171,227,207,173,50,209,144,72,197,
97,212,20,83,142,149,221,199,76,129,68,4,54,254,180,240,62,5,52,188,169,202,
228,81,144,102,42,152,107,64,200,204,121,101,13,88,187,249,129,245,21,41,198,80,
26,29,193,230,136,31,65,68,189,130,2,78,212,204,111,155,127,160,164,185,182,
162,219,183,133,133,66,144,232,36,143,145,156,208,25,247,168,22,56,198,122,84,
55,59,212,185,5,12,197,38,204,190,162,137,207,134,197,38,135,12,41,163,142,68,
127,177,166,152,50,121,200,162,159,149,91,237,75,179,0,221,104,209,48,104,136,
173,34,246,34,112,167,139,21,59,136,188,29,42,118,224,28,53,49,39,43,37,116,194,
54,137,101,74,175,139,7,206,133,58,224,26,114,112,170,114,41,105,112,223,122,
195,34,173,13,30,135,248,14,224,52,215,248,246,231,140,47,20,27,109,3,151,185,
83,209,167,145,88,3,255,0,40,223,235,138,165,248,224,176,142,207,183,107,150,
138,55,31,136,178,134,103,102,31,51,28,141,189,128,0,125,171,191,126,1,116,131,
99,216,245,238,164,202,65,212,117,73,25,114,58,170,42,160,63,168,106,111,226,
163,177,13,99,181,13,71,74,213,248,126,243,79,183,188,178,133,160,149,46,121,
151,188,82,217,7,152,3,211,125,177,231,92,17,146,89,109,154,53,163,193,49,41,
205,54,6,99,7,249,77,122,91,74,248,63,226,162,179,182,165,196,154,84,92,177,22,
137,109,213,228,46,248,217,78,66,224,103,207,122,243,173,237,164,182,119,115,89,
220,33,142,88,221,162,145,79,85,101,56,35,245,175,83,4,225,59,81,125,25,73,53,
217,93,59,109,154,7,54,245,57,186,144,104,66,156,222,196,137,147,141,188,169,89,
9,12,69,31,118,24,3,56,30,84,41,23,36,31,214,185,230,82,39,106,60,85,216,157,
134,240,214,129,197,61,168,104,218,39,19,95,139,45,54,226,83,206,217,3,188,32,
100,71,147,242,243,17,203,159,122,235,235,97,130,42,251,134,225,158,239,94,211,
173,109,99,121,46,37,186,141,34,72,199,137,152,176,0,15,122,105,92,24,253,159,
84,172,237,173,236,237,33,180,180,133,32,183,133,4,113,70,131,10,138,6,0,3,200,
1,95,61,62,40,111,199,17,246,229,196,151,154,125,170,126,30,197,214,217,228,
141,48,24,196,161,93,152,249,158,108,140,250,1,95,67,1,238,173,195,57,62,4,203,
103,216,87,152,251,63,209,109,238,62,23,184,251,137,46,44,86,75,189,106,93,74,
240,72,195,45,203,146,163,4,238,55,83,92,24,103,193,242,255,0,219,52,146,179,
201,16,193,204,187,14,155,211,214,209,248,74,249,245,20,59,28,114,15,109,171,
185,62,23,59,61,28,103,218,2,94,106,22,198,77,27,73,196,247,60,223,44,143,249,
35,247,201,220,143,65,239,94,228,165,28,80,115,102,11,110,142,245,248,76,236,
195,253,212,225,191,247,171,86,135,151,88,213,98,6,36,97,189,189,185,193,3,217,
155,98,125,176,61,107,189,43,30,21,95,37,80,62,192,87,85,106,253,179,104,211,
233,235,254,238,242,205,115,117,175,38,137,103,37,199,134,57,100,60,166,73,64,
206,74,40,110,187,100,145,235,94,20,229,44,146,114,102,234,146,53,239,141,187,
157,86,223,178,72,98,176,149,227,180,158,254,56,239,130,131,226,78,86,42,9,242,
28,192,125,118,175,16,55,142,62,83,212,87,188,62,50,162,141,251,13,189,121,38,
228,104,175,45,217,70,62,115,205,140,126,132,159,181,120,38,73,57,36,246,243,
174,255,0,13,175,198,255,0,185,156,251,23,148,117,6,147,152,227,106,110,228,239,
145,72,204,115,189,84,216,144,22,109,234,6,178,119,174,1,181,115,178,204,1,69,3,
106,194,173,72,211,138,19,32,219,84,25,182,169,57,161,53,54,8,195,87,43,6,185,
82,50,218,60,83,49,210,177,209,208,215,68,8,99,81,249,123,209,135,90,4,39,127,
165,51,106,57,166,31,90,221,8,101,87,8,106,80,197,151,27,81,8,29,216,247,52,205,
140,97,164,207,144,21,188,33,110,132,47,32,88,229,94,113,133,124,142,111,32,106,
194,56,215,146,37,24,166,82,219,188,92,8,249,129,235,182,212,98,34,129,212,34,
163,178,129,215,117,31,106,235,142,10,236,155,11,105,221,198,194,89,134,84,12,
133,254,99,254,149,85,171,222,136,129,145,219,114,127,90,122,250,115,35,153,142,
114,228,236,124,191,237,90,142,189,35,201,116,1,39,148,10,159,39,55,227,141,33,
197,89,153,110,94,123,121,36,115,243,48,0,123,81,172,161,98,170,241,200,172,114,
50,181,94,201,139,88,211,39,114,77,53,101,111,48,238,217,50,9,53,231,41,54,237,
150,205,167,64,13,26,60,100,96,243,103,21,112,238,35,141,152,157,148,18,106,175,
75,82,164,3,191,40,206,104,218,172,157,222,149,117,43,48,80,34,109,254,213,234,
227,203,199,25,155,86,192,104,218,149,229,238,164,142,100,238,160,24,97,24,243,
7,32,102,172,184,130,86,26,93,201,94,165,113,90,222,159,58,64,200,241,72,174,
127,15,25,56,96,112,67,110,63,74,218,174,213,36,71,137,247,71,4,26,195,22,119,
40,73,54,41,45,157,126,138,127,90,36,103,19,156,249,10,156,168,35,153,148,28,
242,146,40,124,192,43,183,153,21,196,217,160,172,251,206,88,29,168,50,40,107,55,
207,155,98,184,206,14,78,122,214,29,191,225,212,31,54,174,121,59,29,16,120,2,
195,183,144,2,148,107,94,250,100,37,136,198,0,171,41,55,140,227,249,191,202,162,
138,5,202,251,98,179,106,198,62,150,210,74,170,136,50,204,184,25,170,184,180,
137,216,204,210,171,43,137,48,61,235,109,176,137,66,196,253,8,243,162,132,6,221,
189,73,205,106,224,158,200,229,70,144,136,18,115,27,28,50,156,6,173,219,132,110,
30,91,143,226,28,56,82,9,30,126,245,171,181,134,117,35,35,72,4,44,204,73,29,65,
223,2,182,30,19,96,110,115,208,133,222,186,252,89,56,205,48,151,70,235,14,191,
54,153,143,199,89,92,58,14,147,219,39,58,145,234,64,221,77,55,38,183,47,17,76,
79,14,192,203,106,184,239,239,110,35,42,161,177,186,162,249,183,215,97,73,105,
242,63,54,65,173,155,69,150,72,227,117,80,26,54,249,163,35,194,223,247,247,175,
162,199,57,228,215,45,127,191,255,0,76,52,141,95,92,177,23,150,77,108,206,220,
235,209,155,169,53,215,23,118,141,21,211,70,227,12,173,134,30,245,221,58,229,
130,69,113,224,249,91,12,185,235,130,51,93,117,198,86,13,111,168,254,32,43,24,
165,92,150,198,193,186,87,31,241,12,21,242,70,152,229,232,175,178,189,181,142,6,
142,105,10,115,142,83,203,30,79,235,87,124,1,96,34,213,162,191,134,233,100,140,
18,70,1,4,31,66,15,74,211,136,230,112,160,103,7,160,173,211,178,156,255,0,107,
188,119,60,203,105,26,22,118,243,250,10,231,241,26,252,138,202,125,29,149,169,
94,192,116,126,241,96,136,78,36,43,51,21,5,153,88,109,147,212,213,30,143,169,
207,166,156,90,202,235,24,232,164,228,1,233,191,151,181,31,90,188,23,67,146,40,
99,134,16,118,85,27,159,169,243,170,105,72,65,214,189,202,87,116,115,182,93,
106,28,65,52,177,178,243,4,83,185,10,48,13,106,247,183,141,44,217,52,59,137,137,
98,51,181,35,113,46,6,106,114,100,213,33,29,157,216,119,104,58,55,103,247,154,
246,167,168,91,220,92,221,205,104,177,217,197,24,24,118,230,201,12,127,40,217,
119,250,215,173,248,27,81,212,53,142,15,210,181,109,82,8,173,239,47,45,82,121,
34,143,60,169,204,50,0,206,253,8,175,16,246,57,194,210,113,183,105,58,110,144,
80,155,64,221,253,225,242,16,166,236,62,251,47,222,189,235,26,36,113,172,113,
168,68,80,21,84,12,0,7,65,95,29,252,99,241,254,109,126,167,223,252,35,179,13,
209,42,229,66,226,84,130,7,153,200,10,138,88,253,171,49,22,49,41,113,134,35,36,
122,26,242,13,138,46,210,52,185,53,190,207,248,131,72,130,5,184,154,243,78,158,
24,162,63,153,202,16,163,245,197,124,195,54,210,194,210,67,52,109,28,177,57,87,
70,24,42,65,193,7,239,95,86,235,194,95,22,92,14,120,95,181,59,221,66,8,194,216,
107,138,111,97,192,217,100,207,241,87,254,173,255,0,230,21,217,225,181,205,199,
236,137,244,116,156,145,142,99,183,93,232,13,22,85,128,250,211,211,1,133,62,212,
21,32,62,61,107,211,226,140,196,238,34,1,149,177,243,45,70,32,57,8,20,205,232,
6,4,97,228,72,164,81,240,196,87,60,151,22,51,46,65,136,143,74,76,201,149,43,
76,160,46,236,190,180,51,111,202,251,214,82,77,148,132,201,60,212,91,77,228,
199,168,174,75,22,26,165,2,148,148,103,214,178,167,99,49,42,98,83,239,189,69,70,
89,148,121,138,110,241,48,85,190,212,186,237,34,183,161,161,160,23,222,141,27,
22,129,215,204,110,43,107,236,199,128,181,142,208,184,222,219,134,52,85,11,36,
196,188,179,178,146,144,68,58,187,99,200,126,228,129,74,113,255,0,10,222,112,79,
30,234,220,45,125,32,150,93,62,225,161,50,133,229,18,47,85,112,15,145,4,31,189,
77,238,128,214,217,242,170,104,214,206,67,99,214,132,99,33,153,8,232,107,102,
236,207,130,245,158,58,226,251,30,26,209,35,67,119,116,199,196,231,9,26,40,203,
59,31,64,5,84,109,59,96,108,221,153,240,157,174,161,161,234,220,93,196,109,53,
191,13,233,9,202,237,25,229,123,187,150,31,195,183,140,159,50,112,88,249,40,39,
210,180,201,166,221,176,2,130,118,3,202,189,45,241,47,161,30,30,209,120,43,177,
110,10,183,55,205,26,53,229,204,22,232,90,121,167,62,17,35,129,211,57,115,236,
61,128,175,56,241,158,139,123,195,92,77,127,195,250,139,66,215,150,19,24,103,
238,95,157,3,142,160,31,60,29,190,213,190,44,150,174,251,245,251,19,36,84,74,
229,188,250,214,45,237,229,184,153,33,137,75,200,236,21,84,117,36,156,1,88,32,
147,93,183,240,163,193,115,113,135,108,90,72,48,44,150,26,91,139,251,194,78,0,
84,62,17,239,151,229,24,250,212,205,210,114,98,71,187,59,31,225,101,224,190,
204,244,30,26,207,52,150,118,138,38,111,89,91,196,231,254,162,105,158,13,226,
157,63,138,47,181,195,165,202,39,182,211,47,127,0,101,93,213,228,69,5,240,124,
192,45,143,177,164,251,101,226,216,248,35,179,77,111,136,139,1,53,189,185,91,97,
159,154,103,240,160,255,0,168,131,244,6,180,223,132,62,28,214,56,123,177,248,27,
91,140,71,115,169,221,62,160,170,78,95,146,69,94,82,222,132,227,56,247,21,231,
113,248,242,102,191,177,220,53,243,255,0,226,203,129,230,225,14,212,111,110,212,
15,192,107,46,247,214,172,163,24,44,222,52,250,134,63,161,21,244,2,188,203,241,
247,166,164,188,39,195,154,174,84,73,5,228,144,96,245,33,208,55,255,0,193,251,
215,87,133,55,28,169,125,232,156,138,209,226,171,229,195,243,14,141,75,249,230,
156,185,193,66,167,168,220,85,223,102,188,13,196,124,127,196,48,232,220,59,167,
77,116,236,195,190,148,47,240,224,76,238,206,221,0,254,190,85,219,153,168,187,
102,104,245,71,96,125,135,112,158,187,216,238,147,197,15,99,42,235,55,250,109,
220,110,101,108,172,140,226,88,209,128,61,48,24,31,176,53,228,142,42,225,189,95,
133,248,130,239,135,245,219,67,105,168,218,48,18,196,88,55,41,32,17,184,36,110,
8,53,245,59,134,116,155,109,3,135,52,237,18,204,1,111,97,107,29,188,120,24,
200,69,11,159,190,43,201,191,25,61,139,219,233,145,222,118,155,161,77,121,43,
220,93,134,212,237,88,115,170,115,103,248,170,70,225,114,0,32,244,205,121,248,
114,124,247,236,210,75,71,148,85,112,62,149,187,246,19,169,89,233,157,177,240,
157,246,161,34,71,107,22,169,15,120,238,112,171,150,192,39,216,18,13,105,45,128,
222,212,51,177,250,87,108,149,166,136,179,235,124,82,193,119,3,52,50,172,145,
182,87,153,27,35,208,239,93,81,197,118,80,118,121,240,209,175,216,63,40,75,123,
43,184,227,15,249,140,210,184,79,255,0,49,73,252,22,181,228,157,130,233,146,94,
75,36,165,174,174,59,178,228,146,16,62,0,201,242,200,53,65,241,233,171,201,101,
217,78,157,166,198,216,26,134,168,130,77,250,170,35,54,63,94,95,210,188,216,195,
250,138,63,185,171,122,179,197,214,243,242,191,46,118,59,87,170,254,3,63,180,
102,188,226,89,133,227,141,58,40,226,86,182,252,173,51,19,135,246,33,84,143,191,
181,121,17,159,27,131,94,162,248,0,214,46,127,222,190,34,209,192,6,218,226,202,
59,150,62,97,209,249,71,234,28,254,130,189,63,42,119,137,163,40,118,119,119,
197,71,28,75,193,93,149,221,53,159,120,183,218,171,126,6,222,69,255,0,195,230,4,
187,127,210,27,30,228,87,133,244,43,233,211,93,210,36,89,164,229,130,242,55,69,
12,112,167,157,73,32,121,29,191,106,245,135,199,216,156,118,119,160,200,139,
152,70,168,68,141,232,76,77,203,253,13,120,227,135,174,85,53,171,34,228,114,165,
204,108,121,186,108,192,214,94,45,44,79,252,142,125,159,82,117,189,47,77,215,
244,91,141,43,85,181,138,242,194,242,34,146,197,32,202,178,145,255,0,189,252,
171,193,127,20,29,143,142,204,53,123,75,189,46,230,107,173,19,82,46,32,50,143,
28,14,187,247,108,71,205,177,200,59,103,7,210,190,128,68,193,162,70,24,193,80,
70,58,87,145,62,63,120,163,86,135,83,209,248,65,48,186,84,246,194,245,249,163,
82,90,85,118,80,85,186,140,14,191,81,92,120,37,37,36,151,178,228,180,121,65,
223,153,125,197,45,33,169,177,195,123,26,131,12,237,93,146,118,66,5,138,200,169,
21,200,172,133,172,202,38,163,106,131,209,64,218,135,37,104,32,13,80,52,70,161,
212,49,152,21,202,200,174,80,5,146,3,233,71,140,12,238,105,53,106,102,35,91,65,
162,88,228,88,228,39,56,21,99,164,164,14,228,188,174,164,13,188,25,21,90,14,16,
10,126,199,195,19,55,174,213,211,14,201,31,157,66,200,80,145,225,30,84,246,154,
201,21,172,151,24,5,185,194,46,122,12,140,230,171,46,103,134,71,103,28,234,72,0,
142,187,214,96,186,11,3,66,164,144,204,24,146,61,43,170,51,81,118,132,91,220,92,
202,201,133,60,199,200,19,181,66,216,220,58,179,72,171,145,185,11,184,2,171,90,
91,182,218,33,8,30,172,73,167,173,165,104,35,1,37,124,227,5,179,185,173,127,35,
111,98,160,151,15,206,115,140,0,48,5,80,107,49,171,142,111,48,118,171,171,139,
158,245,8,125,220,124,172,6,231,216,213,13,243,151,145,23,203,53,203,228,52,209,
72,27,103,190,142,48,54,84,20,245,133,195,126,36,71,208,45,40,172,63,18,228,
236,5,6,238,241,45,195,152,254,119,219,232,43,153,75,139,177,179,117,211,238,
173,136,101,239,227,44,58,140,213,7,24,234,137,112,166,198,221,195,34,16,92,131,
177,111,74,213,100,145,153,57,185,142,73,206,115,69,138,62,123,54,100,96,124,89,
62,84,231,228,185,71,138,64,144,250,67,52,113,44,177,51,35,132,231,12,190,96,
117,205,111,145,93,119,218,84,55,64,252,208,134,253,171,83,180,229,35,75,138,65,
133,150,39,141,190,185,63,246,167,180,235,169,34,225,87,70,27,196,205,17,246,25,
165,134,92,109,19,45,149,115,74,228,228,227,115,185,205,9,223,192,217,53,9,216,
121,238,166,129,33,41,9,220,145,239,83,41,20,144,43,134,192,200,56,53,44,146,
209,70,79,55,159,210,133,55,49,28,163,106,132,33,204,224,179,26,196,99,234,234,
124,36,239,204,106,97,127,143,147,234,42,177,1,102,45,204,64,206,106,210,221,35,
146,64,26,114,163,174,121,104,166,196,108,150,50,129,0,25,222,137,43,17,11,21,
235,138,90,194,223,188,33,97,157,24,251,230,154,145,101,128,50,72,132,169,29,87,
113,90,164,234,200,53,214,39,189,223,168,53,178,112,189,159,37,177,185,99,150,
144,237,236,42,142,84,141,166,110,94,185,220,26,219,52,8,202,233,144,131,215,
127,235,93,62,63,202,99,125,23,154,100,92,200,79,161,21,180,233,214,87,119,10,
33,178,116,89,220,128,188,201,204,63,76,138,165,209,162,194,73,159,85,173,207,
68,34,215,77,186,186,31,56,64,139,237,205,177,63,167,245,175,163,241,227,73,
152,51,83,226,9,181,232,111,197,164,150,118,87,41,26,242,45,212,82,148,66,71,
153,83,147,250,85,15,18,173,203,104,115,133,195,75,203,131,129,183,189,108,58,
197,201,105,27,39,207,97,90,183,21,106,107,99,164,200,196,22,121,114,138,62,219,
154,195,202,146,73,237,208,71,179,74,210,46,165,129,217,4,239,26,179,14,118,69,
28,223,169,173,167,65,191,113,174,61,170,200,103,139,151,34,82,6,126,153,29,69,
104,208,14,105,25,88,224,176,243,53,111,160,105,102,105,196,240,223,8,221,55,56,
216,143,222,188,156,57,120,73,51,89,36,118,165,189,157,197,201,45,201,221,69,
140,180,178,120,84,15,173,10,239,76,179,17,150,254,214,182,99,228,168,9,53,166,
193,171,222,188,15,21,197,195,201,221,183,46,236,112,125,241,76,233,183,50,73,
114,168,88,248,136,21,237,227,242,20,210,49,104,206,173,20,182,55,175,111,54,3,
15,48,118,32,244,52,140,132,56,10,185,44,78,0,30,117,99,218,27,242,106,206,6,
220,136,171,250,10,236,14,196,244,126,24,225,125,54,215,180,110,208,230,41,11,
75,141,23,79,229,13,37,211,131,142,251,148,245,80,122,103,108,140,250,87,31,
151,229,199,2,119,191,164,84,97,201,157,231,240,205,217,161,224,222,30,254,220,
213,35,145,53,189,78,33,222,70,199,251,136,178,10,166,63,155,161,63,97,229,93,
195,75,233,151,49,222,105,246,247,81,21,41,44,97,193,12,24,110,61,70,198,152,
175,143,203,150,89,102,231,46,217,218,146,138,164,117,247,108,220,82,154,23,251,
183,164,41,6,93,107,88,130,221,151,56,61,208,117,46,127,252,71,222,187,6,188,
163,241,121,196,77,163,246,205,193,243,206,178,155,93,62,24,174,202,142,141,137,
201,108,123,225,69,118,119,108,93,180,47,10,118,113,162,113,159,12,216,219,234,
246,186,188,220,145,52,236,200,170,188,172,114,64,223,57,82,49,87,44,95,24,87,
110,255,0,228,87,182,119,5,116,23,198,254,140,151,157,154,88,235,64,129,46,155,
124,171,211,170,74,10,145,250,133,174,223,236,247,138,44,120,207,131,116,206,37,
211,142,32,190,132,57,76,228,198,253,25,15,184,96,71,218,163,218,55,12,219,113,
143,4,106,188,55,117,128,151,182,229,17,143,228,113,186,55,217,128,53,156,36,
225,52,254,134,246,143,152,178,72,74,96,158,135,20,2,199,32,211,186,246,159,119,
164,107,55,186,85,252,45,13,213,164,239,12,200,195,117,101,36,17,72,176,205,123,
28,175,163,32,146,120,173,152,122,16,105,105,173,46,45,228,143,191,130,88,76,
138,29,57,208,175,50,158,132,103,168,247,174,227,248,84,159,134,219,180,251,93,
27,137,244,91,29,78,215,86,67,107,25,185,78,97,12,189,84,128,118,223,28,191,
122,245,151,110,29,141,104,93,162,240,148,22,16,172,58,126,171,167,68,19,77,188,
9,158,237,71,254,19,99,170,31,219,168,243,207,54,124,220,38,147,69,70,54,143,
158,16,32,73,122,117,169,77,3,203,48,72,163,105,29,186,42,140,147,91,71,31,240,
31,18,240,87,22,39,12,235,54,39,251,65,194,152,86,3,222,9,213,142,20,166,58,
228,130,49,214,189,87,240,229,216,93,223,11,112,253,247,16,241,12,16,47,19,95,
89,60,54,80,75,226,91,21,116,35,45,143,206,114,51,142,131,111,51,85,151,52,33,
11,91,250,18,77,179,196,19,168,7,113,130,58,208,28,128,65,21,177,118,147,194,
92,65,192,188,85,113,195,252,77,110,144,223,198,4,135,146,64,234,234,219,134,4,
121,31,214,181,130,249,92,86,110,73,237,14,134,231,241,195,145,229,131,64,3,52,
72,31,153,57,79,166,40,96,129,64,30,162,255,0,103,204,5,248,235,136,174,185,
114,19,75,72,201,247,50,131,255,0,240,214,159,241,179,100,99,248,128,191,148,46,
59,251,43,105,62,190,14,95,255,0,134,187,67,224,43,71,212,172,63,181,53,75,93,
75,72,191,210,181,8,16,92,195,13,193,252,77,156,232,79,40,145,10,141,136,45,
184,56,233,239,91,39,199,47,7,218,234,28,23,101,197,241,90,150,189,211,166,91,
121,100,77,177,12,135,171,109,184,12,0,30,156,198,185,226,215,230,41,254,147,
197,113,88,126,34,254,8,84,168,105,217,80,19,208,18,113,189,125,2,248,123,236,
63,74,236,177,46,53,23,191,58,166,179,121,10,199,37,199,119,200,145,47,82,168,
58,224,156,100,157,206,7,74,242,79,97,125,158,107,92,123,198,186,116,54,54,206,
182,22,119,49,203,125,118,201,152,225,69,57,32,158,133,142,48,7,191,165,125,21,
173,124,183,197,168,39,253,197,13,236,232,95,138,14,51,176,236,167,73,185,213,
244,13,62,53,226,238,37,61,202,95,180,124,198,24,227,80,165,178,125,1,0,40,243,
57,242,175,4,221,220,203,115,115,36,243,200,242,205,35,23,145,220,229,153,137,
201,36,249,147,95,67,62,49,248,126,195,88,236,55,87,190,185,182,18,221,105,69,
46,109,100,29,99,110,117,86,251,21,39,63,246,175,157,236,163,154,171,197,75,
131,107,177,79,176,177,128,107,215,63,236,246,209,216,55,21,107,204,60,56,134,
205,62,190,39,111,255,0,134,188,145,10,215,188,126,5,173,173,161,236,102,105,
162,101,51,79,170,76,102,199,80,66,160,0,253,134,126,245,94,78,177,138,29,148,
191,28,28,70,150,177,112,182,128,209,52,240,181,209,212,46,96,57,9,42,198,66,
170,147,239,150,170,158,201,254,34,117,237,87,180,91,91,46,39,22,22,122,21,217,
48,71,20,16,133,22,204,112,35,37,142,228,3,177,250,231,202,182,47,141,254,29,
123,222,25,209,56,134,49,145,99,112,246,242,251,44,128,16,127,84,199,222,188,
239,217,103,10,223,241,119,29,105,186,30,158,10,180,178,135,150,76,100,69,26,
238,206,126,131,247,197,116,120,184,48,228,241,156,167,234,247,245,255,0,180,76,
229,37,42,71,209,42,241,215,199,55,24,29,75,137,236,56,54,216,14,227,75,79,196,
92,55,172,210,46,195,236,191,254,94,213,235,248,196,118,118,64,60,159,195,134,
63,19,183,160,27,147,95,54,251,77,215,15,17,241,230,183,173,187,115,11,219,201,
36,79,100,207,132,127,210,0,174,79,225,248,249,228,228,253,23,149,210,162,231,
225,255,0,177,91,254,213,117,139,169,94,253,52,237,27,79,116,91,201,128,230,149,
203,100,132,65,211,56,7,115,176,247,175,120,118,127,193,124,57,192,156,59,22,
133,195,58,122,89,218,71,187,30,178,74,222,110,237,213,155,222,186,67,224,46,
202,72,184,35,136,111,206,59,187,141,69,17,127,228,140,103,255,0,202,157,248,
207,237,55,137,120,11,70,208,44,248,90,234,91,11,203,235,135,150,75,181,64,192,
36,96,127,15,112,65,201,96,79,176,172,252,135,44,153,156,87,216,227,74,54,119,
156,90,230,145,47,16,75,195,241,106,54,207,170,195,0,184,150,209,92,25,18,50,
112,24,143,32,77,57,117,111,5,213,172,182,183,49,36,208,76,133,36,141,215,42,
234,70,8,35,204,17,95,51,120,43,181,78,43,225,174,211,79,31,254,49,175,245,57,
100,99,122,39,99,203,116,141,243,35,99,160,233,140,116,192,199,74,247,71,195,
255,0,108,58,103,107,90,69,253,197,182,155,46,153,123,167,186,45,197,187,200,36,
24,96,121,89,88,1,145,177,27,143,42,203,38,25,67,108,106,73,158,96,248,137,248,
113,215,120,87,82,184,215,120,46,206,125,87,135,228,47,43,65,16,230,150,196,0,
88,130,63,50,0,14,24,111,228,125,79,158,226,71,154,68,142,53,46,238,193,85,71,
82,79,74,250,222,193,28,24,216,43,2,55,83,230,43,229,198,187,12,60,59,218,245,
245,191,36,107,14,157,174,184,9,159,8,84,156,224,125,48,43,124,57,101,36,211,
244,76,162,145,244,127,178,30,28,255,0,116,123,50,225,238,29,100,9,45,157,140,
107,48,7,63,197,35,153,255,0,245,19,94,92,255,0,104,15,17,53,207,20,104,28,53,
20,128,197,101,110,247,50,175,255,0,113,200,3,246,95,220,215,178,44,229,19,218,
69,58,186,186,200,129,195,47,66,8,200,197,124,236,248,182,212,22,255,0,183,190,
36,8,156,139,109,36,118,224,122,149,141,114,126,228,154,199,199,92,178,38,84,
244,142,169,102,218,189,93,254,207,13,45,158,255,0,139,53,198,199,44,113,65,104,
158,185,98,206,127,252,86,188,150,88,244,175,100,127,179,178,82,120,127,139,160,
228,216,93,219,191,55,213,28,99,246,174,175,37,252,8,135,101,191,251,65,53,88,
109,187,53,209,52,163,131,53,230,169,222,175,168,88,227,108,159,213,214,188,70,
37,33,131,131,138,244,135,251,65,181,86,185,237,43,69,210,3,183,119,103,165,
247,156,185,216,52,146,54,79,232,171,94,106,133,30,73,22,36,5,157,136,10,7,153,
53,24,29,64,114,236,250,193,193,178,180,252,33,162,206,236,25,164,176,129,137,
7,57,38,53,53,227,127,246,129,222,73,47,105,154,29,145,70,88,237,244,174,101,
98,54,98,210,182,113,255,0,72,174,255,0,248,87,224,110,53,224,62,7,159,76,227,
29,85,46,251,217,86,75,59,101,153,165,22,137,140,21,4,244,7,99,129,176,173,55,
227,215,132,97,212,251,60,177,226,200,96,205,230,145,114,34,145,199,94,226,77,
136,62,193,249,127,83,92,184,218,140,209,111,163,195,204,51,92,27,140,250,86,84,
102,179,140,31,173,118,209,4,121,106,65,48,106,106,42,101,105,164,0,136,197,14,
65,70,52,23,53,78,132,1,197,12,209,28,208,201,168,99,34,107,149,198,174,84,128,
210,29,233,184,78,226,149,229,32,209,160,39,57,52,163,38,152,199,26,79,22,41,
232,159,150,221,71,173,83,134,203,125,234,195,155,203,249,86,186,33,148,150,137,
188,164,167,213,168,176,190,212,179,140,4,95,65,69,139,96,43,101,50,104,177,130,
74,96,62,71,90,70,6,201,192,220,154,59,200,145,12,55,137,191,148,31,235,90,172,
154,10,37,44,165,124,92,216,198,224,208,18,202,105,149,47,35,195,166,249,94,132,
99,211,214,148,188,153,164,56,39,25,61,5,53,125,127,29,133,170,193,25,13,34,
166,0,30,190,181,207,44,150,195,162,166,123,181,12,216,4,182,105,9,152,185,230,
99,185,172,73,43,51,150,99,150,61,104,110,121,142,51,92,206,111,217,116,78,64,
8,85,199,149,66,85,120,192,92,144,62,180,80,193,174,2,128,163,112,55,56,172,
234,12,69,195,196,192,0,173,145,82,221,161,150,186,72,99,167,119,139,39,138,57,
51,200,221,62,162,172,164,212,75,218,92,195,44,60,134,126,87,66,131,3,152,108,
217,250,143,220,85,110,129,36,82,67,61,179,48,5,227,240,159,66,55,31,231,76,77,
137,116,104,102,94,177,74,99,127,108,238,43,92,114,33,161,70,111,155,61,7,74,
132,205,224,229,62,116,57,153,8,10,227,59,210,239,57,141,153,84,100,13,198,105,
182,49,136,249,228,112,2,18,115,131,245,169,72,166,218,86,121,19,45,203,144,1,
216,85,115,221,204,178,115,41,198,71,151,181,15,241,50,58,200,94,66,75,15,51,83,
104,11,61,54,214,230,120,187,196,69,100,36,174,237,138,106,214,218,236,171,133,
143,152,163,148,111,16,234,63,249,170,139,43,153,163,139,9,35,46,91,36,121,81,
32,212,46,96,119,40,255,0,51,100,231,214,142,85,232,40,217,52,217,174,173,101,
230,120,36,3,27,255,0,236,86,193,111,170,217,220,70,176,203,207,19,231,1,155,
203,245,197,104,201,174,222,168,195,34,63,236,106,219,79,226,200,121,146,59,187,
84,100,200,200,97,154,168,230,227,232,78,22,92,235,58,103,60,210,77,109,50,22,
7,36,46,199,244,52,239,15,106,65,154,43,57,193,73,83,111,99,76,105,113,104,90,
211,150,176,212,18,210,99,184,142,70,202,19,236,58,138,175,214,244,171,221,51,
81,134,71,141,148,135,24,97,186,157,252,143,165,111,138,124,90,156,73,167,211,
59,15,72,154,221,127,19,222,79,26,225,199,83,86,55,156,71,166,67,96,44,160,186,
70,119,110,105,152,111,211,162,143,235,90,38,147,42,221,11,204,236,123,205,199,
220,215,26,211,158,98,20,132,198,249,61,43,214,135,153,46,52,145,155,136,230,
175,175,91,247,140,16,51,31,208,86,147,197,26,203,222,42,194,234,170,171,226,95,
92,213,229,254,149,51,72,89,100,83,183,189,104,220,72,146,193,49,141,193,12,
167,122,228,242,114,228,227,114,232,113,138,176,112,206,207,40,98,112,125,168,
246,218,181,213,140,141,221,73,128,78,24,17,212,85,125,148,175,156,28,108,54,
171,29,58,59,151,189,148,68,209,142,117,193,230,92,237,92,106,77,173,22,209,99,
97,126,211,172,211,16,64,44,42,239,78,185,229,145,95,152,109,90,252,80,180,16,
188,35,27,62,78,41,171,54,96,70,125,107,208,241,242,56,164,140,228,141,203,180,
17,223,219,91,235,80,32,154,9,21,68,163,249,88,121,31,173,105,92,75,175,106,90,
245,255,0,226,239,238,30,86,88,214,56,212,159,12,104,163,1,84,116,85,0,108,5,
118,36,26,111,127,217,245,226,203,253,236,229,90,5,206,237,203,214,186,202,226,
217,237,217,149,144,130,61,106,252,220,109,201,76,35,244,123,255,0,225,87,90,
182,214,187,13,225,243,2,114,53,148,109,103,50,231,163,198,122,253,193,7,239,93,
163,93,9,240,55,169,65,117,217,21,205,132,113,132,154,203,82,144,74,71,231,231,
85,96,127,203,237,93,247,95,45,145,84,218,253,206,181,209,231,63,142,237,51,70,
126,207,180,205,102,225,17,117,120,111,150,222,213,199,204,209,178,177,117,250,
108,13,121,215,178,254,32,143,137,120,151,131,184,39,142,181,38,255,0,116,44,46,
157,82,15,145,67,73,204,71,51,46,251,177,3,62,64,158,149,232,207,143,29,46,226,
231,179,189,31,84,137,25,161,177,212,8,155,3,101,18,33,0,159,184,3,239,94,41,89,
8,185,4,100,111,145,93,152,18,150,42,191,191,240,68,180,207,122,118,35,103,55,
103,157,164,241,47,102,83,134,143,73,186,99,171,240,241,102,200,104,88,129,44,
106,125,84,242,237,215,98,124,235,187,43,204,122,239,21,94,106,221,138,112,7,
107,90,86,37,189,225,59,212,77,80,21,37,204,120,16,206,51,232,124,39,238,15,149,
122,98,210,120,238,173,98,185,133,131,71,42,7,66,60,193,25,21,197,43,189,150,
143,19,124,113,240,87,246,39,31,219,113,101,156,28,182,122,220,120,156,170,236,
46,16,96,231,221,151,7,236,107,207,35,60,160,215,210,15,136,190,23,177,226,190,
200,117,219,59,209,134,181,182,107,219,121,2,243,24,228,136,22,4,15,112,8,62,
196,215,206,17,242,26,244,60,73,242,141,63,70,115,84,203,62,23,212,166,209,181,
219,13,90,6,34,91,59,152,231,76,29,242,172,15,249,87,212,77,34,250,29,79,74,180,
212,109,206,97,186,129,38,140,255,0,133,148,17,253,107,229,66,55,81,237,94,206,
248,63,237,134,78,35,75,94,206,181,27,21,142,125,55,78,205,173,210,201,253,242,
161,0,171,41,243,1,135,79,67,83,230,198,210,146,244,56,63,71,126,221,240,214,
131,119,196,182,188,73,115,165,219,77,171,90,66,97,183,186,116,203,196,132,228,
133,244,62,253,119,53,109,92,174,87,158,104,124,227,248,200,189,91,175,136,78,
34,229,206,33,238,33,220,250,66,153,254,181,220,63,11,255,0,14,90,124,186,14,
159,199,124,115,103,37,213,196,193,167,179,209,230,69,238,154,50,190,6,148,17,
146,79,80,58,116,205,118,143,29,246,9,163,113,127,110,218,119,31,106,77,19,233,
144,219,41,188,177,35,123,155,136,206,35,39,203,151,24,207,175,40,30,102,187,
165,64,85,10,160,0,6,0,30,85,110,119,21,20,42,217,243,163,81,236,115,95,135,179,
78,44,237,27,90,176,186,209,141,166,162,35,179,211,218,30,78,101,50,242,200,
196,121,42,228,5,198,199,7,202,186,145,145,185,190,187,215,212,14,220,236,96,
212,187,29,226,203,75,142,110,237,180,169,223,97,146,10,169,96,127,85,21,243,41,
144,20,82,60,182,174,143,29,185,39,100,79,71,103,124,37,107,247,92,61,219,158,
130,35,186,146,43,109,70,83,101,114,129,176,178,43,169,10,24,121,225,185,72,175,
160,92,107,160,90,113,87,9,106,156,59,122,74,193,168,91,60,12,192,100,161,35,
102,30,224,224,253,171,230,63,3,95,127,100,241,158,137,170,115,21,252,45,252,19,
18,60,130,200,9,254,149,245,61,24,58,6,83,144,70,65,168,242,35,198,73,161,193,
218,53,238,206,56,82,199,130,184,55,78,225,219,21,140,173,164,33,100,149,80,41,
153,255,0,51,182,60,201,222,182,42,229,107,29,169,241,149,151,0,240,46,165,197,
23,200,37,75,68,29,220,60,220,166,105,24,128,168,15,185,53,134,219,253,203,13,
218,79,15,175,21,240,14,185,195,167,173,253,148,144,167,139,30,50,60,59,250,115,
98,190,91,95,90,79,101,123,61,149,212,109,20,246,242,52,82,163,117,86,83,130,
63,81,95,84,184,39,136,172,120,183,132,244,206,36,211,121,197,166,161,110,179,
70,174,48,203,158,170,125,193,200,251,87,134,254,55,116,45,51,68,237,165,165,
211,109,133,185,212,172,146,242,228,3,179,74,89,149,152,15,44,242,140,251,228,
215,79,141,62,50,113,126,200,154,213,157,43,101,30,91,122,247,247,193,133,153,
180,236,58,206,66,138,166,230,246,226,92,142,164,115,114,228,255,0,211,94,17,
208,172,46,117,11,219,123,75,56,154,91,139,137,22,56,163,81,187,51,28,0,62,230,
190,153,246,101,195,81,112,127,1,233,28,59,30,51,103,110,22,66,60,228,59,185,
255,0,168,154,219,204,105,65,34,97,216,247,23,233,54,186,239,12,234,58,85,229,
172,119,81,92,91,186,119,110,1,5,176,121,79,177,7,4,26,233,223,131,174,25,178,
211,248,62,255,0,95,123,70,93,74,230,241,237,218,71,92,17,18,114,225,87,216,156,
231,220,123,87,123,215,93,118,199,218,103,14,118,81,194,194,89,146,41,47,228,66,
186,126,155,22,198,67,234,113,242,160,61,79,233,189,114,195,36,248,60,113,247,
95,236,91,74,237,136,124,72,118,161,165,246,119,193,178,193,32,91,173,91,82,
141,225,182,180,18,114,176,86,4,52,167,209,71,238,118,245,175,159,211,207,222,
40,101,243,167,120,211,138,181,174,50,226,91,189,119,94,188,107,171,203,166,
201,39,229,65,228,138,60,148,116,2,171,52,244,46,26,54,175,83,198,199,248,163,
94,217,132,229,201,158,243,248,48,179,130,219,176,203,25,162,112,207,119,121,
113,52,187,116,110,126,92,126,138,41,159,138,126,203,245,94,211,184,42,206,211,
66,146,205,53,45,62,228,207,26,220,18,189,226,149,33,144,55,145,59,29,246,219,
202,180,111,134,110,214,251,61,225,174,206,244,174,19,212,245,59,139,13,65,37,
115,43,92,66,123,162,238,228,236,227,32,13,192,223,21,233,104,164,142,88,150,88,
157,100,141,192,101,101,57,12,15,66,15,152,175,47,42,148,50,182,254,205,227,78,
39,202,254,53,225,45,119,131,56,133,244,46,35,178,54,119,200,129,158,62,112,
222,22,232,65,4,140,86,255,0,240,183,218,63,255,0,166,253,161,171,95,28,105,26,
167,37,173,241,63,248,99,155,195,39,252,185,63,98,107,178,62,58,120,22,242,211,
138,173,56,234,57,101,184,177,212,17,109,101,13,146,45,228,65,225,3,209,88,100,
143,112,222,181,230,185,99,217,100,245,24,63,90,244,113,197,103,197,191,102,45,
241,145,234,126,201,187,105,158,126,214,120,247,82,215,117,163,119,9,211,230,26,
68,102,62,85,101,183,50,58,42,129,176,202,228,147,230,77,121,151,132,237,165,
226,190,210,116,187,123,222,105,228,213,117,88,196,251,238,253,228,163,155,250,
154,169,102,100,4,171,50,158,153,7,27,29,141,118,7,195,5,144,190,237,247,132,
162,43,204,169,123,223,16,127,192,140,223,229,89,75,10,196,164,215,209,74,92,
168,250,75,111,18,65,4,112,68,188,169,26,132,81,232,0,192,175,158,127,24,26,60,
186,79,111,250,227,184,254,30,160,176,221,198,113,212,50,0,127,245,41,175,161,
245,229,143,142,174,6,212,117,91,72,56,230,22,183,142,203,70,182,75,105,87,148,
247,178,180,146,236,115,211,149,114,63,83,92,126,60,148,114,43,52,146,180,120,
214,88,200,53,235,255,0,246,118,60,159,217,156,97,23,119,252,49,53,171,7,207,
159,44,155,87,146,228,64,241,130,5,122,179,253,157,243,129,39,24,218,103,124,90,
201,143,255,0,200,43,179,203,85,2,33,217,212,159,24,183,154,157,215,111,154,220,
122,145,82,45,22,40,109,176,184,196,60,161,151,235,243,29,235,172,52,237,31,91,
154,7,213,116,253,54,250,91,123,95,226,61,196,80,51,36,88,223,152,176,24,24,199,
90,244,183,199,255,0,8,155,94,38,209,184,202,21,94,235,80,136,217,220,96,110,
36,143,116,39,234,164,255,0,211,93,137,240,25,60,151,189,142,106,54,87,80,43,
219,193,169,203,18,115,168,33,213,145,11,47,184,201,63,173,115,41,241,198,154,
42,190,71,101,252,63,241,220,125,161,118,95,165,235,142,196,223,34,11,123,240,
70,63,142,128,6,63,70,249,135,215,218,158,237,187,67,255,0,121,59,36,226,125,
28,114,7,159,78,148,198,88,224,7,65,206,187,253,84,85,191,6,112,206,149,194,90,
47,246,62,139,0,183,178,89,229,154,56,128,217,59,199,46,84,123,2,199,30,213,99,
170,216,219,106,122,101,214,157,120,156,246,247,80,180,50,174,113,149,97,131,
251,26,230,254,197,159,38,128,197,100,12,214,227,219,31,3,106,61,158,113,222,
161,195,183,200,230,40,220,189,164,228,109,60,39,116,96,126,155,31,66,13,105,
200,219,215,164,169,171,70,65,16,86,88,237,238,42,37,177,189,10,73,55,218,155,
208,17,149,233,119,122,204,135,122,25,205,67,99,48,78,106,53,202,225,164,6,26,
185,92,97,92,165,64,89,20,53,48,152,143,52,112,153,169,204,128,0,163,235,87,192,
44,82,20,204,170,61,233,197,241,51,123,156,84,33,64,28,159,65,76,219,32,37,126,
230,166,168,102,36,254,240,251,109,92,83,82,42,138,115,60,171,24,39,207,114,126,
212,67,110,8,204,109,145,239,181,104,155,37,209,152,152,164,79,32,219,27,15,169,
168,25,0,143,210,131,168,206,97,137,32,200,254,99,75,25,242,128,3,190,50,125,
169,75,39,160,51,117,51,247,139,221,231,32,230,148,152,57,230,121,100,221,142,
228,245,172,27,142,103,41,25,11,234,199,206,148,149,216,73,137,50,125,235,23,42,
41,32,234,109,87,231,102,99,245,163,219,205,96,29,71,113,204,115,230,41,64,129,
162,108,108,203,184,172,70,27,152,159,65,81,201,142,135,161,189,211,140,196,201,
104,8,39,113,146,40,202,52,153,223,10,76,4,237,134,57,6,170,90,6,18,28,14,187,
212,160,133,158,225,114,50,20,100,138,20,159,208,169,23,214,54,143,105,41,158,
209,227,144,122,16,28,26,118,222,214,230,6,188,91,196,68,180,188,78,100,116,7,
145,92,110,62,149,172,69,206,178,51,41,42,60,176,113,87,122,78,189,169,88,196,
88,48,146,5,35,193,48,4,48,251,245,173,35,37,98,105,136,50,151,24,252,194,150,
127,20,156,132,224,168,216,250,213,203,155,77,82,241,229,178,88,237,36,62,35,9,
56,76,255,0,135,211,233,85,23,161,161,156,199,34,21,117,111,18,17,184,53,111,
236,16,2,20,131,159,11,10,27,33,84,232,10,231,57,20,209,8,224,182,1,168,142,236,
70,202,6,27,35,4,80,192,136,194,164,89,29,65,52,2,72,39,0,227,52,228,201,227,
72,93,182,88,193,233,143,122,129,85,32,133,223,35,202,148,164,0,99,114,78,13,
99,147,39,36,121,211,240,68,54,230,143,127,106,107,240,74,241,115,39,159,236,
125,40,236,10,171,87,154,9,196,144,72,200,192,228,16,107,117,208,248,246,242,5,
138,199,87,183,91,203,92,128,115,243,1,158,162,181,134,180,101,97,177,20,43,136,
74,74,158,96,176,166,155,139,180,29,157,181,29,128,123,45,67,88,209,28,221,218,
196,225,229,238,247,104,148,159,204,60,190,180,206,135,203,118,226,67,130,51,
159,99,93,115,193,252,69,169,112,237,236,247,122,117,195,168,115,201,52,121,240,
200,135,170,145,230,43,177,116,43,219,9,154,59,205,60,8,237,110,78,123,175,255,
0,115,39,230,95,167,152,255,0,181,119,248,217,19,146,76,206,72,181,189,69,12,
54,173,11,180,59,4,104,22,233,20,115,33,195,123,131,93,133,117,27,74,219,82,28,
67,162,70,116,75,153,46,242,11,68,76,105,230,125,253,133,123,89,188,103,151,11,
163,36,233,157,47,18,96,41,246,197,90,105,192,254,58,54,7,25,90,87,187,196,107,
183,67,131,78,217,97,94,39,244,56,175,159,90,54,123,69,173,188,72,101,153,79,
173,96,5,70,207,165,97,36,255,0,141,101,202,158,97,190,13,21,212,102,186,241,
189,104,154,55,148,155,251,87,65,179,26,100,192,92,89,70,115,9,216,182,119,36,
123,214,190,230,223,82,96,151,49,33,44,112,92,108,65,163,118,127,56,135,137,109,
81,156,170,201,205,31,208,176,32,126,245,206,11,225,221,95,93,227,203,126,24,
177,141,164,186,154,232,196,72,7,8,1,241,57,244,0,100,215,163,44,201,71,148,186,
246,71,31,163,211,127,4,122,5,230,145,192,250,221,237,196,108,144,222,234,63,
240,228,143,157,99,92,22,30,217,36,125,171,208,21,93,195,26,61,174,129,195,214,
58,53,146,5,130,206,21,137,113,231,142,164,251,147,146,126,181,99,95,29,154,
106,121,37,37,211,103,90,84,168,234,175,139,13,87,77,211,123,13,215,160,212,38,
8,247,232,182,214,169,140,151,148,176,96,0,246,229,36,159,32,43,231,210,64,
123,228,200,234,107,223,31,20,124,48,188,95,164,240,158,132,102,17,181,223,16,
67,17,194,115,55,35,35,243,176,244,194,130,127,74,233,95,136,174,202,239,238,
59,107,211,180,158,17,210,75,13,90,206,38,133,21,121,99,67,24,228,114,79,64,0,
85,36,251,251,215,79,139,40,45,63,119,254,196,77,54,95,124,21,216,106,122,199,
13,113,143,13,106,214,93,255,0,10,221,168,66,95,167,124,235,202,234,191,84,193,
62,132,15,90,244,31,100,182,55,250,71,2,88,104,58,144,148,220,105,28,214,29,
228,131,29,242,70,197,99,113,234,10,114,154,87,177,110,9,155,128,56,26,13,2,226,
250,59,201,187,215,158,71,72,249,84,51,99,42,60,200,24,234,119,173,189,163,97,
120,38,18,55,43,39,33,79,33,231,159,253,251,87,46,89,41,77,181,209,105,82,57,
125,109,29,229,148,246,146,140,199,60,109,27,143,102,24,63,214,190,95,113,183,
15,94,112,183,22,234,220,59,127,31,37,197,141,195,194,125,8,7,194,195,216,140,
17,245,175,168,245,243,251,227,48,75,7,111,154,169,146,211,240,226,75,123,118,
70,207,247,163,187,3,159,245,4,125,171,127,18,85,58,38,107,71,76,25,2,181,118,
63,194,246,189,253,135,219,207,12,92,51,114,199,115,112,108,228,250,74,165,7,
238,69,117,124,132,243,125,235,181,126,21,248,29,248,223,182,13,54,22,184,107,
123,109,44,141,74,119,79,152,136,217,121,84,125,88,168,250,102,183,205,47,131,
38,43,103,209,202,230,70,113,157,235,149,212,157,184,246,135,254,228,113,231,
103,214,166,112,150,250,142,161,36,119,170,79,254,11,42,198,9,250,51,131,255,0,
45,121,223,216,212,237,186,229,114,184,72,80,73,32,1,185,38,128,19,215,108,215,
81,209,47,180,246,80,235,115,109,36,37,79,67,204,164,99,247,175,150,26,149,141,
198,153,170,94,105,119,104,99,184,181,153,225,145,122,225,148,144,127,165,125,
88,130,104,174,32,73,224,149,37,138,69,12,142,141,149,96,122,16,71,81,95,62,
254,46,184,78,94,21,237,159,81,186,88,202,217,107,24,191,183,111,44,182,210,15,
179,3,250,138,232,241,165,82,175,178,38,180,117,2,244,219,168,53,244,67,225,115,
180,47,247,255,0,179,43,121,46,143,255,0,181,52,190,91,59,223,241,144,163,149,
255,0,230,95,220,26,249,224,112,174,71,149,122,131,253,159,151,87,67,138,56,158,
205,85,141,163,89,69,35,159,202,174,28,133,251,144,91,244,174,143,38,41,194,254,
137,131,217,236,90,241,215,199,231,25,77,46,183,163,240,53,180,184,183,183,139,
241,215,64,31,154,70,202,160,63,69,4,255,0,205,94,197,175,154,31,17,188,69,119,
196,221,179,113,14,165,117,111,45,191,45,201,182,134,41,20,171,44,113,248,23,32,
250,129,159,189,115,120,234,231,127,69,205,232,245,167,192,231,19,166,179,217,1,
209,94,76,220,232,151,111,9,95,49,19,146,232,127,82,227,237,93,91,254,208,93,49,
151,140,248,103,86,9,224,154,194,72,11,122,148,147,56,253,30,177,254,207,155,
139,152,248,211,137,44,131,127,195,203,167,36,174,164,254,101,144,5,56,250,51,
87,99,252,121,105,182,183,29,150,233,186,156,152,23,54,122,154,164,71,213,100,
70,230,31,250,65,251,85,165,195,61,126,255,0,242,79,112,58,15,225,46,198,218,
251,182,221,2,59,140,98,22,146,116,24,234,201,27,21,253,247,175,160,117,242,191,
135,181,205,87,64,212,163,212,244,109,70,231,79,188,140,16,179,193,33,71,80,70,
14,8,246,175,164,125,141,107,119,92,69,217,95,13,235,87,210,153,174,174,180,
248,218,105,15,87,112,48,196,251,146,13,95,155,23,201,75,252,11,27,244,117,199,
196,191,110,111,217,204,169,195,186,13,164,119,26,237,196,2,99,52,219,197,108,
132,144,15,47,230,99,141,135,79,95,74,241,39,19,113,38,177,196,218,213,198,171,
175,106,19,223,223,92,28,188,178,182,79,176,30,64,15,32,54,174,201,248,198,191,
23,29,188,235,138,14,68,17,193,23,233,18,255,0,173,117,55,13,233,151,122,254,
187,109,165,217,180,73,36,205,134,150,103,9,28,74,55,103,118,59,42,129,146,79,
181,107,133,67,28,20,189,178,101,109,209,223,127,10,93,138,112,247,105,26,126,
161,196,28,73,121,116,109,108,238,63,12,182,118,231,187,44,220,170,220,204,254,
155,244,20,239,196,159,97,22,189,159,217,71,197,124,41,37,204,218,49,144,71,121,
4,205,206,246,197,182,86,13,212,169,59,111,184,56,245,173,187,74,237,171,178,
254,199,59,53,143,134,184,34,83,196,186,156,13,252,73,17,26,56,174,38,97,151,
149,156,143,148,96,0,7,150,7,189,118,199,98,189,161,104,125,180,246,119,115,253,
163,97,106,46,48,214,218,166,154,199,157,64,97,177,25,220,171,14,135,212,31,74,
231,252,217,35,63,201,186,47,140,90,163,192,114,62,14,115,215,113,93,213,216,63,
196,37,255,0,0,88,39,15,107,214,114,234,218,32,147,48,186,201,252,107,80,122,
133,206,204,190,124,187,99,124,26,75,226,39,177,45,91,179,251,233,181,141,26,25,
175,120,97,223,49,202,185,103,180,207,228,147,219,209,186,31,61,235,165,36,112,
83,62,98,189,87,248,252,152,125,163,15,148,25,244,222,210,227,132,251,73,224,
145,36,127,132,214,180,61,70,60,50,176,200,62,160,142,170,192,253,8,53,228,191,
136,191,135,187,158,16,129,245,254,10,130,238,251,67,11,205,115,3,30,242,91,66,
63,55,76,180,120,243,234,60,253,107,174,251,18,237,127,93,236,187,92,51,218,3,
123,164,92,145,248,221,61,223,10,255,0,227,83,249,92,15,63,62,134,189,183,216,
175,106,252,61,218,182,141,121,119,164,193,61,172,246,114,8,238,109,46,48,93,67,
103,149,178,54,32,128,127,67,94,100,163,147,197,157,199,163,117,83,91,62,107,76,
114,79,189,61,194,60,69,171,112,175,16,218,107,250,29,201,182,191,180,110,104,
164,3,56,200,193,4,122,16,72,251,215,168,62,45,251,4,138,214,222,126,60,224,109,
60,170,41,50,106,154,116,9,225,69,193,38,104,192,232,63,153,71,212,121,215,146,
122,18,43,165,100,142,85,100,83,137,244,239,177,30,63,177,237,35,179,235,30,34,
182,238,227,185,35,186,190,183,67,253,196,234,60,75,244,61,71,177,21,167,252,
103,234,77,167,246,17,169,70,176,75,39,227,46,32,183,230,78,136,11,115,101,189,
188,56,250,145,94,109,248,43,227,232,248,75,180,185,52,125,78,249,109,180,141,
102,6,71,50,190,35,73,144,115,35,122,2,71,50,253,197,123,115,138,180,141,47,141,
184,30,255,0,72,146,72,174,116,253,90,205,145,37,70,230,82,25,124,46,8,244,56,
35,233,94,124,227,248,230,106,157,163,229,196,39,42,84,249,215,167,255,0,217,
239,27,142,39,226,215,31,32,179,183,7,235,206,216,255,0,58,243,103,18,105,23,
220,55,196,90,134,133,169,70,98,188,176,184,120,37,82,49,186,156,103,232,122,
253,235,212,127,236,246,17,153,120,193,249,215,188,34,212,114,249,227,248,155,
215,111,147,37,44,87,253,136,143,103,121,124,66,240,19,246,141,217,188,220,63,
110,209,165,223,226,160,154,9,28,124,132,56,12,71,252,133,171,96,236,235,130,
244,62,2,225,152,184,127,135,237,204,54,136,198,70,44,196,180,146,16,3,57,39,
204,226,182,58,29,213,196,22,182,210,221,92,205,28,48,68,133,228,145,216,42,162,
129,146,73,61,0,21,230,219,53,9,92,175,23,246,161,241,81,172,14,210,237,231,224,
174,238,78,29,210,221,149,162,148,16,186,137,32,169,102,243,10,63,47,211,39,208,
122,35,176,238,215,248,115,181,29,9,39,179,150,59,45,98,49,139,189,50,73,65,146,
50,63,50,255,0,50,31,35,143,173,83,132,146,182,133,103,82,255,0,180,39,71,239,
184,71,134,245,228,136,22,181,189,146,218,71,198,225,100,78,97,251,161,253,107,
197,193,176,107,233,55,196,183,103,183,93,164,118,99,117,163,233,247,114,65,125,
106,255,0,140,181,143,62,9,228,69,56,141,135,184,36,3,228,113,95,53,230,71,134,
87,138,84,100,145,24,171,43,12,16,71,80,107,167,4,190,52,76,130,59,229,104,44,
217,168,51,26,198,107,102,73,46,162,177,89,198,192,143,58,227,169,7,6,144,193,
176,174,1,145,82,3,53,192,40,17,28,87,42,68,111,92,160,11,200,199,140,86,101,
221,235,136,192,100,250,86,76,51,24,76,220,135,147,61,107,71,32,34,155,35,17,
212,237,80,23,79,26,201,221,224,16,49,205,254,149,41,88,69,7,49,59,141,199,214,
146,153,130,219,253,79,244,172,39,33,162,86,199,189,185,78,98,73,45,146,79,181,
93,72,216,76,231,165,107,182,243,24,101,13,203,204,121,118,166,158,234,89,34,
98,204,0,11,208,82,132,233,3,64,46,37,55,23,78,254,93,7,218,163,35,5,136,3,178,
179,111,244,168,69,225,92,215,29,123,219,118,65,243,46,227,220,84,88,193,79,14,
60,104,121,147,168,53,25,27,158,52,200,241,3,76,218,161,10,57,149,130,158,185,
27,84,102,80,178,99,27,10,73,88,204,68,24,150,3,27,169,172,32,196,109,234,112,
43,42,199,12,195,108,12,84,9,196,96,122,156,213,8,113,71,57,92,14,139,138,98,
210,28,9,220,236,21,51,247,161,88,114,185,29,118,171,123,88,151,240,146,129,249,
153,87,111,173,107,21,100,178,150,8,75,220,164,108,164,146,122,123,84,245,52,
102,184,104,130,224,38,192,121,103,206,182,27,91,84,142,227,191,238,199,152,250,
121,210,55,118,209,139,132,146,119,229,132,177,105,24,245,3,174,5,15,29,32,189,
149,114,233,179,91,66,46,93,132,94,99,45,214,151,191,190,150,252,164,147,191,59,
197,24,64,216,193,192,233,159,90,150,163,39,61,208,98,204,200,219,168,206,112,
41,41,49,144,80,228,227,113,138,78,151,67,72,36,82,55,47,34,252,196,249,244,
169,170,77,144,156,203,235,210,135,30,114,25,151,230,243,6,155,136,115,58,156,
224,131,231,66,3,55,145,51,220,57,102,27,40,24,3,174,42,112,33,42,10,48,193,27,
2,42,19,74,75,243,227,230,200,251,209,109,207,118,0,234,127,206,135,216,14,
217,35,54,11,32,3,99,204,13,90,73,104,194,22,154,216,19,40,25,8,126,87,246,63,
235,85,182,138,170,4,172,216,219,27,244,2,182,61,20,153,64,140,161,230,110,131,
204,251,214,177,73,137,138,68,44,102,140,9,127,131,46,55,89,7,46,15,152,201,216,
213,126,171,98,97,186,10,70,217,24,250,86,237,28,17,177,238,10,35,0,112,85,135,
95,106,165,214,116,191,195,184,252,59,30,65,185,133,183,0,127,132,249,125,58,
125,43,73,99,213,147,123,52,244,6,55,127,70,106,189,224,221,65,173,46,46,45,25,
143,36,156,175,31,179,131,254,96,145,85,119,113,243,91,25,21,121,124,91,231,214,
167,160,14,109,73,24,249,17,81,6,212,145,76,238,221,26,246,221,163,18,202,1,43,
143,1,243,63,233,85,220,85,168,25,173,46,9,108,179,41,201,251,85,28,55,125,221,
208,76,224,21,172,234,50,115,216,205,147,159,9,175,117,121,205,97,224,99,199,
103,94,200,121,35,228,234,220,195,20,80,89,21,6,119,45,229,66,187,62,53,35,200,
213,141,169,129,109,195,183,136,146,13,120,254,205,12,186,24,238,22,69,24,230,
199,235,87,54,54,151,23,247,80,219,91,33,146,105,152,42,46,113,147,85,178,180,
109,42,178,55,52,78,62,234,69,118,231,98,220,23,165,95,220,219,113,63,25,223,
105,250,119,12,218,200,89,150,230,126,87,187,43,249,17,7,137,134,113,159,210,
182,142,69,142,46,76,18,179,101,236,143,225,243,93,215,90,219,90,214,117,75,125,
50,192,56,101,75,119,18,204,248,244,35,194,191,92,159,165,122,71,128,123,55,
225,158,11,212,47,245,45,42,222,73,47,239,143,241,174,103,33,159,151,249,70,195,
3,204,227,169,173,22,15,136,46,10,183,212,23,79,211,244,187,197,210,45,212,41,
186,84,88,209,20,108,57,99,235,143,210,181,174,52,248,160,181,183,152,67,194,
154,3,92,128,222,41,175,155,144,17,236,170,115,250,154,228,201,15,59,55,198,81,
116,253,116,139,92,17,232,30,33,214,116,222,31,209,110,181,141,94,233,45,108,
173,80,188,178,183,144,255,0,50,122,0,58,215,80,106,127,18,252,14,147,71,109,
162,233,250,206,177,113,36,130,52,72,160,17,243,18,112,49,204,114,115,233,138,
233,221,59,81,227,255,0,136,62,50,26,37,237,255,0,224,244,136,255,0,141,60,112,
33,16,90,168,232,216,207,141,207,65,147,250,98,187,191,178,14,193,184,127,129,
53,83,172,222,93,54,179,169,199,33,54,146,201,31,34,64,189,1,11,147,151,199,
153,233,229,235,89,203,199,195,129,86,103,114,250,95,246,198,164,223,71,106,217,
15,198,67,105,127,117,104,97,159,187,14,177,72,1,104,11,13,198,125,124,141,50,
209,68,210,164,173,26,25,19,33,88,141,215,61,112,106,117,192,65,232,115,94,121,
103,43,149,202,229,0,114,188,145,254,208,94,23,148,158,30,227,24,34,37,20,53,
133,203,1,211,126,120,243,255,0,172,87,173,235,68,237,251,134,151,138,251,32,
226,61,35,240,253,252,230,205,167,182,80,50,123,216,252,107,143,124,140,125,234,
161,46,50,76,30,207,153,110,190,51,91,79,101,188,103,169,240,7,26,216,113,70,
148,171,36,214,172,121,225,114,66,205,27,12,50,28,122,131,246,56,53,182,118,151,
217,143,251,151,217,127,7,107,215,221,240,213,117,211,44,211,70,219,44,49,5,67,
26,227,249,176,217,63,92,87,90,114,87,160,146,200,157,116,103,209,245,71,132,
53,168,56,147,133,180,189,126,213,74,67,168,90,71,114,138,78,74,135,80,113,246,
206,43,198,223,29,218,203,92,118,183,165,233,177,134,67,167,105,168,193,193,252,
206,236,217,30,157,5,122,51,225,78,254,59,254,193,56,100,164,129,218,222,23,183,
124,54,121,74,72,195,7,237,138,242,79,198,60,242,77,241,1,172,151,206,33,142,
222,37,250,119,74,127,204,215,30,40,255,0,82,190,138,147,209,237,126,198,56,178,
14,53,236,203,68,226,8,156,180,147,91,44,119,0,245,19,39,134,64,127,230,4,253,
234,183,226,47,137,231,225,30,198,248,131,86,181,140,189,195,91,254,26,47,240,
180,167,147,155,237,204,79,218,186,207,224,30,252,205,217,222,187,166,180,133,
191,9,170,115,170,147,242,172,145,169,253,202,154,221,62,47,35,18,124,63,241,22,
113,225,16,48,207,255,0,206,74,135,26,159,31,220,119,171,49,240,141,196,135,136,
187,14,209,187,211,153,244,222,107,9,50,114,79,119,242,159,250,74,254,149,174,
124,113,240,148,122,223,101,81,241,12,104,63,21,161,220,9,11,121,152,100,33,24,
126,188,135,236,107,172,254,5,120,246,13,47,92,188,224,75,226,137,30,168,223,
136,179,144,237,252,101,93,211,254,101,25,30,235,239,93,253,241,49,194,92,69,
198,157,147,106,26,55,12,220,148,188,230,73,154,223,97,248,180,67,147,22,124,
137,56,35,212,140,121,213,201,126,60,162,91,71,206,6,127,148,253,141,122,207,
253,158,118,82,25,184,187,83,57,238,249,109,160,30,231,198,199,252,171,201,183,
86,243,219,92,205,107,113,19,195,52,78,85,227,113,134,86,7,4,17,228,107,210,
127,6,29,170,112,239,5,217,106,188,57,196,83,155,127,237,11,216,26,201,146,18,
204,242,63,240,216,18,58,1,133,59,250,154,233,206,220,177,186,34,58,103,181,235,
230,247,197,53,212,247,157,190,241,76,147,200,207,221,93,136,83,62,74,168,160,
10,250,67,95,46,123,90,187,188,189,237,31,136,238,117,4,100,187,147,83,157,165,
86,234,167,156,237,250,86,62,42,249,54,84,250,59,123,224,83,83,178,181,237,122,
226,210,230,113,28,215,154,108,145,219,169,233,35,134,86,35,235,202,164,253,171,
181,63,218,3,118,240,246,117,160,91,140,242,205,170,146,219,127,44,77,254,181,
228,110,203,245,151,208,59,69,225,237,97,102,48,139,77,70,9,29,199,146,115,142,
111,183,41,53,234,159,246,134,77,158,11,225,64,158,40,223,80,149,185,135,79,238,
246,254,181,89,31,245,148,133,31,211,71,146,184,78,206,215,89,226,93,63,74,191,
212,226,210,237,110,238,18,25,47,37,82,203,0,99,142,98,7,144,175,166,157,150,
240,217,225,14,207,116,94,26,107,181,188,54,22,194,35,58,140,9,55,39,32,122,111,
95,44,134,198,189,171,240,93,218,253,182,169,160,39,0,241,54,172,139,170,218,
55,46,150,211,182,13,196,24,254,236,49,234,202,115,129,212,140,99,165,30,74,
147,73,250,8,82,35,241,139,216,133,255,0,19,59,113,231,8,90,27,141,78,56,194,
234,54,81,175,142,225,87,97,34,15,54,3,98,60,192,24,220,111,227,14,234,234,218,
121,45,157,101,129,207,130,88,216,21,35,7,229,35,235,229,95,91,171,167,251,84,
248,121,224,142,62,214,238,181,251,137,181,13,59,87,185,42,100,184,182,144,21,
98,170,20,101,24,99,160,29,49,81,139,55,29,75,161,202,55,209,243,254,222,201,
165,41,12,113,180,146,187,5,68,81,146,196,236,0,30,102,189,43,240,175,217,167,
106,252,49,218,61,158,185,46,139,54,145,164,50,20,190,252,99,132,239,161,35,160,
76,228,182,112,70,70,196,87,113,246,87,240,231,193,188,13,174,71,174,75,115,
117,173,234,16,56,123,87,186,1,82,2,63,48,65,177,111,115,211,202,187,107,90,214,
52,157,18,204,222,107,26,157,158,159,110,63,241,110,102,88,215,245,99,90,102,
242,148,151,24,45,19,24,86,216,197,236,54,215,22,115,65,121,20,82,219,72,133,
101,73,64,40,202,70,224,131,182,49,95,44,248,185,244,225,197,154,186,105,3,26,
119,227,102,22,163,255,0,181,206,121,127,108,87,178,126,32,190,32,56,30,46,0,
214,180,62,21,226,49,125,172,222,219,52,16,201,107,19,60,104,27,102,241,236,51,
203,158,153,175,13,22,232,194,175,195,78,54,216,100,217,54,57,4,87,115,252,25,
113,186,112,167,108,16,105,215,114,136,236,53,232,255,0,5,33,99,128,178,231,49,
31,250,188,63,243,87,74,177,223,53,1,36,144,206,147,194,236,146,35,7,70,83,130,
164,28,130,43,163,55,206,45,19,29,51,235,116,241,69,60,18,65,52,107,36,82,41,71,
70,25,12,164,96,131,237,94,1,248,161,236,62,247,179,189,102,77,123,66,130,91,
158,22,187,144,149,101,92,155,39,39,251,183,255,0,15,242,183,219,175,95,100,246,
17,198,18,113,215,101,90,31,17,207,12,145,92,77,7,119,63,56,249,164,67,200,204,
61,137,4,253,235,111,213,44,44,181,77,58,125,59,81,181,134,238,206,225,12,115,
67,50,6,71,83,212,16,122,215,151,9,184,59,70,205,89,242,93,75,43,6,66,85,134,
224,131,184,175,92,124,22,118,204,57,108,187,47,215,200,4,115,141,42,233,155,
175,230,238,15,254,174,95,211,210,165,241,57,240,229,164,233,252,53,39,22,118,
127,100,45,63,179,226,105,47,236,3,22,18,68,50,76,137,159,53,29,71,152,30,163,
127,38,105,151,215,154,86,167,107,169,233,243,189,189,221,172,171,52,18,161,221,
29,78,65,31,113,93,77,199,52,116,66,78,44,239,239,143,45,22,29,51,181,235,77,
82,8,4,99,84,211,146,73,88,13,158,68,102,66,126,188,161,42,167,224,195,137,167,
208,187,108,176,176,12,77,182,179,19,217,204,190,248,46,135,236,203,251,154,55,
196,31,104,90,103,106,221,159,240,206,190,145,119,90,238,148,12,26,156,96,120,
71,120,58,175,183,50,103,254,106,233,206,25,214,181,46,29,215,45,117,173,30,
233,173,111,237,31,188,130,101,0,148,108,99,56,59,121,210,199,114,199,197,141,
233,217,244,111,180,190,218,56,7,179,221,110,215,71,226,61,86,68,188,157,57,218,
59,120,76,166,21,242,46,23,117,207,151,158,213,229,110,217,126,40,56,143,137,
111,245,13,51,133,161,134,195,135,39,182,150,205,163,185,133,100,150,225,92,21,
50,54,126,83,131,176,29,60,242,107,162,53,221,70,255,0,89,212,238,53,77,82,242,
107,203,219,153,12,147,207,43,115,59,177,234,73,170,225,215,30,180,150,5,30,246,
28,137,41,193,246,171,94,19,214,245,46,25,226,107,13,111,73,187,123,91,203,57,
214,72,229,83,211,7,112,125,65,27,17,230,42,164,26,33,28,209,134,243,27,86,213,
203,66,62,167,232,60,101,195,186,181,237,158,151,109,172,216,205,169,220,233,
241,234,9,111,20,185,47,11,109,206,190,163,63,122,242,135,197,95,195,239,19,75,
198,87,220,105,193,58,95,246,142,159,126,123,235,171,43,85,29,236,18,227,196,
193,63,50,177,203,120,119,4,157,171,207,221,158,241,61,247,9,113,182,143,196,
150,151,18,164,154,125,202,59,114,157,218,60,248,211,232,84,145,143,122,250,9,
218,23,28,221,106,61,134,234,60,111,217,189,220,55,228,90,52,241,58,167,51,5,3,
199,225,200,33,211,169,7,127,9,174,73,66,88,90,162,211,179,230,198,165,99,123,
167,222,73,103,168,90,92,90,92,199,243,195,60,101,29,124,247,7,113,64,2,156,212,
111,111,117,59,233,111,181,27,185,239,46,166,110,105,38,158,66,238,231,212,147,
185,165,202,226,186,183,236,204,196,123,229,125,122,125,106,100,115,68,15,154,
236,126,149,16,49,184,163,41,0,135,199,133,182,97,77,0,12,98,184,69,18,84,229,
56,235,232,125,69,96,12,138,64,64,12,215,42,120,197,114,128,28,19,191,47,131,
194,79,159,157,57,223,52,81,32,89,10,21,94,190,191,90,169,14,84,174,0,56,223,
122,156,179,18,255,0,196,99,147,88,169,49,180,114,234,224,207,114,48,57,66,140,
224,116,168,220,110,169,30,124,168,72,60,76,195,124,157,168,164,102,113,237,83,
223,99,51,115,136,224,230,29,88,237,244,165,98,124,196,64,232,77,31,85,61,35,95,
37,165,208,21,8,163,203,122,79,176,65,223,97,138,205,140,50,79,114,17,8,219,
115,244,168,177,202,19,86,58,10,114,197,44,167,169,192,20,226,174,64,250,22,186,
51,199,41,71,36,15,79,42,5,217,38,98,115,176,0,85,157,254,29,212,17,211,122,
171,96,93,137,245,53,109,83,161,35,7,104,0,243,99,154,193,82,121,71,149,74,231,
98,170,7,65,81,141,139,73,141,176,41,12,177,211,227,229,76,154,187,211,227,197,
140,37,186,201,41,199,216,127,173,84,90,159,224,179,121,127,74,216,96,143,187,
54,80,178,146,162,0,78,122,43,57,206,15,237,91,193,16,216,100,83,206,15,41,173,
98,233,131,221,204,28,243,48,118,24,39,166,245,185,18,16,148,116,109,254,83,
228,125,190,181,80,150,128,218,222,14,237,88,202,249,83,141,198,55,173,36,172,
73,154,141,196,100,185,64,115,201,242,208,199,204,197,178,8,0,18,41,135,231,91,
131,206,184,86,108,243,84,46,99,196,222,210,12,15,168,172,26,246,88,24,136,86,
43,144,87,61,40,232,234,175,202,79,65,191,215,210,129,34,178,19,141,199,67,244,
174,70,252,190,44,28,226,149,214,134,30,70,102,30,20,59,96,228,211,17,129,34,
117,198,122,17,229,75,35,182,202,70,251,117,163,66,229,24,100,97,127,165,59,17,
99,166,247,83,52,10,203,204,241,147,207,157,242,70,78,49,246,173,251,130,44,
150,254,224,106,183,130,119,130,218,78,238,67,9,241,120,129,33,136,198,224,96,
231,30,71,218,186,234,18,203,124,141,11,5,118,32,174,122,115,142,128,253,122,87,
122,246,31,168,104,71,67,213,160,23,50,88,94,177,239,123,187,136,202,162,50,174,
225,100,233,143,76,144,124,171,57,207,138,26,86,107,182,146,219,203,121,112,214,
215,9,54,100,198,84,131,143,74,167,226,137,90,53,117,136,255,0,22,70,8,152,245,
53,115,196,183,250,50,106,118,183,127,218,106,215,51,22,75,174,239,39,3,10,81,
178,54,206,65,218,170,184,138,209,100,72,174,172,238,210,110,243,154,72,28,13,
215,7,12,24,116,219,35,113,212,17,210,186,163,151,227,68,53,179,81,213,215,187,
182,49,168,216,96,109,69,208,109,76,47,12,147,12,51,248,192,62,158,95,231,65,
184,184,18,201,34,75,24,73,99,127,20,121,216,143,81,237,86,86,46,100,144,74,231,
118,53,80,92,165,97,232,179,191,147,248,106,235,243,1,138,170,123,203,136,17,
213,91,157,92,96,131,79,222,158,104,128,205,82,93,203,140,175,67,90,205,208,146,
17,147,154,73,57,124,170,243,79,138,15,236,206,98,71,56,205,83,36,114,185,231,
11,133,7,175,173,58,241,201,20,107,144,122,103,35,161,21,24,233,176,99,73,26,
140,203,31,92,111,138,179,176,103,120,215,157,139,99,212,213,22,153,57,142,112,
175,186,157,141,108,26,116,101,164,228,29,1,251,98,189,15,19,29,178,91,162,222,
70,3,75,96,189,67,130,195,219,27,126,244,78,2,225,45,111,142,56,146,61,27,66,
183,19,92,48,46,238,231,9,18,14,172,199,200,127,90,140,141,18,89,92,147,150,29,
223,42,159,241,19,177,253,169,206,206,59,64,215,120,5,239,166,225,225,109,29,
213,234,172,111,60,177,7,40,128,231,0,29,183,56,235,233,94,143,150,166,161,253,
62,201,133,123,61,179,217,39,103,250,95,103,188,48,186,85,142,38,186,148,137,
47,46,138,225,166,147,31,178,142,128,127,173,110,53,213,31,12,188,109,196,28,
111,194,55,247,188,67,60,51,207,109,121,220,199,34,68,16,178,242,6,220,13,179,
147,93,175,95,23,157,78,57,36,167,223,179,169,117,163,67,237,231,142,83,128,59,
55,191,214,99,117,23,242,15,195,216,41,243,153,129,193,199,248,70,91,237,94,28,
179,237,87,180,139,56,249,45,184,211,89,141,112,87,31,136,39,169,36,245,243,201,
59,245,175,103,124,69,240,55,14,241,103,8,203,169,241,22,163,121,105,30,141,
107,113,60,11,20,202,136,207,201,145,204,8,57,62,16,7,214,188,6,169,147,93,222,
14,60,115,139,181,108,153,182,142,196,183,237,191,181,88,180,185,109,147,140,
175,143,46,8,119,84,103,199,159,136,174,104,90,119,110,61,171,233,247,201,116,
156,99,125,113,202,115,221,220,5,146,54,250,169,21,163,199,30,57,212,254,100,34,
185,111,108,110,46,33,129,94,52,50,176,64,210,55,42,174,78,50,79,144,247,174,
215,227,99,175,210,136,228,207,64,118,79,241,21,199,183,188,119,164,216,241,36,
246,215,250,109,245,194,91,75,28,118,138,142,133,219,148,50,149,25,200,36,109,
230,43,216,213,231,79,135,46,193,95,134,117,43,110,45,226,123,187,27,219,168,
215,158,198,222,217,251,216,163,39,164,133,250,49,199,76,108,51,156,215,162,235,
198,242,30,55,63,233,244,107,27,173,157,41,241,143,194,75,196,61,143,79,168,64,
159,241,58,28,162,238,48,63,253,223,203,32,253,14,127,229,175,7,24,242,1,175,
169,60,89,165,199,173,240,190,171,163,202,200,137,123,103,45,185,103,25,11,204,
132,100,253,51,154,249,135,123,1,179,185,184,180,144,171,60,18,180,108,84,228,
18,9,7,30,219,87,95,128,211,78,44,137,158,161,248,9,226,118,83,174,240,100,238,
121,118,212,45,129,110,157,18,64,7,253,7,245,174,180,248,210,183,142,62,221,53,
38,82,11,75,105,109,33,199,145,238,192,223,244,164,126,21,117,71,211,251,119,
225,220,92,8,82,229,228,182,124,244,112,241,182,23,238,220,191,124,86,126,48,
100,157,187,124,215,68,249,192,75,113,30,127,151,185,76,127,157,39,21,31,33,215,
208,174,226,109,63,3,156,71,46,155,218,156,250,11,74,86,215,88,176,99,200,78,
198,104,188,74,126,188,188,255,0,173,122,95,226,103,79,151,83,236,39,138,237,
160,136,203,34,217,119,193,64,223,192,234,228,254,138,107,197,31,13,215,146,90,
118,217,193,242,196,124,71,81,16,183,254,87,5,79,236,107,232,174,165,105,21,254,
157,115,99,48,204,87,16,188,78,49,249,88,16,127,173,114,249,26,201,104,184,116,
124,172,208,117,59,221,27,88,179,213,180,249,154,43,187,57,146,120,93,78,8,117,
32,143,233,95,79,248,11,136,173,56,183,131,52,158,36,178,96,97,191,182,73,112,
63,43,17,226,95,179,100,125,171,230,55,16,105,147,104,220,67,168,105,23,10,86,
91,43,169,45,220,30,185,86,43,254,85,233,143,129,206,209,197,165,244,221,157,
106,179,145,21,201,105,244,194,199,101,144,12,188,127,112,57,135,184,62,181,182,
120,57,65,77,19,23,78,142,185,248,204,225,180,208,59,112,190,186,134,34,144,106,
208,199,122,187,108,89,178,175,255,0,169,73,251,215,79,65,152,207,58,146,25,78,
65,7,112,107,215,127,237,5,225,213,147,69,225,222,42,66,121,224,153,236,101,30,
69,88,23,83,250,171,126,181,227,245,108,31,168,173,60,121,174,8,83,91,62,159,
246,65,172,201,196,61,151,112,214,179,43,22,150,235,77,133,164,98,119,46,20,6,
63,168,53,225,239,140,221,63,78,211,187,120,213,35,211,173,214,1,53,188,51,220,
5,232,210,186,229,155,234,118,53,233,239,130,157,100,106,157,134,217,90,25,3,
75,166,221,77,108,203,157,212,115,115,175,236,245,230,95,141,75,59,155,110,223,
53,89,103,7,146,230,222,222,88,79,170,119,97,127,170,154,228,197,172,149,253,
203,151,71,73,231,6,189,133,219,197,201,227,31,131,30,22,226,89,66,27,139,102,
180,119,108,100,243,0,208,190,254,89,59,215,143,63,54,43,190,120,23,180,27,61,
67,225,187,95,236,194,254,39,55,144,71,45,237,148,188,217,1,18,72,228,41,143,
47,252,66,62,149,182,84,221,53,233,146,142,140,238,201,80,113,68,132,52,82,199,
50,59,35,163,2,25,78,8,62,160,212,217,148,41,2,128,100,36,17,93,84,145,7,209,
31,132,238,58,184,227,126,202,224,254,209,184,123,141,79,74,151,240,119,50,59,
101,164,0,2,142,79,169,83,143,168,53,219,114,58,70,133,228,117,69,29,89,142,0,
175,159,159,12,157,174,89,118,89,99,196,247,154,132,83,94,155,184,97,91,75,56,
206,59,201,148,182,236,223,149,66,147,147,131,90,103,105,29,167,113,151,104,58,
204,183,250,246,175,63,117,205,152,108,225,114,144,66,190,138,163,111,185,201,
53,194,240,57,77,165,209,167,42,71,179,187,85,248,146,224,14,12,239,236,116,
251,163,196,58,180,121,81,5,147,3,18,55,163,203,242,143,249,114,107,196,189,168,
118,131,196,221,162,241,19,235,60,71,122,101,97,225,130,221,54,134,221,60,149,
23,203,235,212,249,214,171,32,241,156,121,239,91,47,0,240,31,20,113,198,160,
214,156,61,166,73,112,145,142,105,238,92,242,65,110,189,75,73,33,240,168,21,209,
12,80,197,242,100,182,216,135,14,240,230,189,196,142,109,52,45,26,255,0,83,152,
108,86,214,6,147,31,92,13,190,245,189,92,246,23,198,186,47,14,75,175,113,123,
105,156,49,96,138,74,255,0,104,93,14,246,86,242,68,141,57,152,177,244,174,219,
211,123,109,225,126,198,56,42,203,128,248,38,222,14,39,213,45,201,109,67,82,230,
41,104,211,49,203,114,17,226,144,3,176,59,12,14,181,231,174,208,248,203,136,
248,227,137,167,214,184,143,80,146,230,121,24,152,227,201,238,225,95,36,69,232,
160,127,243,66,158,73,187,90,65,73,26,208,25,219,237,88,117,202,145,233,189,16,
236,199,245,166,116,203,11,189,79,84,182,211,180,251,119,184,187,186,149,98,134,
36,25,103,102,56,0,125,205,109,235,98,163,232,239,195,132,66,203,176,94,16,89,
74,198,23,76,71,98,118,0,28,182,127,122,236,64,114,50,58,87,70,246,129,170,47,
15,232,29,159,246,55,101,118,33,213,245,134,179,180,186,238,155,120,109,98,11,
223,54,124,185,185,74,143,81,205,93,229,94,73,177,9,162,142,104,94,25,145,100,
142,69,42,234,195,33,129,216,131,95,53,254,34,184,10,62,207,59,79,212,116,59,
105,163,150,202,76,93,90,5,108,178,68,228,144,140,60,136,193,30,224,3,231,94,
250,237,123,180,61,19,179,78,19,109,127,90,45,39,52,139,21,189,180,100,119,147,
185,242,92,250,12,146,125,171,230,255,0,31,241,53,231,24,113,174,173,196,183,
204,198,93,66,229,165,10,199,60,136,79,133,62,129,112,62,213,191,142,159,43,244,
76,138,75,91,185,173,225,184,130,55,34,59,132,11,34,255,0,48,4,17,251,138,22,
113,81,97,134,53,144,50,43,173,45,144,79,57,160,190,205,154,52,67,38,179,44,71,
210,180,113,109,9,16,238,243,134,29,13,22,37,252,167,207,106,45,186,134,136,175,
152,220,84,91,99,87,24,82,176,108,14,48,216,174,238,248,81,237,90,243,130,248,
186,14,20,213,102,142,94,24,214,103,16,220,71,49,240,219,187,248,68,131,208,29,
131,14,132,125,43,164,231,234,24,121,212,73,56,14,164,130,60,197,103,146,10,106,
152,211,163,108,237,171,135,172,120,91,181,126,36,208,52,198,99,101,103,124,233,
8,97,130,170,124,65,126,217,198,124,241,90,113,27,85,255,0,22,107,143,196,75,
99,127,123,43,203,170,36,2,222,230,86,27,202,19,100,114,124,219,151,194,127,
242,138,163,228,56,205,68,83,226,147,27,6,61,42,113,227,152,171,31,11,87,10,239,
89,34,138,17,135,4,14,70,234,181,132,244,162,145,207,30,127,50,245,247,20,50,
49,189,20,4,177,92,172,131,181,114,157,0,59,97,150,37,188,169,89,28,180,140,
222,251,83,12,193,33,99,156,49,24,165,16,18,107,150,138,26,135,102,95,214,178,
197,176,204,54,201,218,177,22,51,191,165,76,236,49,78,132,15,230,60,199,115,92,
111,156,138,32,94,93,242,48,58,212,20,2,229,252,188,133,38,51,143,242,133,171,
125,49,121,45,74,158,160,210,22,49,137,174,213,79,65,185,171,85,35,241,114,32,
24,79,203,85,141,110,193,137,221,55,241,36,63,202,184,170,248,71,60,192,14,153,
167,103,96,207,38,60,218,150,139,3,157,134,60,34,135,216,128,78,121,166,99,229,
157,171,16,252,217,31,165,112,138,106,205,34,144,144,153,202,249,250,210,160,29,
129,63,128,171,231,35,5,31,115,91,90,70,183,18,221,5,108,40,101,141,8,235,225,3,
31,210,181,164,137,156,71,201,213,15,48,173,147,66,126,104,7,62,67,103,44,63,
206,183,135,100,72,99,82,119,91,120,221,160,231,40,114,72,97,131,182,51,237,84,
87,23,107,203,31,41,41,133,57,25,247,222,172,184,150,118,130,20,252,59,16,102,
60,174,157,65,30,103,216,213,13,237,177,58,172,214,204,252,177,40,7,3,174,234,
42,230,221,232,16,40,172,82,107,59,139,142,240,128,159,221,161,25,230,246,170,
73,28,49,42,114,66,252,185,173,150,105,68,54,177,5,32,21,96,119,233,145,90,246,
162,226,105,94,117,1,67,18,121,71,150,79,74,202,93,22,136,91,200,161,159,152,12,
157,242,125,40,126,2,217,229,110,82,126,194,185,116,156,146,100,116,35,34,165,
30,28,114,128,121,71,145,234,125,133,69,250,25,194,15,41,148,146,217,62,32,79,
90,114,216,140,115,17,204,172,54,247,20,154,147,158,82,114,9,162,218,115,98,78,
66,162,56,240,197,155,56,25,219,203,215,111,210,132,246,12,114,222,72,150,117,
141,202,166,78,18,86,232,158,199,219,250,87,171,254,19,117,174,24,131,69,214,
244,125,110,238,61,59,86,187,126,115,21,217,83,12,193,147,230,141,206,204,15,92,
31,95,58,242,92,108,4,188,211,228,99,208,102,189,33,240,203,196,252,61,166,90,
95,240,119,17,197,6,165,107,168,90,155,141,41,228,136,43,231,30,56,67,28,149,
62,96,103,250,215,23,155,107,27,113,53,196,173,155,23,18,112,174,139,10,61,147,
90,217,79,108,35,28,156,136,57,78,73,220,99,215,218,186,58,242,201,172,181,249,
44,52,119,121,180,219,123,199,238,228,39,35,147,24,59,254,217,243,229,173,211,
136,181,203,77,18,75,205,3,71,191,186,128,106,150,98,43,40,164,60,237,109,114,
243,133,100,14,126,81,202,73,201,233,229,77,241,21,165,157,133,138,105,86,177,8,
197,172,42,87,0,120,199,66,217,243,222,183,240,238,105,73,147,155,226,220,78,
160,226,75,116,55,189,248,92,50,157,136,243,21,59,22,33,34,35,249,141,19,137,
112,67,20,198,251,210,150,79,152,32,61,15,51,87,161,143,77,152,250,44,111,102,
254,24,223,122,170,153,11,71,223,145,149,239,57,62,248,205,26,238,76,161,201,
168,218,77,19,233,23,177,22,29,226,75,28,203,244,193,7,252,168,202,193,2,183,
187,107,43,128,93,121,224,109,157,61,191,214,174,94,220,75,1,184,211,36,23,16,
182,237,24,62,37,255,0,67,90,248,34,71,10,248,42,223,214,143,20,23,54,82,9,173,
228,100,243,12,166,158,38,38,135,76,17,188,92,240,161,12,167,12,189,10,159,113,
229,86,154,103,226,33,230,73,71,41,206,48,70,255,0,173,83,75,117,37,203,134,185,
0,30,134,68,24,63,122,181,130,229,216,36,19,16,206,163,193,32,232,226,189,79,
26,73,50,36,92,59,44,182,230,18,220,172,72,193,61,9,244,170,153,50,174,65,234,
14,13,52,178,114,58,18,118,29,106,195,133,120,91,93,226,189,105,116,189,11,79,
154,242,114,87,156,162,146,177,169,32,115,177,242,93,250,215,126,124,137,71,147,
213,10,43,103,175,126,18,116,235,11,14,202,98,154,214,250,43,155,155,217,218,
226,233,17,193,48,177,240,170,16,58,30,85,7,127,90,237,30,33,214,52,237,3,69,
186,214,53,107,148,182,178,181,140,201,44,140,122,1,253,73,232,7,153,173,123,
178,46,4,176,236,251,131,224,209,109,89,102,185,99,222,222,92,5,199,125,41,27,
159,160,232,7,160,174,173,248,219,214,63,15,193,154,54,136,143,134,189,188,105,
157,65,234,177,175,250,184,253,43,227,248,255,0,49,228,82,125,179,167,164,116,
39,110,253,172,106,253,164,107,128,39,121,99,162,219,115,45,181,162,185,241,2,
126,121,60,139,29,182,232,63,122,235,101,76,111,83,147,230,172,49,254,24,63,106,
247,241,225,142,53,198,43,70,45,216,70,42,172,167,214,151,146,64,23,232,107,147,
147,220,163,103,166,69,41,43,28,26,110,84,7,161,190,19,187,92,181,225,125,74,94,
23,226,75,219,161,166,222,186,11,57,94,76,195,104,251,231,32,252,170,217,27,
141,134,62,245,236,208,65,0,130,8,61,8,175,149,86,178,114,220,39,161,56,175,121,
124,37,241,142,167,197,29,155,37,158,173,111,63,125,165,55,225,162,186,112,121,
110,98,31,46,254,108,191,41,250,15,90,241,60,220,73,63,200,189,154,66,94,142,
225,149,18,88,154,41,20,50,58,149,96,124,193,235,95,51,59,91,225,230,224,254,
210,117,254,27,60,221,221,173,211,136,73,243,140,248,144,255,0,210,69,125,53,
175,16,124,123,104,191,129,237,75,75,214,145,48,154,150,156,21,219,29,94,54,42,
127,244,149,172,60,105,184,206,190,202,154,180,116,127,6,235,71,65,226,237,35,
91,28,223,240,23,176,220,16,58,144,142,9,31,160,174,237,248,221,177,182,189,
226,142,30,227,173,37,197,198,151,174,233,170,18,225,55,86,100,63,215,149,151,
244,53,231,112,124,68,86,217,254,250,106,23,189,156,158,9,212,49,113,105,109,56,
186,176,119,98,90,221,198,67,40,255,0,11,2,118,245,173,230,155,154,146,37,117,
68,251,31,214,162,208,59,75,225,205,94,110,94,234,215,82,130,73,51,208,47,48,4,
253,129,53,244,236,16,70,65,200,61,13,124,148,87,42,219,30,181,244,227,177,14,
38,182,226,238,202,120,123,90,183,148,200,207,102,145,78,91,230,18,198,57,28,
31,249,148,254,181,135,144,182,152,224,124,243,237,91,251,66,46,210,120,145,
117,102,230,191,26,156,226,102,229,229,230,110,115,190,61,234,135,75,212,239,
116,173,74,223,83,211,110,100,181,188,181,149,102,130,104,206,25,28,28,130,43,
186,254,56,248,114,45,27,182,33,170,65,36,124,186,213,154,92,180,106,48,81,215,
248,108,79,215,148,28,253,107,161,193,206,61,198,43,167,28,185,65,34,26,166,123,
227,182,185,38,226,239,132,139,189,99,136,108,69,166,160,218,100,23,207,27,46,
59,185,195,41,200,244,206,78,61,154,188,8,167,43,244,175,99,233,220,83,127,218,
119,193,166,177,166,105,67,188,214,244,123,88,173,111,161,31,51,199,17,86,12,
191,249,163,95,213,77,121,183,83,236,254,250,203,178,61,31,180,36,102,107,91,
235,233,172,165,66,191,33,93,209,129,244,108,56,250,175,189,115,97,124,109,63,
178,229,179,183,62,4,120,209,52,126,58,191,225,43,219,142,238,219,89,136,61,176,
110,159,136,143,203,234,87,155,254,145,79,255,0,180,50,220,47,22,240,181,200,
139,6,75,25,144,190,62,110,89,1,3,237,205,251,215,155,116,109,70,243,70,214,44,
181,109,62,102,134,238,206,100,158,23,83,186,186,144,71,244,175,83,252,71,107,
90,71,107,95,15,54,124,119,166,158,91,189,10,253,97,185,141,70,66,180,138,171,
32,245,229,201,66,15,181,94,72,241,202,165,233,130,118,168,242,32,30,42,118,
202,238,75,57,140,177,146,57,163,116,108,121,134,82,8,253,233,67,82,235,31,211,
106,233,162,14,3,145,88,69,38,64,0,36,147,128,7,157,74,17,151,3,215,106,236,239,
133,228,182,61,189,240,162,221,192,147,35,93,48,10,227,32,55,118,252,167,236,
112,105,73,241,139,96,150,205,19,83,208,53,157,34,43,121,53,93,38,250,198,43,
180,239,45,222,226,6,140,74,190,170,72,223,237,73,66,160,56,253,43,213,159,31,
220,81,105,53,231,15,240,141,184,87,184,182,13,125,59,109,224,12,57,81,125,70,
64,99,250,87,69,246,25,195,227,137,187,94,225,173,29,226,50,65,45,242,73,48,
198,71,118,158,54,207,182,20,212,195,35,112,228,208,218,221,29,217,216,239,195,
150,157,165,216,77,198,189,173,207,111,6,149,105,31,127,29,152,155,248,108,152,
207,121,43,15,203,232,163,115,231,232,122,179,182,94,213,228,226,54,147,133,248,
50,220,112,255,0,3,219,49,91,109,62,217,4,95,136,255,0,238,75,141,201,61,112,
73,198,222,117,232,47,142,110,62,176,211,184,49,56,2,209,217,181,45,73,163,158,
225,87,97,21,186,182,70,125,217,148,96,122,3,237,94,44,81,145,138,207,12,92,254,
115,41,235,72,138,140,81,167,28,200,178,15,62,180,63,122,44,35,154,55,143,207,
168,174,170,32,7,249,87,161,254,15,248,106,29,62,77,99,181,189,101,35,151,73,
225,203,105,149,99,81,205,49,152,32,98,202,189,54,66,70,231,169,175,61,170,228,
215,183,59,15,224,29,82,251,225,57,184,126,202,88,172,175,56,144,201,43,206,224,
226,56,164,112,188,196,13,207,240,211,97,239,92,254,67,227,10,251,42,59,103,87,
118,5,170,107,29,168,252,85,39,26,106,48,74,209,193,223,92,28,2,82,218,49,25,72,
163,207,65,142,96,61,206,77,123,67,91,213,44,52,93,30,239,87,212,238,82,218,202,
210,38,154,121,92,224,42,168,201,53,77,217,199,4,232,28,1,195,16,104,90,5,170,
67,12,96,25,165,35,248,147,190,55,119,62,100,254,221,5,121,67,226,251,182,163,
196,151,87,28,5,195,23,10,116,107,121,0,191,186,141,179,248,185,20,252,138,127,
145,79,234,71,160,223,155,139,203,58,138,47,165,179,172,254,33,123,78,187,237,
71,141,31,81,78,242,29,30,211,48,233,214,205,249,83,59,187,15,230,110,167,211,
97,229,93,101,203,76,219,38,79,47,173,73,225,193,233,94,148,48,165,26,70,77,
137,74,185,1,170,81,39,239,77,119,33,188,39,161,172,36,124,185,83,212,85,44,123,
21,144,72,240,212,102,64,203,154,225,193,92,214,98,57,200,173,82,64,9,15,118,
244,57,134,28,138,52,163,122,196,139,205,16,111,49,177,164,192,95,28,202,71,220,
80,227,234,84,211,10,48,115,80,116,229,147,34,177,144,208,37,93,241,78,195,15,
60,100,99,122,31,32,217,133,57,105,177,165,5,176,98,15,31,41,193,168,149,218,
172,175,96,200,231,81,72,227,124,83,148,105,133,130,92,171,100,86,36,76,116,232,
119,20,98,155,87,0,219,148,244,254,149,52,2,235,181,114,138,209,224,215,40,160,
177,9,124,120,200,233,88,140,99,99,82,97,150,200,62,85,129,190,227,99,231,92,
133,19,79,173,19,32,29,250,121,84,34,220,224,237,68,0,96,156,125,232,3,132,120,
79,55,79,74,23,48,81,233,92,119,198,124,232,43,151,147,239,82,198,139,77,7,199,
168,164,121,217,186,213,230,180,202,185,100,80,57,7,144,170,109,14,49,14,180,20,
156,242,243,111,246,205,63,171,74,5,172,158,172,107,72,254,150,75,236,168,45,
203,27,31,90,25,202,218,159,86,106,148,159,32,244,174,92,142,85,68,244,27,212,
12,74,118,194,224,117,61,105,238,30,78,105,36,207,78,92,213,109,193,203,224,85,
223,14,196,123,185,36,198,65,194,138,80,220,198,250,46,244,232,212,52,242,28,98,
56,176,62,167,111,245,167,35,185,183,177,69,50,201,202,196,99,151,27,183,210,
171,173,174,17,98,158,0,167,188,149,193,31,65,89,187,71,180,213,34,189,154,62,
120,72,0,146,54,95,244,173,239,232,138,31,50,193,168,234,16,71,9,44,57,14,118,
59,100,239,85,55,209,187,106,18,202,179,30,114,216,5,186,98,182,107,73,33,105,
141,196,65,12,105,3,190,70,55,56,192,173,102,228,249,158,164,230,174,93,2,16,
213,101,49,36,97,155,30,0,71,169,223,122,173,148,175,35,42,169,35,175,208,83,90,
196,173,52,189,225,249,16,5,0,121,1,73,198,127,130,23,249,155,45,246,27,127,90,
193,189,150,18,53,23,54,166,49,253,242,99,3,215,255,0,99,250,123,208,237,91,187,
189,140,145,178,158,149,8,149,222,231,9,144,73,192,199,173,74,73,31,189,196,168,
11,41,220,145,131,73,140,140,174,93,251,176,190,123,83,92,165,116,225,26,236,
206,252,196,122,129,211,252,233,78,100,70,118,80,217,110,153,242,171,105,98,204,
113,74,14,84,196,152,246,219,52,123,16,146,201,206,0,82,161,198,220,172,113,246,
205,110,58,13,253,173,188,154,101,205,221,132,178,69,106,29,46,132,67,46,170,
203,202,29,125,112,78,126,213,169,94,68,128,100,198,6,127,54,105,174,29,212,100,
177,190,141,213,164,123,113,179,131,208,103,210,157,39,166,35,122,227,141,96,
235,90,10,22,88,47,167,181,112,246,122,154,169,73,157,20,238,140,127,56,244,230,
241,12,117,53,178,91,235,73,174,112,213,142,165,112,75,200,35,238,222,68,220,
135,3,7,62,248,0,227,206,180,119,184,142,213,158,120,227,15,103,33,45,52,35,166,
127,157,60,190,163,219,52,27,89,47,244,11,235,139,157,30,17,168,233,23,101,135,
112,217,195,40,57,25,198,234,70,70,8,245,170,132,120,116,38,236,87,86,148,188,
247,48,227,104,217,176,125,122,31,243,160,218,54,32,128,255,0,137,171,151,154,
148,26,173,201,69,182,123,59,130,206,68,101,178,55,29,55,193,160,219,183,252,44,
25,24,57,39,127,122,210,18,216,80,75,167,202,26,119,134,45,63,17,165,107,199,
185,14,223,134,69,70,192,202,177,127,244,7,244,170,187,131,177,173,239,128,116,
219,132,224,173,71,91,228,13,108,111,226,133,241,185,194,169,39,111,249,255,0,
106,89,36,173,88,210,58,250,18,74,142,111,46,181,121,164,207,29,202,181,156,143,
137,112,76,47,234,125,13,39,196,22,95,217,186,212,246,227,120,152,247,145,31,84,
59,138,175,83,32,156,24,137,231,207,135,29,115,78,13,193,209,61,150,93,224,67,
204,20,130,167,14,135,202,172,108,100,14,64,3,111,152,123,26,215,224,105,37,186,
102,102,36,177,223,222,182,88,80,69,18,40,198,113,189,122,94,36,156,182,201,144,
204,173,144,43,209,127,3,215,195,251,123,136,172,10,166,100,180,138,80,113,226,
240,185,24,207,167,136,87,155,165,108,40,174,223,248,61,213,127,3,219,28,22,140,
216,91,251,57,160,250,144,3,143,255,0,10,215,207,249,248,242,65,13,72,246,221,
120,155,226,187,140,52,190,42,227,248,87,71,188,23,118,154,109,184,183,46,160,
133,239,57,219,156,12,253,134,125,171,214,253,166,107,99,135,59,63,215,117,162,
220,173,107,101,35,70,115,249,200,194,255,0,234,34,190,113,163,179,164,236,204,
89,143,136,147,230,115,94,79,240,204,87,55,145,250,53,155,244,10,67,226,168,
147,252,22,246,32,212,29,247,53,132,112,121,215,213,107,218,148,140,136,179,102,
217,191,194,192,210,76,217,6,154,140,229,101,95,84,207,233,73,49,235,92,210,96,
68,62,8,62,149,218,93,134,246,179,169,246,105,197,176,202,211,75,55,15,222,56,
26,133,166,114,49,211,188,65,228,235,237,212,12,87,84,158,180,89,188,118,232,
222,155,87,46,72,169,170,96,157,31,84,180,157,66,203,86,211,45,181,61,58,226,59,
155,59,168,150,88,101,67,149,116,97,144,69,116,167,198,167,3,73,197,93,150,29,
110,207,38,247,135,157,174,130,1,158,242,18,0,144,125,128,13,255,0,41,174,164,
248,59,237,142,109,15,85,181,236,239,136,38,86,210,111,37,43,167,92,59,111,109,
51,116,140,159,228,99,211,208,159,122,245,111,105,218,117,206,173,217,223,16,
105,214,103,23,51,233,243,44,67,25,203,114,28,15,185,219,239,94,76,162,241,79,
251,27,167,104,249,106,199,18,102,184,78,24,212,165,70,87,195,41,86,27,16,124,
136,174,58,147,131,234,43,189,246,102,11,62,42,247,143,97,186,101,207,98,63,15,
26,166,189,196,191,241,18,22,125,75,184,183,159,188,66,172,170,35,85,35,97,205,
182,72,219,127,106,240,138,174,13,123,23,225,107,136,100,227,142,192,248,179,
128,117,105,26,226,77,54,206,88,160,36,150,99,4,177,183,32,255,0,149,129,3,219,
2,185,188,139,226,190,138,137,230,94,211,184,255,0,136,187,69,226,70,214,248,
138,229,100,144,2,150,241,34,133,72,35,201,33,20,122,111,212,238,107,88,65,183,
208,214,57,10,190,8,193,7,113,71,9,140,138,232,130,75,72,147,176,187,0,237,42,
231,179,78,51,107,201,30,87,210,47,98,104,53,8,20,115,6,24,60,175,202,118,37,73,
207,184,200,243,174,241,236,198,247,132,59,66,236,3,136,251,58,183,187,140,106,
145,11,141,70,210,217,199,33,70,46,100,78,76,237,179,229,113,232,71,173,121,38,
95,35,234,40,113,79,52,47,207,12,175,27,128,71,50,49,7,126,189,43,44,184,84,
157,173,50,147,162,82,2,185,82,48,65,193,173,167,128,184,226,251,134,172,181,61,
18,102,123,141,3,88,133,161,212,44,182,195,228,97,93,115,209,212,224,131,237,
90,152,221,106,39,161,21,187,138,146,166,79,71,39,78,238,70,80,67,0,118,35,206,
177,8,230,37,125,69,68,3,208,209,32,240,184,62,244,33,28,3,31,106,122,202,238,
235,79,190,134,254,194,119,183,185,133,132,177,72,135,12,141,234,13,41,34,226,
66,40,171,186,15,109,170,171,208,12,106,186,149,238,175,120,247,154,133,212,
183,55,12,170,12,146,185,102,194,128,0,201,246,21,235,63,129,190,205,26,218,201,
187,73,213,3,44,179,172,150,218,108,94,93,222,112,242,31,169,5,71,182,125,107,
205,189,145,112,109,215,29,246,135,165,240,205,184,112,151,51,3,115,34,143,238,
161,93,221,191,78,158,228,87,209,231,155,134,248,23,133,173,45,229,158,215,73,
210,108,213,45,160,231,96,168,190,74,185,62,123,127,90,229,242,103,197,112,69,
197,123,60,207,241,191,217,190,185,123,173,91,113,222,149,107,53,245,159,225,
150,214,242,56,144,179,192,84,177,14,64,252,132,28,103,200,143,122,243,14,183,
195,218,222,130,109,134,179,165,221,88,27,168,204,176,9,227,42,93,65,32,144,15,
184,34,189,169,63,196,207,8,218,118,153,170,112,230,163,137,248,125,57,35,183,
212,237,208,186,135,229,196,129,215,243,38,122,50,254,135,173,116,143,198,7,24,
232,60,105,218,6,153,39,14,223,197,127,101,101,167,44,102,104,190,66,236,204,
196,15,160,43,159,122,175,29,228,181,6,180,41,87,103,69,136,88,157,134,221,69,
18,24,153,36,86,253,106,198,40,135,119,156,110,191,210,187,131,176,142,195,245,
158,59,212,237,245,61,86,222,107,14,26,141,131,201,59,142,86,185,3,242,70,60,
243,230,221,7,214,189,9,168,99,143,41,50,21,190,133,190,29,251,15,212,120,251,
91,143,87,213,160,123,110,22,183,151,50,200,114,173,116,71,254,28,126,222,173,
229,245,175,119,105,246,118,186,125,140,22,54,80,36,22,214,241,172,80,196,131,
10,136,163,0,15,96,42,166,251,81,225,126,5,225,184,86,246,242,199,69,210,172,
226,17,196,36,112,138,170,6,0,81,212,159,166,77,121,203,182,95,137,242,68,218,
71,103,72,57,89,74,182,171,50,28,251,247,104,70,223,249,155,244,243,175,37,243,
242,37,164,106,170,40,219,126,47,251,79,28,53,195,7,132,52,91,227,30,181,169,
175,252,65,136,248,160,183,57,206,79,145,110,131,207,25,246,175,17,73,16,230,
233,86,218,206,167,125,171,223,203,169,234,87,147,94,93,206,121,165,154,103,44,
238,125,201,170,217,88,87,171,131,4,113,66,189,153,201,219,3,26,114,182,105,139,
149,5,67,15,58,92,189,17,100,230,139,7,202,181,180,137,5,182,62,149,203,142,161,
199,158,199,235,80,39,15,143,93,170,67,197,25,95,63,47,168,172,238,198,8,124,
216,245,169,32,33,235,40,185,0,250,81,249,1,0,211,73,128,41,87,206,177,16,7,42,
122,29,168,178,141,168,40,124,88,165,39,64,15,147,12,65,169,58,101,1,243,20,105,
151,36,63,175,90,138,227,4,31,49,89,49,130,66,49,203,71,183,219,106,88,3,205,
244,167,96,76,168,52,163,216,49,132,195,41,83,208,210,23,16,242,61,88,114,30,94,
97,229,88,120,251,202,217,171,17,92,169,145,92,49,251,83,93,209,86,169,119,85,
10,32,38,35,206,198,185,78,136,189,171,148,113,21,154,201,246,235,80,44,220,
222,158,85,45,206,79,233,89,43,183,76,138,243,205,9,197,208,125,105,165,92,231,
62,148,156,57,24,244,27,227,214,154,50,40,232,114,13,2,22,185,192,206,212,109,
46,19,57,96,171,156,169,31,79,74,94,229,137,240,129,146,122,213,143,15,74,35,
158,85,97,243,70,89,64,235,181,37,216,253,25,209,73,109,68,200,195,112,27,63,
166,41,141,101,128,136,47,169,205,15,73,66,156,242,227,25,216,208,245,71,45,42,
169,61,42,150,160,30,192,41,231,117,95,122,133,228,128,202,216,223,202,179,9,
196,132,255,0,40,38,128,249,96,196,16,14,42,111,67,20,57,105,51,229,154,217,180,
129,221,90,46,70,204,51,84,105,101,62,1,88,203,131,252,187,214,194,152,137,68,
126,75,202,134,140,73,167,108,36,76,201,0,211,162,141,173,157,164,137,154,73,27,
229,194,227,166,104,186,212,223,217,82,90,205,108,188,209,207,25,13,19,18,85,
179,208,254,245,111,53,159,46,172,182,220,129,148,66,170,192,249,146,55,170,62,
38,178,146,194,107,101,46,94,213,88,247,97,183,49,250,174,125,43,102,154,68,34,
199,66,70,181,208,174,99,148,129,33,78,80,61,50,195,35,250,214,185,168,92,247,
211,50,71,178,3,140,250,213,173,221,204,29,192,45,42,198,204,220,193,151,230,
246,219,253,106,150,103,181,50,51,44,115,72,205,212,146,20,103,216,10,82,122,
161,164,47,114,216,135,146,149,142,69,11,140,239,157,168,242,137,29,183,240,143,
65,229,80,8,83,32,17,154,201,178,232,127,135,240,37,146,112,78,65,192,229,25,
32,250,214,39,182,73,110,217,154,66,75,182,73,234,115,73,66,90,4,230,60,193,89,
183,229,56,52,237,247,240,251,169,210,99,40,42,14,79,95,165,23,160,36,186,67,
151,17,151,29,220,131,8,228,99,149,188,129,163,40,43,97,20,113,49,110,237,138,
177,97,215,204,125,58,154,125,3,79,166,72,160,248,28,2,61,143,90,71,79,136,174,
100,12,196,159,11,161,232,107,78,53,68,216,189,233,121,167,182,181,232,25,128,
63,82,113,87,49,104,16,72,24,30,110,97,183,55,76,31,165,84,222,50,247,168,192,
128,122,15,109,243,91,191,11,200,183,54,106,237,243,135,101,111,127,63,243,199,
218,136,171,157,49,250,53,187,125,43,82,134,228,65,19,115,66,251,16,122,85,222,
130,101,183,180,93,56,57,55,54,147,176,116,242,49,158,164,253,136,199,189,108,
23,22,233,12,47,112,202,68,72,165,153,191,148,14,166,181,40,53,56,83,138,175,
39,104,46,22,43,168,87,187,61,209,201,0,13,241,215,27,121,86,169,44,111,178,30,
193,106,246,208,95,184,191,177,60,235,111,52,72,242,46,220,204,199,124,31,108,
254,198,148,189,145,165,117,98,161,72,0,108,54,35,200,254,148,119,70,180,185,
132,90,151,252,4,238,215,75,17,252,206,160,168,108,117,198,231,239,75,94,76,239,
200,110,2,139,133,202,201,143,51,157,179,244,4,15,181,103,246,202,21,184,108,0,
43,178,120,106,214,226,14,16,176,177,121,101,180,75,233,214,78,112,112,79,49,
235,250,5,174,186,211,45,222,255,0,86,183,182,69,231,231,112,8,246,243,253,179,
91,239,104,124,85,61,228,214,17,105,240,193,109,13,165,186,91,194,160,115,120,
80,110,119,232,73,39,53,156,165,115,138,41,105,54,33,199,28,63,123,30,145,248,
183,151,241,50,89,76,241,57,94,188,153,216,159,235,247,173,38,218,79,16,113,212,
86,245,105,113,172,44,48,202,211,7,182,156,132,153,63,43,103,125,255,0,83,90,
135,16,233,115,232,218,164,214,236,15,116,78,98,124,108,84,244,174,156,169,95,
36,140,161,244,206,104,72,101,185,201,27,46,245,176,110,72,170,190,27,65,248,
121,31,204,156,85,176,95,15,222,187,188,71,241,20,129,72,73,192,171,78,10,226,
11,174,21,226,237,51,136,108,209,100,154,194,225,102,84,99,128,224,117,82,125,
8,200,251,213,99,138,25,21,211,38,165,22,152,143,101,246,247,199,154,110,177,
240,217,30,179,106,6,53,241,12,81,71,205,147,27,243,115,58,147,254,30,70,21,227,
91,93,222,68,254,100,53,184,106,60,65,13,199,99,122,87,14,126,40,254,34,207,90,
184,156,193,255,0,219,120,147,13,255,0,87,55,234,107,79,179,192,187,79,241,109,
92,62,46,63,197,22,191,118,92,157,136,74,78,106,48,177,239,70,253,118,169,220,
12,72,195,208,145,66,27,16,125,13,116,50,73,193,181,192,95,92,175,234,41,66,55,
34,155,127,5,200,111,70,6,131,112,57,110,28,122,49,172,228,2,229,112,212,100,
28,214,206,190,135,53,18,55,162,193,212,143,230,90,128,21,142,73,32,185,142,
120,137,89,35,112,234,71,145,7,34,190,163,112,46,183,7,18,112,102,143,174,219,
184,146,59,251,56,230,200,245,42,57,135,216,228,125,171,229,211,173,122,103,224,
243,181,187,171,45,103,78,236,247,90,155,54,19,43,197,167,200,199,251,183,36,
176,79,161,36,129,245,174,15,47,27,107,146,244,92,29,104,233,62,221,56,121,248,
111,181,142,36,210,90,62,237,35,191,145,225,192,192,49,191,141,72,251,17,90,91,
143,225,47,181,122,147,227,207,133,97,183,226,13,35,138,224,24,123,248,90,222,
96,7,204,209,96,131,255,0,75,127,233,175,47,5,202,48,251,213,99,124,160,152,61,
48,33,114,107,185,62,17,56,186,223,132,123,95,180,91,249,132,54,58,180,77,99,
43,49,240,134,98,12,100,255,0,204,0,255,0,154,186,128,13,170,105,36,145,72,146,
196,204,142,140,25,88,28,16,71,67,68,225,202,45,13,51,115,237,215,134,91,132,
187,90,226,29,31,185,120,224,91,199,154,223,153,113,152,164,60,234,71,182,14,62,
213,165,179,120,65,30,85,233,14,214,172,110,123,91,236,15,64,237,62,206,40,166,
214,180,40,158,211,92,110,96,172,200,159,159,30,120,56,108,122,57,244,175,53,
141,193,21,56,165,113,175,104,37,162,50,31,235,66,52,86,221,106,24,222,181,98,
57,31,165,112,141,241,89,65,226,197,76,141,243,235,77,9,130,229,222,179,140,84,
200,174,31,90,116,50,114,12,133,127,81,131,88,76,228,143,90,200,241,66,71,166,
245,197,25,80,212,234,196,119,151,193,37,196,80,246,229,110,146,100,52,250,125,
196,113,224,224,115,96,54,254,187,41,174,251,248,228,182,158,110,198,98,154,34,
121,32,213,33,105,64,244,42,234,63,114,43,203,127,14,28,65,163,240,183,107,218,
46,181,174,220,75,109,97,11,186,188,200,50,16,178,50,130,195,175,46,78,254,213,
239,110,40,209,120,107,180,142,8,159,74,185,158,43,253,39,80,64,86,107,89,65,
193,4,21,101,97,145,144,64,53,199,157,112,202,164,255,0,98,227,180,124,206,134,
44,184,106,183,210,244,139,221,79,81,130,195,77,180,150,238,238,225,130,69,20,
75,204,204,79,160,175,69,234,191,9,58,180,87,15,253,143,197,150,50,219,151,240,
11,168,25,28,46,124,202,228,18,62,213,181,104,157,146,232,189,147,232,183,26,
183,17,246,155,119,165,65,38,210,201,101,26,91,201,38,7,200,142,67,72,115,232,
184,174,223,230,241,70,63,29,191,242,71,7,123,19,236,235,177,30,10,236,254,194,
223,137,123,80,214,116,247,186,228,14,182,151,50,170,91,196,221,112,65,57,149,
135,167,79,99,75,246,233,241,31,107,167,233,201,163,118,111,43,9,206,82,75,233,
45,10,198,137,140,14,228,54,55,247,229,199,165,117,255,0,104,93,183,240,204,73,
53,135,103,252,37,109,222,103,3,90,214,19,241,87,36,143,204,130,78,110,83,238,
79,218,186,51,81,186,184,190,185,107,203,169,158,105,166,57,119,115,146,77,115,
195,28,178,75,158,82,155,75,72,127,86,215,245,142,33,189,146,235,91,213,46,245,
11,137,50,76,151,19,23,57,246,207,79,181,86,161,240,145,230,13,46,132,164,148,
193,192,155,62,76,51,93,177,126,137,56,27,242,154,4,196,138,36,155,111,65,159,
125,197,83,122,0,92,222,85,56,137,201,30,180,48,187,209,225,77,255,0,122,138,
109,129,25,16,144,24,86,99,7,62,253,105,248,97,12,25,126,226,132,99,229,106,213,
99,246,43,32,169,143,161,233,92,44,2,227,210,138,49,202,83,207,170,210,115,190,
9,167,39,197,1,137,31,34,130,27,197,154,137,108,156,84,115,189,114,74,86,202,
72,119,155,154,60,125,197,8,54,245,136,155,111,165,100,140,54,125,105,246,4,
194,101,193,245,167,44,215,7,148,249,80,98,25,79,165,55,10,224,134,173,99,26,38,
198,22,60,28,121,26,136,143,150,76,26,110,36,14,158,245,218,253,152,118,49,119,
197,26,100,28,75,196,122,181,167,14,240,219,18,5,212,242,168,121,176,112,66,2,
112,55,4,100,250,116,53,89,37,24,71,148,152,146,108,233,249,32,200,233,81,72,
124,177,94,142,226,73,254,28,56,124,127,103,88,104,154,151,17,220,66,0,105,224,
186,112,142,125,220,176,7,254,85,199,165,116,231,25,93,233,26,167,17,79,121,161,
104,105,162,233,237,129,21,162,202,210,114,0,58,150,61,73,59,212,99,200,230,255,
0,75,75,247,27,84,106,221,207,181,114,172,30,28,30,149,202,218,136,58,231,228,
56,59,138,154,177,17,143,210,179,42,120,77,7,197,202,125,186,215,144,108,51,
221,225,65,83,226,30,117,197,108,158,86,80,51,81,70,87,80,24,28,129,229,67,45,
227,240,18,7,169,164,216,28,193,50,55,185,167,244,216,90,105,97,238,207,140,29,
177,229,74,198,2,130,231,229,171,158,13,85,73,230,230,82,100,9,204,131,218,132,
183,64,57,123,18,197,26,178,128,57,247,32,122,213,5,219,243,92,19,87,90,164,204,
84,6,219,148,85,3,156,177,53,115,126,129,18,255,0,193,118,243,59,10,7,228,220,
103,122,44,167,17,42,253,205,4,117,172,216,208,246,150,203,248,200,57,19,144,
171,110,67,28,55,214,175,108,98,252,110,164,145,54,226,105,66,145,237,154,215,
45,134,14,107,103,225,220,69,115,28,254,113,229,191,106,211,31,208,153,98,108,
87,241,115,201,253,167,61,189,176,98,14,88,103,0,224,14,99,237,84,122,165,226,
75,163,205,25,204,139,20,229,99,118,57,60,189,65,253,60,234,194,250,225,211,
240,112,136,162,148,77,33,218,83,224,206,54,39,216,103,53,87,171,73,109,248,23,
130,41,63,21,43,73,204,238,170,66,231,204,231,166,60,170,164,196,138,148,32,198,
8,221,136,235,92,82,73,7,208,212,21,130,140,121,87,21,183,39,126,149,137,102,
100,30,44,31,74,139,140,57,250,10,196,174,198,86,32,126,180,54,126,86,37,182,
247,164,1,46,136,238,162,143,61,70,72,199,169,169,88,79,111,20,146,193,117,8,
146,39,216,19,213,79,76,138,139,190,110,80,108,64,0,26,3,168,148,157,198,73,216,
209,214,192,218,244,63,198,53,170,198,159,133,146,32,74,247,114,199,144,126,245,
61,54,205,100,239,99,4,44,165,242,169,159,63,48,42,167,70,213,6,155,54,38,180,
19,169,249,149,156,140,253,186,85,181,204,208,69,117,14,165,162,222,73,28,82,
236,241,179,120,226,127,79,113,90,169,42,68,208,181,246,154,182,250,143,113,42,
169,89,7,52,109,156,227,62,95,174,106,223,135,229,91,9,205,172,187,65,62,7,49,
252,140,58,31,220,253,141,103,86,187,186,185,75,91,141,67,186,145,213,138,9,149,
2,151,255,0,205,142,164,122,213,182,179,161,73,115,195,210,234,86,195,101,85,
116,35,204,141,136,253,63,165,83,87,116,9,208,30,43,213,157,172,91,73,183,29,
227,178,115,206,81,178,57,87,124,103,204,121,254,149,70,143,125,126,44,181,41,
37,239,27,153,191,11,28,101,85,99,43,234,8,242,169,105,246,210,68,203,50,51,
126,30,116,195,145,185,80,118,63,165,48,246,13,162,106,247,150,178,203,12,193,
237,26,107,103,133,242,140,199,4,227,211,35,59,82,229,111,97,69,44,18,79,54,167,
121,61,204,156,178,34,4,206,122,121,224,122,82,236,177,37,136,61,236,109,59,76,
79,34,158,98,23,29,73,233,215,202,154,238,4,55,41,204,22,69,186,80,192,176,207,
143,31,231,254,116,148,81,151,145,34,65,187,55,40,30,230,151,160,47,248,73,109,
108,172,239,53,59,201,100,142,71,141,160,181,8,185,37,200,223,232,49,212,251,
212,33,187,107,162,182,209,216,193,222,34,21,119,108,147,38,228,231,126,157,124,
171,58,148,182,209,222,91,217,153,21,109,108,215,148,17,191,120,255,0,152,143,
92,157,190,130,179,167,204,13,236,151,118,250,117,197,212,106,66,130,168,121,
127,230,32,126,212,99,171,176,151,209,101,103,54,179,125,108,97,134,72,68,81,
140,164,36,99,60,190,158,245,43,177,170,107,26,26,218,221,8,38,66,192,195,38,48,
200,222,64,159,67,210,148,176,212,53,155,13,72,221,105,118,43,3,33,39,198,161,
128,7,203,13,91,6,152,156,72,97,102,176,181,211,166,23,92,221,228,101,129,10,78,
228,99,59,111,184,244,174,155,82,251,35,163,76,176,105,172,173,76,82,68,202,232,
196,50,145,184,62,245,97,107,126,146,120,100,94,82,122,85,159,20,105,122,196,86,
235,115,171,233,111,105,114,163,29,234,16,201,48,30,184,232,195,215,206,181,156,
169,143,152,31,42,172,115,120,244,135,217,110,236,10,237,235,80,35,31,74,70,198,
118,101,40,199,37,124,234,195,33,173,129,244,36,87,100,101,202,54,75,84,10,65,
185,172,6,228,150,22,250,31,222,165,38,9,251,84,46,6,34,137,190,162,152,16,212,
147,150,242,81,254,44,210,192,120,77,55,169,248,174,139,121,21,7,246,165,128,
207,48,246,166,4,103,223,7,218,163,120,51,63,55,243,40,63,181,73,142,81,125,171,
146,140,136,27,212,99,244,53,18,64,46,115,145,89,140,225,148,250,26,203,143,25,
30,134,176,71,90,138,17,151,93,216,123,212,236,167,158,202,238,27,187,89,90,27,
136,92,73,28,138,112,85,129,200,35,239,89,11,204,255,0,81,67,35,6,147,141,140,
246,12,252,67,103,241,7,216,62,165,105,21,186,39,21,232,138,151,70,216,224,243,
202,128,238,191,225,112,28,99,200,144,43,199,172,129,39,101,0,129,158,132,99,30,
213,183,118,73,198,250,159,103,188,107,105,196,58,105,46,168,123,187,155,126,
108,44,241,31,153,15,245,7,200,129,77,118,199,101,164,55,18,14,38,225,178,63,
177,117,208,110,224,139,35,154,214,82,127,139,3,1,208,171,103,30,160,131,92,144,
196,241,75,143,167,215,255,0,133,183,106,205,4,174,50,40,103,165,52,235,226,52,
18,187,154,213,192,155,59,155,225,187,140,90,207,67,226,254,1,185,135,191,135,
94,210,238,26,209,9,255,0,250,132,133,143,40,255,0,204,185,31,85,21,210,104,60,
99,223,106,110,222,73,97,110,246,9,30,41,80,134,70,67,130,167,216,208,31,44,
197,143,82,115,89,44,92,100,223,216,238,193,114,224,145,232,106,60,190,180,103,
3,155,62,162,160,195,122,190,32,71,27,230,136,70,64,197,71,30,31,161,162,196,
50,164,26,168,198,192,17,27,84,113,145,76,152,246,168,170,120,136,199,90,167,
140,44,20,99,203,214,137,18,236,203,247,174,40,253,168,136,49,32,247,218,170,49,
19,37,110,112,107,114,236,239,180,14,40,224,29,77,239,248,115,80,48,51,161,71,
138,69,239,34,112,72,59,169,219,59,117,235,90,106,248,95,122,97,6,72,247,218,
174,84,215,22,172,72,238,125,99,226,111,181,11,219,65,4,55,122,109,129,198,26,
91,123,65,206,127,234,44,7,216,87,85,241,47,18,235,252,79,122,215,186,254,175,
121,169,92,30,143,113,41,110,95,96,58,1,236,42,169,215,124,87,35,66,79,74,198,
56,227,23,241,84,83,109,129,69,201,34,142,137,205,25,95,62,163,235,92,229,229,
53,37,126,93,199,145,205,104,162,32,18,1,128,213,156,230,47,117,53,41,135,140,
168,232,219,138,140,93,126,187,82,161,156,115,204,5,9,1,96,84,209,149,124,36,
122,87,21,113,32,62,181,74,33,100,22,61,250,81,224,76,48,39,165,16,167,157,118,
143,97,29,143,234,157,167,95,207,47,226,36,211,116,107,80,86,107,254,228,72,12,
187,17,18,130,195,45,131,146,119,192,198,122,140,219,113,198,185,75,161,119,163,
173,191,187,96,125,40,55,187,55,48,232,107,215,23,159,10,26,28,118,175,34,113,
70,175,113,34,38,68,113,91,196,25,200,242,28,204,6,79,185,3,222,170,91,225,207,
131,244,197,105,248,158,247,139,173,52,232,226,121,30,235,254,13,18,32,163,39,
152,171,72,119,242,219,124,99,174,43,39,230,226,107,76,124,25,229,38,98,48,65,
233,74,92,54,73,174,196,236,235,128,95,180,110,210,207,14,240,207,226,162,210,
140,239,43,92,220,128,210,91,218,43,124,239,202,48,95,4,12,108,11,16,54,21,188,
118,249,240,223,171,240,69,156,154,255,0,10,207,117,174,104,145,229,167,141,208,
27,155,85,254,102,229,0,58,250,176,3,30,99,27,214,57,115,70,248,183,177,164,
121,243,53,176,232,218,86,153,111,166,38,189,196,102,228,217,73,35,71,107,103,
106,234,147,221,149,249,136,102,4,71,26,156,2,252,173,147,176,7,12,86,163,74,
177,155,82,212,237,180,251,124,9,46,36,84,82,221,23,39,118,62,128,117,39,200,3,
76,241,37,244,119,250,145,107,110,101,178,183,65,111,102,141,177,88,87,101,200,
242,39,118,108,117,102,99,231,89,189,232,99,156,89,125,195,151,250,186,77,194,
250,21,206,139,98,35,10,96,158,248,221,59,56,39,44,91,149,113,145,141,177,85,
165,118,199,165,43,25,193,167,49,149,83,90,193,104,76,157,179,120,241,235,79,
192,50,49,73,65,25,230,62,213,99,0,241,3,235,91,68,150,51,102,121,91,7,165,91,
35,75,44,34,221,166,145,161,27,162,22,37,84,251,15,42,170,8,65,200,171,43,35,
156,86,177,126,153,44,2,161,73,48,69,52,99,5,67,10,45,196,64,183,48,29,107,48,
12,169,83,84,149,104,0,24,242,190,226,185,68,249,73,174,84,129,214,6,133,35,5,
114,65,29,48,212,73,91,148,114,142,167,246,161,24,179,25,127,94,149,227,154,129,
109,152,131,144,69,49,24,86,94,102,110,163,52,55,203,0,173,213,70,43,10,63,130,
72,62,37,56,168,25,194,228,168,94,184,59,15,83,91,46,143,15,225,34,183,149,228,
29,235,177,18,15,49,158,153,173,126,210,60,77,25,25,45,206,0,30,166,182,109,85,
121,46,247,199,55,40,39,21,81,6,33,171,63,151,158,77,85,129,204,248,167,245,124,
126,55,148,116,192,63,181,39,109,187,179,99,97,68,157,176,33,116,57,137,198,219,
226,128,190,244,196,216,245,235,65,10,24,129,239,83,236,99,150,81,243,40,245,39,
108,213,246,152,217,137,156,100,12,98,170,108,176,20,121,145,228,42,194,205,156,
68,177,8,216,156,228,129,228,43,72,186,36,143,18,127,197,92,88,233,177,31,30,
114,222,217,219,250,81,248,134,246,43,104,14,159,12,64,120,64,30,128,85,66,95,
198,154,252,151,187,178,140,132,247,219,2,131,168,221,75,121,59,78,234,1,198,0,
30,148,54,20,40,251,230,179,110,165,79,220,99,53,131,190,244,85,3,4,250,100,
138,138,40,31,153,111,122,9,221,192,199,83,71,144,145,14,65,220,208,84,238,15,
161,164,192,32,32,220,51,99,166,106,86,48,27,139,148,140,126,99,184,246,20,36,
124,35,146,119,59,85,183,10,198,243,95,243,36,101,149,80,228,250,83,17,205,66,
217,88,130,126,97,182,105,75,114,208,75,206,114,201,231,138,216,245,11,109,243,
140,85,76,214,228,13,135,90,183,20,250,4,205,155,76,188,178,213,116,161,165,187,
219,53,203,143,225,49,114,141,205,229,215,99,250,212,116,159,237,187,103,158,
221,111,231,138,88,220,199,44,12,50,15,177,7,99,90,149,197,187,43,167,46,205,
140,226,182,78,22,226,18,183,177,46,160,138,196,14,86,153,155,148,156,116,201,
61,104,82,218,76,77,23,28,40,21,46,36,179,187,27,247,141,132,85,39,10,122,128,
42,179,80,211,36,135,95,158,208,74,75,196,121,163,39,205,126,134,175,184,179,
79,152,73,14,181,166,72,241,199,46,57,164,133,198,223,66,40,55,176,234,210,180,
26,133,220,194,237,85,68,125,243,128,28,3,211,39,204,81,40,211,4,237,9,241,62,
155,102,186,61,165,146,199,53,182,179,108,65,101,206,82,85,234,172,167,200,251,
85,70,161,111,14,153,166,27,187,178,141,169,221,156,65,20,108,8,137,63,52,141,
143,205,228,7,150,230,182,126,59,177,154,251,65,177,214,224,70,145,109,151,240,
247,14,1,219,27,12,231,202,180,93,122,198,59,41,97,146,218,99,36,19,70,178,41,
61,84,145,186,253,141,102,219,253,37,254,224,26,88,196,139,53,200,239,8,3,150,
60,236,49,211,63,233,86,87,124,83,175,222,216,8,133,244,130,218,31,10,66,167,
149,16,123,40,218,170,237,18,25,98,120,165,217,207,202,230,161,105,203,12,173,
28,141,148,59,54,60,170,151,100,144,123,171,217,24,153,46,92,130,122,115,83,9,
37,204,74,146,71,60,202,73,35,103,35,165,4,44,124,204,128,115,17,231,235,78,
161,29,218,197,201,190,228,31,173,48,44,108,184,139,136,224,129,140,90,173,195,
196,131,116,149,249,151,31,122,193,190,183,212,109,153,204,43,5,216,59,242,108,
175,235,183,145,161,152,8,208,230,192,60,207,32,12,63,194,6,127,174,40,6,204,
216,136,196,164,247,204,161,202,142,138,15,76,251,214,176,148,133,162,13,35,67,
38,213,103,97,112,38,180,147,7,12,167,36,125,170,158,237,188,85,155,25,24,51,
128,72,37,107,163,22,78,58,6,172,187,231,202,161,245,90,204,164,53,160,246,122,
82,210,67,53,128,148,144,57,27,144,239,190,251,209,215,197,108,227,59,130,13,
119,42,146,180,102,98,102,231,229,111,108,84,99,31,196,30,245,28,236,42,74,112,
192,251,208,4,29,112,8,244,53,22,254,225,79,242,73,253,104,211,224,74,227,222,
130,55,138,85,246,13,250,82,146,208,2,156,226,225,189,142,107,7,230,197,102,233,
79,122,15,243,40,174,58,144,170,222,162,146,90,37,132,132,142,100,253,43,19,46,
28,208,208,144,71,177,166,46,151,196,8,243,20,80,88,17,215,53,41,153,240,99,
230,60,132,243,114,231,108,250,215,35,92,214,101,27,41,246,163,141,161,216,63,
32,125,170,14,187,209,87,122,195,46,84,84,240,0,113,15,22,61,70,40,101,119,166,
35,24,96,107,146,160,89,8,247,165,248,244,49,114,187,13,186,84,74,102,152,228,
174,99,20,191,24,88,186,167,81,237,82,136,96,209,48,3,10,136,216,210,170,25,156,
145,181,71,163,3,82,59,156,1,146,124,171,184,116,223,134,174,214,47,108,227,185,
58,61,149,176,145,67,42,79,125,24,108,30,153,10,78,62,149,50,156,99,250,152,
210,58,116,168,14,71,173,101,70,72,174,215,190,236,19,141,44,174,94,11,253,79,
133,108,228,139,2,97,62,179,18,152,182,7,44,58,141,136,61,58,86,191,218,167,102,
218,183,103,19,233,176,235,26,182,137,125,54,161,11,79,28,122,117,195,202,99,64,
64,12,220,200,160,2,73,0,140,231,149,189,42,99,146,47,73,133,26,84,139,226,230,
254,97,154,98,1,149,207,152,175,74,246,45,216,31,9,241,199,99,182,156,77,172,
222,106,214,119,215,18,78,233,45,163,6,29,218,72,83,29,217,82,91,116,109,134,
231,53,208,92,103,167,233,218,47,24,234,122,86,149,113,115,113,101,107,112,209,
71,37,204,77,20,167,29,121,149,149,89,72,57,4,21,29,58,81,12,177,148,156,87,
160,106,144,154,89,92,221,25,77,173,172,211,136,99,50,202,99,140,183,118,131,
171,54,58,1,234,105,117,24,220,87,174,126,13,120,135,128,161,210,31,133,173,76,
171,196,183,65,167,185,146,230,37,11,114,48,51,28,77,147,144,131,170,156,100,
243,48,200,233,213,159,21,221,154,195,192,188,101,22,167,162,217,45,183,15,234,
171,152,18,60,242,65,50,128,30,61,250,3,243,15,169,3,101,165,28,233,228,112,106,
135,90,179,175,187,55,224,93,115,180,46,41,143,64,208,82,33,41,67,44,211,76,72,
142,8,199,86,98,1,61,72,0,0,73,36,85,22,177,162,234,122,87,18,93,112,245,221,
179,141,70,218,233,173,30,21,4,147,32,110,92,15,92,158,158,187,87,120,252,29,
113,244,122,15,29,65,194,114,218,65,29,166,182,12,111,113,202,59,195,114,50,98,
203,117,228,198,80,47,243,54,124,205,93,252,71,199,166,240,15,196,174,131,199,
218,134,155,37,245,141,204,11,118,208,71,133,50,92,194,10,13,206,195,24,133,179,
251,82,150,73,44,174,21,235,65,90,179,206,220,71,195,218,255,0,15,78,45,117,253,
26,255,0,75,184,27,170,93,219,180,69,135,168,230,27,143,113,85,64,96,237,245,
21,239,254,18,237,51,178,254,215,116,3,167,106,49,218,131,44,130,23,211,117,
116,64,198,66,9,1,9,36,49,192,108,21,60,219,30,149,214,125,172,124,43,219,200,
178,106,93,157,221,152,100,0,147,165,221,201,149,111,104,229,59,143,163,231,255,
0,48,169,199,228,165,46,57,21,48,113,250,58,239,135,251,37,225,109,111,176,
185,248,202,30,40,138,45,126,198,202,123,219,171,24,157,101,33,22,70,9,222,38,
121,147,33,8,7,24,220,117,173,207,225,74,243,129,120,19,129,174,56,203,138,245,
72,180,205,71,88,191,147,77,178,184,120,153,202,70,136,140,121,112,172,23,196,
217,44,70,54,80,107,173,59,33,146,247,132,184,239,88,225,62,34,180,155,78,125,
115,72,187,209,110,34,185,66,140,146,74,135,186,59,227,171,133,0,244,195,103,
222,131,60,178,106,95,13,176,161,129,79,246,55,19,114,172,128,28,136,231,129,
152,231,254,104,255,0,113,239,90,79,27,149,193,189,54,191,248,239,254,193,63,
103,109,252,71,246,69,12,252,43,117,199,250,18,233,206,109,130,203,51,233,227,
193,125,110,199,105,202,1,202,174,160,130,204,132,171,140,182,19,24,61,91,7,105,
188,89,193,28,31,166,112,143,10,106,195,78,136,219,139,219,217,162,133,12,178,
75,56,231,3,153,129,192,17,152,198,216,57,7,127,33,191,124,35,118,141,223,79,
63,102,28,83,118,110,116,173,74,6,135,78,89,200,43,27,16,220,240,228,254,87,4,
224,19,128,70,0,241,87,66,113,124,23,54,92,73,168,105,215,82,247,178,216,204,
108,249,249,64,200,135,248,107,211,217,5,24,162,211,120,242,110,186,7,246,142,
212,224,110,213,120,211,88,225,126,53,208,181,109,127,82,189,158,231,72,107,171,
57,218,225,132,144,73,11,171,48,66,8,42,10,115,147,143,229,30,166,186,142,251,
136,117,203,248,18,215,80,214,181,27,187,116,217,98,158,233,228,85,250,2,113,86,
93,157,78,201,197,214,182,169,131,253,162,146,233,219,244,31,136,137,161,7,127,
67,32,63,106,213,110,207,44,167,203,122,109,70,13,210,14,199,147,89,212,108,
109,5,165,141,203,218,47,127,248,131,36,12,82,70,96,48,185,97,190,23,124,122,22,
111,90,237,110,205,254,38,123,65,225,171,192,154,245,207,251,209,166,242,114,
152,46,200,89,70,219,17,40,82,217,245,230,230,207,239,93,44,231,157,51,230,40,
32,111,88,78,49,151,104,125,30,133,237,91,134,184,18,78,202,207,108,60,17,105,
113,98,117,187,153,109,100,178,115,225,179,150,95,12,136,160,108,23,9,56,255,0,
251,171,140,0,0,243,200,27,87,113,118,77,171,203,172,118,47,218,23,103,179,42,
60,113,216,157,126,204,147,226,87,129,226,50,129,147,143,145,115,129,190,3,117,
174,157,63,53,78,52,213,166,12,192,216,213,133,184,231,132,31,181,33,79,233,135,
57,74,219,31,116,75,27,179,95,22,13,60,137,64,137,57,92,31,93,170,194,5,200,
174,136,175,68,132,68,230,80,105,139,69,229,108,31,168,168,194,190,84,194,46,8,
35,202,175,136,134,72,202,208,241,202,217,20,81,130,185,168,54,235,143,74,177,
16,152,120,179,235,189,114,178,65,101,0,117,21,202,145,157,77,59,143,197,110,
54,233,92,64,236,0,45,176,216,87,26,44,183,49,220,209,212,42,40,29,77,120,134,
192,222,48,131,61,114,104,83,41,141,187,197,30,31,58,60,192,225,113,185,38,163,
122,64,128,70,187,146,119,169,99,11,164,184,75,232,221,144,184,234,160,29,243,
87,119,179,37,197,227,58,19,130,163,98,48,69,107,240,127,114,170,122,142,132,
121,85,172,44,135,119,103,230,56,5,177,78,50,208,62,192,94,196,77,203,57,144,5,
3,24,27,158,149,97,165,88,51,233,83,184,76,120,9,141,188,249,135,157,47,132,
134,41,103,69,4,115,0,51,91,58,75,8,150,39,78,81,13,196,96,242,250,54,55,253,
106,162,137,102,137,57,230,25,198,28,31,22,6,6,48,48,127,173,64,46,79,244,250,
213,165,252,34,223,82,188,143,144,180,109,25,64,7,145,36,16,126,216,164,96,71,
36,202,160,21,140,115,48,62,158,162,165,162,135,237,210,20,89,50,248,101,139,
42,63,155,4,103,250,154,82,75,219,153,3,42,59,69,25,219,149,15,151,189,89,155,
62,238,54,239,88,71,113,52,60,241,166,122,38,57,183,62,68,143,47,122,171,229,8,
184,170,16,184,78,84,216,99,122,158,8,143,124,245,169,17,156,103,165,114,101,2,
49,130,69,32,4,163,44,62,181,47,203,245,21,148,30,158,66,185,140,149,247,52,12,
133,202,242,148,3,204,80,102,240,182,71,165,53,114,188,210,242,159,42,70,93,152,
147,147,229,154,76,8,174,224,228,237,233,91,175,0,196,5,149,196,164,12,179,133,
250,0,43,80,177,181,107,137,70,1,228,206,231,160,173,179,67,186,75,77,67,240,
248,24,153,112,7,79,16,233,73,125,129,111,123,6,124,88,219,247,170,185,45,242,
118,25,21,120,236,75,225,128,223,99,66,252,40,119,37,118,111,235,86,132,80,93,
219,14,244,12,100,1,85,115,64,70,67,19,140,245,29,107,112,150,215,188,159,149,
151,149,128,170,203,203,50,164,146,15,94,180,221,49,116,85,232,122,197,254,149,
51,217,139,135,252,36,199,199,17,221,15,190,60,141,118,95,15,24,53,222,29,187,
211,97,158,9,39,120,1,69,71,241,171,41,219,194,126,253,43,173,174,172,241,33,32,
96,210,234,151,118,51,53,221,164,242,69,52,104,25,89,78,24,28,249,26,154,104,
102,243,97,15,16,69,99,123,96,39,184,154,54,4,207,110,224,16,84,121,143,165,86,
90,233,35,87,210,46,173,139,5,154,216,23,129,185,134,231,249,72,235,87,92,7,
198,208,53,250,157,86,72,22,240,176,33,166,202,171,147,177,220,109,191,158,107,
28,105,194,146,216,107,34,254,11,124,233,247,63,196,66,141,204,23,62,132,117,
20,152,89,214,168,190,18,1,33,134,196,31,90,196,251,0,251,238,48,126,181,113,
197,58,116,250,110,180,241,204,163,19,162,205,27,14,140,164,117,21,81,38,233,
143,32,115,73,61,0,75,40,75,237,231,231,154,217,116,205,53,102,88,92,41,110,100,
254,134,168,44,231,138,60,0,11,49,192,199,149,110,28,61,50,139,104,159,151,43,
27,184,219,220,103,252,171,72,213,18,216,204,90,43,50,169,193,81,205,130,7,215,
21,173,94,72,247,87,179,203,46,231,188,42,7,160,27,15,233,91,55,2,107,47,123,
107,120,47,231,85,11,32,120,249,143,171,29,135,175,74,215,181,36,88,117,107,232,
127,146,225,199,238,107,88,52,246,11,178,174,230,62,99,138,29,152,229,184,10,
124,246,166,38,249,137,161,199,129,50,182,113,131,84,85,152,133,185,45,230,95,
71,4,83,22,215,78,35,112,119,24,235,75,202,184,50,253,143,239,80,137,138,163,
249,237,87,12,142,61,9,171,29,73,213,188,232,249,6,32,71,173,84,6,247,166,173,
229,43,9,12,124,60,195,237,91,195,61,246,75,136,237,203,142,96,125,64,161,68,
227,188,193,63,48,34,135,51,228,46,253,54,174,88,91,93,95,223,219,89,88,219,203,
115,117,60,171,20,48,196,165,158,71,99,128,170,6,228,146,64,197,105,41,232,84,
102,105,63,133,25,27,224,99,53,52,145,100,137,70,119,206,43,58,190,157,168,105,
55,147,105,218,157,149,205,141,220,46,68,144,92,68,209,200,135,208,171,110,41,
0,72,67,141,136,57,172,225,145,166,55,17,242,155,244,171,141,107,71,188,211,
172,116,235,139,152,200,142,250,213,110,173,219,27,58,22,101,63,163,35,15,181,
55,217,119,9,107,189,161,107,255,0,216,58,13,178,203,118,176,180,204,242,55,44,
104,139,230,205,141,183,192,30,228,87,105,241,157,166,128,123,8,210,56,114,254,
250,27,78,53,225,59,203,171,107,187,25,54,118,141,238,36,98,170,223,43,227,40,
195,4,237,205,235,90,126,85,105,34,92,78,140,65,131,138,203,143,1,246,53,232,
127,132,14,20,224,221,110,243,90,126,45,131,72,189,150,229,86,215,78,179,189,
228,103,114,60,82,180,106,219,243,0,99,221,119,0,154,165,248,135,236,58,247,128,
174,228,214,244,8,231,189,225,153,78,75,31,20,150,76,78,57,92,249,174,78,205,
246,59,224,145,121,16,252,143,27,236,56,186,179,163,151,173,75,27,17,89,228,60,
213,46,66,26,182,36,179,224,174,28,212,120,183,138,244,254,27,210,123,175,198,
223,205,221,68,101,36,34,236,73,102,32,18,0,0,147,128,118,21,105,218,119,0,113,
47,103,250,226,233,156,69,101,221,51,175,52,55,17,18,208,78,7,82,141,129,156,
109,145,177,27,100,110,43,29,152,241,141,231,0,241,92,124,73,167,89,218,221,95,
65,27,36,2,225,73,68,44,64,99,128,65,221,57,215,99,249,171,219,240,201,193,125,
183,118,115,99,105,170,195,27,29,66,197,47,133,184,112,39,181,110,102,140,188,
109,254,23,71,92,253,136,195,96,241,230,207,44,82,90,248,151,24,166,120,191,176,
238,207,167,237,35,143,45,244,5,153,237,236,209,13,197,244,235,243,71,10,144,15,
46,118,230,37,130,140,249,156,249,86,251,219,135,96,144,240,172,83,221,240,157,
230,163,118,182,200,101,150,198,253,84,207,36,32,120,166,133,208,5,145,70,9,100,
0,58,1,204,70,8,53,101,162,240,118,191,217,70,167,218,54,144,53,41,173,47,207,
14,73,115,164,106,48,18,134,120,35,153,25,217,72,249,31,148,96,140,228,29,198,
216,53,177,124,47,118,233,123,169,106,144,112,15,28,93,75,127,45,227,152,244,
253,66,118,12,196,144,127,131,41,59,183,54,48,172,114,73,32,30,163,25,229,205,
145,190,112,122,94,138,73,116,207,38,57,235,66,105,50,118,173,223,183,142,18,78,
8,237,95,93,225,219,116,101,179,142,110,250,207,63,254,230,64,29,0,62,124,161,
185,115,234,166,180,60,156,213,254,78,74,208,168,236,142,193,181,93,47,133,248,
178,94,55,214,244,227,168,218,104,48,25,162,183,5,115,37,203,145,28,64,103,96,
65,102,124,227,110,76,141,192,7,185,44,126,47,53,89,245,235,69,185,225,77,62,
207,74,107,133,23,36,78,242,204,145,18,57,138,159,8,44,6,79,79,181,121,150,210,
252,199,162,93,105,156,132,254,34,226,25,185,249,186,119,107,32,198,60,243,222,
126,212,4,21,147,199,25,187,146,29,181,209,233,110,214,62,34,123,64,208,184,255,
0,136,116,29,49,244,105,52,235,107,151,130,220,201,103,207,152,252,155,60,216,
108,130,55,232,125,43,207,252,85,196,90,199,21,107,146,235,26,229,217,185,187,
148,5,230,229,10,170,163,101,85,80,0,85,3,96,5,88,118,145,56,190,226,11,109,85,
79,50,95,105,150,114,115,122,186,219,164,114,127,254,200,228,31,106,214,65,193,
173,49,66,49,73,164,38,236,245,95,195,151,101,231,141,251,11,186,142,243,137,53,
173,42,59,205,81,204,98,210,64,170,99,72,249,57,72,63,50,150,99,145,176,240,143,
173,121,147,92,177,93,51,92,190,211,146,99,50,218,220,73,8,144,167,47,63,43,21,
206,60,186,86,227,193,124,105,197,218,103,8,107,26,62,145,196,154,181,133,188,
17,37,220,9,107,121,36,92,135,190,85,112,188,164,99,34,66,199,31,203,90,93,223,
60,183,15,44,142,206,242,30,114,204,114,88,157,201,39,204,230,158,56,73,74,77,
189,3,99,154,22,171,127,162,234,118,186,190,153,112,246,247,182,115,44,240,74,
167,117,101,63,211,212,121,138,247,110,183,101,166,118,231,216,123,219,6,138,27,
249,99,86,232,113,103,126,138,9,95,160,36,169,59,248,88,215,133,180,45,34,231,
83,188,211,237,161,235,127,120,44,208,227,56,118,42,6,127,234,31,161,174,246,
248,107,237,57,56,95,181,11,254,16,185,185,103,225,237,99,83,159,240,242,201,
130,235,112,236,22,55,102,244,96,161,79,187,102,167,201,198,228,148,163,218,216,
226,206,135,183,109,83,135,184,150,55,84,123,93,83,76,188,4,41,30,40,167,137,
250,99,212,50,254,213,236,31,137,141,57,123,67,248,118,176,226,219,24,145,174,
44,146,29,79,150,54,230,229,70,78,89,144,17,212,47,54,79,255,0,203,170,31,137,
238,200,180,187,125,82,255,0,181,20,190,130,11,36,69,151,80,176,116,57,184,159,
42,136,16,141,135,57,42,27,211,118,223,52,159,193,159,25,29,78,207,82,236,203,
92,41,113,96,246,210,75,101,28,131,170,49,61,244,95,67,204,91,31,249,169,100,
154,201,8,230,135,250,123,255,0,176,74,157,30,102,180,103,255,0,119,111,173,212,
156,27,152,37,101,246,85,149,115,246,46,7,222,187,99,178,62,223,248,187,130,187,
139,29,78,71,215,244,81,225,54,247,50,30,246,17,235,28,135,39,254,86,200,244,
199,90,168,237,71,130,180,158,7,226,173,95,133,116,205,94,45,98,225,173,101,144,
178,128,63,12,138,235,42,198,231,63,222,4,137,201,198,62,101,245,34,186,230,37,
200,43,235,211,235,93,170,56,243,71,106,211,39,104,247,133,221,159,0,118,245,
194,16,234,186,101,200,143,81,178,96,214,183,106,129,110,244,233,199,136,7,95,
53,200,207,46,121,91,25,7,161,29,21,217,247,1,235,18,197,218,151,101,58,141,
188,81,106,223,134,135,80,179,142,51,132,121,33,114,200,99,255,0,11,137,20,111,
208,48,206,55,174,170,236,223,140,181,174,4,226,139,109,123,69,156,172,145,144,
39,128,177,228,184,143,62,40,220,121,131,251,28,17,184,174,224,237,23,181,203,
77,47,183,62,27,237,3,65,182,239,33,155,64,183,93,70,212,156,51,137,11,179,70,
79,243,42,148,193,245,81,229,92,159,135,38,38,225,29,167,181,251,53,178,237,61,
157,67,217,246,133,173,71,218,182,131,165,54,149,124,154,132,90,165,187,61,185,
133,150,84,11,34,150,36,31,151,0,18,73,216,98,133,218,252,19,193,218,159,22,69,
116,67,76,53,155,178,228,116,57,149,142,127,122,245,237,215,196,151,101,113,232,
239,170,67,121,123,45,248,139,193,101,248,23,89,152,245,229,47,142,65,191,248,
177,245,175,19,241,38,173,115,173,241,6,163,173,94,145,248,141,66,230,75,153,
113,211,153,216,177,199,182,77,94,44,147,201,39,41,70,180,38,146,42,227,184,150,
218,116,158,7,49,203,19,135,70,29,84,131,144,127,90,181,237,30,207,240,188,89,
126,85,145,225,184,113,121,3,162,242,171,67,58,137,99,32,121,120,92,125,58,85,
13,203,97,232,247,186,132,218,141,204,114,92,4,12,150,241,91,130,160,238,177,
160,69,39,39,174,20,84,205,219,4,37,25,245,172,54,205,88,193,87,35,204,26,33,92,
140,212,208,205,171,177,253,111,77,225,254,208,180,235,253,106,226,88,52,146,38,
183,191,49,161,114,96,150,39,141,199,47,158,67,123,250,249,86,163,33,12,228,170,
242,130,118,30,158,213,34,58,26,230,41,86,236,44,136,92,211,154,112,43,50,159,
35,64,69,205,88,89,71,149,173,33,29,146,203,72,80,50,227,206,153,182,217,177,
64,182,200,97,239,77,227,18,2,62,181,215,68,12,198,187,138,58,174,42,17,141,
168,224,109,84,6,83,99,138,27,156,53,73,186,100,117,21,9,124,67,34,165,136,138,
177,86,53,202,192,25,21,202,145,157,104,35,203,40,233,83,88,65,99,128,73,52,64,
60,241,82,146,101,138,62,68,221,143,83,94,35,54,43,238,157,150,80,177,238,69,
76,198,123,165,14,217,99,190,42,72,185,96,88,111,154,46,57,155,155,29,54,21,5,
4,180,133,75,34,225,65,198,119,166,68,57,0,129,128,88,159,208,82,51,147,222,
133,83,211,2,174,109,10,36,49,247,167,35,187,36,253,206,41,218,232,68,33,180,2,
193,26,64,225,76,153,56,25,219,214,173,117,139,78,230,5,49,16,34,101,230,67,159,
145,128,207,232,127,173,27,81,142,239,74,75,102,151,13,106,87,42,113,242,146,51,
143,109,168,23,19,60,214,109,166,0,54,28,232,228,228,119,103,117,199,211,113,90,
58,90,36,214,102,86,186,145,164,118,110,246,86,192,193,229,25,27,159,216,84,45,
121,45,37,230,114,197,23,126,86,232,125,141,17,227,123,67,12,210,14,117,231,36,
161,232,112,74,228,125,63,206,152,150,205,218,233,98,240,199,128,25,159,30,71,
24,254,181,43,236,100,37,185,51,94,196,202,252,206,236,50,231,213,188,169,57,3,
43,16,221,65,193,163,202,103,181,187,97,203,28,114,35,108,202,185,57,245,4,210,
238,220,196,146,73,36,228,147,84,194,136,72,112,223,74,228,188,204,20,29,128,29,
43,15,187,125,106,50,55,241,72,244,218,165,140,154,140,70,199,237,68,132,127,
21,7,182,104,76,216,132,110,60,70,165,223,170,76,220,221,64,199,76,211,3,44,65,
154,70,62,85,94,197,76,161,91,56,45,189,21,174,148,44,140,48,197,191,106,13,178,
180,205,144,0,3,174,245,50,118,5,227,58,195,106,166,53,28,132,100,17,74,44,178,
37,226,220,228,247,136,65,20,194,158,123,66,27,148,97,112,49,73,6,71,101,83,
177,36,3,68,196,142,193,142,65,61,172,115,46,194,68,13,255,0,122,53,169,245,216,
150,2,168,244,135,120,46,91,78,114,66,50,243,199,159,47,165,94,219,33,13,30,248,
203,231,56,170,76,98,92,83,114,214,118,47,50,99,155,152,40,62,230,155,178,133,
46,108,33,103,28,197,134,73,164,184,242,39,110,28,149,213,24,242,204,132,144,
41,205,9,24,233,80,18,78,121,70,212,215,98,23,190,211,176,204,85,118,7,165,86,
95,89,255,0,14,113,142,145,45,109,172,22,77,155,36,226,131,171,216,43,45,199,
40,0,247,106,54,251,85,8,235,91,187,102,231,230,35,127,90,180,208,120,154,255,
0,77,129,108,165,185,151,240,160,229,65,241,132,245,192,59,111,76,222,90,148,
230,44,184,229,223,235,85,19,217,203,35,103,148,70,159,202,119,39,223,218,161,
199,118,135,223,102,221,169,52,188,79,195,201,61,165,221,165,211,233,74,210,242,
21,238,231,88,179,226,92,116,97,230,61,55,173,70,226,6,82,160,15,3,142,100,62,
160,208,44,167,159,77,191,45,109,43,41,229,42,217,243,82,55,7,214,182,40,26,43,
206,25,217,71,123,108,249,247,0,210,74,193,148,177,70,59,146,23,35,31,189,109,
124,23,135,210,228,66,48,235,58,146,51,235,145,90,228,97,73,40,70,222,117,117,
193,76,79,227,80,236,123,176,222,222,22,21,164,86,200,98,124,52,178,89,53,220,
138,146,51,192,210,15,9,4,41,86,216,145,231,214,133,112,102,185,212,230,150,224,
163,73,47,44,156,203,208,228,127,218,175,52,72,185,120,167,81,181,103,40,179,78,
195,159,151,56,14,185,206,13,81,234,18,195,30,171,221,193,56,120,212,24,209,179,
177,10,127,110,180,71,67,19,186,89,45,219,46,9,141,190,83,140,212,21,131,41,96,
65,21,115,123,205,46,148,211,68,65,238,223,46,58,141,199,254,255,0,74,169,252,
48,146,38,154,220,242,178,238,233,212,99,212,86,187,64,153,30,126,126,127,117,
52,191,49,1,189,197,115,196,174,115,183,149,0,185,168,114,42,130,3,76,65,150,
130,85,246,205,42,128,183,74,110,199,114,232,124,212,213,69,129,149,114,209,111,
212,87,112,124,57,234,92,3,193,211,220,246,137,198,58,132,151,23,90,109,212,118,
250,126,147,109,26,60,238,238,9,55,24,98,60,42,1,220,17,131,231,158,80,122,101,
78,57,135,181,115,57,63,106,183,46,81,166,35,222,29,171,93,246,63,218,174,151,
195,150,26,174,160,182,119,92,65,107,36,186,6,177,221,114,20,116,110,86,137,152,
255,0,136,224,163,96,18,8,4,54,43,198,157,161,240,134,179,192,156,93,125,195,58,
236,74,151,118,219,171,161,202,76,135,117,116,62,106,71,233,184,56,32,138,238,
158,202,123,46,189,237,163,177,174,27,180,181,215,109,116,180,225,173,79,80,182,
157,165,132,202,236,147,119,18,175,42,130,54,4,191,82,55,39,222,171,126,51,44,
31,76,226,78,26,210,230,213,34,212,166,210,116,120,180,249,110,231,185,141,175,
46,142,93,185,158,53,60,202,160,17,226,108,22,44,126,109,205,99,137,168,203,
138,99,102,151,216,239,106,26,135,101,243,37,254,141,107,109,52,183,151,138,186,
143,122,156,205,37,170,114,145,18,28,248,121,139,57,39,29,85,125,8,174,255,0,
248,185,209,52,157,83,67,225,222,210,52,97,27,69,126,137,20,210,162,0,38,142,68,
231,134,66,71,152,25,93,206,112,87,210,188,171,195,122,4,250,252,22,208,166,167,
165,233,234,242,220,127,27,81,187,91,120,135,34,68,91,196,199,115,134,27,1,147,
141,179,210,189,117,216,93,165,159,104,255,0,13,26,191,103,111,171,90,234,23,58,
99,201,105,21,212,34,64,153,230,239,173,220,115,170,183,40,109,183,3,100,166,
231,248,230,166,191,200,85,170,60,183,167,106,23,90,62,179,103,169,216,204,209,
92,217,92,44,240,178,146,57,93,72,32,254,194,189,169,192,157,174,104,188,83,
197,186,207,0,241,44,80,69,44,242,186,216,119,160,119,119,150,242,14,97,11,14,
156,225,91,24,232,192,122,245,240,182,171,21,205,157,236,246,151,113,73,111,115,
4,141,20,209,56,195,35,169,195,41,30,68,16,69,91,241,85,229,226,106,86,23,235,
43,163,182,157,102,240,200,14,24,119,112,164,121,4,122,52,103,244,174,188,209,
134,94,200,141,163,112,248,137,224,8,123,61,237,26,109,50,196,183,246,101,220,
66,242,200,18,73,72,217,152,114,18,122,149,42,71,174,49,158,181,215,189,222,
112,107,176,190,35,184,171,88,226,46,37,208,37,214,227,48,94,195,195,246,125,
252,69,66,178,200,233,222,49,35,168,45,206,14,15,64,64,174,186,130,101,101,27,
214,152,114,55,5,201,236,82,91,51,52,56,57,21,187,104,220,87,171,240,246,135,
194,218,206,137,123,45,174,161,165,220,222,91,198,195,36,20,204,82,242,156,236,
84,153,152,21,250,159,58,211,157,193,143,57,171,61,62,54,212,56,93,237,45,161,
121,175,98,212,227,88,34,141,75,60,130,88,164,231,192,3,203,185,79,214,156,169,
246,35,216,22,188,105,195,253,169,112,63,12,221,220,37,181,166,165,171,220,94,
104,147,197,187,24,164,146,202,97,34,3,228,172,123,166,223,200,168,235,94,29,
190,142,251,72,214,30,41,59,219,75,251,41,202,182,15,43,197,42,54,14,254,68,17,
251,87,118,241,93,170,118,45,47,0,89,181,242,223,106,176,234,35,94,213,34,141,
191,186,7,187,84,136,47,150,81,100,220,224,156,249,0,43,190,120,167,176,190,203,
251,80,188,135,141,172,174,239,96,26,158,46,100,155,77,157,68,119,89,234,196,50,
183,43,31,60,99,124,228,103,53,231,169,199,23,93,51,90,179,203,191,18,90,197,
199,16,235,220,37,175,95,129,248,251,254,21,178,158,237,130,128,175,41,105,114,
192,14,153,24,174,170,101,222,187,191,227,13,244,27,94,209,52,190,24,225,232,
163,142,211,135,116,104,116,242,168,115,200,193,157,194,19,230,66,186,231,59,
228,156,239,93,40,70,245,166,55,241,66,125,145,77,141,29,126,111,173,7,24,163,
174,234,13,104,132,108,122,178,75,121,192,250,45,235,64,220,182,83,92,105,253,
232,59,114,228,76,139,143,35,205,44,191,92,123,86,183,34,225,189,142,245,119,97,
170,8,248,87,80,209,152,49,252,85,221,189,194,158,80,64,49,172,170,119,61,63,
189,242,244,253,107,36,76,160,246,218,173,8,239,175,131,190,206,180,94,55,186,
215,245,13,117,110,30,11,8,146,218,56,227,148,42,201,223,164,170,225,182,206,
202,1,29,48,72,62,85,217,252,91,240,187,193,98,210,123,205,43,81,215,96,145,75,
50,219,171,36,171,203,228,170,8,12,78,122,101,142,245,227,253,55,88,213,244,
200,101,131,79,213,47,172,225,148,134,146,56,46,26,53,114,58,18,1,0,226,172,173,
120,135,90,146,39,137,181,157,68,135,4,16,110,95,124,253,255,0,247,154,135,143,
36,165,106,84,59,85,209,220,61,166,112,55,13,246,91,109,167,91,233,186,252,215,
218,187,203,53,236,214,247,45,23,53,169,138,23,16,183,34,19,202,76,142,167,114,
115,129,183,132,215,70,14,100,148,72,140,85,148,243,43,3,130,15,168,168,188,153,
98,88,146,217,220,158,166,163,222,100,215,84,35,197,109,219,37,236,236,94,59,
237,123,141,120,219,133,108,56,115,94,188,130,75,75,70,87,103,142,50,178,92,58,
130,3,74,115,134,56,62,64,12,128,113,157,235,81,208,181,29,67,71,213,34,212,52,
171,219,139,43,200,243,221,79,4,133,29,9,24,216,141,198,199,21,82,143,190,41,
168,155,161,243,21,112,81,74,146,208,48,215,23,215,210,234,19,223,79,119,60,215,
115,135,239,103,149,203,187,243,130,27,153,142,228,144,72,251,210,203,182,13,26,
229,112,217,29,14,244,22,242,35,204,86,157,8,147,156,54,124,141,14,102,118,108,
187,22,32,0,9,57,216,12,1,250,84,143,138,51,234,42,15,186,131,73,140,131,29,141,
45,43,236,69,77,222,150,115,226,172,39,33,160,82,248,134,106,43,228,104,220,
155,227,214,176,169,185,24,172,104,100,102,93,195,255,0,55,95,173,113,54,163,4,
230,136,143,49,184,161,129,69,80,16,97,189,96,12,209,89,118,205,113,87,122,40,
12,196,187,85,133,134,204,87,214,150,137,61,105,168,7,43,130,5,109,21,68,178,
202,33,184,167,16,101,1,244,165,35,223,24,167,237,198,86,183,162,67,67,186,209,
129,192,160,197,179,17,69,160,71,9,205,97,6,229,107,10,114,113,69,43,190,106,88,
200,42,227,32,215,40,197,114,1,174,84,88,206,177,144,248,125,40,27,29,133,21,
206,118,168,16,21,9,197,120,140,216,103,75,183,91,169,251,172,224,117,52,246,
179,101,20,61,212,144,163,39,54,204,184,216,98,150,208,167,134,212,77,52,167,
114,48,163,20,213,214,171,113,118,142,145,32,72,192,201,245,52,173,80,20,192,
130,228,227,36,157,170,226,214,56,158,243,185,153,136,229,84,84,31,204,192,103,
6,169,237,65,123,168,211,249,156,83,204,229,239,85,148,227,55,5,129,244,197,
17,141,131,102,237,198,2,65,162,28,191,58,243,162,182,222,155,230,180,203,91,
134,252,109,187,60,141,203,26,225,127,242,249,143,222,183,13,50,238,45,67,64,
146,59,215,94,238,82,248,198,237,205,242,236,62,245,165,234,246,179,105,247,38,
2,193,249,88,172,108,60,241,85,62,236,72,182,185,150,210,117,151,76,126,85,73,
79,60,110,6,121,88,157,254,223,235,80,181,183,184,91,241,111,116,3,102,16,138,
227,164,138,163,3,246,254,148,222,129,164,197,119,163,172,141,225,145,100,240,
57,234,15,250,81,245,96,250,106,218,60,160,28,158,241,74,250,121,143,184,52,
213,129,171,235,182,215,9,57,119,203,5,240,115,122,227,214,171,59,202,220,120,
128,69,45,136,145,8,42,217,96,71,210,181,88,173,99,100,105,36,36,1,208,122,210,
150,134,40,39,29,234,141,179,154,131,73,151,36,156,239,69,154,201,217,193,138,
60,12,19,156,208,163,180,156,184,83,141,252,234,45,140,156,146,1,221,38,49,210,
165,221,228,187,228,140,147,86,186,47,15,155,251,245,89,228,100,140,31,159,25,
242,242,30,116,93,115,64,155,78,28,241,19,53,179,15,11,244,59,158,132,122,213,
69,137,162,128,90,51,68,57,20,150,111,74,177,179,182,238,45,219,42,57,136,166,
67,136,161,138,1,184,198,115,138,147,202,166,50,160,12,98,173,37,98,101,77,156,
141,204,241,72,112,87,37,71,173,9,242,46,19,30,180,107,148,15,226,93,152,28,131,
232,105,101,239,36,96,114,6,61,186,84,75,232,102,225,123,20,179,67,103,113,110,
252,178,162,0,14,58,213,190,157,121,46,34,142,241,59,183,11,140,249,26,165,181,
89,27,74,81,21,210,179,42,248,112,187,31,99,82,135,84,231,229,91,212,240,145,
131,231,76,102,223,109,36,110,25,27,150,69,97,134,86,25,7,237,83,142,40,226,80,
145,40,85,242,3,202,181,139,89,37,137,90,91,73,132,241,231,60,153,241,15,245,
171,77,63,87,138,227,40,249,73,7,80,70,42,211,19,69,154,167,138,156,157,85,191,
16,24,245,0,85,114,78,165,179,159,58,205,221,232,19,76,153,216,147,244,170,180,
67,40,184,150,104,173,30,222,55,82,194,103,11,251,214,47,44,66,175,54,50,49,
214,171,120,194,227,188,155,79,110,165,101,63,208,85,252,211,44,150,101,200,252,
153,253,169,39,182,51,72,183,69,158,105,228,35,126,98,1,171,173,22,198,228,91,
205,113,19,3,26,175,241,19,29,84,156,102,168,236,156,160,96,63,49,200,173,219,
132,110,162,138,20,105,49,202,71,43,130,50,8,244,253,41,99,219,9,116,106,179,38,
3,131,145,144,70,212,199,6,92,164,90,176,143,196,253,250,52,56,81,185,36,108,
105,238,48,177,180,182,212,102,142,202,115,37,180,139,204,132,124,203,157,241,
90,228,37,173,157,90,35,150,66,55,243,52,228,248,187,23,104,223,238,236,251,
139,175,198,66,224,93,186,35,36,108,48,57,135,66,73,242,216,214,171,170,42,220,
8,238,21,57,98,87,41,142,92,6,98,6,79,215,34,182,125,14,25,245,29,33,46,32,42,
205,18,200,34,89,9,230,118,59,101,143,182,78,43,92,148,114,232,67,188,121,59,
223,196,96,163,125,15,136,10,125,177,34,90,92,112,198,210,70,139,39,241,147,148,
133,108,123,237,239,73,67,35,91,222,117,85,145,24,171,35,116,117,63,246,171,126,
31,107,120,181,91,41,175,82,71,181,73,145,166,88,241,204,80,48,44,6,227,124,
102,189,17,198,253,167,118,19,165,90,193,6,133,217,69,142,172,247,64,18,247,54,
145,192,139,143,86,241,49,111,183,222,170,114,113,164,144,210,60,203,174,89,24,
152,200,161,137,85,14,63,199,25,232,126,160,236,106,142,78,187,87,116,246,145,
218,188,90,158,138,220,47,163,240,7,14,112,253,140,161,24,201,12,61,229,193,1,
185,176,178,16,48,15,67,183,76,239,93,69,121,108,141,33,154,211,38,34,124,81,
159,154,51,233,238,61,234,29,191,84,82,208,8,88,167,46,7,150,244,221,158,5,210,
145,242,181,44,169,204,131,3,161,34,141,108,25,37,94,97,182,106,162,193,144,152,
114,76,203,232,72,168,198,224,50,146,3,0,119,25,235,83,190,218,234,76,111,189,
46,8,39,106,171,3,182,63,253,79,226,51,217,222,173,166,112,174,159,97,194,90,
122,94,219,52,255,0,216,98,88,100,100,41,42,145,36,172,237,35,130,66,3,150,253,
137,21,213,206,239,53,193,150,103,105,36,118,230,118,99,146,196,157,201,62,102,
182,126,206,10,222,69,196,92,62,196,243,234,154,76,159,134,24,235,60,14,151,10,
7,187,8,157,0,243,47,244,173,83,59,82,142,152,51,182,184,27,177,238,53,227,14,
201,175,245,61,23,69,154,121,87,87,183,252,12,109,252,63,196,198,201,34,202,202,
206,66,149,86,238,183,207,243,116,197,91,124,29,113,244,92,21,218,138,233,154,
140,233,22,153,174,168,178,157,203,14,68,152,28,194,228,244,198,75,46,122,97,
243,229,65,236,203,226,3,136,248,59,128,245,46,16,150,202,45,66,202,107,57,97,
176,148,73,221,73,101,35,163,0,219,3,206,185,32,242,236,118,235,189,116,186,101,
84,227,98,14,69,38,155,180,192,245,135,198,199,1,112,198,151,125,23,24,90,223,
205,6,183,173,74,176,38,155,28,96,173,196,139,142,105,243,159,8,11,128,70,55,
102,83,182,249,178,135,178,45,11,178,141,59,71,227,126,209,248,150,210,237,52,
24,187,171,109,62,214,216,17,117,41,150,73,2,130,228,23,57,147,249,70,2,228,
236,54,243,31,16,113,151,20,113,37,198,157,123,174,107,55,26,149,198,155,18,69,
104,247,24,115,26,41,200,7,35,197,191,82,217,39,207,53,46,61,227,238,43,227,173,
100,106,124,85,171,203,127,42,2,177,38,2,71,10,231,162,34,224,15,175,83,141,201,
161,41,82,139,96,19,180,142,39,187,227,62,50,212,248,162,242,40,225,158,254,115,
33,142,63,149,20,0,21,125,240,160,12,249,226,181,248,100,112,113,154,231,48,
116,108,28,239,154,204,107,131,154,221,107,161,6,73,220,56,86,59,26,244,239,3,
118,205,193,157,155,118,31,164,88,232,22,118,186,151,24,73,12,134,101,22,229,86,
55,105,92,134,154,76,2,216,4,0,160,147,128,6,64,193,175,47,186,239,68,83,134,
193,243,167,36,178,42,144,186,232,177,226,93,91,82,215,245,123,141,99,88,188,
150,246,250,229,249,230,154,83,150,99,254,128,96,1,228,5,79,67,226,126,38,208,
237,165,182,209,56,139,88,211,33,147,37,227,179,189,146,21,108,245,200,82,1,164,
185,114,148,48,190,44,122,213,184,166,36,192,204,242,75,35,203,43,180,146,59,22,
118,99,146,196,245,36,249,154,134,51,138,40,93,200,174,42,146,42,104,96,185,77,
30,221,121,178,181,133,83,154,61,186,242,200,13,56,170,3,49,166,13,16,38,67,47,
222,139,34,114,200,69,96,12,56,53,163,16,179,199,182,107,3,49,21,113,231,181,51,
201,187,45,68,199,205,110,195,205,78,104,90,2,50,128,231,156,109,204,51,143,122,
1,200,52,96,15,39,184,168,176,205,104,182,132,96,103,25,163,70,196,125,40,104,
50,8,169,160,242,170,64,60,164,75,110,61,87,106,9,92,28,86,45,223,5,144,249,
140,253,235,44,224,128,107,68,236,68,177,202,51,228,105,41,95,12,80,26,52,179,
100,21,7,166,244,156,153,230,13,81,57,125,13,3,98,67,87,10,212,228,79,58,144,92,
174,107,26,29,152,85,200,205,101,147,4,28,84,226,21,55,93,170,168,64,87,194,217,
198,213,7,78,87,35,203,202,139,140,143,165,102,69,202,6,243,93,141,42,29,129,81,
229,235,89,68,222,166,169,154,50,166,249,245,166,144,142,68,155,83,40,55,21,24,
211,6,142,169,90,36,33,155,113,176,167,160,218,146,131,106,110,51,131,90,33,12,
121,134,20,66,118,161,131,229,92,230,218,129,18,93,156,26,112,46,86,147,143,115,
79,65,186,212,54,52,74,53,219,21,202,50,46,213,202,205,140,233,238,106,131,177,
114,17,70,107,142,9,59,26,177,225,251,33,117,169,199,110,206,84,54,249,198,248,
175,17,155,1,1,32,131,117,18,75,208,15,122,148,86,87,13,98,215,35,37,139,242,
242,131,156,230,175,175,180,37,134,250,52,128,179,115,2,48,125,64,207,244,167,
225,183,75,75,84,200,252,192,239,72,44,214,63,6,214,23,145,180,135,44,177,151,
97,232,113,67,180,223,145,207,148,108,244,215,18,92,35,221,202,232,115,152,194,
159,214,147,77,160,147,30,81,42,254,181,174,46,196,205,163,129,90,17,167,93,247,
184,59,164,123,249,2,121,191,168,165,56,154,8,98,134,242,70,230,102,50,42,194,
79,150,217,63,125,232,124,45,114,177,67,36,18,108,179,57,193,247,3,20,94,42,
186,71,212,173,109,67,99,8,175,34,159,34,1,0,254,148,223,64,89,112,162,56,208,
64,12,24,151,45,183,64,64,57,21,14,61,81,253,143,167,78,135,96,121,71,233,92,
225,11,136,237,236,194,130,67,7,254,42,159,34,122,31,211,21,62,47,142,77,75,72,
183,72,10,40,75,133,32,231,96,27,195,191,182,77,15,244,135,179,73,185,191,184,
146,214,59,82,64,142,50,113,131,185,21,8,207,59,162,19,133,27,251,1,86,23,156,
63,125,4,174,36,49,128,131,36,134,255,0,223,165,81,74,236,179,178,169,200,233,
89,187,25,176,105,170,53,11,167,130,6,84,10,187,179,127,144,171,55,209,172,109,
173,140,211,180,178,58,56,110,110,96,20,140,244,34,181,43,115,114,35,45,108,228,
51,158,83,202,119,197,92,221,220,223,220,105,6,217,237,220,49,92,72,205,234,58,
99,222,146,40,216,116,71,146,107,206,244,69,201,31,118,88,1,249,69,53,174,8,
222,8,80,224,97,215,3,215,109,235,90,225,221,98,227,186,145,76,64,146,130,62,
112,113,130,125,125,232,242,106,13,248,128,151,28,206,3,100,111,146,40,72,118,
89,234,182,154,109,241,238,166,182,88,24,46,4,176,140,50,159,167,66,61,171,82,
212,237,37,211,221,149,202,58,126,89,16,228,17,254,95,74,185,181,190,252,116,
247,110,164,148,89,57,87,30,152,172,148,19,90,200,146,5,44,55,1,183,233,211,106,
124,157,236,77,35,84,103,14,54,109,143,90,98,209,81,160,42,71,77,141,61,123,164,
71,45,191,227,45,199,116,74,229,162,242,251,122,125,41,22,138,75,70,84,157,26,
34,235,149,39,161,30,160,249,208,152,142,65,113,61,147,183,115,33,1,134,8,29,
13,31,78,186,156,9,100,238,196,145,116,96,125,233,91,134,82,135,27,154,111,135,
108,225,187,252,64,145,221,88,40,43,202,216,167,239,66,26,179,182,153,212,207,
105,40,183,39,242,131,159,222,163,60,247,252,192,205,20,37,212,120,95,117,206,
61,198,212,234,192,214,153,28,204,201,235,158,148,194,21,40,121,128,42,119,192,
25,162,134,71,77,187,212,102,228,194,36,107,145,146,205,205,131,237,138,122,72,
47,46,230,145,150,246,14,189,68,39,255,0,250,161,90,66,96,145,30,28,96,176,200,
61,13,74,57,144,185,42,198,25,73,63,67,90,47,220,150,37,121,99,44,147,164,119,
252,141,10,191,48,150,49,130,135,239,229,86,83,0,34,120,227,99,202,23,3,108,28,
80,110,47,22,55,16,92,180,104,178,2,12,142,71,47,79,127,58,197,159,114,33,88,
227,186,89,182,249,185,193,36,122,237,77,118,35,84,137,148,29,250,140,131,86,
218,110,162,182,209,242,146,9,97,129,158,128,213,100,145,247,122,156,240,182,6,
28,253,179,92,49,152,89,84,184,36,29,177,89,166,208,217,125,197,163,186,189,
181,149,102,50,45,196,60,229,70,0,216,145,143,218,168,48,12,173,146,188,135,60,
160,158,162,158,207,227,10,194,167,154,117,82,209,169,223,159,213,126,187,100,
125,13,36,131,189,61,199,50,163,59,110,79,229,167,39,108,147,108,225,105,217,
237,102,183,182,154,100,33,75,71,24,201,97,145,215,35,223,52,142,181,111,18,126,
26,117,105,88,203,204,31,156,254,96,125,63,47,210,171,120,110,226,242,218,253,
100,177,7,188,229,100,62,224,111,157,250,123,85,230,183,8,77,15,79,159,189,105,
36,158,73,39,151,39,163,28,115,15,168,53,81,118,131,217,64,237,52,109,204,146,
242,145,208,26,125,245,53,188,176,75,27,139,113,28,136,252,209,200,167,108,250,
99,203,52,168,117,149,3,1,183,158,70,199,222,176,45,220,146,35,25,243,27,238,
167,218,173,223,104,104,182,213,109,222,235,66,142,89,16,139,155,77,137,35,230,
67,208,253,186,82,23,81,45,206,159,22,163,24,229,146,60,69,115,203,229,252,175,
247,233,245,169,88,106,183,22,147,49,148,173,218,58,242,58,59,144,113,230,7,149,
27,78,154,31,196,150,182,136,180,51,2,178,219,177,223,151,204,127,157,55,43,98,
170,42,30,57,33,149,196,132,16,216,101,97,209,133,57,106,170,234,8,35,35,173,61,
115,166,31,226,89,51,103,43,207,111,33,252,195,200,255,0,145,251,26,168,128,72,
140,67,2,146,35,114,176,61,65,165,250,88,39,97,175,45,148,200,91,215,173,84,76,
134,57,14,58,85,233,61,234,28,141,233,43,184,8,82,213,77,95,67,178,58,38,165,
121,164,234,214,122,174,159,49,134,242,206,100,158,9,0,207,43,169,5,78,15,93,
197,99,84,185,75,221,78,238,238,43,104,237,99,158,103,149,96,143,229,136,51,18,
20,123,12,226,146,66,51,143,218,138,42,81,68,163,124,18,15,165,72,96,231,220,
80,136,222,178,173,131,189,93,136,60,7,194,69,6,109,164,218,137,31,83,88,153,9,
193,160,12,70,231,167,168,166,173,164,12,184,39,113,74,70,167,59,142,134,139,26,
97,246,166,128,116,239,82,198,64,165,57,153,78,41,136,101,200,193,173,19,16,
120,152,174,212,84,1,250,117,160,245,172,161,40,217,21,162,100,180,77,147,150,
78,158,117,128,152,114,40,196,135,195,123,81,10,140,131,143,42,170,0,38,62,134,
166,145,144,51,69,0,26,44,107,149,97,237,69,80,25,149,121,163,71,246,193,161,17,
71,139,197,110,235,230,167,34,134,203,177,250,213,80,17,109,164,7,212,84,71,
133,136,61,14,213,54,4,162,159,67,92,157,72,57,31,90,124,68,6,33,226,35,29,107,
18,38,42,64,16,115,70,149,51,191,145,25,171,72,5,98,30,58,144,219,236,113,82,
229,229,152,123,215,46,7,43,56,3,222,133,161,28,249,89,95,208,208,102,124,51,34,
250,245,168,135,46,55,174,58,147,202,222,216,164,216,200,40,43,39,43,125,40,156,
153,21,201,119,10,216,223,24,52,101,25,92,250,138,148,0,130,230,63,113,81,65,
212,81,151,108,138,137,24,106,96,65,5,16,238,181,140,96,212,208,100,226,154,0,
64,111,245,169,198,185,98,167,243,12,86,74,239,68,11,156,26,116,32,105,31,149,
26,52,219,20,78,64,91,155,212,102,166,23,2,157,1,132,94,148,85,27,86,7,74,200,
109,233,128,104,198,40,234,112,41,101,97,68,71,200,35,218,157,138,134,195,108,
43,10,222,45,232,17,62,69,23,59,230,166,192,98,19,227,197,63,110,119,170,216,
207,136,26,126,220,210,99,31,65,181,114,184,135,34,185,80,7,78,114,138,182,208,
185,150,242,11,168,206,241,120,72,199,150,106,153,155,109,169,238,28,145,219,82,
72,121,176,140,195,63,173,120,198,172,222,117,67,207,127,106,168,193,88,43,178,
253,113,255,0,108,86,185,197,26,128,100,70,129,219,45,140,169,252,164,117,24,
171,173,73,133,195,199,58,55,43,65,190,127,168,173,35,90,144,61,227,178,159,11,
238,55,243,164,197,23,96,31,157,224,82,204,75,72,255,0,210,172,103,85,138,217,
178,119,46,7,232,41,72,215,154,107,120,135,150,63,173,55,120,191,193,230,252,
199,152,143,233,85,23,73,148,198,180,168,65,142,208,48,207,59,2,71,212,209,110,
44,198,161,199,194,201,178,81,185,121,190,128,100,211,48,192,44,238,224,114,
223,195,88,86,95,166,23,113,76,112,74,254,47,136,111,53,41,49,206,168,112,63,
243,109,253,5,52,175,66,57,0,73,184,138,253,128,196,80,197,200,192,126,99,229,
154,102,210,226,33,205,101,63,39,32,82,0,254,101,62,191,235,85,92,65,111,61,132,
211,222,219,76,203,222,54,100,95,90,166,146,255,0,191,136,43,243,35,143,204,42,
174,128,191,191,153,92,92,69,222,146,161,0,140,231,115,143,42,210,238,148,37,
233,30,167,52,237,189,195,119,140,37,98,202,199,207,202,146,191,200,187,62,46,
110,152,53,13,216,210,39,107,152,47,97,98,124,60,224,159,214,183,75,167,141,173,
38,149,136,229,88,203,117,173,42,236,146,168,202,15,76,213,254,159,112,47,116,
151,183,102,193,100,43,247,199,90,150,82,51,195,112,56,183,149,74,225,166,85,
154,49,235,131,184,250,226,151,147,248,183,179,58,236,202,78,7,66,48,42,227,67,
128,207,195,241,201,40,117,49,62,17,208,248,145,128,193,170,119,73,222,226,250,
47,21,193,200,60,195,1,213,177,177,170,76,98,22,68,136,196,145,73,201,33,57,57,
232,198,142,215,247,19,198,25,85,81,142,114,194,133,165,198,12,18,164,158,6,80,
24,6,243,30,127,210,135,4,114,11,48,227,56,220,244,242,205,67,17,178,232,18,
254,55,75,254,33,5,249,176,78,41,171,13,58,27,153,164,180,212,49,60,16,167,119,
26,147,184,7,161,30,159,90,213,172,47,110,52,201,8,141,84,244,200,61,8,245,173,
155,71,212,173,238,228,15,46,35,184,229,199,93,136,244,20,116,29,148,220,73,194,
243,233,209,155,155,73,12,246,196,245,243,95,99,74,240,179,247,119,253,215,35,
22,112,71,92,86,241,223,115,71,44,18,242,182,87,117,39,0,131,72,233,92,63,167,
221,91,52,175,52,145,203,156,172,137,143,13,90,219,19,66,139,204,202,200,209,
227,39,4,29,200,164,94,126,226,99,22,219,15,8,30,98,141,126,46,244,237,64,91,
221,58,185,198,82,85,252,235,235,73,206,63,19,121,190,84,34,248,88,122,159,42,
166,33,251,105,216,220,71,202,114,51,146,8,169,55,44,132,21,25,59,249,82,182,
209,20,184,136,28,244,39,235,177,163,69,149,228,61,79,149,8,24,188,241,200,242,
191,50,247,145,170,228,169,27,82,19,219,216,172,101,241,220,50,111,225,28,172,
62,132,86,193,109,136,149,250,145,203,147,183,189,82,107,184,146,233,81,64,229,
140,100,251,154,24,138,200,249,153,201,118,103,108,245,99,146,105,159,196,152,
165,11,32,239,23,30,84,21,216,145,212,154,59,64,203,31,49,92,226,132,5,134,129,
111,22,163,114,64,144,71,116,36,239,33,201,199,48,244,250,142,180,238,191,165,
37,174,168,178,74,143,12,23,168,57,200,25,49,184,192,113,250,239,244,34,171,
116,231,137,109,213,21,66,92,3,149,114,60,171,125,177,143,253,229,224,225,16,97,
45,253,164,160,250,30,96,48,65,246,43,211,233,87,21,104,206,78,157,154,92,250,
69,198,155,222,56,104,228,84,37,75,116,200,35,32,254,148,246,189,109,35,105,
246,183,42,29,226,66,63,18,131,112,164,129,226,250,29,179,244,167,117,104,102,
254,200,49,78,12,103,145,7,139,203,7,21,205,50,237,238,35,154,202,72,204,100,
161,89,153,155,194,6,48,64,30,121,56,34,154,74,232,108,215,79,202,13,14,73,249,
79,32,62,91,209,102,141,225,45,12,163,149,227,98,172,62,149,14,30,176,146,255,
0,81,105,153,73,130,31,27,251,250,10,166,223,72,160,45,107,36,159,196,127,8,
61,7,159,214,133,60,19,33,18,35,100,174,224,138,184,155,18,75,50,183,134,69,
109,199,166,122,125,169,103,70,25,4,100,86,115,136,38,114,215,94,149,224,16,93,
0,230,35,205,19,0,21,163,111,182,196,31,49,86,215,246,43,169,89,199,169,216,
169,239,14,59,197,193,28,216,30,94,254,158,181,170,221,91,22,184,86,77,137,56,
171,91,43,203,205,33,113,12,145,179,99,117,201,199,208,138,113,155,255,0,80,154,
250,39,10,248,75,1,88,189,10,209,242,141,179,214,155,210,211,251,70,25,110,34,
153,77,200,241,205,9,94,92,250,178,250,208,174,161,97,39,41,24,243,173,34,244,5,
20,240,114,144,194,178,35,44,153,95,46,181,120,246,203,37,171,170,128,91,233,
85,5,24,116,161,199,137,86,45,131,154,192,67,231,77,172,36,130,64,205,69,64,59,
80,4,16,96,138,96,47,50,125,42,33,40,240,141,136,170,72,64,149,55,162,132,5,
179,68,11,82,9,181,82,136,3,184,135,14,14,58,140,212,99,136,171,85,132,169,155,
120,223,29,54,161,170,140,131,90,113,16,16,8,162,40,6,166,203,81,3,122,105,80,4,
69,42,51,229,76,168,202,10,132,0,50,226,142,35,61,217,32,116,53,170,68,131,220,
29,168,138,74,183,210,162,69,25,147,117,62,76,180,232,9,91,46,46,26,51,209,129,
21,153,98,56,220,121,81,121,55,130,96,62,97,131,245,20,213,196,89,80,71,76,211,
72,10,216,211,49,50,250,111,89,146,34,209,169,246,197,51,4,95,198,3,200,237,71,
72,15,35,41,31,43,85,129,88,98,32,3,69,229,6,221,27,29,50,41,227,111,205,17,0,
80,4,76,33,117,199,161,166,33,43,168,177,200,227,165,102,120,129,8,248,234,49,
78,75,23,61,153,219,116,53,21,94,107,81,254,19,67,64,84,164,88,36,123,209,90,
47,225,29,186,28,209,196,121,118,31,122,98,40,121,143,41,232,195,21,41,1,86,99,
202,212,162,27,98,155,238,176,74,145,237,66,238,240,212,80,2,43,131,92,117,218,
154,49,102,54,24,220,110,42,2,60,143,181,58,0,28,185,25,169,162,239,69,11,225,
197,67,96,122,208,144,28,100,222,165,26,249,84,182,245,174,100,3,76,9,168,202,
227,211,122,207,149,64,62,14,69,96,159,22,51,74,192,200,109,136,172,19,88,27,61,
112,84,128,69,52,68,21,4,20,64,48,65,245,166,4,227,60,173,189,28,17,203,66,192,
35,62,117,156,156,98,152,12,66,217,222,159,183,109,133,86,65,179,96,211,246,
199,165,67,96,90,64,222,26,229,66,19,181,114,166,192,233,182,219,106,99,71,151,
240,215,145,220,31,148,54,244,12,115,100,83,154,124,43,48,145,8,232,132,143,106,
241,205,75,221,102,238,56,236,36,120,78,243,116,199,191,90,213,219,248,179,32,4,
99,53,99,173,163,65,4,17,243,18,188,155,125,106,190,221,71,122,8,168,125,132,
80,229,152,255,0,143,242,60,163,63,181,79,80,144,47,114,157,78,1,168,90,145,31,
125,33,235,202,71,235,66,186,70,154,249,81,126,108,0,5,95,250,70,95,221,204,71,
15,89,200,204,57,228,70,3,233,154,143,9,205,248,93,112,43,127,226,161,143,57,
198,9,220,85,102,177,33,94,238,217,15,130,4,8,7,191,83,251,209,102,158,52,176,
181,190,136,129,52,46,18,69,243,35,168,63,214,157,236,13,167,95,85,26,116,138,
192,18,24,19,244,205,105,55,246,165,39,38,62,94,83,190,61,43,115,121,150,233,19,
46,10,186,100,251,131,255,0,122,213,53,190,107,121,121,72,220,108,77,92,186,
177,34,175,33,73,14,66,145,214,135,59,36,183,64,161,202,237,189,21,194,204,160,
183,235,75,178,152,102,254,149,145,68,166,150,84,96,50,49,229,154,103,72,186,48,
221,229,246,70,27,227,166,105,87,152,9,66,200,153,79,35,230,41,235,100,138,72,
200,43,204,167,163,41,193,166,246,8,220,225,182,132,105,129,215,158,41,31,45,
222,33,35,245,29,13,80,7,17,95,202,211,175,43,20,1,153,70,67,96,236,125,188,234,
196,223,53,165,130,219,72,89,163,69,1,88,141,192,62,191,235,85,13,59,162,93,94,
32,230,240,247,104,125,60,191,169,164,138,42,229,152,32,159,148,6,89,20,136,
207,209,143,79,177,167,167,141,86,214,208,68,237,202,199,13,147,177,240,230,150,
107,100,81,110,132,150,71,125,136,234,164,141,255,0,125,232,238,134,9,32,177,
158,101,104,26,64,226,69,24,104,253,189,178,104,16,213,229,136,113,28,201,128,
161,130,184,199,64,216,31,215,20,172,214,239,1,14,187,114,146,142,15,229,53,109,
107,34,14,123,27,233,132,110,170,64,144,182,57,212,244,96,125,105,13,86,43,248,
99,184,158,222,242,59,216,165,24,144,174,57,151,208,237,73,13,161,127,198,23,
150,17,123,36,172,138,125,122,253,235,113,176,213,45,228,183,38,62,68,101,27,41,
234,107,92,184,75,73,172,236,39,35,150,7,31,196,56,249,78,49,191,223,53,9,108,
228,130,54,49,134,100,43,177,27,131,239,77,8,191,47,14,165,114,26,120,185,132,0,
248,51,182,254,244,11,205,42,202,69,255,0,246,124,237,5,199,83,28,141,224,111,
161,242,170,141,23,85,123,86,17,114,44,145,200,185,193,216,143,106,119,241,9,
125,114,202,153,140,174,49,147,214,170,218,23,103,46,33,187,177,152,69,168,66,
209,183,38,99,115,184,59,121,26,205,163,243,50,100,111,86,214,55,147,198,13,181,
202,37,204,5,78,99,144,100,127,219,235,74,234,90,108,9,115,12,250,120,100,137,
207,138,54,108,242,55,160,245,21,73,166,42,50,6,205,142,188,191,173,80,106,35,
55,108,122,100,111,250,85,245,167,122,166,78,244,30,94,79,79,122,170,212,34,6,
231,155,152,16,79,90,108,69,26,12,185,246,52,247,54,49,157,193,20,147,158,238,
82,8,216,157,141,57,3,242,8,228,7,60,166,132,1,237,38,138,34,82,116,45,12,159,
54,58,169,242,34,172,99,252,94,139,118,183,22,151,79,26,72,1,73,84,248,72,235,
189,115,85,177,182,107,88,238,173,0,195,15,18,143,235,75,217,234,175,109,105,
248,73,173,227,186,182,206,121,31,170,250,224,249,85,117,217,61,155,63,20,188,
154,165,181,181,231,56,70,143,148,220,162,46,85,255,0,251,131,219,214,145,225,
238,235,82,185,188,239,57,19,154,85,231,255,0,10,175,76,123,147,251,80,180,91,
232,205,194,218,90,220,46,255,0,220,25,70,193,79,84,111,113,251,209,33,176,254,
203,226,139,91,137,85,22,214,102,110,78,83,149,15,233,159,233,90,45,187,39,173,
21,90,240,45,127,122,224,13,229,122,179,225,132,16,112,163,204,49,205,60,164,
147,236,54,31,210,148,190,132,254,46,234,41,65,230,18,183,95,173,59,164,58,167,
10,199,17,59,171,178,237,185,216,154,117,242,177,183,162,143,89,126,234,104,
238,57,124,64,242,157,254,96,119,222,161,107,122,178,72,177,21,199,57,216,231,
106,15,16,92,172,129,35,92,140,49,36,17,131,72,194,178,200,188,241,63,33,140,
140,28,103,53,140,229,82,209,73,104,185,190,128,194,157,246,49,131,225,250,208,
116,251,51,116,26,105,92,132,230,192,30,109,239,86,28,74,147,127,101,217,78,252,
152,112,73,9,211,56,27,211,210,68,182,214,246,182,192,0,82,21,45,245,59,159,235,
87,195,228,43,208,11,91,15,194,220,199,119,105,225,116,232,9,216,212,245,140,
30,89,214,48,155,110,160,231,20,237,145,4,180,109,230,50,42,58,132,92,214,252,
164,122,138,215,143,208,172,169,70,43,134,94,152,164,230,69,55,12,71,66,115,69,
71,228,5,27,168,245,161,33,36,150,61,15,74,87,232,162,194,192,219,168,49,186,
141,252,234,175,86,179,252,59,247,208,159,1,59,138,63,54,195,52,66,123,216,138,
190,248,254,149,110,164,168,69,124,78,174,129,186,26,97,19,27,138,24,131,9,36,
96,110,55,31,74,28,51,72,131,7,127,173,76,93,118,49,172,122,212,129,219,233,81,
138,65,38,212,83,19,14,149,170,216,134,32,60,246,110,190,106,115,64,230,29,40,
218,120,60,238,135,243,45,5,208,137,8,173,40,70,73,205,68,117,172,47,90,200,59,
212,140,106,13,136,167,34,35,12,190,162,147,135,116,7,204,28,83,8,112,84,251,
214,171,162,89,194,9,223,20,204,107,205,104,143,230,143,131,247,161,170,231,153,
127,74,98,196,115,71,52,71,243,47,48,250,138,164,32,209,40,54,178,71,231,27,134,
31,67,214,155,68,231,131,233,131,75,194,48,224,249,58,242,154,176,177,78,104,
129,244,216,213,85,5,139,199,111,203,40,219,161,167,36,183,195,156,15,152,102,
155,183,131,188,80,196,110,187,26,109,225,1,20,176,233,253,42,92,168,4,45,108,
198,65,35,111,58,133,205,138,172,164,99,30,85,113,16,68,132,188,133,81,20,101,
152,156,0,41,107,125,67,76,213,38,197,149,212,115,48,217,148,28,29,188,240,122,
138,143,200,147,29,20,113,89,16,94,63,231,82,62,244,140,16,30,87,67,91,125,197,
152,140,135,198,48,115,84,179,192,35,188,144,14,153,205,106,166,152,138,53,139,
150,228,109,212,83,98,18,167,32,116,63,181,18,225,10,92,163,99,108,226,154,17,
149,144,171,244,32,175,250,80,158,192,171,190,139,146,96,227,163,140,210,178,
168,4,31,90,178,187,136,201,106,14,119,141,191,99,74,8,121,161,35,204,111,67,0,
81,200,185,83,203,159,35,67,151,33,176,54,193,163,199,22,85,177,243,13,234,51,
46,112,216,242,197,27,1,82,167,152,131,80,100,197,29,129,205,65,253,234,64,135,
149,99,53,158,185,21,128,40,176,56,43,61,72,53,204,86,71,165,32,50,71,136,26,
159,41,235,92,29,40,168,50,41,129,196,93,134,212,64,50,62,149,152,199,134,164,
51,154,116,4,23,56,172,169,244,169,42,156,239,138,146,161,230,197,0,78,37,201,
7,237,78,219,245,160,195,31,80,105,152,150,161,128,228,39,2,185,92,143,166,43,
149,32,117,8,171,77,14,221,166,157,144,15,153,8,207,165,86,68,57,155,21,127,164,
55,225,227,105,115,141,177,154,242,77,36,35,196,4,39,117,22,114,80,16,115,84,
241,73,200,249,3,56,29,41,173,98,231,190,185,102,29,41,24,199,86,53,15,178,162,
180,61,11,30,231,45,213,156,10,231,120,203,115,37,192,56,33,176,159,95,251,84,
99,111,28,73,228,55,161,73,32,105,6,62,81,255,0,179,77,244,51,55,114,18,60,68,
150,59,228,154,12,146,43,70,171,146,42,82,57,149,206,126,95,33,76,65,7,53,198,
99,42,188,139,150,13,208,226,128,25,210,111,166,41,8,142,76,152,252,24,62,99,
57,20,214,180,69,199,56,97,134,42,24,15,48,122,26,15,14,11,89,167,158,214,104,
251,183,148,18,132,126,95,76,86,53,37,157,57,22,95,12,177,146,162,65,209,199,
189,82,232,69,85,187,96,148,53,155,176,15,33,161,73,224,159,56,193,206,226,141,
62,10,41,244,164,134,38,8,121,57,9,220,19,138,103,79,153,225,112,51,149,45,184,
164,88,30,114,65,198,41,187,69,50,52,123,120,129,164,128,217,154,250,43,155,147,
17,198,240,242,224,250,212,52,133,73,116,123,139,121,0,13,31,129,148,143,83,
214,168,101,145,150,115,34,28,48,109,170,202,91,183,145,214,234,32,22,67,128,83,
249,194,141,197,57,13,50,15,28,145,199,18,57,57,73,24,169,245,229,27,80,239,231,
87,239,89,15,36,132,0,209,176,249,128,59,17,238,40,197,154,254,6,228,110,78,67,
204,158,221,77,5,123,139,200,204,23,0,197,58,116,255,0,50,42,93,33,150,250,69,
237,156,232,137,45,186,16,171,150,70,94,96,167,239,210,154,184,107,21,189,138,
27,40,35,19,73,146,220,139,142,85,199,158,60,171,83,180,186,107,57,36,124,179,
156,98,51,235,233,159,106,108,182,165,108,127,16,183,48,171,76,112,74,174,113,
237,244,167,208,172,106,245,101,183,185,138,193,110,159,184,184,99,149,192,5,65,
59,140,213,245,156,154,109,189,146,195,20,226,85,140,96,96,243,17,247,173,121,
237,46,111,94,222,59,203,184,213,6,112,234,187,231,174,42,223,67,133,197,137,75,
57,154,55,70,49,200,172,161,147,35,207,215,127,173,22,0,87,74,138,69,18,149,
100,145,139,16,14,196,46,118,253,169,73,236,230,130,66,203,157,188,243,189,90,
219,93,94,71,43,71,115,20,83,34,191,41,145,27,5,79,94,135,202,140,110,173,166,
202,225,183,242,197,1,69,93,158,169,60,15,203,33,18,236,112,27,99,250,211,175,
172,91,78,96,136,7,138,99,32,199,50,244,172,203,97,19,161,96,70,72,232,42,186,
91,66,151,17,134,4,16,195,6,154,19,179,98,134,246,56,145,210,112,38,136,161,
219,62,33,244,164,228,211,34,191,113,37,140,166,67,212,66,231,15,246,245,170,
120,238,238,45,165,110,101,239,34,101,57,199,81,77,89,92,230,85,146,38,200,3,32,
131,85,97,217,81,170,64,240,93,75,20,177,178,16,113,134,4,17,64,183,126,69,32,
157,189,43,109,226,109,86,93,78,194,72,110,226,89,174,33,35,185,155,163,145,252,
164,249,213,26,232,119,50,66,36,182,104,231,124,101,145,15,136,125,143,95,181,
29,116,33,157,2,254,24,164,48,204,8,86,82,3,19,144,180,206,185,100,130,7,186,
135,99,25,5,215,213,79,159,235,84,16,225,37,100,148,16,121,72,57,242,52,237,134,
166,208,226,57,36,50,192,84,163,33,63,148,250,85,41,234,152,168,103,65,183,138,
238,241,237,124,228,221,51,228,113,91,143,12,217,69,127,31,246,93,214,114,231,5,
88,248,146,81,209,135,214,180,137,140,48,92,172,182,82,19,24,32,161,243,95,106,
216,13,236,183,112,165,253,187,145,117,1,86,144,46,220,224,121,253,69,105,141,
170,34,105,176,220,65,105,45,166,166,45,175,19,150,229,15,118,237,141,156,126,
86,251,138,130,69,220,218,152,149,0,94,98,199,3,204,213,135,26,106,103,87,209,
109,239,100,140,126,34,25,68,50,56,62,37,110,163,62,163,253,105,61,50,116,154,
16,75,6,96,48,71,158,107,79,116,74,186,217,174,241,108,32,90,219,203,141,195,
176,39,219,2,171,244,55,2,229,17,135,132,236,107,96,226,216,214,77,36,178,131,
148,112,79,239,90,181,131,242,220,70,69,99,145,84,205,35,180,110,58,140,66,94,
31,183,64,51,221,92,242,31,167,149,71,84,99,248,233,24,126,82,23,244,24,167,
244,168,197,228,51,219,19,243,114,74,191,81,73,106,105,139,233,151,212,230,186,
56,234,204,204,195,41,49,44,203,213,118,52,241,154,41,172,242,222,22,205,85,89,
191,47,240,207,70,216,209,98,7,185,154,47,53,193,253,233,161,128,190,180,70,230,
97,215,214,171,37,137,225,132,100,108,31,250,138,188,143,248,139,159,177,168,
222,219,135,178,144,1,226,24,97,246,161,194,246,52,202,88,200,97,245,169,41,42,
224,253,141,100,69,209,147,211,165,16,161,97,204,60,250,212,12,42,170,173,212,
92,221,28,99,62,185,165,174,109,128,44,87,200,211,111,27,27,56,159,27,198,228,
103,247,169,74,132,74,199,201,183,253,107,68,172,10,200,212,171,85,148,4,58,96,
245,160,8,114,73,3,165,22,49,131,145,181,105,5,66,97,32,94,238,233,9,233,156,26,
141,220,124,179,159,173,23,156,28,100,81,175,209,88,7,30,99,53,165,8,172,101,
193,53,131,214,167,54,212,18,119,168,99,24,129,177,183,145,166,211,166,106,190,
54,1,186,211,176,74,167,174,125,168,82,162,88,244,67,198,15,182,104,150,217,
142,228,31,67,131,75,67,115,186,16,187,29,142,104,138,238,211,46,224,18,55,171,
230,34,210,24,255,0,134,127,194,213,111,164,219,150,47,30,1,207,79,235,85,90,
104,47,207,27,49,44,87,35,237,87,90,36,232,151,40,196,103,166,106,156,173,1,103,
167,90,49,185,49,227,105,6,71,214,174,109,180,137,46,85,80,46,253,41,205,62,8,
164,117,229,223,149,182,250,26,223,184,111,76,140,184,114,163,197,189,113,231,
206,160,172,184,71,147,58,163,136,244,237,47,72,49,127,188,81,171,88,92,197,34,
42,177,56,73,50,188,174,84,110,112,57,177,232,113,154,212,181,46,26,225,139,
217,47,207,12,137,69,212,22,230,234,11,152,110,220,32,97,184,141,85,243,205,157,
246,7,108,122,87,167,117,78,1,177,215,248,131,75,107,235,104,238,173,18,218,81,
36,14,62,108,50,145,130,55,7,4,254,149,142,32,236,167,135,52,187,203,25,116,
173,42,27,88,187,232,210,66,24,183,63,51,1,141,253,6,107,230,231,252,77,185,189,
51,209,94,60,105,108,243,7,8,241,93,190,187,106,150,119,142,34,191,81,203,134,
216,75,238,61,253,169,235,168,26,59,165,45,209,135,253,168,191,17,92,35,160,240,
103,20,67,121,163,60,214,215,55,206,100,72,6,57,80,41,241,21,199,65,156,99,53,
89,166,107,63,218,154,66,73,40,205,212,35,149,207,243,123,215,187,226,121,75,
44,83,56,178,67,139,163,58,132,65,80,31,48,113,69,113,205,18,75,212,48,222,133,
60,134,107,102,39,203,21,43,39,230,178,100,39,60,167,34,189,104,237,24,131,104,
199,52,145,249,48,34,146,182,141,187,206,86,24,206,198,172,213,114,188,222,98,
129,42,129,57,35,161,222,181,162,108,68,198,33,184,241,116,206,255,0,74,4,241,
242,177,92,244,53,103,123,24,96,28,14,162,145,152,231,175,144,164,208,196,156,
10,12,131,106,102,81,231,65,113,176,172,216,192,14,189,42,96,86,66,239,68,10,
115,181,72,3,34,176,22,142,18,166,177,138,40,1,42,237,210,141,26,31,58,200,0,28,
86,65,197,58,2,72,0,53,156,122,109,81,13,134,233,89,47,78,192,151,230,250,211,
10,132,128,104,17,12,138,122,5,202,226,165,176,36,139,225,86,244,166,35,90,132,
107,128,65,163,34,212,140,154,174,213,202,39,65,92,162,128,234,123,104,48,219,
83,87,174,241,192,33,27,99,115,69,179,229,81,205,183,48,216,10,5,226,31,17,99,
245,175,25,149,236,168,189,82,156,167,111,24,205,1,24,150,0,84,238,50,196,142,
184,168,68,49,151,61,5,65,162,28,141,149,121,178,50,248,216,250,15,254,105,104,
247,62,187,86,35,149,155,188,126,95,203,143,165,78,30,96,132,168,80,78,217,38,
168,14,66,140,204,15,65,154,58,44,161,152,42,243,115,26,46,156,174,243,5,145,
227,34,175,116,205,52,51,172,146,58,32,57,229,13,249,141,47,64,84,61,172,209,60,
101,51,222,32,45,204,190,84,212,179,165,228,70,25,70,29,211,255,0,80,171,37,150,
9,244,249,90,51,144,147,114,231,204,169,218,146,189,128,46,139,21,244,0,52,
138,192,185,3,245,21,75,161,26,213,222,64,229,97,135,70,193,169,35,115,66,77,49,
173,170,58,45,202,116,110,180,165,191,247,31,122,75,177,139,129,149,59,117,53,
105,162,197,205,118,131,252,36,210,65,57,113,159,76,213,182,137,255,0,213,54,
224,98,34,55,167,21,176,18,104,131,72,84,108,197,137,30,245,201,203,42,198,135,
194,65,36,123,26,109,226,45,58,224,96,160,235,65,214,51,136,201,66,25,84,80,193,
17,137,148,44,114,44,175,26,185,196,133,79,67,254,149,61,74,46,238,17,39,124,
210,48,56,92,252,192,250,131,231,244,160,233,168,173,222,66,219,171,142,158,245,
27,161,44,82,197,20,135,153,99,37,148,250,129,83,29,186,41,244,70,37,156,44,
119,18,71,207,12,100,13,136,200,0,244,171,132,137,46,45,130,4,104,242,114,55,
200,207,173,85,201,114,139,116,10,17,221,200,0,96,70,63,95,245,169,195,116,32,
231,136,56,88,217,206,195,124,12,14,159,90,29,177,34,193,164,9,7,59,168,38,9,0,
124,14,163,214,172,52,75,131,4,19,92,204,127,189,241,184,199,65,229,143,93,170,
174,73,150,120,68,86,246,114,99,148,140,183,132,111,78,105,74,38,211,123,185,72,
37,65,141,193,62,148,134,50,136,39,134,91,137,95,149,131,150,68,206,192,227,
169,245,165,109,0,121,76,138,222,18,217,82,122,125,41,54,13,27,92,89,220,23,145,
147,196,156,205,183,41,192,207,254,253,42,194,119,142,59,98,176,140,8,148,0,49,
140,98,169,128,236,83,58,200,20,17,215,25,52,228,171,28,178,198,204,0,44,213,87,
4,235,35,230,60,54,125,15,74,124,204,162,94,237,159,151,36,21,39,247,167,16,
101,108,182,236,36,37,112,195,13,140,85,125,170,186,92,49,79,1,229,57,207,67,86,
127,136,229,114,17,123,195,202,219,141,133,47,165,43,220,106,37,110,57,122,31,
10,141,186,117,166,196,45,61,233,239,60,74,79,136,100,141,198,41,142,248,170,
164,144,73,130,55,12,167,165,11,80,182,110,249,138,31,166,105,3,222,194,196,1,
141,250,121,26,44,13,130,27,139,125,66,110,75,248,128,149,148,143,196,32,241,
116,252,195,207,250,213,45,237,146,192,234,33,146,59,132,96,72,41,156,140,122,
138,46,157,116,191,137,140,183,132,231,27,214,38,42,39,229,12,1,201,197,29,138,
132,67,133,37,114,84,131,184,62,85,101,163,234,70,210,228,22,111,3,100,31,190,
212,27,153,4,252,162,233,121,153,70,3,129,226,199,249,208,101,181,16,34,205,28,
201,60,76,112,113,179,41,244,35,252,250,83,77,167,161,52,110,61,205,165,212,134,
4,115,221,76,4,129,129,255,0,196,3,173,75,78,231,105,68,170,1,141,188,12,71,
78,117,216,253,188,255,0,90,213,52,219,239,195,205,130,74,168,57,24,245,173,
215,77,99,37,149,165,204,82,33,143,46,146,109,143,30,73,207,220,26,233,131,82,
51,106,132,245,184,218,77,54,104,241,159,5,104,240,47,43,134,244,106,236,9,87,
189,105,34,108,248,129,21,165,188,65,89,198,58,81,150,59,76,113,54,254,24,148,
11,152,114,126,100,40,106,90,228,69,53,3,232,84,98,170,52,91,174,234,72,92,244,
87,4,253,15,90,216,248,157,0,16,76,58,29,179,91,71,112,33,233,148,76,164,0,194,
155,180,124,205,146,0,230,76,26,1,249,70,106,81,144,49,189,75,116,50,111,25,138,
227,194,48,26,184,210,158,92,149,216,237,65,158,235,196,174,196,0,8,160,75,125,
110,33,147,50,124,175,75,157,5,28,120,185,37,4,108,15,74,152,69,93,252,141,8,
221,64,208,174,36,46,125,21,127,204,208,154,239,3,10,159,245,28,209,201,12,180,
183,10,214,179,39,166,24,127,74,129,10,202,61,64,197,37,101,127,50,202,85,100,9,
206,133,124,35,20,131,222,183,120,196,202,197,143,82,78,244,126,68,130,139,25,
138,198,217,44,20,123,156,80,154,120,243,243,165,85,60,188,205,146,196,253,232,
114,204,170,162,151,230,29,23,70,226,21,7,46,73,30,130,176,215,109,45,184,229,
192,11,181,84,60,160,133,111,230,25,162,91,76,57,25,106,191,51,98,160,178,207,
41,31,56,253,40,93,227,30,172,104,110,249,59,86,20,177,232,43,55,54,20,48,174,
71,157,48,146,30,68,124,254,98,41,36,12,122,154,110,36,205,179,127,133,129,166,
155,29,15,90,190,80,129,190,13,59,19,51,114,184,92,30,106,90,200,12,55,184,162,
91,205,133,42,79,70,174,136,162,75,155,89,30,43,152,164,230,11,226,244,166,149,
140,23,101,121,137,28,219,82,45,135,131,153,78,235,131,76,78,252,200,146,249,
144,50,107,70,169,18,118,23,11,223,2,98,98,122,142,83,245,21,220,124,40,235,42,
70,202,122,215,157,52,43,194,136,55,198,8,97,93,193,192,90,226,42,42,151,7,27,
141,235,202,242,226,218,55,198,232,238,11,157,90,45,21,108,111,100,229,63,196,
49,12,158,165,151,97,250,138,23,17,241,54,153,32,142,218,223,81,182,184,29,242,
72,90,39,14,85,193,241,2,7,234,63,74,165,187,212,172,175,180,183,183,185,72,
229,141,134,232,227,34,186,184,233,182,186,100,218,128,209,162,183,138,226,84,
144,198,89,124,33,185,78,1,198,228,103,21,243,111,197,147,147,250,103,122,156,
106,253,157,87,219,103,108,242,235,250,245,197,142,131,166,69,101,167,192,252,
157,237,212,34,73,174,49,177,45,157,148,19,157,135,167,90,211,52,29,78,222,73,
187,200,109,141,168,151,9,36,97,242,129,143,154,231,124,123,30,158,181,87,171,
139,27,139,21,49,219,31,196,67,26,171,16,118,206,114,196,253,78,255,0,122,75,73,
114,92,169,108,120,124,25,245,205,125,7,139,5,10,138,56,166,220,182,206,197,182,
3,199,27,228,146,48,71,184,174,88,55,43,186,121,16,104,17,78,166,230,57,144,
248,88,2,126,184,222,136,167,150,231,152,13,139,98,189,188,44,231,99,246,141,
204,57,125,65,31,122,4,167,59,250,84,33,144,163,48,243,7,34,133,52,161,67,103,
207,165,116,217,1,36,110,120,241,233,72,74,84,121,214,123,230,36,140,129,65,147,
230,53,14,67,68,36,111,14,64,233,64,220,231,39,244,163,242,146,8,197,65,87,112,
107,54,236,162,8,187,230,138,160,10,201,83,138,137,20,128,38,5,99,127,90,134,
254,181,158,98,7,74,44,9,18,5,71,155,38,160,73,59,86,122,121,80,1,28,237,154,
192,57,192,168,22,36,98,176,153,230,205,22,5,132,11,128,41,219,113,73,219,100,
140,83,208,141,197,72,6,81,131,69,81,81,81,83,81,72,100,188,171,149,141,235,148,
88,29,105,167,169,121,128,172,106,101,70,192,249,111,69,211,188,1,216,245,3,20,
142,167,47,52,164,87,144,250,41,118,86,72,55,56,234,122,86,46,112,177,132,95,33,
146,125,234,82,54,1,35,175,65,67,147,34,48,181,6,132,99,60,176,182,60,246,174,
14,110,69,7,3,38,167,26,131,22,231,3,59,214,57,73,112,7,74,76,7,116,152,174,
158,231,187,180,25,119,24,174,194,179,210,52,235,59,59,57,46,19,191,50,22,138,
103,199,57,201,93,190,157,13,105,90,76,87,17,219,60,208,201,202,91,108,131,191,
210,173,180,13,86,88,237,47,52,249,37,33,219,50,196,236,115,226,27,255,0,149,52,
33,62,238,27,8,238,225,73,57,151,44,170,126,155,173,75,135,37,252,69,165,213,
156,164,97,201,100,250,249,209,53,107,116,146,21,187,141,204,170,228,22,111,99,
231,251,210,22,241,53,173,219,47,49,194,12,169,245,170,90,96,87,106,168,97,141,
161,99,208,236,41,120,151,150,20,245,59,211,156,66,85,230,140,142,188,155,212,
45,96,44,98,7,201,121,141,9,108,98,206,164,57,207,158,194,139,105,33,73,29,151,
7,196,6,61,104,87,13,202,227,39,169,233,92,183,36,33,96,63,54,104,93,128,249,
187,6,87,44,152,201,197,67,85,116,105,70,55,1,64,52,180,50,22,116,86,25,12,212,
123,200,140,151,111,201,208,30,148,251,16,59,107,73,26,220,202,24,198,85,188,62,
245,139,232,165,69,142,89,88,48,77,142,6,14,13,57,98,229,116,201,154,70,202,163,
96,15,65,74,77,118,142,25,59,182,96,70,0,199,90,203,106,86,139,244,45,42,72,99,
88,206,100,229,76,175,182,255,0,210,133,0,101,196,170,164,128,122,143,35,71,
177,37,39,229,149,185,6,10,134,244,53,135,241,92,57,139,44,7,204,84,224,26,187,
217,35,214,215,162,85,2,97,202,8,194,228,117,166,207,61,153,23,48,183,50,185,
254,34,103,175,184,170,185,32,50,67,28,145,124,192,109,147,229,77,105,179,52,
168,0,28,216,216,131,249,77,38,189,161,133,212,238,96,184,72,238,144,144,195,
193,32,3,170,31,251,208,173,175,76,83,21,152,177,86,27,62,50,51,235,244,165,239,
193,138,78,116,92,100,231,30,141,234,40,246,55,81,18,200,48,188,206,72,25,0,15,
106,107,104,3,220,221,218,71,200,233,39,51,2,14,85,170,218,57,45,36,116,150,39,
87,198,9,223,36,126,180,156,17,198,205,202,208,168,89,15,139,97,189,4,36,112,
94,220,181,144,231,128,0,184,242,15,158,131,244,171,138,6,199,223,127,24,59,16,
122,82,250,100,205,29,216,102,247,30,253,13,73,249,211,115,191,168,205,34,100,
33,212,238,48,222,84,54,5,157,209,6,77,192,232,41,25,64,89,228,7,166,105,137,
101,73,25,119,252,171,73,93,147,248,182,32,237,154,76,14,119,72,101,82,49,214,
135,58,24,238,31,7,204,226,178,165,179,214,141,57,230,148,154,40,4,217,221,126,
111,21,99,190,82,50,167,110,134,137,58,231,222,150,49,231,117,235,233,72,69,172,
119,22,82,195,28,55,22,17,142,94,179,68,74,200,71,190,118,63,165,108,60,50,177,
69,20,150,150,247,177,220,69,51,135,84,127,4,145,183,174,15,95,46,134,180,212,
15,143,9,251,81,226,115,206,132,224,16,115,214,181,132,169,146,209,187,91,119,
141,63,58,164,133,75,96,30,66,6,125,42,151,84,210,166,131,80,148,79,45,189,178,
150,37,68,146,111,131,236,50,105,27,189,71,80,182,149,196,23,151,10,190,96,74,
64,164,86,229,229,115,35,179,51,55,82,119,38,182,115,79,68,165,69,156,81,44,72,
127,226,224,127,252,185,245,250,85,173,230,187,20,246,145,195,36,108,225,64,30,
19,131,145,238,107,87,184,184,228,139,57,160,165,233,100,163,242,86,144,85,155,
4,250,192,49,4,131,78,182,132,143,206,204,206,199,245,56,253,168,13,169,94,58,
224,220,8,215,210,53,10,63,106,162,146,236,142,162,151,55,114,177,56,218,179,
150,65,168,143,221,204,67,110,229,201,243,52,83,44,93,195,175,168,12,115,84,239,
35,158,167,122,97,82,78,85,99,208,174,43,59,29,14,11,133,84,216,158,181,19,114,
77,44,201,203,25,53,4,32,74,190,132,81,201,133,13,139,137,21,212,143,35,80,152,
48,119,250,228,87,0,169,200,114,1,246,170,0,49,243,49,206,112,43,51,140,114,
228,249,215,35,203,12,46,230,167,52,42,145,229,206,90,146,2,109,255,0,211,161,7,
161,197,78,205,114,248,36,110,43,150,118,178,77,102,225,87,229,223,38,179,21,
148,162,64,75,99,122,180,152,137,32,1,249,9,233,210,152,9,233,80,150,209,227,98,
65,230,243,218,139,11,229,124,67,6,180,138,251,17,22,80,163,53,40,228,96,172,
163,163,10,204,192,28,122,87,21,51,140,10,190,59,1,157,61,207,120,1,166,140,100,
74,224,3,130,51,64,211,160,121,46,145,70,199,53,125,125,2,164,136,145,108,184,
220,250,215,68,34,218,33,178,22,188,220,139,232,70,13,24,73,255,0,11,131,190,9,
6,163,106,121,83,148,142,134,184,216,49,76,184,232,114,43,103,29,0,198,155,
112,76,27,19,145,145,143,220,127,67,91,87,10,235,11,28,160,9,24,96,244,62,134,
180,155,46,101,87,40,122,16,212,213,143,50,78,29,95,148,103,246,205,112,230,133,
163,72,61,157,215,167,235,193,227,10,100,205,10,242,238,64,198,88,152,172,128,
229,72,59,215,92,219,223,201,3,242,243,31,11,122,214,199,160,234,11,119,125,109,
17,110,96,102,69,96,125,9,25,175,42,120,248,157,42,73,154,127,106,122,70,139,
195,169,107,34,36,17,234,179,70,179,172,9,25,33,35,36,224,187,103,1,178,15,132,
131,93,121,127,58,220,206,47,162,114,221,239,247,153,3,33,188,250,117,21,113,
218,93,234,106,92,79,172,222,36,156,203,37,228,156,172,70,50,6,195,244,3,21,168,
219,73,220,128,196,101,27,168,173,49,92,118,204,228,110,58,53,224,146,218,56,95,
0,141,149,191,200,213,175,121,184,62,117,167,89,74,63,35,128,15,93,171,100,
180,157,94,21,110,114,228,117,98,49,154,245,240,74,246,115,200,177,239,71,56,
111,38,20,27,210,72,82,61,55,160,202,220,174,87,200,110,40,209,184,120,73,59,
224,255,0,90,235,110,201,18,44,67,3,69,45,129,67,56,36,129,235,68,0,16,15,182,
13,102,51,29,232,207,74,202,144,90,134,201,131,247,172,242,144,212,172,3,149,
200,168,21,108,244,172,18,192,86,4,173,78,192,193,207,165,112,102,178,100,53,
142,122,0,230,54,172,17,82,46,49,81,206,119,160,68,79,160,162,66,187,239,80,234,
105,136,87,112,105,12,114,220,116,52,252,96,99,52,156,3,20,228,88,164,3,9,140,
86,122,116,168,161,242,169,26,76,103,58,215,43,27,87,41,1,214,143,32,143,155,
30,117,87,114,222,34,77,26,226,82,88,147,231,72,207,32,109,135,90,241,228,205,
18,5,156,182,43,50,117,199,160,174,68,50,217,162,42,22,99,82,81,136,80,55,32,
39,3,52,118,139,150,94,97,158,90,128,80,172,160,142,155,213,230,137,167,173,
240,43,33,33,64,164,75,116,115,70,185,48,92,219,6,193,130,73,66,191,223,106,176,
226,93,16,45,211,207,19,114,134,63,47,214,134,250,84,122,118,179,13,164,238,90,
222,84,200,108,252,185,219,246,52,214,161,117,45,198,155,47,122,115,60,71,150,
79,95,9,220,254,130,168,17,81,163,76,77,164,182,82,158,99,19,17,143,85,53,95,
51,79,44,237,11,62,26,16,70,125,113,79,235,17,119,23,233,113,14,7,58,100,242,
249,138,6,167,8,38,11,197,35,248,155,48,247,245,170,161,148,247,140,90,114,9,39,
27,100,213,154,149,137,24,141,219,187,24,170,169,15,61,199,174,91,165,88,76,
166,59,121,25,136,5,219,4,255,0,149,11,216,202,219,181,38,76,141,200,93,253,171,
137,33,138,212,123,154,183,178,179,71,36,184,62,245,205,87,79,65,105,9,68,59,
142,108,143,74,73,5,130,211,158,27,139,136,147,148,103,206,131,40,97,117,33,92,
227,114,105,77,56,148,187,44,58,0,105,147,117,142,244,50,243,108,7,92,83,79,64,
30,201,75,105,215,42,217,228,125,243,238,60,168,49,202,194,218,70,9,158,65,138,
37,165,218,165,156,214,236,158,23,201,82,15,67,82,177,137,90,208,54,50,24,156,
254,181,47,161,136,36,15,53,184,101,124,0,133,155,62,103,173,114,41,20,91,8,144,
224,182,238,199,124,83,81,230,210,71,128,110,25,73,76,249,231,202,131,103,18,
199,58,71,54,222,126,198,173,239,100,135,183,81,28,106,6,70,122,15,74,10,6,91,
254,75,118,12,206,9,112,118,0,141,243,246,197,114,250,229,150,70,142,48,54,61,
105,157,46,5,22,243,169,110,86,116,228,15,231,147,215,255,0,126,245,17,116,237,
141,132,100,154,245,227,146,82,162,1,186,21,24,230,250,84,110,161,142,41,121,
138,41,134,76,6,24,249,79,173,43,4,243,91,102,217,220,38,14,217,249,104,183,18,
77,36,37,94,60,22,193,82,14,84,224,250,213,52,253,116,22,68,200,250,122,23,131,
60,175,179,43,110,61,143,214,172,172,71,117,103,10,140,110,161,142,58,147,231,
85,242,21,185,137,227,221,91,208,142,134,154,209,139,61,151,43,0,123,182,229,
111,85,166,158,128,114,98,74,231,152,213,108,237,144,1,234,42,218,225,87,148,
134,56,0,117,170,201,16,18,205,182,49,141,253,104,144,193,220,243,97,10,182,15,
32,53,137,164,99,33,45,190,244,91,152,252,17,227,249,5,46,88,130,70,13,72,5,70,
4,227,53,57,14,78,67,110,5,1,49,212,138,145,39,56,4,239,235,78,192,227,62,70,
8,168,140,127,243,92,32,214,3,1,212,111,233,77,9,132,4,1,239,89,185,78,89,118,
233,128,127,106,14,57,155,32,253,40,210,101,230,246,80,54,251,85,161,19,149,252,
110,167,207,200,213,114,206,203,149,84,36,138,126,232,19,41,62,162,146,44,4,160,
17,130,105,176,23,116,154,70,230,115,81,57,140,99,152,228,250,81,238,156,38,
203,187,30,130,167,12,72,32,105,103,249,20,100,251,159,74,138,216,24,138,0,98,
230,125,189,88,154,11,73,20,126,21,28,228,121,145,64,158,230,89,216,111,133,29,
0,232,43,49,196,88,249,230,165,191,161,153,50,150,108,156,0,41,244,184,141,
161,80,72,200,53,43,93,37,218,62,246,118,17,41,30,16,70,231,237,88,151,79,101,
66,99,220,143,222,169,70,75,98,209,199,42,80,144,124,169,50,231,32,121,3,92,12,
85,132,100,17,131,184,166,36,183,195,115,46,54,242,52,118,7,22,66,49,156,211,
75,134,143,52,176,33,134,8,193,244,166,108,71,241,48,126,80,51,87,17,48,209,
198,34,140,156,14,99,189,98,222,19,117,41,24,240,175,137,143,181,76,229,139,123,
138,127,75,140,45,157,195,227,114,202,191,106,214,49,183,68,140,233,209,168,231,
136,1,134,83,75,52,100,176,207,94,148,205,169,229,184,70,247,197,98,85,193,127,
85,124,254,181,209,196,64,222,34,121,79,168,165,218,44,141,197,89,68,4,145,12,
245,7,99,65,145,57,92,237,77,192,44,82,40,135,230,56,199,149,24,0,6,20,125,235,
49,224,200,196,140,239,138,43,96,39,244,166,162,38,199,116,120,130,199,115,113,
157,226,76,227,215,52,116,185,231,130,50,221,70,212,149,133,193,128,184,32,20,
145,121,88,83,102,223,16,146,140,25,122,131,93,16,235,68,176,232,195,36,131,214,
179,255,0,140,87,249,212,138,90,38,43,144,104,232,114,209,55,163,86,157,129,13,
53,207,226,57,27,163,2,180,72,159,187,39,155,200,239,92,238,140,115,146,163,
229,108,212,174,147,248,207,182,205,226,21,205,146,22,138,76,122,89,213,192,116,
12,75,1,156,122,226,137,163,222,52,119,74,68,173,19,238,81,189,24,12,143,233,
73,71,47,36,103,0,96,96,147,255,0,191,173,102,218,55,151,83,181,88,207,137,166,
69,29,124,206,15,77,250,26,225,156,62,44,210,246,105,186,236,157,228,16,72,79,
142,94,103,127,169,111,251,85,64,193,183,76,249,49,31,210,155,212,92,243,188,28,
193,140,108,203,156,109,128,222,85,92,165,128,229,242,4,154,228,44,102,217,157,
91,192,107,104,177,114,136,136,199,126,92,26,213,44,223,14,87,212,86,197,100,
252,241,163,121,226,187,252,118,99,34,222,105,3,198,140,14,8,24,53,43,73,79,49,
140,254,97,138,81,73,193,30,163,52,69,61,27,27,138,237,76,144,169,146,79,168,
235,71,135,195,149,251,208,99,7,189,98,7,81,76,198,135,42,216,242,166,4,95,127,
189,97,252,143,181,20,198,78,54,216,215,12,100,168,52,128,25,25,197,65,151,29,5,
48,169,225,168,184,222,128,22,53,26,51,46,245,30,74,64,5,179,154,224,200,20,82,
155,214,66,82,2,9,144,105,203,119,245,3,244,160,4,163,68,189,41,88,14,194,71,
152,166,81,133,41,8,222,156,141,118,166,1,65,57,205,79,39,21,21,25,169,140,99,
173,0,98,185,89,29,112,69,114,128,58,118,237,240,185,20,170,239,190,122,209,46,
15,48,174,34,109,94,43,54,39,10,236,105,200,227,1,61,40,17,12,10,47,120,73,10,
58,82,6,114,117,7,96,49,239,91,46,132,82,3,111,9,32,121,236,122,154,169,158,
200,182,156,215,67,162,227,165,73,110,187,187,136,25,49,132,198,69,4,246,108,
124,88,86,13,122,11,135,0,196,240,4,4,244,4,255,0,243,84,145,206,144,92,48,118,
37,72,229,62,249,233,79,106,247,162,238,220,43,69,252,47,202,204,119,62,227,
208,86,191,106,172,242,169,102,240,169,42,181,85,177,160,247,114,179,160,137,
193,6,50,70,79,152,242,170,158,249,153,202,43,18,139,156,12,211,58,212,229,101,
150,32,119,7,99,245,165,173,147,187,182,146,67,215,24,20,253,148,70,201,2,202,
172,219,156,211,229,59,199,139,110,114,88,182,61,41,27,24,203,204,58,154,186,
142,230,27,73,2,198,129,166,11,187,147,178,210,64,193,219,153,121,155,149,65,
108,156,169,244,171,75,150,82,64,145,57,4,72,60,182,170,35,56,123,196,65,41,144,
18,50,221,50,105,157,74,229,218,105,3,49,101,24,0,19,77,49,9,93,67,26,220,188,
145,242,242,186,239,203,211,52,223,15,232,127,218,175,36,125,239,44,140,79,32,
245,164,144,51,69,141,203,51,236,62,130,173,120,94,227,240,154,149,178,202,252,
164,159,9,242,39,202,144,196,46,52,107,251,126,253,101,180,145,123,146,121,136,
25,7,30,244,29,26,69,42,208,243,101,79,136,3,229,235,93,147,117,174,66,46,174,
163,238,62,84,14,217,29,65,31,246,173,71,138,180,116,210,239,35,189,180,85,22,
243,120,148,1,178,159,49,67,232,10,77,78,40,222,234,8,185,207,136,146,113,251,
82,183,81,92,194,10,178,137,163,29,9,27,138,110,103,31,218,49,221,242,127,13,
128,13,129,242,159,90,106,238,120,227,140,205,207,28,136,118,240,190,79,233,77,
90,232,76,162,142,88,213,131,20,99,234,51,86,186,84,156,232,172,9,32,51,150,31,
113,254,180,140,145,75,120,230,68,138,40,87,29,57,183,52,197,171,173,146,119,40,
123,217,25,129,99,208,1,230,5,18,65,99,151,112,66,241,144,232,48,14,196,117,2,
171,99,43,4,153,180,153,164,25,241,198,126,82,60,233,221,93,157,44,185,0,32,179,
99,126,184,235,75,90,67,19,32,98,188,192,108,7,249,210,142,149,141,236,98,249,
97,121,187,235,83,203,230,21,188,199,161,168,129,50,148,189,177,102,12,70,25,
125,254,158,116,57,227,96,59,197,36,12,249,116,52,125,58,66,134,72,177,158,111,
26,145,251,208,158,192,153,212,99,146,68,75,136,12,13,249,128,249,91,223,7,250,
81,166,4,74,232,221,65,193,247,165,53,146,26,213,185,137,102,24,222,156,187,
202,136,246,39,150,53,7,39,207,25,171,123,4,47,62,27,187,93,193,11,184,165,25,8,
151,28,237,236,105,137,36,201,140,143,165,70,64,59,197,233,215,21,12,96,213,88,
108,28,31,173,113,152,43,96,224,26,131,248,27,25,251,212,102,124,161,201,52,0,
64,249,36,110,119,174,17,157,179,245,168,161,10,2,212,152,243,12,13,134,51,86,
132,12,115,6,240,211,144,249,22,29,122,210,240,144,73,30,148,192,96,6,51,191,
149,90,19,37,116,202,211,144,135,32,1,159,210,170,53,62,100,145,100,29,51,86,83,
42,175,35,231,126,92,31,122,71,81,249,0,27,239,226,165,46,129,16,180,1,166,230,
115,146,122,87,53,146,232,233,8,62,2,57,133,74,202,60,242,182,122,86,53,114,36,
189,132,46,254,15,243,169,255,0,72,123,23,183,139,38,174,244,40,98,55,37,228,80,
226,49,144,167,204,213,91,98,62,95,34,106,254,206,47,194,89,71,33,83,207,58,243,
103,208,122,85,98,91,19,13,115,28,140,198,66,252,217,242,244,165,183,7,7,34,155,
135,44,167,124,138,228,176,227,194,70,253,107,102,172,69,46,173,110,50,179,174,
222,77,65,51,115,0,191,173,92,220,66,30,23,140,239,145,84,42,164,62,43,41,42,99,
67,11,31,48,230,245,59,83,86,235,243,17,233,138,194,174,87,10,60,176,40,186,
115,163,67,60,36,127,16,144,203,246,234,42,226,182,38,25,97,34,32,249,235,208,
85,237,189,184,131,65,118,97,226,145,129,170,251,53,239,35,80,71,203,181,89,
221,220,102,205,109,87,24,81,146,125,235,175,28,82,86,67,101,122,182,8,62,134,
140,169,222,205,34,127,50,159,212,111,75,54,212,196,18,132,184,73,15,76,130,107,
74,3,22,228,169,42,126,212,73,70,112,124,235,23,11,201,59,1,235,181,101,6,64,
39,173,82,64,42,163,149,159,35,122,44,106,72,5,188,250,84,231,143,243,142,135,
173,98,49,146,9,59,210,161,19,9,158,189,60,169,189,52,17,204,165,176,184,233,65,
11,176,247,167,52,245,28,174,164,86,208,142,196,200,50,131,184,53,52,4,12,125,
235,156,164,49,24,169,128,73,6,174,129,12,200,161,159,155,249,128,53,153,211,
153,20,251,114,212,128,202,33,246,197,72,129,203,244,169,154,177,139,33,192,43,
142,163,6,178,147,139,40,230,190,239,123,185,45,99,50,198,121,176,123,192,71,38,
61,243,143,210,179,202,81,186,117,170,30,49,186,132,8,172,109,249,158,68,28,
243,176,232,24,244,81,244,31,185,174,28,202,162,209,75,179,89,184,146,73,166,
146,121,93,158,73,28,187,179,28,150,36,228,147,247,165,51,151,53,103,45,163,139,
22,155,24,93,135,49,243,164,4,120,4,13,205,121,206,52,105,102,33,60,147,41,244,
53,176,233,248,17,16,15,200,216,251,117,21,175,200,184,96,125,70,106,219,69,
152,25,66,177,194,184,229,62,222,135,245,174,140,18,166,76,145,119,17,223,56,
166,163,64,113,64,183,83,206,1,27,231,20,252,17,224,227,29,43,209,138,51,39,12,
99,32,226,156,88,199,40,218,161,26,209,192,240,214,136,68,57,7,40,246,168,149,
192,52,112,42,44,41,208,11,129,229,66,101,201,166,8,197,12,141,170,90,1,114,190,
85,18,187,209,249,107,5,118,168,99,2,23,38,136,137,83,84,62,148,84,67,138,64,
15,146,167,28,123,224,10,50,166,58,209,80,1,229,64,24,138,62,90,56,62,85,5,205,
77,69,0,17,70,219,154,146,253,106,0,214,124,233,208,19,34,185,81,230,174,85,
168,1,211,104,164,154,48,92,10,202,128,43,4,226,188,3,99,28,216,52,75,117,105,
37,0,80,25,75,28,250,83,112,206,150,240,228,14,105,15,237,64,22,58,149,224,75,
68,179,66,48,14,91,235,85,118,236,75,122,154,90,73,153,223,152,157,201,201,171,
125,8,70,208,76,184,5,241,231,233,66,91,4,168,118,226,81,38,159,110,195,4,242,
21,164,226,1,45,196,197,114,177,128,204,40,22,78,221,212,136,217,254,27,84,26,
240,127,102,73,25,30,41,14,7,210,173,0,132,242,27,155,183,149,134,1,52,103,57,
135,30,84,40,87,108,122,209,46,6,16,47,144,169,25,136,36,195,114,166,192,245,53,
145,151,145,216,120,137,243,160,192,217,144,96,103,210,157,181,17,199,128,224,
185,39,112,167,31,189,2,51,167,64,127,26,172,251,227,38,143,120,21,121,228,114,
51,146,113,233,89,23,48,199,51,145,8,207,46,20,115,18,114,124,234,186,242,89,
37,112,140,78,58,242,142,148,2,29,211,14,99,150,227,249,99,110,81,238,118,171,
62,25,142,210,77,64,195,125,24,100,150,62,68,230,233,205,215,237,245,170,235,
101,228,178,104,195,14,102,229,92,98,159,154,18,145,128,235,203,203,129,204,14,
223,246,161,140,218,45,173,12,23,220,243,30,249,22,62,239,157,134,248,39,161,
245,199,249,210,92,67,205,115,164,77,105,144,205,110,67,198,125,87,255,0,138,
145,185,154,231,64,101,103,34,110,133,191,155,30,116,77,16,45,221,155,162,224,
203,17,200,83,230,60,197,55,208,141,83,76,136,221,66,208,196,63,142,158,37,30,
190,162,170,117,103,50,221,247,92,161,123,191,9,219,114,106,255,0,84,79,236,189,
66,25,237,139,198,193,207,139,27,99,208,251,138,164,213,152,157,82,121,64,12,
29,187,194,80,116,243,200,162,61,129,200,160,72,175,237,163,93,132,163,148,145,
228,122,86,37,130,65,43,243,108,85,136,52,41,94,118,104,174,35,28,230,54,231,12,
187,249,231,165,92,219,4,186,205,207,46,99,155,42,251,103,187,111,35,244,255,0,
189,12,66,215,115,53,197,130,205,39,137,162,32,31,167,74,86,208,148,231,25,216,
128,69,57,101,24,123,137,45,31,97,38,86,171,194,188,18,189,188,196,35,131,225,
99,208,227,214,154,218,160,45,109,162,23,150,151,74,0,18,166,36,24,243,245,164,
236,1,89,193,102,3,148,17,138,98,221,174,45,88,92,164,100,21,217,148,141,190,
134,131,3,180,211,146,145,225,179,146,7,149,36,51,26,187,1,26,198,122,187,138,
101,216,201,111,204,219,177,25,111,106,79,83,60,215,113,2,54,85,205,26,22,137,
252,44,158,217,171,1,105,242,136,135,56,194,138,29,196,189,225,239,19,62,254,
198,137,126,252,190,19,190,6,198,147,183,149,123,204,54,202,219,26,150,49,203,
148,231,183,19,32,200,243,199,149,40,207,147,200,78,6,119,167,180,246,238,100,
104,101,193,70,216,31,42,86,254,220,199,114,93,65,238,253,113,211,218,155,251,2,
37,249,190,81,247,52,85,92,140,146,78,104,33,247,200,27,81,162,60,203,158,148,
208,137,40,228,106,34,54,50,124,232,100,248,115,80,119,199,54,61,106,128,204,
147,98,108,29,192,160,93,72,25,92,14,184,168,93,56,239,72,29,113,154,17,19,56,
36,46,115,214,165,176,27,177,98,96,81,210,177,126,23,241,145,242,126,69,25,62,
166,165,167,144,96,92,125,43,55,88,107,198,3,242,224,126,212,62,128,205,189,177,
154,233,12,157,24,244,173,191,136,237,123,155,43,94,81,225,141,121,14,63,90,215,
109,131,72,209,247,106,70,58,159,74,216,175,165,104,244,101,66,50,29,192,25,223,
30,245,209,138,41,69,145,39,177,27,0,121,138,121,154,110,64,29,17,177,190,6,
105,24,75,9,57,151,57,24,53,96,8,104,209,177,215,53,113,64,42,209,150,147,99,
181,82,73,106,82,245,211,61,14,213,176,178,228,208,47,45,68,216,148,30,87,3,173,
18,133,133,136,0,21,78,58,129,65,176,148,91,222,36,164,2,51,189,73,1,124,130,
78,1,172,50,12,129,233,80,190,198,93,88,194,76,115,30,111,151,112,125,115,82,
229,39,39,52,198,144,157,237,129,10,55,81,131,235,67,117,192,53,221,24,105,25,
216,180,155,175,77,234,11,146,66,239,210,153,8,24,26,194,199,176,199,149,87,16,
10,254,32,142,119,44,163,245,27,81,99,3,151,62,116,48,63,130,54,249,79,245,162,
91,142,181,164,98,4,150,60,228,17,144,106,49,66,57,247,29,41,180,83,140,245,
172,50,229,252,34,173,192,86,15,151,127,106,61,162,30,114,192,224,1,189,114,56,
75,28,108,15,189,52,176,24,134,8,32,213,69,108,77,131,43,226,233,214,165,202,5,
76,12,141,186,212,138,19,229,84,208,38,78,45,211,232,118,172,145,150,192,169,
196,155,122,84,192,60,213,46,58,29,128,153,51,140,121,86,179,123,166,180,218,
221,208,229,49,172,132,180,103,124,31,189,110,29,221,14,233,48,158,213,205,151,
29,161,217,167,241,64,17,105,193,125,100,85,31,96,73,255,0,42,214,227,216,213,
247,23,76,75,197,111,177,85,37,254,132,237,253,5,83,219,196,89,137,175,51,44,
126,109,35,72,189,0,101,38,33,159,44,138,107,76,79,21,17,109,193,230,230,219,52,
230,153,107,207,32,85,216,14,166,158,40,62,64,222,139,171,65,206,170,217,201,
198,245,105,26,120,129,30,123,210,246,118,252,136,6,54,21,99,26,127,12,122,131,
94,156,81,145,196,90,152,21,144,43,39,97,86,6,43,13,92,38,162,88,244,162,192,
131,121,208,219,21,39,201,172,170,253,234,91,0,60,167,210,136,138,42,97,115,89,
85,197,67,25,149,95,106,158,43,138,61,69,79,35,29,41,1,192,5,72,1,81,207,181,
72,83,160,36,49,211,21,48,61,170,32,214,115,181,90,136,140,228,215,9,172,18,42,
36,214,145,136,54,75,154,185,67,38,185,90,168,147,103,83,243,103,106,146,14,
106,89,91,197,78,64,112,113,95,48,145,208,26,8,149,114,88,116,222,171,229,37,
165,35,203,52,245,227,242,133,193,234,49,73,196,188,210,143,115,77,141,28,16,
146,189,40,154,117,195,90,204,192,231,196,49,251,213,171,197,28,54,197,142,50,
70,213,73,57,31,161,164,244,193,59,25,150,224,65,119,41,25,228,144,103,239,72,
161,39,175,173,98,225,203,1,158,162,167,110,11,121,116,20,12,110,4,192,205,66,
241,191,134,213,52,124,41,39,96,41,25,231,105,159,10,48,191,214,129,19,183,27,
237,212,211,225,138,68,177,71,130,196,228,147,73,219,186,67,227,103,223,201,64,
166,45,238,225,105,242,233,141,182,198,104,6,70,222,54,105,137,115,156,182,244,
30,110,123,134,39,166,105,182,11,18,14,78,132,22,253,106,186,216,142,240,150,
62,121,160,17,125,100,193,32,92,175,241,37,148,0,79,144,4,85,202,74,123,195,4,
128,119,91,228,242,239,131,235,237,84,186,106,119,243,163,146,112,139,144,61,
234,237,163,104,44,227,186,4,157,200,35,29,61,191,74,96,86,89,223,205,105,20,
150,70,54,149,89,243,24,7,116,97,215,236,69,53,97,168,136,47,82,117,6,50,8,37,
124,190,190,226,133,20,240,13,94,11,136,99,42,164,248,131,122,158,184,167,53,29,
54,21,84,133,159,168,230,12,167,113,159,90,64,88,113,74,90,234,54,139,117,11,5,
46,60,74,122,134,245,173,57,35,101,2,103,67,202,141,202,88,12,242,26,61,177,
104,175,127,11,115,35,242,3,129,226,173,147,135,44,35,183,215,158,202,81,248,
139,59,200,73,1,247,220,82,3,81,191,180,54,201,21,221,164,248,50,124,234,60,155,
253,41,141,54,240,44,109,35,198,17,177,203,40,95,149,199,184,253,193,167,248,
131,76,22,18,74,168,172,214,225,202,169,63,151,219,53,66,172,209,146,6,8,63,189,
59,16,118,5,102,18,68,73,28,222,19,253,42,203,95,178,142,238,198,218,242,16,86,
87,93,207,248,170,166,209,193,112,140,112,51,225,38,183,139,171,88,219,72,138,
85,3,187,157,3,169,242,14,54,34,128,53,237,26,9,239,236,227,135,189,228,144,14,
86,86,232,192,124,167,236,114,62,148,189,220,19,233,183,188,207,31,43,41,195,1,
184,53,105,98,255,0,128,151,152,199,206,51,157,186,131,231,79,235,209,27,200,99,
148,71,180,169,208,141,206,58,17,255,0,190,148,236,102,191,171,90,164,169,21,
228,27,163,161,13,254,19,85,173,27,70,199,124,253,43,96,211,224,184,180,185,109,
62,236,0,93,121,144,245,25,165,117,75,30,238,22,49,244,25,194,249,175,153,31,
79,49,247,30,85,66,40,47,155,153,203,3,182,49,72,144,1,200,253,169,169,193,42,
65,165,78,219,212,189,148,57,13,193,117,84,144,114,250,48,242,171,133,79,196,
218,5,108,22,62,149,175,128,219,19,181,88,105,183,114,194,234,171,186,249,231,
122,168,191,176,23,184,128,195,33,92,116,172,219,158,108,138,189,186,183,142,
238,49,44,88,201,220,227,214,170,228,183,146,19,150,82,49,234,42,248,208,172,27,
156,13,232,46,114,79,212,81,103,96,203,183,90,92,54,11,103,210,128,33,26,9,174,
89,136,216,83,138,156,187,1,64,179,33,99,39,204,156,209,164,112,49,73,104,25,8,
136,134,108,254,92,228,253,106,48,146,211,146,122,177,205,22,24,218,103,244,81,
89,88,194,234,34,60,96,28,82,2,223,72,84,254,55,49,233,34,108,58,224,245,197,
63,172,220,139,187,177,20,62,27,104,128,8,61,79,173,39,161,58,218,113,36,13,58,
142,229,155,149,242,54,220,99,252,233,189,66,220,65,127,52,88,199,43,144,62,158,
85,213,11,226,67,236,132,49,30,113,159,148,237,154,114,56,202,161,76,124,172,
107,54,202,178,64,87,30,36,222,141,27,142,103,108,108,113,145,90,168,161,88,184,
30,44,81,59,172,199,236,107,18,46,38,35,214,143,203,200,163,39,203,122,180,132,
107,243,218,189,180,173,143,145,142,198,133,50,19,130,58,86,193,60,9,52,100,54,
224,244,53,83,50,114,49,143,61,13,79,227,161,216,255,0,13,191,117,58,151,36,35,
248,51,229,154,176,212,32,229,148,133,232,69,87,105,45,19,36,208,63,144,12,191,
106,181,187,124,200,185,57,33,5,118,226,143,192,205,189,149,177,41,13,202,70,48,
104,208,175,140,140,81,39,81,144,192,108,107,49,141,198,43,69,26,11,50,98,192,
200,27,26,226,40,13,77,32,5,72,53,6,143,7,56,218,175,136,88,104,147,41,154,138,
128,28,130,69,18,28,136,233,116,60,204,113,68,132,130,177,207,157,55,27,9,173,
130,31,239,23,206,171,164,83,141,141,49,166,247,140,79,46,228,111,138,152,202,
157,3,67,49,70,202,114,105,133,3,204,84,224,110,95,156,100,26,41,84,36,114,116,
173,82,34,200,32,21,206,83,156,209,86,60,12,209,22,60,142,148,113,31,32,42,50,
41,107,220,242,17,228,42,201,97,219,165,39,123,31,90,203,36,116,9,154,15,22,
199,201,169,242,18,57,130,47,54,61,106,124,55,8,123,160,74,131,202,185,168,113,
12,45,30,165,38,249,230,33,129,171,174,24,180,240,153,198,193,135,79,79,90,242,
20,91,200,205,159,68,53,123,85,230,18,114,141,198,58,80,244,136,177,115,140,
108,106,243,80,181,47,3,12,116,21,91,166,198,22,225,114,58,26,223,141,73,9,116,
92,69,16,35,165,21,87,25,30,162,152,138,47,13,66,104,207,41,197,117,81,34,224,
159,33,92,193,61,106,34,82,141,211,53,147,112,172,248,3,30,245,13,140,225,4,86,
49,189,24,21,97,145,131,235,88,11,226,192,20,88,2,41,235,89,69,0,98,137,32,192,
168,121,208,50,106,160,13,197,99,195,233,81,102,218,134,78,69,2,8,72,172,59,101,
104,69,170,44,231,20,12,152,147,246,162,163,237,74,22,222,166,173,131,66,1,174,
106,144,109,169,101,125,232,168,107,68,132,194,22,168,182,107,25,174,19,90,196,
147,155,215,42,36,215,43,64,58,133,62,106,100,62,48,69,42,166,137,205,181,124,
186,58,67,203,39,56,3,210,141,10,133,139,159,204,28,82,42,222,42,59,205,136,200,
245,160,67,87,183,57,136,46,122,10,170,46,77,114,105,51,231,65,25,53,45,141,32,
168,57,136,20,212,68,71,27,182,112,0,197,45,6,67,2,6,113,89,185,156,177,62,72,
14,195,222,144,206,92,76,207,177,56,30,148,46,109,182,216,84,6,251,154,205,0,
72,53,26,219,60,204,125,5,1,62,109,135,222,157,178,3,198,122,244,160,2,18,91,
35,36,5,76,109,65,182,183,56,230,198,195,173,48,136,76,83,55,181,55,167,178,
170,152,200,4,58,224,159,122,98,57,106,76,50,171,130,112,71,80,122,138,217,67,
25,96,8,204,203,17,33,185,189,119,3,252,234,147,67,238,228,146,75,73,70,239,
188,100,249,26,181,141,138,42,67,47,48,84,59,226,130,88,134,191,100,250,93,204,
120,201,67,186,159,161,171,43,151,102,154,222,242,71,86,134,225,2,236,49,202,
113,92,227,70,105,236,224,97,146,6,224,210,58,116,241,220,240,236,246,115,31,20,
88,104,253,71,189,30,199,96,184,166,201,237,110,163,144,145,226,92,231,215,214,
139,166,234,146,143,195,186,183,241,237,223,43,159,49,230,42,58,213,227,106,48,
91,12,28,198,158,47,115,211,52,158,149,12,19,72,208,76,197,36,63,221,190,122,
31,74,76,19,46,120,130,241,167,44,97,114,246,247,15,156,17,242,191,161,173,90,
79,225,220,114,202,165,72,56,32,249,26,191,158,207,83,88,30,55,129,93,151,114,
71,86,3,204,85,30,177,51,79,117,223,178,0,196,0,216,243,35,206,129,156,104,124,
92,201,250,86,225,192,247,113,222,69,39,13,234,4,170,92,101,173,164,243,71,199,
74,211,227,148,128,6,62,245,178,240,101,237,189,166,179,111,119,114,188,209,
198,78,72,27,174,70,51,246,166,20,49,61,180,246,151,146,217,94,166,46,34,27,159,
41,23,201,133,23,77,212,162,190,153,180,217,188,12,6,109,228,243,86,21,184,113,
102,157,14,175,102,140,165,25,249,121,161,153,122,227,216,215,87,92,217,93,217,
221,63,226,18,69,117,59,62,8,207,189,11,76,13,167,86,186,180,133,98,93,70,48,46,
2,224,50,143,148,250,210,58,133,177,158,3,36,79,190,196,48,243,244,53,69,120,
215,179,114,79,120,28,247,137,224,102,252,192,109,154,181,210,245,184,109,116,
62,226,72,251,201,35,147,101,61,25,15,93,253,170,236,84,107,122,221,183,115,39,
50,140,35,239,143,67,230,42,168,38,251,244,173,203,92,183,134,238,209,110,109,
198,80,142,97,235,138,213,231,143,151,160,233,73,173,141,24,9,222,69,183,81,88,
140,180,82,2,54,34,165,108,252,146,6,61,58,26,61,226,5,229,108,3,157,193,30,98,
169,0,253,187,186,68,183,73,186,231,15,138,176,99,20,246,248,99,144,251,85,29,
173,211,68,165,7,200,221,69,61,101,203,42,75,26,62,8,28,202,167,166,125,51,90,
69,137,148,210,135,94,114,84,248,27,148,208,164,62,99,161,163,137,153,37,114,
202,74,200,8,96,105,118,56,39,3,106,134,50,8,10,145,191,90,50,142,101,59,231,21,
132,108,48,97,212,26,125,172,226,152,43,135,49,179,12,228,116,52,170,250,6,78,
201,84,64,184,244,161,78,167,251,102,221,127,253,224,81,92,11,53,159,204,59,216,
191,152,117,90,54,161,36,102,242,206,254,22,12,163,0,175,152,197,85,107,98,45,
53,177,24,190,142,56,64,194,42,134,63,226,59,154,119,86,137,162,186,80,204,88,
178,2,73,243,170,123,43,129,123,11,52,131,196,247,28,222,248,197,95,107,41,152,
109,165,7,32,174,1,246,21,213,141,90,108,134,10,207,152,74,25,79,65,146,42,124,
195,157,185,78,199,113,88,177,0,198,78,112,121,72,160,219,156,201,138,211,208,
15,72,57,214,57,87,200,239,76,220,42,180,101,182,201,20,27,80,13,168,29,67,111,
69,7,248,120,173,224,137,43,210,110,88,152,231,165,84,76,197,156,185,206,244,
214,160,26,39,104,193,234,104,182,150,241,220,219,152,87,102,3,155,155,213,168,
174,78,131,161,139,27,23,54,166,99,128,204,54,201,234,41,249,163,36,35,63,82,
160,126,130,169,45,239,30,5,48,207,204,10,28,1,87,150,146,36,246,60,196,158,124,
248,71,181,117,97,113,106,145,18,176,65,79,33,25,207,165,70,208,228,178,182,114,
40,196,21,59,10,2,2,183,59,121,214,141,8,118,62,157,104,156,185,83,154,93,31,
29,104,170,217,166,4,178,66,48,246,164,173,228,30,251,83,217,92,100,210,50,5,
134,67,184,57,57,172,166,232,164,49,204,36,217,71,78,162,154,209,217,109,111,
195,190,241,184,193,164,84,243,99,27,31,35,210,155,182,141,221,176,216,4,249,
138,132,247,96,203,121,227,11,41,1,131,47,80,71,165,78,33,181,66,43,114,144,43,
156,224,212,149,241,236,43,162,38,76,60,107,158,180,204,73,235,75,68,224,154,
101,36,3,98,69,95,36,32,225,0,90,74,234,30,98,118,167,18,69,59,2,43,18,21,193,
174,124,179,76,164,142,191,226,107,65,248,208,192,110,69,108,28,51,105,203,100,
163,215,122,87,136,225,205,202,146,63,46,71,235,91,22,129,7,37,132,64,141,200,
205,113,227,143,205,154,190,129,221,219,129,30,8,170,8,225,17,221,176,199,70,
173,178,253,124,53,69,119,16,91,192,248,249,148,31,189,105,53,180,8,126,1,148,
31,74,229,194,120,115,82,183,218,53,250,81,100,193,74,215,208,138,41,151,196,
73,20,171,99,61,113,86,151,105,215,106,172,153,14,113,138,202,74,138,37,15,120,
119,4,98,155,183,13,191,54,199,27,82,246,80,75,33,202,244,27,147,232,41,147,52,
103,1,70,49,177,247,168,143,96,101,200,35,52,63,90,139,28,19,88,223,202,169,129,
134,61,106,5,252,171,143,159,60,80,192,98,73,6,139,3,142,219,212,11,29,234,79,
129,212,212,54,160,14,115,84,131,109,66,39,6,184,173,226,166,152,12,35,109,69,
87,165,179,82,70,53,105,128,208,59,214,73,160,134,169,102,180,136,153,50,107,
148,50,107,149,160,142,164,7,122,158,118,168,138,230,119,175,153,58,12,231,122,
140,143,154,195,54,40,103,115,82,198,115,115,181,72,10,226,140,10,200,198,105,0,
72,219,144,16,58,145,143,165,45,33,203,109,208,116,169,74,227,162,231,21,1,72,
12,173,103,124,226,176,54,21,37,235,64,204,140,157,188,169,251,37,196,14,125,
197,42,23,6,155,128,226,223,31,204,212,8,105,0,93,58,67,230,88,10,229,136,231,
152,70,124,246,31,92,109,251,212,228,199,224,99,3,243,57,38,129,1,41,51,21,39,
35,113,64,172,41,110,226,104,228,76,171,3,154,217,237,117,59,11,152,99,47,34,
199,32,27,131,182,245,174,220,169,158,52,127,204,91,148,159,127,90,118,21,54,
209,139,121,237,146,104,199,136,178,140,159,214,169,9,151,122,186,9,236,201,76,
52,107,226,200,59,85,101,134,156,57,86,96,165,162,207,44,140,167,5,115,208,209,
180,187,11,11,246,104,162,187,146,34,122,40,108,12,125,43,58,60,243,105,23,114,
90,220,176,49,57,42,9,27,31,106,4,29,244,115,111,200,142,88,197,112,9,67,232,
194,168,181,155,11,157,58,227,199,226,93,136,97,231,91,253,130,127,105,233,239,
110,171,134,141,185,163,108,252,141,212,86,185,169,163,222,217,207,20,185,239,
99,220,3,212,96,238,40,4,75,64,215,1,84,138,232,171,242,224,134,39,125,169,78,
54,210,227,153,70,171,167,46,99,113,205,50,175,145,254,97,236,106,170,43,37,
184,239,59,181,44,200,119,65,243,99,212,122,251,138,119,135,150,252,94,27,107,
107,129,202,48,198,25,14,204,51,130,7,189,34,141,126,214,101,86,238,229,27,121,
26,182,210,227,43,123,28,106,195,149,250,26,151,30,233,169,166,241,12,144,198,
129,17,209,100,80,58,12,255,0,241,84,246,151,79,4,200,224,231,144,231,20,232,13,
254,199,83,158,192,53,140,140,221,214,114,153,234,173,230,62,134,174,26,103,158,
2,179,48,158,7,25,82,195,122,175,210,95,79,214,236,57,101,192,147,151,194,227,
168,53,13,63,188,134,71,211,38,124,56,222,222,79,113,229,66,2,23,86,81,92,233,
178,91,247,100,0,73,139,212,31,74,214,90,192,194,141,149,98,15,145,253,235,102,
186,186,153,194,134,66,142,185,12,64,216,154,226,33,184,64,236,170,193,190,113,
239,235,247,166,34,135,65,126,241,101,211,152,229,136,45,16,245,245,21,77,125,
15,36,204,184,219,52,245,252,111,99,169,134,141,138,148,110,100,106,142,181,42,
206,226,224,114,129,55,139,97,208,249,213,62,129,20,108,133,73,20,229,178,173,
197,171,66,231,12,167,42,125,40,179,193,176,219,168,202,159,95,90,70,57,26,9,
255,0,175,210,154,208,200,50,148,110,86,216,169,220,85,132,82,181,170,149,117,
198,70,65,246,164,174,220,51,135,245,243,166,33,184,19,90,247,50,0,100,79,144,
250,143,74,107,176,1,112,253,225,56,93,188,168,66,60,252,219,10,176,178,181,89,
230,17,175,78,172,222,159,74,62,179,20,80,128,17,64,192,163,142,172,44,171,187,
182,48,4,96,67,43,13,136,169,89,92,132,6,57,9,229,61,15,161,168,203,47,120,20,
16,72,83,156,102,166,45,86,68,230,128,179,3,235,212,123,81,253,129,150,112,150,
229,230,217,134,42,55,122,98,201,11,221,90,227,145,83,157,151,59,143,90,75,78,
186,107,119,238,228,221,106,204,220,71,7,35,6,240,63,152,255,0,223,74,213,83,91,
36,169,210,101,238,222,2,60,164,222,183,105,85,101,209,24,147,253,203,130,135,
216,249,86,148,34,54,151,178,192,195,96,193,144,250,169,233,251,86,207,20,204,
52,104,208,236,36,108,253,64,173,124,125,38,152,164,75,78,148,43,20,113,149,35,
244,169,60,97,110,185,6,193,134,212,165,185,60,228,10,109,206,76,91,248,129,253,
171,101,209,35,26,99,142,70,137,142,224,158,180,219,199,134,243,222,170,156,119,
119,128,161,249,155,247,205,93,202,54,83,237,93,56,149,170,250,37,232,215,117,
149,197,238,55,249,107,58,76,139,13,194,115,110,27,194,126,245,30,33,153,99,189,
1,142,252,157,5,85,195,127,58,92,131,28,74,88,116,7,214,161,205,66,99,171,69,
230,185,96,19,83,46,207,144,192,48,171,45,22,17,200,98,44,9,63,41,244,170,97,37,
252,138,90,239,150,86,10,49,203,228,42,223,67,114,211,64,170,192,130,195,113,
231,93,120,184,185,218,93,153,203,161,137,135,41,101,61,65,165,200,1,129,171,13,
90,30,75,146,227,163,146,105,38,140,237,91,202,45,58,37,50,61,78,69,18,73,97,
130,62,121,93,81,125,73,174,42,227,233,90,165,237,225,186,212,166,71,112,194,54,
33,8,233,203,229,138,231,207,151,241,47,238,92,85,151,147,234,240,110,33,15,33,
250,98,146,107,201,36,151,188,49,63,40,244,21,84,179,132,125,128,56,242,171,27,
75,171,185,135,138,86,17,13,176,187,87,155,63,33,190,205,84,67,46,172,209,144,
4,5,179,234,105,184,181,230,66,7,225,9,207,248,171,54,95,131,25,230,132,72,
124,249,155,4,213,181,173,165,133,212,68,162,71,19,122,54,42,63,152,146,246,62,
2,113,235,215,178,46,18,204,31,172,148,104,245,153,66,230,123,11,149,111,240,
142,96,105,152,244,174,70,7,240,214,178,168,59,186,57,83,253,106,222,195,72,180,
156,115,50,220,70,65,219,248,135,31,189,67,242,230,189,143,241,38,106,183,58,
150,175,59,102,11,105,34,143,201,121,119,251,154,194,54,168,87,188,187,185,238,
215,200,19,91,180,252,51,47,112,210,193,173,60,123,100,43,144,113,251,111,90,
241,91,228,13,5,211,219,220,161,219,155,187,25,31,181,103,252,204,164,251,31,
226,72,197,149,194,70,170,94,238,71,250,109,86,176,200,206,137,59,200,96,182,
124,226,89,51,130,7,92,122,213,73,210,162,0,52,55,74,222,163,148,140,86,13,139,
150,28,210,115,114,140,12,183,65,91,195,43,100,184,142,235,19,195,119,114,130,
220,177,134,53,229,66,195,12,125,115,247,171,157,50,229,132,8,2,146,0,199,74,
215,82,34,135,200,253,13,89,233,247,77,14,54,108,123,28,26,222,44,154,45,47,102,
98,191,46,62,213,87,121,39,120,81,118,254,24,192,253,106,229,174,109,174,33,
254,44,115,43,123,182,106,174,230,40,1,37,92,143,173,95,43,236,40,92,92,58,128,
160,138,225,191,101,216,128,105,121,66,130,119,52,187,5,242,98,40,230,208,168,
112,220,25,14,227,148,122,208,167,146,30,64,2,22,39,203,206,149,121,73,33,71,
135,213,170,79,42,196,165,35,82,93,134,11,183,92,123,82,115,176,160,230,232,136,
123,184,135,46,58,251,253,104,17,14,99,81,137,114,114,122,14,180,89,10,198,170,
113,177,232,40,67,10,26,48,112,60,77,239,66,121,243,144,6,49,214,149,121,7,51,
42,2,199,200,212,192,229,135,12,124,68,244,166,34,44,204,199,114,64,53,151,144,
40,229,31,173,112,200,170,188,184,230,111,233,75,200,219,156,245,162,232,12,
150,53,206,98,42,11,150,206,43,60,131,27,190,226,139,3,4,228,215,6,79,65,80,231,
3,208,212,213,193,29,113,66,96,24,18,87,126,162,178,27,6,130,142,50,64,57,205,
75,4,159,165,104,152,12,43,102,167,156,10,93,115,138,159,55,65,90,196,76,41,99,
92,160,151,244,53,202,208,71,87,214,26,185,154,193,175,153,58,80,54,59,215,16,
111,89,35,122,202,210,2,88,218,132,231,211,165,23,203,122,19,239,72,8,29,235,3,
173,79,21,130,40,3,10,114,104,139,92,141,57,142,42,65,79,76,111,74,128,41,4,198,
172,7,177,163,169,196,104,62,245,24,129,252,59,2,55,161,187,116,25,198,212,132,
89,220,56,91,107,117,246,45,251,208,22,68,201,32,239,208,210,247,114,159,2,2,
112,16,80,33,108,183,90,164,132,145,127,166,92,64,76,176,77,130,146,33,10,79,
228,127,35,237,70,211,238,208,169,239,7,241,87,109,207,157,80,142,124,230,153,
239,148,178,72,50,175,140,63,161,62,180,154,27,86,108,207,105,109,116,97,184,
130,116,182,152,182,1,7,24,62,255,0,235,64,215,45,111,82,33,36,229,101,0,225,
130,237,131,235,73,144,25,0,67,144,195,111,168,171,173,55,80,239,45,214,222,244,
119,145,227,1,207,204,163,252,235,53,104,142,133,184,103,83,123,107,196,229,185,
145,1,27,171,54,196,142,149,123,173,247,111,32,186,80,197,88,243,59,175,204,167,
233,237,215,245,173,55,82,179,123,107,201,84,14,116,70,249,151,166,251,131,87,
58,85,233,188,141,96,239,9,40,1,228,59,115,99,208,214,137,140,225,91,105,239,
29,187,193,28,165,3,7,143,167,48,216,154,46,139,109,37,221,219,74,36,86,186,
181,112,192,249,200,135,33,129,245,198,196,84,181,24,27,78,187,131,82,132,119,
182,178,130,132,145,242,147,249,77,83,234,23,6,13,73,175,52,233,30,21,35,229,
206,234,125,62,148,198,109,125,162,232,242,234,48,195,170,90,168,126,238,46,89,
83,243,0,60,235,171,228,202,185,246,174,215,224,254,33,75,248,191,11,116,202,
39,198,9,35,1,171,78,227,206,30,254,201,185,142,120,24,188,51,103,175,229,62,
149,67,253,138,141,19,82,184,178,159,188,129,200,245,95,35,91,21,222,174,117,24,
123,211,201,12,137,131,179,110,8,173,58,48,193,178,41,219,105,138,184,101,60,
174,58,26,64,111,250,117,228,90,149,166,37,240,200,64,18,145,212,31,38,250,122,
212,228,180,186,178,35,188,229,96,14,252,191,177,173,62,27,169,140,169,60,51,52,
114,174,205,138,190,131,136,90,83,12,26,138,176,35,96,224,236,69,52,196,208,93,
102,194,59,251,39,112,248,157,14,85,72,220,251,86,155,112,147,70,57,28,18,128,
237,91,230,161,221,79,17,116,63,71,245,250,251,251,214,183,168,65,155,121,1,27,
129,85,76,72,196,177,143,192,129,156,163,97,162,127,67,143,58,162,189,66,92,156,
96,142,181,107,163,60,151,16,201,6,67,44,99,229,62,254,84,27,251,118,86,223,
113,228,199,250,31,122,161,162,170,49,204,133,124,235,9,224,108,231,113,83,112,
98,147,62,251,215,8,86,147,25,216,141,189,141,33,150,252,58,75,60,204,113,132,
80,77,47,170,203,248,155,159,7,200,40,90,100,143,16,145,85,185,75,174,62,163,
204,83,51,66,34,35,62,99,53,93,170,15,98,33,22,57,48,196,0,70,70,104,209,120,15,
121,17,193,27,251,26,140,171,206,65,244,160,130,66,176,242,205,46,129,150,26,
149,134,82,27,200,129,48,76,57,143,46,229,15,152,170,215,108,168,235,128,106,
215,67,187,238,110,68,47,227,130,83,202,235,159,222,137,168,105,162,41,228,88,
91,188,180,145,178,24,13,209,191,247,229,90,56,242,218,38,235,178,189,132,215,
48,197,49,25,17,14,239,35,211,168,205,108,55,0,174,157,98,6,192,71,130,61,234,
170,210,9,244,235,179,29,194,150,143,35,155,7,102,30,68,86,193,98,176,92,217,
152,88,229,63,240,219,205,107,171,12,46,254,201,147,3,166,195,191,49,27,255,0,
149,59,45,164,109,27,76,173,227,77,216,123,121,80,44,65,70,193,223,208,250,213,
165,178,172,129,163,110,142,164,87,84,49,166,168,134,202,91,236,71,124,204,122,
7,7,237,86,194,84,150,53,117,57,207,157,39,125,9,56,45,190,197,79,218,143,167,
218,73,28,89,39,102,25,21,182,40,181,38,132,222,138,190,38,182,133,173,30,229,
147,248,139,128,26,181,219,115,150,24,245,222,182,30,46,156,36,9,102,167,46,228,
51,251,15,42,171,210,108,26,226,101,69,29,65,53,134,104,242,205,81,42,47,226,
89,105,178,230,233,9,233,138,176,230,125,62,97,123,4,97,144,18,74,249,100,245,
164,109,97,49,74,1,235,156,85,178,18,51,144,10,145,134,83,208,215,102,56,186,
253,204,228,203,73,10,94,216,164,209,29,152,115,0,124,189,69,39,203,225,222,185,
165,186,91,57,128,115,119,45,146,128,254,83,233,76,200,131,159,110,135,113,93,
169,114,87,236,207,162,131,137,218,69,177,88,34,114,141,43,99,32,249,86,171,46,
155,119,18,243,134,201,30,158,66,172,120,198,237,228,212,12,41,144,33,28,163,
235,212,154,165,91,203,216,215,6,82,227,209,183,175,3,204,156,101,145,223,163,
166,9,164,72,9,163,127,27,3,245,171,27,103,154,56,185,215,12,190,120,57,197,86,
27,238,243,195,60,35,30,171,212,84,75,188,18,119,176,72,74,31,67,253,69,121,
242,104,209,23,34,233,201,201,21,97,99,126,164,97,157,148,142,132,85,30,157,117,
111,117,40,134,102,238,89,142,3,121,103,222,172,165,211,174,173,79,120,235,152,
179,129,32,220,86,110,251,29,150,195,80,120,223,154,41,119,235,147,87,208,241,
180,241,219,164,108,145,74,87,230,200,197,105,222,14,239,45,34,131,142,153,161,
6,143,151,156,56,106,67,179,124,183,227,7,156,158,123,113,18,158,152,222,172,
172,248,130,201,155,23,17,70,118,234,84,100,215,93,219,78,20,2,143,177,242,52,
234,78,173,215,106,165,16,179,176,100,190,211,39,143,153,33,85,111,34,184,222,
144,184,85,220,198,217,31,74,214,34,151,148,120,28,140,211,208,207,43,96,52,220,
191,122,232,134,137,108,102,78,112,114,66,214,4,160,84,25,110,20,127,122,132,
127,230,165,221,196,77,137,163,235,230,13,111,204,138,29,23,8,14,228,254,181,
134,150,55,4,134,32,143,83,72,52,182,199,126,119,95,98,51,80,47,16,233,58,159,
108,26,78,99,161,153,30,60,100,200,126,152,52,53,154,0,219,243,181,46,100,231,
217,88,87,21,249,78,232,9,247,20,185,138,134,205,194,185,24,140,5,30,94,180,66,
26,105,3,202,193,71,254,252,169,81,46,63,240,193,166,4,227,151,2,21,6,180,139,
16,105,36,141,71,42,2,126,187,82,178,180,178,28,145,176,31,165,23,155,195,226,
140,125,168,4,54,228,33,253,107,94,196,96,72,19,1,70,227,206,176,210,19,189,64,
134,31,150,176,8,243,216,125,104,108,14,22,235,129,189,65,183,250,87,11,162,245,
98,71,210,179,222,175,229,243,243,52,172,102,97,98,199,149,118,90,35,133,92,
122,122,80,4,170,185,193,222,176,102,200,220,116,222,132,4,167,24,36,143,58,14,
77,98,89,129,217,69,102,33,182,88,129,64,19,138,69,65,158,166,143,28,164,157,
128,164,137,92,245,162,71,32,81,239,90,196,67,193,241,185,24,172,59,3,74,9,201,
27,214,30,92,13,141,110,132,48,198,185,64,142,76,245,53,202,161,29,121,138,206,
43,56,174,29,171,230,153,210,129,184,172,33,29,77,113,205,64,26,64,77,155,53,
30,181,138,205,48,51,237,82,9,235,89,140,121,154,38,51,77,32,37,108,131,152,
237,68,138,44,130,113,231,92,183,24,108,81,160,207,41,30,244,248,147,97,34,136,
16,192,250,82,115,196,67,13,186,213,189,154,169,99,154,148,144,5,144,178,128,
125,143,152,169,226,43,41,38,64,103,243,216,98,179,110,170,178,29,143,233,70,
145,63,140,192,250,208,176,85,243,239,73,198,138,26,117,229,60,165,113,154,94,
65,202,106,220,90,201,46,154,151,33,11,168,216,145,213,126,180,132,177,242,140,
145,225,61,13,20,0,226,184,146,55,5,9,207,150,244,254,156,77,204,161,100,189,17,
1,228,1,222,170,220,17,176,218,165,23,120,131,195,39,32,62,121,169,98,104,221,
44,215,74,129,147,189,82,224,99,188,230,111,159,253,41,105,215,71,89,90,91,25,
123,151,14,88,12,244,30,213,174,68,145,56,204,151,38,156,157,44,94,218,62,234,
224,247,170,216,32,142,163,214,148,73,70,215,101,171,65,127,111,253,159,117,26,
102,98,17,246,217,199,175,177,21,87,196,26,12,218,83,185,51,119,182,187,114,57,
59,224,250,253,42,190,91,121,116,247,133,243,204,24,6,141,193,200,106,217,53,
72,100,185,210,101,32,187,163,162,48,230,223,12,58,143,173,89,93,26,122,247,
150,151,9,44,44,65,7,59,86,235,44,246,250,239,14,136,166,199,120,163,153,51,212,
17,212,86,151,42,24,136,71,102,202,249,26,217,184,58,212,70,22,234,70,201,157,
72,0,249,47,253,232,64,205,62,88,22,25,240,122,55,74,148,150,216,1,150,158,215,
173,26,6,154,38,4,52,82,30,92,250,117,20,165,172,254,17,27,159,165,58,25,8,153,
149,188,193,198,244,205,179,71,58,50,75,112,170,87,229,45,66,156,109,204,189,69,
6,39,238,165,89,185,67,15,67,231,64,23,154,86,168,45,213,160,155,196,7,202,65,
200,62,212,211,180,55,81,55,118,65,86,24,62,181,70,47,213,216,3,105,31,46,124,
137,205,18,89,237,211,162,200,132,250,85,166,42,56,85,244,155,222,244,2,208,57,
241,85,165,194,69,60,29,236,120,100,97,157,191,173,82,220,223,36,150,221,209,37,
247,234,77,19,75,185,107,124,195,34,158,237,183,3,29,41,166,128,5,213,184,228,
45,142,155,17,73,42,242,184,32,116,233,87,93,236,77,36,136,115,200,199,98,71,
74,175,187,183,48,191,170,158,134,138,0,124,160,97,148,120,78,227,216,213,205,
252,100,218,65,47,153,81,154,173,179,8,207,221,184,240,190,223,67,228,105,235,
57,139,194,109,165,108,242,108,135,219,210,180,138,66,98,165,71,41,192,235,74,
76,160,46,125,41,247,94,82,86,151,150,60,130,167,204,82,113,11,22,50,52,40,12,
99,198,124,253,40,150,151,183,81,243,4,145,176,255,0,48,61,26,160,64,102,94,
110,131,25,199,165,49,5,139,63,51,196,114,16,245,246,167,20,239,64,94,233,233,
53,199,118,183,73,225,35,0,249,129,86,87,90,100,182,44,163,60,202,248,109,186,
102,170,244,59,185,63,31,18,204,114,131,195,138,223,117,43,113,53,146,178,238,
84,2,43,214,241,177,41,197,191,102,51,116,202,41,33,231,133,102,140,0,19,3,3,
210,185,108,172,37,59,244,220,84,237,28,91,220,148,127,238,164,219,232,105,150,
129,150,96,203,189,117,70,23,180,69,139,92,34,202,133,128,199,138,141,35,119,
118,77,39,46,121,20,156,84,214,48,36,100,63,152,109,71,8,173,7,41,92,134,234,13,
111,8,9,179,174,175,38,123,139,166,150,93,217,206,245,119,162,242,199,42,186,
142,131,20,158,175,107,12,119,146,173,190,121,21,176,61,189,169,141,28,146,165,
79,81,94,126,52,227,147,102,175,162,203,83,135,9,223,39,215,106,118,193,98,188,
179,202,248,103,3,63,90,140,10,37,183,120,159,174,54,164,236,59,200,36,60,167,
12,167,99,94,138,165,43,244,204,159,67,44,165,88,100,16,202,115,86,145,160,49,
43,14,132,109,66,159,146,230,17,42,140,58,236,226,143,96,115,1,83,249,107,162,
17,169,18,202,93,103,66,91,219,129,113,17,85,152,12,28,141,154,181,125,119,64,
188,176,128,207,44,40,209,231,118,67,210,187,47,187,193,200,165,245,91,68,190,
176,150,213,152,168,145,72,200,242,174,95,43,194,134,68,218,236,168,100,104,233,
140,174,248,126,83,232,107,0,145,208,227,62,98,156,215,52,139,173,46,118,142,
225,50,160,248,93,126,83,85,241,73,202,192,31,150,190,91,36,92,37,198,74,142,
181,190,142,56,100,125,198,61,43,106,225,94,32,145,83,240,87,76,37,67,208,56,
200,199,165,107,115,77,19,175,41,7,216,226,128,172,99,96,65,193,21,151,79,69,
118,118,88,211,173,167,151,188,183,2,18,223,151,203,247,162,157,40,54,210,44,71,
30,168,1,173,107,69,226,126,230,215,185,186,133,103,81,182,231,12,62,134,154,
143,91,19,74,123,134,144,39,144,108,237,247,161,136,114,251,78,133,20,148,139,4,
249,174,213,89,200,81,176,91,122,180,143,88,188,136,97,78,199,232,105,107,155,
246,149,195,73,111,11,31,80,57,79,237,78,50,161,24,183,121,80,99,168,171,8,46,
148,237,38,71,191,165,87,197,119,110,127,189,136,129,236,212,119,123,70,222,11,
149,108,254,86,24,34,182,140,196,199,203,101,121,151,196,190,162,132,206,72,198,
78,7,149,47,7,124,9,104,78,121,122,224,143,233,83,19,49,108,75,1,250,141,170,
185,8,207,59,174,121,121,79,212,102,132,229,219,124,40,250,109,70,202,29,249,78,
63,90,31,121,31,54,31,106,57,1,20,92,252,206,71,219,52,120,227,81,184,149,79,
215,34,178,138,141,228,62,181,134,76,29,136,167,96,25,57,182,249,91,232,213,206,
103,70,59,48,165,193,52,69,97,141,201,171,139,161,7,19,191,230,6,179,248,156,47,
169,165,203,108,7,51,99,235,89,228,79,152,177,21,170,152,140,188,236,217,6,132,
197,143,74,227,50,41,240,22,30,181,6,184,199,94,82,61,8,163,152,25,206,122,245,
168,18,119,193,161,180,153,60,219,12,249,10,227,62,60,182,163,144,28,36,231,173,
112,190,219,154,192,117,45,226,93,171,7,148,231,202,154,96,103,157,66,231,206,
138,147,160,95,148,102,150,228,46,60,4,19,233,80,49,200,51,145,138,164,192,101,
230,4,109,81,18,99,106,88,43,143,42,150,27,210,181,136,131,25,106,92,251,82,248,
111,74,206,248,27,86,200,6,11,224,248,77,114,128,160,249,215,42,128,212,199,90,
139,154,149,14,74,249,211,160,27,111,92,229,172,121,209,60,170,64,9,216,212,147,
115,88,151,173,74,30,166,154,16,81,68,142,133,82,94,181,104,76,102,35,135,166,
17,8,109,169,88,250,138,126,47,154,172,150,17,15,40,243,6,156,142,69,112,84,
141,232,19,129,220,131,138,132,63,48,171,81,36,82,97,252,102,219,206,128,235,
215,30,180,220,255,0,223,26,3,84,184,148,89,104,23,143,20,50,194,55,4,124,167,
206,179,113,110,68,237,110,227,1,71,50,143,99,72,216,146,183,89,4,131,202,122,
85,213,217,56,70,207,139,113,159,60,109,89,180,5,20,240,242,100,14,180,36,181,
200,204,153,253,41,203,207,152,154,175,150,73,27,1,157,136,7,204,212,52,87,161,
158,75,117,80,25,112,163,169,243,161,76,108,206,59,142,241,91,59,146,118,253,43,
144,129,142,131,173,78,116,64,210,97,20,99,56,218,166,136,246,90,233,183,113,73,
108,116,235,182,204,79,188,79,252,141,91,53,133,233,143,77,130,9,152,30,83,202,
79,150,122,103,250,87,95,198,78,5,109,250,127,139,78,60,222,45,135,95,165,48,
145,14,47,178,24,143,80,141,113,207,180,171,232,113,214,139,101,35,27,43,85,142,
64,10,168,59,121,83,188,80,1,210,36,200,206,21,42,151,135,183,181,57,223,13,
183,182,226,154,5,208,207,31,2,166,222,112,155,220,197,202,127,243,15,254,107,
88,187,181,146,206,65,28,167,152,17,149,113,93,129,196,136,143,195,101,217,21,
153,112,84,145,146,55,242,173,91,88,0,217,169,35,39,34,168,164,202,152,228,230,
94,86,168,14,166,50,118,61,13,65,58,181,66,79,239,86,132,50,199,75,149,33,144,
161,81,205,235,231,77,206,81,152,161,198,24,100,109,85,50,18,25,72,216,211,211,
19,203,17,250,213,174,137,20,107,126,239,81,72,142,10,182,226,173,110,45,135,
114,38,81,146,187,237,72,95,255,0,245,80,31,62,83,87,86,164,181,136,230,57,250,
211,138,24,130,144,87,152,28,169,174,50,134,94,237,247,67,208,250,80,237,254,
121,71,144,99,71,27,161,171,91,17,94,136,99,144,250,171,96,209,185,25,37,230,92,
224,238,13,65,55,44,78,231,154,158,135,255,0,160,62,198,170,49,11,48,234,30,46,
113,215,206,151,157,124,33,128,166,227,254,225,232,77,253,201,173,40,66,112,68,
48,78,51,189,109,92,59,109,4,246,108,113,135,143,230,30,171,90,236,61,90,182,
46,19,36,95,128,14,1,82,15,189,111,227,69,114,68,203,161,43,155,85,134,245,196,
125,3,109,91,158,135,112,215,58,122,169,57,40,57,77,107,90,136,31,138,93,134,
235,254,102,174,248,100,144,28,14,152,175,67,198,92,114,82,51,158,208,61,78,219,
149,249,135,76,230,152,176,115,34,0,195,36,81,181,15,147,238,104,90,71,207,39,
254,90,234,74,178,104,207,208,123,136,1,78,241,122,174,245,128,1,64,227,165,53,
255,0,132,223,67,74,218,255,0,244,205,245,173,234,152,141,63,80,132,155,217,89,
134,1,99,250,212,44,63,133,112,51,208,156,26,182,215,192,19,54,0,27,10,171,63,
55,252,213,230,202,60,102,108,157,162,241,87,24,34,162,97,193,230,31,122,36,
127,34,253,5,29,43,189,43,70,76,20,36,171,100,31,168,245,167,237,19,150,82,7,
202,195,111,122,77,124,234,206,207,251,168,190,245,182,53,177,48,132,226,48,79,
165,104,26,222,185,168,174,162,210,219,78,209,198,15,133,113,149,32,86,251,115,
255,0,211,63,254,70,254,149,215,23,64,24,216,17,92,223,196,37,37,20,162,232,188,
105,10,234,58,246,165,119,3,71,51,194,209,182,204,189,208,173,102,72,202,147,
182,69,88,221,108,199,20,25,58,175,210,190,103,60,165,145,252,157,157,49,73,116,
32,107,132,156,15,60,84,228,249,207,214,160,107,141,154,7,180,117,87,223,108,
213,165,172,192,16,85,170,147,210,141,110,78,122,154,44,77,27,181,157,237,156,
232,34,189,143,203,2,72,206,24,127,173,55,253,157,100,203,207,13,234,200,190,
157,8,173,35,153,131,12,49,253,106,214,213,219,187,83,204,115,245,160,146,254,
93,54,48,187,48,35,212,28,208,13,156,72,63,188,81,142,185,169,91,59,152,193,46,
221,61,106,190,254,71,239,72,231,108,125,105,166,192,123,146,5,28,198,104,249,
64,234,173,189,15,189,102,254,234,32,19,249,156,228,213,111,230,7,218,138,187,
141,235,68,192,106,64,126,110,85,12,124,195,227,246,161,139,137,211,98,249,30,
251,214,108,192,50,12,128,106,206,72,227,49,47,240,215,167,165,85,136,173,75,
150,230,201,36,123,13,133,48,183,121,29,65,52,173,208,1,182,0,125,40,38,173,1,
100,47,28,124,200,8,172,173,228,62,121,6,171,148,156,117,53,147,214,168,11,88,
228,18,110,174,8,247,218,166,211,99,108,85,74,19,145,185,166,193,56,93,252,170,
172,145,166,150,60,122,250,212,8,140,169,45,231,230,41,103,235,83,63,221,210,
176,48,225,6,235,204,106,28,217,59,243,98,185,146,6,213,133,39,61,77,52,192,158,
223,205,183,184,168,191,50,142,162,164,181,137,126,90,164,192,31,61,99,189,62,
181,198,249,5,64,245,171,76,9,247,181,49,33,233,138,88,117,169,39,249,214,209,
144,154,24,220,159,155,244,172,242,183,173,7,202,141,17,60,149,186,98,51,202,
125,235,149,33,92,170,21,159,255,217};
static Fl_JPEG_Image image_launcher_bg_cz("launcher_bg_cz.jpg", idata_launcher_bg_cz);

void cUserInterface::cb_CBQPreset_i(Fl_Choice*, void*) {
  int lSelectedItem = CBQPreset->value();
cConfigFile* pPreset = mvPresets[lSelectedItem];

if(pPreset==NULL) return;

cLauncherHelper::UpdateConfigFileWithPreset(mpConfigFile, pPreset);
cLauncherHelper::SetInitialValues(mpConfigFile, this);
}
void cUserInterface::cb_CBQPreset(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBQPreset_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBQPreset[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Custom", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIQPLow = cUserInterface::menu_CBQPreset + 0;
Fl_Menu_Item* cUserInterface::MIQPMed = cUserInterface::menu_CBQPreset + 1;
Fl_Menu_Item* cUserInterface::MIQPHigh = cUserInterface::menu_CBQPreset + 2;
Fl_Menu_Item* cUserInterface::MIQPCustom = cUserInterface::menu_CBQPreset + 3;

void cUserInterface::cb_BDetectSettings_i(Fl_Button*, void*) {
  cLauncherHelper::DetectSettings(this, mpConfigFile, mvPresets, mpQualityChooser, msCardString);
}
void cUserInterface::cb_BDetectSettings(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_BDetectSettings_i(o,v);
}

void cUserInterface::cb_CBLanguage_i(Fl_Choice*, void*) {
  int lValue = CBLanguage->value();
const tString& sLangFile = mvLanguageFiles[lValue];
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Main", "StartLanguage", sLangFile);

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_CBLanguage(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBLanguage_i(o,v);
}

void cUserInterface::cb_CBResolution_i(Fl_Choice*, void*) {
  int lValue = (long int)CBResolution->mvalue()->user_data();
cVideoMode& vMode = mvVModes[lValue];
cLauncherHelper::UpdateConfigFile(this, mpConfigFile,"Screen", "Width", vMode.mvScreenSize.x);
cLauncherHelper::UpdateConfigFile(this, mpConfigFile,"Screen", "Height", vMode.mvScreenSize.y);
}
void cUserInterface::cb_CBResolution(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBResolution_i(o,v);
}

void cUserInterface::cb_ChBFullScreen_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Screen", "FullScreen", ChBFullScreen->value()==1);
}
void cUserInterface::cb_ChBFullScreen(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBFullScreen_i(o,v);
}

void cUserInterface::cb_CBShadowQ_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ShadowQuality", CBShadowQ->value());
}
void cUserInterface::cb_CBShadowQ(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBShadowQ_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBShadowQ[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISQLow = cUserInterface::menu_CBShadowQ + 0;
Fl_Menu_Item* cUserInterface::MISQMed = cUserInterface::menu_CBShadowQ + 1;
Fl_Menu_Item* cUserInterface::MISQHigh = cUserInterface::menu_CBShadowQ + 2;

void cUserInterface::cb_CBShadowRes_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ShadowResolution", CBShadowRes->value());
}
void cUserInterface::cb_CBShadowRes(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBShadowRes_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBShadowRes[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISRLow = cUserInterface::menu_CBShadowRes + 0;
Fl_Menu_Item* cUserInterface::MISRMed = cUserInterface::menu_CBShadowRes + 1;
Fl_Menu_Item* cUserInterface::MISRHigh = cUserInterface::menu_CBShadowRes + 2;

void cUserInterface::cb_BShowAdvanced_i(Fl_Button*, void*) {
  SetWidgetEnabled(GroupBasicGfxOptions, false);
SetWidgetVisible(GroupBasicGfxOptions, false);

SetWidgetEnabled(GroupAdvancedGfxOptions, true);
SetWidgetVisible(GroupAdvancedGfxOptions, true);
}
void cUserInterface::cb_BShowAdvanced(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_BShowAdvanced_i(o,v);
}

void cUserInterface::cb_CBTexQ_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureQuality", (CBTexQ->size()-1-1)-CBTexQ->value());
}
void cUserInterface::cb_CBTexQ(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBTexQ_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBTexQ[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MITQLow = cUserInterface::menu_CBTexQ + 0;
Fl_Menu_Item* cUserInterface::MITQMed = cUserInterface::menu_CBTexQ + 1;
Fl_Menu_Item* cUserInterface::MITQHigh = cUserInterface::menu_CBTexQ + 2;

void cUserInterface::cb_CBAnisotropy_i(Fl_Choice*, void*) {
  int lValue = (long int)CBAnisotropy->mvalue()->user_data();
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureAnisotropy", (float)lValue);
}
void cUserInterface::cb_CBAnisotropy(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBAnisotropy_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBAnisotropy[] = {
 {"Off", 0,  0, (void*)(1), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2x", 0,  0, (void*)(2), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"4x", 0,  0, (void*)(4), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"8x", 0,  0, (void*)(8), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"16x", 0,  0, (void*)(16), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIAnisotropyOff = cUserInterface::menu_CBAnisotropy + 0;

void cUserInterface::cb_ChBSSAO_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOActive", ChBSSAO->value()==1);
}
void cUserInterface::cb_ChBSSAO(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBSSAO_i(o,v);
}

void cUserInterface::cb_CBSSAORes_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOResolution", CBSSAORes->value());
}
void cUserInterface::cb_CBSSAORes(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBSSAORes_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBSSAORes[] = {
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISSAOResMed = cUserInterface::menu_CBSSAORes + 0;
Fl_Menu_Item* cUserInterface::MISSAOResHigh = cUserInterface::menu_CBSSAORes + 1;

void cUserInterface::cb_ChBEdgeSmooth_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "EdgeSmooth", ChBEdgeSmooth->value()==1);
}
void cUserInterface::cb_ChBEdgeSmooth(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBEdgeSmooth_i(o,v);
}

void cUserInterface::cb_CBTexFilter_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureFilter", CBTexFilter->value());
}
void cUserInterface::cb_CBTexFilter(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBTexFilter_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBTexFilter[] = {
 {"Nearest", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Bilinear", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Trilinear", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MITFilterNearest = cUserInterface::menu_CBTexFilter + 0;
Fl_Menu_Item* cUserInterface::MITFilterBilinear = cUserInterface::menu_CBTexFilter + 1;
Fl_Menu_Item* cUserInterface::MITFilterTrilinear = cUserInterface::menu_CBTexFilter + 2;

void cUserInterface::cb_ChBWaterReflect_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "WorldReflection", ChBWaterReflect->value()==1);
}
void cUserInterface::cb_ChBWaterReflect(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBWaterReflect_i(o,v);
}

void cUserInterface::cb_CBParallax_i(Fl_Choice*, void*) {
  int lSelectedItem = CBParallax->value();

cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ParallaxEnabled", lSelectedItem==1);
}
void cUserInterface::cb_CBParallax(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBParallax_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBParallax[] = {
 {"Off", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"On", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIParallaxOff = cUserInterface::menu_CBParallax + 0;
Fl_Menu_Item* cUserInterface::MIParallaxOn = cUserInterface::menu_CBParallax + 1;

void cUserInterface::cb_BShowBasic_i(Fl_Button*, void*) {
  SetWidgetEnabled(GroupAdvancedGfxOptions, false);
SetWidgetVisible(GroupAdvancedGfxOptions, false);

SetWidgetEnabled(GroupBasicGfxOptions, true);
SetWidgetVisible(GroupBasicGfxOptions, true);
}
void cUserInterface::cb_BShowBasic(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_BShowBasic_i(o,v);
}

void cUserInterface::cb_CBSSAOSamples_i(Fl_Choice*, void*) {
  int lValue = (long int)CBSSAOSamples->mvalue()->user_data();
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOSamples", lValue);
}
void cUserInterface::cb_CBSSAOSamples(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBSSAOSamples_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBSSAOSamples[] = {
 {"4", 0,  0, (void*)(4), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"8", 0,  0, (void*)(8), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"16", 0,  0, (void*)(16), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"32", 0,  0, (void*)(32), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void cUserInterface::cb_CBSoundDevices_i(Fl_Choice*, void*) {
  int lIndex = CBSoundDevices->value();
int lDevID;
if(lIndex<0 || lIndex>=(int)mvSoundDevices.size())
{
	lDevID = mpCurSndDev->GetID();
}
else
{
	iSoundDeviceIdentifier* pDev = mvSoundDevices[lIndex];
	lDevID = pDev->GetID();
}


cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Sound", "Device", lDevID);
}
void cUserInterface::cb_CBSoundDevices(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBSoundDevices_i(o,v);
}

void cUserInterface::cb_BLaunchGame_i(Fl_Button*, void*) {
  mlExitFlag = 1;
mpConfigFile->Save();

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BLaunchGame(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BLaunchGame_i(o,v);
}

void cUserInterface::cb_BCancel_i(Fl_Button*, void*) {
  mlExitFlag = 0;

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BCancel(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BCancel_i(o,v);
}

void cUserInterface::cb_BLaunchPTest_i(Fl_Button*, void*) {
  mlExitFlag = 2;
mpConfigFile->Save();

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BLaunchPTest(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BLaunchPTest_i(o,v);
}

void cUserInterface::cb_BReadRemember_i(Fl_Button*, void*) {
  cPlatform::OpenFileOnShell(_W("Remember - Short Story Collection.pdf"));
}
void cUserInterface::cb_BReadRemember(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->user_data()))->cb_BReadRemember_i(o,v);
}

Fl_Window* cUserInterface::CreateWindow() {
  { AddResolutionWindow = new Fl_Window(205, 135, "Add Custom Resolution");
    AddResolutionWindow->callback((Fl_Callback*)cb_AddResolutionWindow, (void*)(this));
    { BAddCustomResolution = new Fl_Return_Button(120, 95, 70, 25, "Add");
      BAddCustomResolution->callback((Fl_Callback*)cb_BAddCustomResolution);
    } // Fl_Return_Button* BAddCustomResolution
    { Fl_Button* o = new Fl_Button(15, 95, 80, 25, "Cancel");
      o->callback((Fl_Callback*)cb_Cancel);
    } // Fl_Button* o
    { ICustomWidth = new Fl_Value_Input(75, 15, 100, 25, "Width:");
      ICustomWidth->minimum(640);
      ICustomWidth->maximum(4000);
      ICustomWidth->step(1);
      ICustomWidth->value(640);
    } // Fl_Value_Input* ICustomWidth
    { ICustomHeight = new Fl_Value_Input(75, 55, 100, 25, "Height:");
      ICustomHeight->minimum(480);
      ICustomHeight->maximum(4000);
      ICustomHeight->step(1);
      ICustomHeight->value(480);
    } // Fl_Value_Input* ICustomHeight
    AddResolutionWindow->set_modal();
    AddResolutionWindow->end();
  } // Fl_Window* AddResolutionWindow
  { LauncherWindow = new Fl_Window(694, 554, "Amnesia: P\341""d Do Temnoty");
    LauncherWindow->box(FL_NO_BOX);
    LauncherWindow->color((Fl_Color)228);
    LauncherWindow->user_data((void*)(this));
    LauncherWindow->when(FL_WHEN_NEVER);
    { Fl_Group* o = new Fl_Group(0, 0, 695, 555);
      o->color(FL_BACKGROUND2_COLOR);
      o->image(image_launcher_bg_cz);
      o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      { Fl_Tabs* o = new Fl_Tabs(60, 330, 585, 175);
        { TabGeneral = new Fl_Group(60, 355, 585, 150, "General");
          { CBQPreset = new Fl_Choice(235, 405, 110, 20, "Quality:");
            CBQPreset->down_box(FL_BORDER_BOX);
            CBQPreset->callback((Fl_Callback*)cb_CBQPreset);
            CBQPreset->when(FL_WHEN_RELEASE_ALWAYS);
            CBQPreset->menu(menu_CBQPreset);
          } // Fl_Choice* CBQPreset
          { BDetectSettings = new Fl_Button(380, 405, 135, 20, "Detect");
            BDetectSettings->callback((Fl_Callback*)cb_BDetectSettings);
          } // Fl_Button* BDetectSettings
          { StringVideoDevice = new Fl_Box(235, 368, 405, 22);
            StringVideoDevice->align(Fl_Align(36|FL_ALIGN_INSIDE));
            StringVideoDevice->label(msCardString.c_str());
          } // Fl_Box* StringVideoDevice
          { LabelVideoDevice = new Fl_Box(235, 369, 405, 21, "Video Device:");
            LabelVideoDevice->align(Fl_Align(FL_ALIGN_LEFT));
          } // Fl_Box* LabelVideoDevice
          { CBLanguage = new Fl_Choice(235, 435, 110, 20, "Language:");
            CBLanguage->down_box(FL_BORDER_BOX);
            CBLanguage->callback((Fl_Callback*)cb_CBLanguage);
          } // Fl_Choice* CBLanguage
          TabGeneral->end();
        } // Fl_Group* TabGeneral
        { TabGraphics = new Fl_Group(60, 355, 585, 150, "Graphic Options");
          TabGraphics->hide();
          { GroupBasicGfxOptions = new Fl_Group(60, 355, 585, 150);
            { CBResolution = new Fl_Choice(190, 370, 115, 20, "Resolution:");
              CBResolution->down_box(FL_BORDER_BOX);
              CBResolution->callback((Fl_Callback*)cb_CBResolution);
              CBResolution->when(FL_WHEN_CHANGED);
            } // Fl_Choice* CBResolution
            { ChBFullScreen = new Fl_Check_Button(335, 370, 170, 20, "Full screen");
              ChBFullScreen->down_box(FL_DOWN_BOX);
              ChBFullScreen->callback((Fl_Callback*)cb_ChBFullScreen);
              ChBFullScreen->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBFullScreen
            { CBShadowQ = new Fl_Choice(220, 430, 85, 20, "Shadow quality:");
              CBShadowQ->down_box(FL_BORDER_BOX);
              CBShadowQ->callback((Fl_Callback*)cb_CBShadowQ);
              CBShadowQ->when(FL_WHEN_CHANGED);
              CBShadowQ->menu(menu_CBShadowQ);
            } // Fl_Choice* CBShadowQ
            { CBShadowRes = new Fl_Choice(490, 430, 90, 20, "Shadow resolution:");
              CBShadowRes->down_box(FL_BORDER_BOX);
              CBShadowRes->callback((Fl_Callback*)cb_CBShadowRes);
              CBShadowRes->when(FL_WHEN_CHANGED);
              CBShadowRes->menu(menu_CBShadowRes);
            } // Fl_Choice* CBShadowRes
            { BShowAdvanced = new Fl_Button(405, 480, 225, 20, "Show Advanced");
              BShowAdvanced->callback((Fl_Callback*)cb_BShowAdvanced);
            } // Fl_Button* BShowAdvanced
            { CBTexQ = new Fl_Choice(220, 400, 85, 20, "Texture quality:");
              CBTexQ->down_box(FL_BORDER_BOX);
              CBTexQ->callback((Fl_Callback*)cb_CBTexQ);
              CBTexQ->menu(menu_CBTexQ);
            } // Fl_Choice* CBTexQ
            GroupBasicGfxOptions->end();
          } // Fl_Group* GroupBasicGfxOptions
          { GroupAdvancedGfxOptions = new Fl_Group(60, 355, 585, 150);
            GroupAdvancedGfxOptions->hide();
            GroupAdvancedGfxOptions->deactivate();
            { CBAnisotropy = new Fl_Choice(450, 370, 120, 20, "Anisotropy:");
              CBAnisotropy->down_box(FL_BORDER_BOX);
              CBAnisotropy->callback((Fl_Callback*)cb_CBAnisotropy);
              CBAnisotropy->menu(menu_CBAnisotropy);
            } // Fl_Choice* CBAnisotropy
            { ChBSSAO = new Fl_Check_Button(130, 395, 65, 20, "SSAO");
              ChBSSAO->down_box(FL_DOWN_BOX);
              ChBSSAO->callback((Fl_Callback*)cb_ChBSSAO);
              ChBSSAO->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBSSAO
            { CBSSAORes = new Fl_Choice(450, 395, 120, 20, "SSAO Resolution:");
              CBSSAORes->down_box(FL_BORDER_BOX);
              CBSSAORes->callback((Fl_Callback*)cb_CBSSAORes);
              CBSSAORes->menu(menu_CBSSAORes);
            } // Fl_Choice* CBSSAORes
            { ChBEdgeSmooth = new Fl_Check_Button(130, 420, 155, 20, "Edge Smooth");
              ChBEdgeSmooth->down_box(FL_DOWN_BOX);
              ChBEdgeSmooth->callback((Fl_Callback*)cb_ChBEdgeSmooth);
            } // Fl_Check_Button* ChBEdgeSmooth
            { CBTexFilter = new Fl_Choice(225, 370, 80, 20, "Texture Filter:");
              CBTexFilter->down_box(FL_BORDER_BOX);
              CBTexFilter->callback((Fl_Callback*)cb_CBTexFilter);
              CBTexFilter->menu(menu_CBTexFilter);
            } // Fl_Choice* CBTexFilter
            { ChBWaterReflect = new Fl_Check_Button(130, 445, 155, 20, "Water reflection");
              ChBWaterReflect->down_box(FL_DOWN_BOX);
              ChBWaterReflect->callback((Fl_Callback*)cb_ChBWaterReflect);
              ChBWaterReflect->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBWaterReflect
            { CBParallax = new Fl_Choice(450, 445, 120, 20, "Parallax:");
              CBParallax->down_box(FL_BORDER_BOX);
              CBParallax->callback((Fl_Callback*)cb_CBParallax);
              CBParallax->menu(menu_CBParallax);
            } // Fl_Choice* CBParallax
            { BShowBasic = new Fl_Button(415, 480, 230, 20, "Show Basic");
              BShowBasic->callback((Fl_Callback*)cb_BShowBasic);
            } // Fl_Button* BShowBasic
            { CBSSAOSamples = new Fl_Choice(450, 420, 120, 20, "SSAO Samples:");
              CBSSAOSamples->down_box(FL_BORDER_BOX);
              CBSSAOSamples->callback((Fl_Callback*)cb_CBSSAOSamples);
              CBSSAOSamples->menu(menu_CBSSAOSamples);
            } // Fl_Choice* CBSSAOSamples
            GroupAdvancedGfxOptions->end();
          } // Fl_Group* GroupAdvancedGfxOptions
          TabGraphics->end();
        } // Fl_Group* TabGraphics
        { TabSound = new Fl_Group(60, 355, 585, 150, "Sound Options");
          TabSound->hide();
          { CBSoundDevices = new Fl_Choice(190, 370, 300, 20, "Device:");
            CBSoundDevices->down_box(FL_BORDER_BOX);
            CBSoundDevices->callback((Fl_Callback*)cb_CBSoundDevices);
          } // Fl_Choice* CBSoundDevices
          TabSound->end();
        } // Fl_Group* TabSound
        o->end();
      } // Fl_Tabs* o
      { BLaunchGame = new Fl_Button(225, 520, 115, 25, "Launch game");
        BLaunchGame->callback((Fl_Callback*)cb_BLaunchGame);
      } // Fl_Button* BLaunchGame
      { BCancel = new Fl_Button(350, 520, 115, 25, "Cancel");
        BCancel->callback((Fl_Callback*)cb_BCancel);
      } // Fl_Button* BCancel
      { BLaunchPTest = new Fl_Button(595, 520, 90, 25, "Justine");
        BLaunchPTest->labelfont(2);
        BLaunchPTest->callback((Fl_Callback*)cb_BLaunchPTest);
      } // Fl_Button* BLaunchPTest
      o->end();
    } // Fl_Group* o
    { BReadRemember = new Fl_Button(5, 520, 95, 25, "Remember");
      BReadRemember->labelfont(2);
      BReadRemember->callback((Fl_Callback*)cb_BReadRemember);
    } // Fl_Button* BReadRemember
    LauncherWindow->position(((float)(Fl::w()-LauncherWindow->w()))*0.5f, ((float)(Fl::h()-LauncherWindow->h()))*0.5f);
    LauncherWindow->set_modal();
    LauncherWindow->end();
  } // Fl_Window* LauncherWindow
  BShowAdvanced->value(0);

  cLauncherHelper::PopulateLanguages(mvLanguageFiles, gsDefaultGameLanguage, mpConfigFile, CBLanguage);
  cLauncherHelper::PopulateResolutions(mvVModes, mpConfigFile, CBResolution, this);

  mpCurSndDev = mpEngine->GetSound()->GetLowLevel()->GetCurrentSoundDevice();
  cLauncherHelper::PopulateSoundDevices(mvSoundDevices, mpCurSndDev, mpConfigFile, CBSoundDevices);
  cb_CBSoundDevices_i(NULL,NULL);

  cLauncherHelper::SetUpWidgetLabels(this, mlstLabels);
  cLauncherHelper::SetInitialValues(mpConfigFile,this);

  CheckEqualsPreset();
  return LauncherWindow;
}

cUserInterface::cUserInterface(int& alExitFlag, cConfigFile *apConfigFile, bool abConfigFileExists, bool abLastInitCrashed, const tString& asCardString, cQualityChooser* apChooser, const std::vector<cConfigFile*>& avPresets, cEngine* apEng) : mlExitFlag(alExitFlag) {
  Fl::scheme("plastic");

  if(abLastInitCrashed)
  	fl_message("Last settings crashed the game, falling back to defaults");

  mpConfigFile = apConfigFile;

  msCardString = asCardString;
  mpQualityChooser = apChooser;
  mvPresets = avPresets;

  mpEngine = apEng;

  mbSettingPreset = false;


  ////////////////////////////////////
  // Retrieve available languages
  mvLanguageFiles = cLauncherHelper::GetAvailableLanguages(gsGameLanguageFolder);

  ////////////////////////////////////
  // Retrieve video modes
  mvVModes = cLauncherHelper::GetAvailableVideoModes(mpConfigFile);

  ////////////////////////////////////
  // Retrieve sound devices
  mvSoundDevices = cLauncherHelper::GetAvailableSoundDevices();

  /////////////////////////////////////////////
  // If no config file was present, set 'medium' settings
  if(abConfigFileExists==false)
  	cLauncherHelper::UpdateConfigFileWithPreset(mpConfigFile, mvPresets[1]);

  Fl_Window* pWin = CreateWindow();
  char *argv[] = { " " };
  pWin->show(0,argv);
}

int cUserInterface::Run() {
  return Fl::run();
}

void cUserInterface::SetWidgetEnabled(Fl_Widget* apW, bool abX) {
  if(abX)
  	apW->show();
  else
  	apW->hide();
}

void cUserInterface::SetWidgetVisible(Fl_Widget* apW, bool abX) {
  if(abX)
  	apW->activate();
  else
  	apW->deactivate();
}

void cUserInterface::CheckEqualsPreset() {
  int lValue = cLauncherHelper::GetEqualPresetIndex(mpConfigFile, mvPresets);
  if(lValue==-1)
  	lValue = 3;

  CBQPreset->value(lValue);
}
