#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2024 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for sonic_system
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type

DOCUMENTATION = """
---
module: sonic_system
version_added: 1.0.0
notes:
- Tested against Enterprise SONiC Distribution by Dell Technologies.
- Supports C(check_mode).
author: Abirami N (@abirami-n)
short_description: Configure system parameters
description:
  - This module is used for configuration management of global system parameters on devices running Enterprise SONiC.
options:
  config:
    description:
      - Specifies the system related configurations
    type: dict
    suboptions:
      hostname:
        description:
          - Specifies the hostname of the SONiC device
        type: str
      interface_naming:
        description:
          - Specifies the type of interface-naming in device
        type: str
        choices:
          - standard
          - standard_extended
          - native
      anycast_address:
        description:
          - Specifies different types of anycast address that can be configured on the device
        type: dict
        suboptions:
          ipv4:
            description:
              - Enable or disable ipv4 anycast-address
            type: bool
          ipv6:
            description:
              - Enable or disable ipv6 anycast-address
            type: bool
          mac_address:
            description:
              - Specifies the mac anycast-address
            type: str
      auto_breakout:
        description:
          - Specifies auto-breakout status in the device
        version_added: 2.5.0
        type: str
        choices:
          - ENABLE
          - DISABLE
      load_share_hash_algo:
        description:
          - Specifies different types of ECMP Load share hash algorithm
        version_added: 2.5.0
        type: str
        choices:
          - CRC
          - XOR
          - CRC_32LO
          - CRC_32HI
          - CRC_CCITT
          - CRC_XOR
          - JENKINS_HASH_LO
          - JENKINS_HASH_HI
      audit_rules:
        description:
           - Specifies audit rule profile type.
           - Can be used on SONiC release versions 4.4.0 and above.
        version_added: 2.5.0
        type: str
        choices:
          - BASIC
          - DETAIL
          - CUSTOM
          - NONE
  state:
    description:
      - Specifies the operation to be performed on the system parameters configured on the device.
      - In case of merged, the input configuration will be merged with the existing system configuration on the device.
      - In case of deleted the existing system configuration will be removed from the device.
    default: merged
    choices: ['merged', 'replaced', 'overridden', 'deleted']
    type: str
"""
EXAMPLES = """
# Using deleted
#
# Before state:
# -------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard
#ip load-share hash algorithm JENKINS_HASH_HI

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      interface_naming: standard
      anycast_address:
        ipv6: true
      load_share_hash_algo: JENKINS_HASH_HI
    state: deleted

# After state:
# ------------
#!
#sonic(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable


# Using deleted
#
# Before state:
# -------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard
#ip load-share hash algorithm JENKINS_HASH_HI

- name: Delete all system related configs in device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
    state: deleted

# After state:
# ------------
#!
#sonic(config)#do show running-configuration
#!


# Using merged
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      interface_naming: standard
      anycast_address:
        ipv6: true
        ipv4: true
        mac_address: aa:bb:cc:dd:ee:ff
      load_share_hash_algo: JENKINS_HASH_HI
    state: merged

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard
#ip load-share hash algorithm JENKINS_HASH_HI

# Using replaced
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable

- name: Replace system configuration.
  sonic_system:
    config:
      hostname: sonic
      interface_naming: standard
    state: replaced

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#interface-naming standard

# Using replaced
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#interface-naming standard

- name: Replace system device configuration.
  sonic_system:
    config:
      hostname: sonic
      interface_naming: standard
      anycast_address:
        ipv6: true
        ipv4: true
      load_share_hash_algo: JENKINS_HASH_HI
    state: replaced

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard
#ip load-share hash algorithm JENKINS_HASH_HI

# Using overridden
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#ip load-share hash algorithm JENKINS_HASH_HI

- name: Override system configuration.
  sonic_system:
    config:
      hostname: sonic
      interface_naming: standard
      anycast_address:
        ipv4: true
        mac_address: bb:aa:cc:dd:ee:ff
      load_share_hash_algo: CRC_XOR
    state: overridden

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address bb:aa:cc:dd:ee:ff
#ip anycast-address enable
#interface-naming standard
#ip load-share hash algorithm CRC_XOR

# Using merged
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      interface_naming: standard
      auto_breakout: ENABLE
      load_share_hash_algo: JENKINS_HASH_HI
      audit_rules: BASIC
    state: merged

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#hostname SONIC
#interface-naming standard
#auto-breakout
#ip load-share hash algorithm JENKINS_HASH_HI
#auditd-system rules basic

# Using deleted
#
# Before state:
# -------------
#!
#SONIC(config)#do show running-configuration
#!
#hostname SONIC
#interface-naming standard
#auto-breakout
#ip load-share hash algorithm JENKINS_HASH_HI
#auditd-system rules basic

- name: Delete auto-breakout configuration on the device
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      auto_breakout: ENABLE
      load_share_hash_algo: JENKINS_HASH_HI
      audit_rules: BASIC
    state: deleted

# After state:
# ------------
#!
#sonic(config)#do show running-configuration
#!
#interface-naming standard

"""
RETURN = """
before:
  description: The configuration prior to the module invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
    as the parameters above.
after:
  description: The resulting configuration module invocation.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
    as the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['command 1', 'command 2', 'command 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.argspec.system.system import SystemArgs
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.config.system.system import System


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(argument_spec=SystemArgs.argument_spec,
                           supports_check_mode=True)

    result = System(module).execute_module()
    module.exit_json(**result)


if __name__ == '__main__':
    main()
