# Integration tests

This document provides information to work with the integration tests.

## Guidelines

A set of guidelines to follow when writing integrations tests.

### Prepare and cleanup

The integration tests use a small testing framework that helps to set up and teardown any resources needed or generated by the tests. This small testing framework is located in the `tests/integration/common` directory. The files within the `common` directory are then duplicated and kept in sync in all the integration tests targets (`tests/integration/targets/hcloud_*`).

- Use a `tasks/prepare.yml` file to set up resources needed during the tests.
- Use a `tasks/cleanup.yml` file to teardown resources from the `tasts/prepare.yml` tasks **and** the resources generated by the tests.
- Use a `tasks/test.yml` file to defines your tests.
- You may explode the tests into multiple `tasks/test-*.yml` files and import them in the `tasks/test.yml` file.
- The `tasks/cleanup.yml` file cannot use variables present in the `tasks/prepare.yml` file because cleanup should also run before the prepare tasks.

### Naming convention

The integration tests handle a lot of different variables, names, identifier. To reduce this complexity, make sure to use the following naming conventions:

- Any test resources MUST be registered using the `test_<resource>` variable name (e.g. `test_server` or `test_floating_ip`) and MUST be created and cleaned in the `tasks/prepare.yml` and `tasks/cleanup.yml`. The scope of this variable is the entire target.
- In `tasks/prepare.yml`, tasks names MUST start with: `Create test_<resource>` (e.g. `Create test_server` or `Create  test_floating_ip`)
- In `tasks/cleanup.yml`, tasks names MUST start with: `Cleanup test_<resource>` (e.g. `Cleanup test_server` or `Cleanup test_floating_ip`)
- Any fact starting with `_` is scoped to the current file and MUST NOT be used outside of it.
- Any test result MUST be registered using the `result` variable name unless it is required in a future test, in that case it MUST use the `<resource>` variable name as prefix.
