#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"


/* 
   checks to see if the current token is a known
   defined function.  returns either functptr or -1 if
   it's not a function
*/

int isfunction(char *token)
{
int t;
char *s;

  s=funct;

  for (t=0; t<functptr; t++)
  {
    if (strcasecmp(s,token)==0 && currdeffunct!=t) return t;
    s=s+strlen(s)+1;
  }

  return -1;
}

/* returns true even if the name matches currdeffunct. MHB 4/23/06 */
int isfunction2(char *token)
{
int t;
char *s;

  s=funct;

  for (t=0; t<functptr; t++)
  {
    if (strcasecmp(s,token)==0) return t;
    s=s+strlen(s)+1;
  }

  return -1;
}

int add_funct(char *token)
{
int t;
char *s;

  s=funct;

  for (t=0; t<functptr; t++)
  {
    s=s+strlen(s)+1;
  }

  if ((s-funct)+strlen(token)>FUNCTHEAP)
  {
    printf("Error: Function heap too small.  Please report this to mike@mikekohn.net\n");
    return 0;
  }

  strcpy(s,token);
  functptr++;
#ifdef DEBUG
printf("add_funct(): %s\n",token);
#endif

  return 0;
}


/* parse parameters in sub/function definition */
int parse_funct_parms(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];

  while((tokentype=gettoken(token))!=TOK_EOF)
  {
    switch (tokentype)
    {
      case TOK_COMMA:      strcat(newtoken,",");
                           if (spacer) strcat(newtoken," ");
                           break;
      case TOK_KEYWORD:    if (strcasecmp(token,"byref")==0)
                           { strcat(newtoken,"&"); }
                             else
                           if (strcasecmp(token,"byval")!=0)
                           { strcat(newtoken,"$"); strcat(newtoken,token); }
                           break;
      case TOK_UNDERSCORE: if ((tokentype=gettoken(token))==TOK_EOL) break;
      case TOK_PAREN:      if (strcmp(")",token)==0) return 0;
      default:             error(token,"parameter list","parse_funct_parms");
    }
  }

  return 0;
}


int parse_funct(int isfunct)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c;

  infunct=isfunct; 

  tokentype=gettoken(token);
  autoindent();
  if (inclass>0 && php>3)
  {
    if (strcasecmp(token,"public")==0 || strcasecmp(token,"private")==0)
    {
      if (php>4)
      { fprintf(out,"%s ",token); }
      tokentype=gettoken(token);
    }
    if (strcasecmp(token,"class_initialize")==0)
    {
      if (php>4)
      {
        fprintf(out,"function __construct");
      }
        else
      {
        fprintf(out,"function %s",classes);
      }
    }
      else
    if (strcasecmp(token,"class_terminate")==0)
    {
      if (php>4)
      {
        fprintf(out,"function __destruct");
      }
        else
      {
        fprintf(out,"function %s",token);
        printf("Warning: class_terminate will not be automatically called (line %d)\n",line);
      }
    }
      else
    {
      fprintf(out,"function %s",token);
    }
  }
    else
  {
    fprintf(out,"function %s",token);
  }

  currdeffunct=isfunction2(token);

#ifdef DEBUG
printf("parse_funct: %s (currdeffunct=%d, functptr=%d)\n",token,currdeffunct,functptr);
#endif

  tokentype=gettoken(token);
  newtoken[0]=0;

  if (strcmp(token,"(")==0)
  { parse_funct_parms(newtoken); fprintf(out,"(%s)",newtoken); }
    else
  { push(token,tokentype); fprintf(out,"()"); }

  fprintf(out,"\n");
  autoindent();

  fprintf(out,"{\n");
  autoindent();
  fprintf(out,"  extract($GLOBALS);\n");

  indent++;
  c=parse_body(0);

  autoindent();
  fprintf(out,"return $function_ret;\n");
  indent--;
  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);

  if (isfunct==1)
  {
    if (strcasecmp(token,"function")!=0 && strcasecmp(token,"property")!=0)
    { error(token,"function","parse_funct"); }
  }
    else
  if (isfunct==2)
  {
    if (strcasecmp(token,"sub")!=0 && strcasecmp(token,"property")!=0)
    { error(token,"sub","parse_funct"); }
  }
  infunct=0;
  currdeffunct=-1;

  return 0;
}

int eval_funct(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
int parencount=1;
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp("(",token)!=0)
  { 
    push(token,tokentype);
    strcat(newtoken,"()");
    /* error(token,"(","eval_funct"); */
    return 0; 
  }

  while((tokentype=gettoken(token))!=TOK_EOF)
  {
    if (strcmp("(",token)==0)
    { parencount++; strcat(newtoken,"("); }
      else
    if (strcmp(")",token)==0)
    {
      parencount--;
      if (parencount!=0)
      { strcat(newtoken,")"); }
        else
      { break; }
    }
      else
    if (strcmp(",",token)==0)
    { strcat(newtoken,","); }
      else
    {
      eval_element(molecule,tokentype,token);
      strcat(newtoken,molecule);
    }
  }

  return 0;
}

int find_null(char *s, int l)
{
  while(s[l]!=0)
  {
    l++;
    if (l>LINELENGTH) return 0;
  }

  return l;
}

/*

supress flags:

bit 0: supress parenthesis
bit 1: supress , between params. use . instead
bit 2: don't put more PHP params than there are asp params
bit 3: Fix windows paths in strings 
bit 4: This is an array, not a function

*/

void convert_funct(char *newtoken, char *params1, int suppress)
{
char params[256];
char molecule[LINELENGTH];
char temp[LINELENGTH];
int paramptr[50];
int param_count;
int parens,pflag,tokentype,isstring,t,m,l,k,n;
char token[TOKENSIZE];
char s[10];
char extra[256];

  strcpy(params,params1);
  parens=0;
  molecule[0]=0;
  pflag=0;
  isstring=0;

  param_count=0;
  paramptr[0]=0;

  tokentype=gettoken(token);

  if (strcmp(token,"(")==0)
  {
    parens++;
    pflag=1;
  }
    else
  { push(token,tokentype); }

  while(1)
  {
    tokentype=gettoken(token);
#ifdef DEBUG
printf("convert_funct(): %s (type=%i)\n",token,tokentype);
#endif
    /* if (tokentype==TOK_EOL) break; */
    if (tokentype==TOK_EOF) return;
    if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT) isstring=1;
    if (tokentype==TOK_COMMENT || tokentype==TOK_EOL || tokentype==TOK_ENDCODE || tokentype==TOK_COLON)
    {
      push(token,tokentype);
      break;
    }

    if (spacer==1) strcat(&molecule[paramptr[param_count]]," ");

    if (strcmp(token,"(")==0)
    {
      parens++;
      strcat(&molecule[paramptr[param_count]],"(");
    }
      else
    if (strcmp(token,")")==0)
    {
      parens--;
      if (parens==0 && pflag==1) break;
      if (parens<0)
      {
        push(token,tokentype);
        break;
      }
      strcat(&molecule[paramptr[param_count]],")");
    }
      else
    if (strcasecmp(token,"else")==0 || strcasecmp(token,"then")==0)
    {
      push(token,tokentype);
      break;
    }
      else
    if (strcasecmp(token,"mod")==0)
    { strcat(&molecule[paramptr[param_count]],"%"); }
      else
    if (strcasecmp(token,"=")==0)
    { strcat(&molecule[paramptr[param_count]],"=="); /* this would never be an assignment */ }
      else
    if (tokentype==TOK_ARITHOP || tokentype==TOK_NUMBER)
    { 
      strcat(&molecule[paramptr[param_count]],token);
#ifdef DEBUG
printf("convert_funct molecule: %s token: %s\n",&molecule[paramptr[param_count]],token);
#endif
    }
      else
    if (tokentype==TOK_UNDERSCORE)
    {
      strcat(&molecule[paramptr[param_count]],"\n");
      autoindent_string(&molecule[paramptr[param_count]]);
    }
      else
    if (tokentype==TOK_AMP)
    { strcat(&molecule[paramptr[param_count]],"."); }
      else
    if (tokentype==TOK_COMMA)
    {
      t=find_null(molecule,paramptr[param_count]);
#ifdef DEBUG
printf("convert_funct Found null: %d\n",t);
#endif
      param_count++;
      paramptr[param_count]=t+1;
      molecule[t+1]=0;
    }
      else
    if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
    {
      if ((suppress&8)!=0)
      { if (fixwin95paths==1) fixwinpath(token); }
      strcat(&molecule[paramptr[param_count]],token);
    }
      else
    {
      eval_element(temp,tokentype,token);
      strcat(&molecule[paramptr[param_count]],temp);
    }
  }

  if (parens!=0)
  { printf("Warning: Unbalanced parenthesis on line %d\n",line); } 

#ifdef DEBUG
  for (l=0; l<=param_count; l++)
  {
    printf("convert_funct >> %d: (%d),%s\n",l,paramptr[l],&molecule[paramptr[l]]);
  }
#endif

  strcat(params,"\n");
  t=strlen(params);
  s[0]=0;
  pflag=0;
  m=0;

  if ((suppress&16)==16)
  { strcat(newtoken,"["); }
    else
  if ((suppress&1)==0)
  { strcat(newtoken,"("); }

  extra[0]=0;

  for(l=0; l<t; l++)
  {
    if ((suppress&4)!=0 && pflag>param_count)
    { break; }

    if (params[l]=='-' || params[l]=='+' || params[l]=='@' || params[l]=='_')
    {
      k=0;
      while(params[l]!=',' && params[l]!='\n')
      { extra[k++]=params[l++]; }

      extra[k]=0;
#ifdef DEBUG
printf("convert_funct atoi extra=%d\n",atoi(extra));
#endif

      if (extra[0]=='@')
      {
        if (pflag!=0)
        {
          if ((suppress&2)==0)
          { strcat(newtoken,","); }
            else
          { strcat(newtoken,"."); }
        }
        strcat(newtoken,&extra[1]);

        s[0]=0;
        extra[0]=0;
        pflag++;
        m=0;

        if (params[l]=='\n') break;
        continue;
      }
    }

    if (params[l]==',' || params[l]=='\n')
    {
      s[m]=0;
      m=atoi(s);
      if (m!=0)
      {
        if (pflag!=0)
        {
          if ((suppress&16)==16)
          { strcat(newtoken,"]["); }
            else
          if ((suppress&2)==0)
          { strcat(newtoken,","); }
            else
          { strcat(newtoken,"."); }
        }

        m--;
        if (m<=param_count)
        {
          if (isnum(&molecule[paramptr[m]])==1 && atoi(extra)!=0)
          {
            n=atoi(&molecule[paramptr[m]])+atoi(extra);
            sprintf(extra,"%d",n);
#ifdef DEBUG
printf("convert_funct extra to append: %s\n",extra);
#endif
            strcat(newtoken,extra);
          }
            else
          {
            strcat(newtoken,&molecule[paramptr[m]]);
            strcat(newtoken,extra);
          }
        }

        s[0]=0;
        extra[0]=0;
        pflag++;
        m=0;
      }
      if (params[l]=='\n') break;
    }
      else
    { s[m++]=params[l]; }
  }

  if ((suppress&16)==16)
  { strcat(newtoken,"]"); }
    else
  if ((suppress&1)==0)
  { strcat(newtoken,")"); }
}


