/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.gui;

import com.ctreber.acearth.renderer.RenderTarget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PixelCanvas
implements RenderTarget {
    private final int fImageWidth;
    private final int fImageHeight;
    private final BufferedImage fEarthImage2;

    public PixelCanvas(int pWidth, int pHeight) {
        this.fImageWidth = pWidth;
        this.fImageHeight = pHeight;
        this.fEarthImage2 = new BufferedImage(this.fImageWidth, this.fImageHeight, 1);
    }

    public Graphics2D getGraphics2D() {
        return this.fEarthImage2.createGraphics();
    }

    @Override
    public void setPixel(int pX, int pY, int pA, int pR, int pG, int pB) {
        this.setPixel(pX, pY, new Color(pR, pG, pB, pA));
    }

    @Override
    public void setPixel(int pX, int pY, Color pColor) {
        this.fEarthImage2.setRGB(pX, pY, pColor.getRGB());
    }

    @Override
    public int getImageWidth() {
        return this.fImageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.fImageHeight;
    }

    public boolean saveToImage(String pFileName, String pFormat) throws IOException {
        return ImageIO.write((RenderedImage)this.fEarthImage2, pFormat, new File(pFileName));
    }

    public void saveToImage(OutputStream os) throws IOException {
        ImageIO.write((RenderedImage)this.fEarthImage2, "png", os);
    }
}

