/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern p = MyPattern.cmpile("(?s)(?i)^[%s]*(@startuml[^\\n\\r]*)?[%s]*(.*?)[%s]*(@enduml)?[%s]*$");

    @Override
    public String compress(String data) throws IOException {
        UncommentReadLine r = new UncommentReadLine(new ReadLineReader(new StringReader(data), "COMPRESS"));
        StringBuilder sb = new StringBuilder();
        StringBuilder full = new StringBuilder();
        CharSequence2 s = null;
        boolean startDone = false;
        while ((s = r.readLine()) != null) {
            this.append(full, s);
            if (s.toString2().startsWith("@startuml")) {
                startDone = true;
                continue;
            }
            if (s.toString2().startsWith("@enduml")) {
                return sb.toString();
            }
            if (!startDone) continue;
            this.append(sb, s);
        }
        if (!startDone) {
            return this.compressOld(full.toString());
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, CharSequence2 s) {
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(s.toString2());
    }

    private String compressOld(String s) throws IOException {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return this.clean(m.group(2));
        }
        return "";
    }

    @Override
    public String decompress(String s) throws IOException {
        String result = this.clean(s);
        if (result.startsWith("@start")) {
            return result;
        }
        result = "@startuml\n" + result;
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        result = result + "@enduml";
        return result;
    }

    private String clean(String s) {
        s = StringUtils.trin(s);
        s = this.clean1(s);
        s = s.replaceAll("@enduml[^\\n\\r]*", "");
        s = s.replaceAll("@startuml[^\\n\\r]*", "");
        s = StringUtils.trin(s);
        return s;
    }

    private String clean1(String s) {
        Matcher m = p.matcher(s);
        if (m.matches()) {
            return m.group(2);
        }
        return s;
    }
}

