/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMinWidth
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final double minWidth;
    private final HorizontalAlignment horizontalAlignment;

    public TextBlockMinWidth(TextBlock textBlock, double minWidth, HorizontalAlignment horizontalAlignment) {
        this.textBlock = textBlock;
        this.minWidth = minWidth;
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.atLeast(dim, this.minWidth, 0.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.textBlock.drawU(ug);
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dim = this.textBlock.calculateDimension(ug.getStringBounder());
            double diffx = this.minWidth - dim.getWidth();
            this.textBlock.drawU(ug.apply(new UTranslate(diffx, 0.0)));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

