/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileIfOrigin
extends AbstractFtile {
    private final Ftile tile1;
    private final Ftile tile2;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final HtmlColor arrowColor;
    private Dimension2D calculateDimensionInternal;

    private FtileIfOrigin(Ftile diamond1, Ftile tile1, Ftile tile2, Ftile diamond2, HtmlColor arrowColor) {
        super(tile1.shadowing() || tile2.shadowing());
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
        this.tile1 = tile1;
        this.tile2 = tile2;
        this.arrowColor = arrowColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, UFont fontArrow, UFont fontTest, HtmlColor arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder) {
        AbstractFtile diamond2;
        AbstractFtile diamond1;
        Display labelTest = branch1.getLabelTest();
        FtileMinWidth tile1 = new FtileMinWidth(branch1.getFtile(), 30.0);
        FtileMinWidth tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        HtmlColor fontColor = skinParam.getFontHtmlColor(FontParam.ACTIVITY_DIAMOND, null);
        FontConfiguration fcArrow = new FontConfiguration(fontArrow, fontColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        FontConfiguration fcTest = new FontConfiguration(fontTest, fontColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        TextBlock tb1 = branch1.getLabelPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory, CreoleMode.SIMPLE_LINE);
        TextBlock tb2 = branch2.getLabelPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory, CreoleMode.SIMPLE_LINE);
        Sheet sheet = new CreoleParser(fcTest, HorizontalAlignment.LEFT, skinParam, CreoleMode.FULL).createSheet(labelTest);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0, skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), new UStroke(1.5));
        if (conditionStyle == ConditionStyle.INSIDE) {
            diamond1 = new FtileDiamondInside(tile1.shadowing(), backColor, borderColor, swimlane, tbTest).withWest(tb1).withEast(tb2);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            diamond1 = new FtileDiamond(tile1.shadowing(), backColor, borderColor, swimlane).withWest(tb1).withEast(tb2).withNorth(tbTest);
        } else {
            throw new IllegalStateException();
        }
        if (tile1.calculateDimension(stringBounder).hasPointOut() && tile2.calculateDimension(stringBounder).hasPointOut()) {
            Display out1 = LinkRendering.getDisplay(branch1.getFtile().getOutLinkRendering());
            TextBlock tbout1 = out1 == null ? null : out1.create(fcArrow, HorizontalAlignment.LEFT, ftileFactory, CreoleMode.SIMPLE_LINE);
            Display out2 = LinkRendering.getDisplay(branch2.getFtile().getOutLinkRendering());
            TextBlock tbout2 = out2 == null ? null : out2.create(fcArrow, HorizontalAlignment.LEFT, ftileFactory, CreoleMode.SIMPLE_LINE);
            diamond2 = new FtileDiamond(tile1.shadowing(), backColor, borderColor, swimlane).withWest(tbout1).withEast(tbout2);
        } else {
            diamond2 = new FtileEmpty(tile1.shadowing(), 24.0, 24.0, swimlane, swimlane);
        }
        FtileIfOrigin result = new FtileIfOrigin(diamond1, tile1, tile2, diamond2, arrowColor);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileIfOrigin ftileIfOrigin = result;
        ftileIfOrigin.getClass();
        conns.add(ftileIfOrigin.new ConnectionHorizontalThenVertical(tile1, branch1));
        FtileIfOrigin ftileIfOrigin2 = result;
        ftileIfOrigin2.getClass();
        conns.add(ftileIfOrigin2.new ConnectionHorizontalThenVertical(tile2, branch2));
        if (tile1.calculateDimension(stringBounder).hasPointOut() && tile2.calculateDimension(stringBounder).hasPointOut()) {
            FtileIfOrigin ftileIfOrigin3 = result;
            ftileIfOrigin3.getClass();
            conns.add(ftileIfOrigin3.new ConnectionVerticalThenHorizontal(tile1, branch1.getInlinkRenderingColor(), branch1.isEmpty()));
            FtileIfOrigin ftileIfOrigin4 = result;
            ftileIfOrigin4.getClass();
            conns.add(ftileIfOrigin4.new ConnectionVerticalThenHorizontal(tile2, branch2.getInlinkRenderingColor(), branch2.isEmpty()));
        } else if (tile1.calculateDimension(stringBounder).hasPointOut() && !tile2.calculateDimension(stringBounder).hasPointOut()) {
            FtileIfOrigin ftileIfOrigin5 = result;
            ftileIfOrigin5.getClass();
            conns.add(ftileIfOrigin5.new ConnectionVerticalThenHorizontalDirect(tile1, branch1.getInlinkRenderingColor(), branch1.isEmpty()));
        } else if (!tile1.calculateDimension(stringBounder).hasPointOut() && tile2.calculateDimension(stringBounder).hasPointOut()) {
            FtileIfOrigin ftileIfOrigin6 = result;
            ftileIfOrigin6.getClass();
            conns.add(ftileIfOrigin6.new ConnectionVerticalThenHorizontalDirect(tile2, branch2.getInlinkRenderingColor(), branch2.isEmpty()));
        }
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    private HtmlColor getInColor(Branch branch) {
        if (branch.isEmpty()) {
            return LinkRendering.getColor(branch.getFtile().getOutLinkRendering(), this.arrowColor);
        }
        LinkRendering linkIn = branch.getFtile().getInLinkRendering();
        HtmlColor color = linkIn == null ? this.arrowColor : linkIn.getColor();
        return color;
    }

    private UTranslate getTranslate1(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        double x1 = 0.0;
        double h = ((Dimension2D)dimDiamond1).getHeight();
        double y1 = h * 1.9;
        return new UTranslate(0.0, y1);
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = dimTotal.getWidth() - ((Dimension2D)dim2).getWidth();
        double h = ((Dimension2D)dimDiamond1).getHeight();
        double y2 = h * 1.9;
        return new UTranslate(x2, y2);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = this.getLeft(stringBounder) - ((Dimension2D)dimDiamond1).getWidth() / 2.0;
        return new UTranslate(x1, 0.0);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - ((Dimension2D)dimDiamond2).getHeight();
        double x2 = this.getLeft(stringBounder) - ((Dimension2D)dimDiamond2).getWidth() / 2.0;
        return new UTranslate(x2, y2);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (child == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (child == this.diamond2) {
            return this.getTranslateDiamond2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        ug.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        if (this.tile1.calculateDimension(stringBounder).hasPointOut() || this.tile2.calculateDimension(stringBounder).hasPointOut()) {
            return new FtileGeometry(dimTotal, this.getLeft(stringBounder), 0.0, dimTotal.getHeight());
        }
        return new FtileGeometry(dimTotal, this.getLeft(stringBounder), 0.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionInternalSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double withInner = Math.max(((Dimension2D)dimDiamond1).getWidth(), dim1.getWidth() - dim1.getLeft() + dim2.getLeft() + 10.0);
        double width = dim1.getLeft() + withInner + (dim2.getWidth() - dim2.getLeft());
        Dimension2D dim12 = Dimension2DDouble.mergeLR(dim1, dim2);
        return new Dimension2DDouble(width + 30.0, dim12.getHeight() + ((Dimension2D)dimDiamond1).getHeight() * 3.0 + 30.0);
    }

    private double getLeft(StringBounder stringBounder) {
        double left1 = this.tile1.calculateDimension(stringBounder).translate(this.getTranslate1(stringBounder)).getLeft();
        double left2 = this.tile2.calculateDimension(stringBounder).translate(this.getTranslate2(stringBounder)).getLeft();
        return (left1 + left2) / 2.0;
    }

    class ConnectionVerticalThenHorizontalDirect
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontalDirect(Ftile tile, HtmlColor myArrowColor, boolean branchEmpty) {
            super(tile, FtileIfOrigin.this.diamond2);
            this.myArrowColor = myArrowColor == null ? FtileIfOrigin.this.arrowColor : myArrowColor;
            this.branchEmpty = branchEmpty;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Dimension2D dimTotal = FtileIfOrigin.this.calculateDimensionInternal(stringBounder);
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double p2 = new Point2D.Double(FtileIfOrigin.this.getLeft(stringBounder), dimTotal.getHeight() - 12.0);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = ((Point2D)p2).getX();
            double y2 = ((Point2D)p2).getY();
            Snake snake = new Snake(this.myArrowColor);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            snake.addPoint(x2, dimTotal.getHeight());
            ug.draw(snake);
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfOrigin.this.tile1) {
                return FtileIfOrigin.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfOrigin.this.tile2) {
                return FtileIfOrigin.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Dimension2D dimTotal = FtileIfOrigin.this.calculateDimensionInternal(stringBounder);
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double p2 = new Point2D.Double(FtileIfOrigin.this.getLeft(stringBounder), dimTotal.getHeight() - 12.0);
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            Snake snake = new Snake(this.myArrowColor);
            double x1 = mp1a.getX();
            double x2 = mp2b.getX();
            double y2 = mp2b.getY();
            snake.addPoint(mp1a);
            snake.addPoint(x1, y2);
            snake.addPoint(mp2b);
            snake.addPoint(x2, dimTotal.getHeight());
            ug.draw(snake);
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontal(Ftile tile, HtmlColor myArrowColor, boolean branchEmpty) {
            super(tile, FtileIfOrigin.this.diamond2);
            this.myArrowColor = myArrowColor == null ? FtileIfOrigin.this.arrowColor : myArrowColor;
            this.branchEmpty = branchEmpty;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            UPolygon arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = new Snake(this.myArrowColor, arrow);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            UPolygon arrow;
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p2 = this.getP2(stringBounder);
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Direction originalDirection = Direction.leftOrRight(p1, p2);
            double x1 = p1.getX();
            double x2 = p2.getX();
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            Direction newDirection = Direction.leftOrRight(mp1a, mp2b);
            UPolygon uPolygon = arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
            if (originalDirection == newDirection) {
                double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double mp2bc = new Point2D.Double(mp2b.getX() + delta, mp2b.getY());
                Snake snake = new Snake(this.myArrowColor);
                double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
                snake.addPoint(mp1a);
                snake.addPoint(mp1a.getX(), middle);
                snake.addPoint(((Point2D)mp2bc).getX(), middle);
                snake.addPoint(mp2bc);
                ug.draw(snake);
                Snake small = new Snake(this.myArrowColor, arrow);
                small.addPoint(mp2bc);
                small.addPoint(((Point2D)mp2bc).getX(), mp2b.getY());
                small.addPoint(mp2b);
                ug.draw(small);
            } else {
                double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double mp2bb = new Point2D.Double(mp2b.getX() + delta, mp2b.getY() - 36.0);
                Snake snake = new Snake(this.myArrowColor);
                snake.addPoint(mp1a);
                snake.addPoint(mp1a.getX(), ((Point2D)mp2bb).getY());
                snake.addPoint(mp2bb);
                ug.draw(snake);
                Snake small = new Snake(this.myArrowColor, arrow);
                small.addPoint(mp2bb);
                small.addPoint(((Point2D)mp2bb).getX(), mp2b.getY());
                small.addPoint(mp2b);
                ug.draw(small);
            }
        }

        private Point2D getP2(StringBounder stringBounder) {
            double x;
            FtileGeometry dimDiamond2 = FtileIfOrigin.this.diamond2.calculateDimension(stringBounder);
            double diamondWidth = ((Dimension2D)dimDiamond2).getWidth();
            if (this.getFtile1() == FtileIfOrigin.this.tile1) {
                x = 0.0;
            } else if (this.getFtile1() == FtileIfOrigin.this.tile2) {
                x = diamondWidth;
            } else {
                throw new IllegalStateException();
            }
            return FtileIfOrigin.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(x, ((Dimension2D)dimDiamond2).getHeight() / 2.0));
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfOrigin.this.tile1) {
                return FtileIfOrigin.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfOrigin.this.tile2) {
                return FtileIfOrigin.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor color;
        private final UPolygon usingArrow;

        public ConnectionHorizontalThenVertical(Ftile tile, Branch branch) {
            super(FtileIfOrigin.this.diamond1, tile);
            this.color = FtileIfOrigin.this.getInColor(branch);
            this.usingArrow = branch.isEmpty() ? null : Arrows.asToDown();
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = new Snake(this.color, this.usingArrow);
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            Direction newDirection;
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Direction originalDirection = Direction.leftOrRight(p1, p2);
            if (originalDirection != (newDirection = Direction.leftOrRight(p1 = translate1.getTranslated(p1), p2 = translate2.getTranslated(p2)))) {
                double delta = (double)(originalDirection == Direction.RIGHT ? -1 : 1) * 12.0;
                FtileGeometry dimDiamond1 = FtileIfOrigin.this.diamond1.calculateDimension(stringBounder);
                Snake small = new Snake(this.color);
                small.addPoint(p1);
                small.addPoint(p1.getX() + delta, p1.getY());
                small.addPoint(p1.getX() + delta, p1.getY() + ((Dimension2D)dimDiamond1).getHeight() * 0.75);
                ug.draw(small);
                p1 = small.getLast();
            }
            Snake snake = new Snake(this.color, this.usingArrow);
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            double x;
            FtileGeometry dimDiamond1 = FtileIfOrigin.this.diamond1.calculateDimension(stringBounder);
            double diamondWidth = ((Dimension2D)dimDiamond1).getWidth();
            if (this.getFtile2() == FtileIfOrigin.this.tile1) {
                x = 0.0;
            } else if (this.getFtile2() == FtileIfOrigin.this.tile2) {
                x = diamondWidth;
            } else {
                throw new IllegalStateException();
            }
            return FtileIfOrigin.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(x, ((Dimension2D)dimDiamond1).getHeight() / 2.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.translate(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile2() == FtileIfOrigin.this.tile1) {
                return FtileIfOrigin.this.getTranslate1(stringBounder);
            }
            if (this.getFtile2() == FtileIfOrigin.this.tile2) {
                return FtileIfOrigin.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }
}

