/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleSpace
implements Command {
    private final Pattern pattern;

    private CommandCreoleSpace(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    public static Command create() {
        return new CommandCreoleSpace("^(?i)(\\<space:(\\d+)/?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        int size = Integer.parseInt(m.group(2));
        stripe.addSpace(size);
        return line.substring(m.group(1).length());
    }
}

