/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class ElementText
extends AbstractElement {
    private final TextBlock block;
    private final boolean show;
    private final String text;

    public ElementText(List<String> text, UFont font, ISkinSimple spriteContainer) {
        FontConfiguration config = new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true);
        this.block = Display.create(text).create(config, HorizontalAlignment.LEFT, spriteContainer);
        this.show = !text.get(0).equals(".");
        this.text = text.get(0);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        if (this.show) {
            this.block.drawU(ug);
        }
    }

    public final String getText() {
        return this.text;
    }
}

