/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class ArrowAndNoteBox
extends Arrow
implements InGroupable {
    private final Arrow arrow;
    private final NoteBox noteBox;

    public ArrowAndNoteBox(StringBounder stringBounder, Arrow arrow, NoteBox noteBox) {
        super(arrow.getStartingY(), arrow.getSkin(), arrow.getArrowComponent(), arrow.getUrl());
        this.arrow = arrow;
        this.noteBox = noteBox;
        double arrowHeight = arrow.getPreferredHeight(stringBounder);
        double noteHeight = noteBox.getPreferredHeight(stringBounder);
        double myHeight = this.getPreferredHeight(stringBounder);
        double diffHeightArrow = myHeight - arrowHeight;
        double diffHeightNote = myHeight - noteHeight;
        if (diffHeightArrow > 0.0) {
            arrow.pushToDown(diffHeightArrow / 2.0);
        }
        if (diffHeightNote > 0.0) {
            noteBox.pushToDown(diffHeightNote / 2.0);
        }
    }

    @Override
    public final double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder);
    }

    @Override
    public void setMaxX(double m) {
        super.setMaxX(m);
        this.arrow.setMaxX(m);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        this.arrow.drawU(ug, maxX, context);
        this.noteBox.drawU(ug, maxX, context);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return Math.max(this.arrow.getPreferredHeight(stringBounder), this.noteBox.getPreferredHeight(stringBounder));
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double w = this.arrow.getPreferredWidth(stringBounder);
        w = Math.max(w, this.arrow.getActualWidth(stringBounder));
        return w + this.noteBox.getPreferredWidth(stringBounder);
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return Math.min(this.arrow.getStartingX(stringBounder), this.noteBox.getStartingX(stringBounder));
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return this.arrow.getDirection(stringBounder);
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYStartLevel(stringBounder);
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYEndLevel(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        return this.arrow.getParticipantAt(stringBounder, position);
    }
}

