/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.MiddleCircleCircledMode;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class MiddleCircleCircled
extends Extremity {
    private final double angle;
    private final MiddleCircleCircledMode mode;
    private final double radius1 = 6.0;
    private final UEllipse circle = new UEllipse(12.0, 12.0);
    private final double radius2 = 10.0;
    private final UEllipse bigcircle = new UEllipse(20.0, 20.0);

    public MiddleCircleCircled(double angle, MiddleCircleCircledMode mode) {
        this.angle = angle;
        this.mode = mode;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
        if (this.mode == MiddleCircleCircledMode.BOTH) {
            ug.apply(new UChangeColor(HtmlColorUtils.WHITE)).apply(new UTranslate(-10.0, -10.0)).draw(this.bigcircle);
        }
        ug = ug.apply(new UStroke(1.5));
        double d = 0.0;
        if (this.mode == MiddleCircleCircledMode.MODE1 || this.mode == MiddleCircleCircledMode.BOTH) {
            UEllipse arc1 = new UEllipse(20.0, 20.0, this.angle, 90.0);
            ug.apply(new UTranslate(-10.0, -10.0)).draw(arc1);
        }
        if (this.mode == MiddleCircleCircledMode.MODE2 || this.mode == MiddleCircleCircledMode.BOTH) {
            UEllipse arc2 = new UEllipse(20.0, 20.0, this.angle + 180.0, 90.0);
            ug.apply(new UTranslate(-10.0, -10.0)).draw(arc2);
        }
        ug.apply(new UTranslate(-6.0, -6.0)).draw(this.circle);
    }
}

