// bbload.hh for bbsload - an tool to display the average load in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

extern "C" {
#include <apm.h>
}

#include "Image.hh"
#include "Basewindow.hh"
#include "resource.hh"

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class BaseResource;
class Basewindow;

struct PIXMAP {
    Pixmap  frame;
    Pixmap  label;
    Pixmap  loadbar_active;
    Pixmap  loadbar_inactive;
};

struct LABELSIZE {
    int seperator_width;
    int space_width;
    int width[8];
    int total_width;
    int height;
};

struct FRAMESIZE {
	int x;
	int y;
    int height;
    int width;
};

struct GEOM {
    int x;
    int y;
    int width;
    int height;
    double level;
};

class ToolWindow : public Basewindow 
{
public:
    ToolWindow(int argc,char **argv);
    ~ToolWindow(void);

    Window framewin;
    Window labelwin;
    Window loadwin;


    void MakeWindow(bool);
    void ReadAPM(void);
    void Redraw(void);
    void EventLoop(void);
    void Reconfigure(void);
    void CheckConfig(void);
    bool raised;

private:

    XGCValues gcv;
    GC frameGC;
    Resource *resource;
    struct LABELSIZE label;
    struct FRAMESIZE frame;
    struct GEOM *load;

    bool close_app;
    bool mapped;
    XPoint points[11];
    struct PIXMAP pixmap;
    bool broken;

    apm_info apm;
};

#endif /* __MAIN_HH */
