// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/plugin/check/v1/category.proto

package checkv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A category that a CheckService implements.
//
// Buf uses categories to include or exclude sets of rules via configuration.
type Category struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the category.
	//
	// Required.
	//
	// This uniquely identifies the Category.
	//
	// Category IDs must also be unique relative to Rule IDs.
	//
	// Rule and Category IDs must be unique across all plugins used at the same time with
	// Buf. That is, no two plugins can both publish the same Rule or Category ID.
	//
	// This must have at least three characters.
	// This must start and end with a capital letter from A-Z or digits from 0-9, and only
	// consist of capital letters from A-Z, digits from 0-0, and underscores.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A user-displayable purpose of the category.
	//
	// Required.
	//
	// This should be a proper sentence that starts with a capital letter and ends in a period.
	Purpose string `protobuf:"bytes,2,opt,name=purpose,proto3" json:"purpose,omitempty"`
	// Whether or not this Category is deprecated.
	//
	// If the Category is deprecated, it may be replaced by 0 or more Categories. These will be
	// denoted by replacement_ids.
	Deprecated bool `protobuf:"varint,3,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// The IDs of the Categories that replace this Category, if this Category is deprecated.
	//
	// This means that the combination of the Categories specified by replacement_ids replace this
	// Category entirely, and this Category is considered equivalent to the AND of the categories
	// specified by replacement_ids.
	//
	// This will only be non-empty if deprecated is true.
	// This may be empty even if deprecated is true.
	//
	// It is not valid for a deprecated Category to specfiy another deprecated Category as a
	// replacement.
	ReplacementIds []string `protobuf:"bytes,4,rep,name=replacement_ids,json=replacementIds,proto3" json:"replacement_ids,omitempty"`
}

func (x *Category) Reset() {
	*x = Category{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_category_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Category) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Category) ProtoMessage() {}

func (x *Category) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_category_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Category.ProtoReflect.Descriptor instead.
func (*Category) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_category_proto_rawDescGZIP(), []int{0}
}

func (x *Category) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Category) GetPurpose() string {
	if x != nil {
		return x.Purpose
	}
	return ""
}

func (x *Category) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Category) GetReplacementIds() []string {
	if x != nil {
		return x.ReplacementIds
	}
	return nil
}

var File_buf_plugin_check_v1_category_proto protoreflect.FileDescriptor

var file_buf_plugin_check_v1_category_proto_rawDesc = []byte{
	0x0a, 0x22, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb0, 0x03, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xba, 0x48, 0x27, 0xc8, 0x01, 0x01, 0x72, 0x22, 0x10, 0x03, 0x18, 0x40, 0x32, 0x1c, 0x5e,
	0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f,
	0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x35, 0x0a, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x1b, 0xba, 0x48, 0x18, 0xc8, 0x01, 0x01, 0x72, 0x13, 0x10, 0x02, 0x18, 0x80, 0x02, 0x32,
	0x0c, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x5d, 0x2e, 0x2a, 0x5b, 0x2e, 0x5d, 0x24, 0x52, 0x07, 0x70,
	0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x2c, 0xba, 0x48, 0x29, 0x92, 0x01, 0x26, 0x22, 0x24, 0x72, 0x22, 0x10, 0x03, 0x18, 0x40, 0x32,
	0x1c, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d,
	0x39, 0x5f, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x0e, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x3a, 0xb9, 0x01,
	0xba, 0x48, 0xb5, 0x01, 0x1a, 0xb2, 0x01, 0x0a, 0x2a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x6e, 0x74, 0x12, 0x36, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x74, 0x72, 0x75, 0x65, 0x20, 0x69, 0x66, 0x20,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x20,
	0x61, 0x72, 0x65, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x4c, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x68, 0x61, 0x73, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x73, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x29, 0x42, 0x54, 0x5a, 0x52, 0x62, 0x75, 0x66,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75,
	0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x76, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_plugin_check_v1_category_proto_rawDescOnce sync.Once
	file_buf_plugin_check_v1_category_proto_rawDescData = file_buf_plugin_check_v1_category_proto_rawDesc
)

func file_buf_plugin_check_v1_category_proto_rawDescGZIP() []byte {
	file_buf_plugin_check_v1_category_proto_rawDescOnce.Do(func() {
		file_buf_plugin_check_v1_category_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_plugin_check_v1_category_proto_rawDescData)
	})
	return file_buf_plugin_check_v1_category_proto_rawDescData
}

var file_buf_plugin_check_v1_category_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_check_v1_category_proto_goTypes = []any{
	(*Category)(nil), // 0: buf.plugin.check.v1.Category
}
var file_buf_plugin_check_v1_category_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_category_proto_init() }
func file_buf_plugin_check_v1_category_proto_init() {
	if File_buf_plugin_check_v1_category_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_plugin_check_v1_category_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Category); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_plugin_check_v1_category_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_check_v1_category_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_category_proto_depIdxs,
		MessageInfos:      file_buf_plugin_check_v1_category_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_category_proto = out.File
	file_buf_plugin_check_v1_category_proto_rawDesc = nil
	file_buf_plugin_check_v1_category_proto_goTypes = nil
	file_buf_plugin_check_v1_category_proto_depIdxs = nil
}
