// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/plugin/check/v1/check_service.proto

package checkv1

import (
	v1 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/descriptor/v1"
	v11 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/option/v1"
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A request to check FileDescriptors.
type CheckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FileDescriptors to check.
	//
	// Required.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	FileDescriptors []*v1.FileDescriptor `protobuf:"bytes,1,rep,name=file_descriptors,json=fileDescriptors,proto3" json:"file_descriptors,omitempty"`
	// The FileDescriptors to check against.
	//
	// Optional.
	//
	// This is usually the state of the FileDescriptors at a previous VCS commit, or the state of
	// the FileDescriptors at a release tag.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	//
	// Note that this may be empty, even for breaking change checks, to account for
	// going from the empty state to the first set of FileDescriptors.
	AgainstFileDescriptors []*v1.FileDescriptor `protobuf:"bytes,2,rep,name=against_file_descriptors,json=againstFileDescriptors,proto3" json:"against_file_descriptors,omitempty"`
	// Options for the Rules.
	//
	// Optional.
	//
	// Options may modify the behavior of a Rule.
	//
	// For now, callers are expected to know what keys are available, and how to construct Values
	// for each key. In the future, we may add a ListOptions or otherwise to CheckService that will
	// describe the available options keys, which can then be validated against.
	//
	// It is acceptable for a plugin to return an error on an unknown or misconstructed Option.
	Options []*v11.Option `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	// The IDs of the Rules to check.
	//
	// Optional. If not specified, all Rules returned by ListRules are checked.
	//
	// The maximum number of Rule IDs that can be sent in a single request is 250; if there are more
	// Rules that should be run, you must make multiple calls to Check.
	//
	// All IDs must be be IDs of Rules returned by ListRules.
	RuleIds []string `protobuf:"bytes,4,rep,name=rule_ids,json=ruleIds,proto3" json:"rule_ids,omitempty"`
}

func (x *CheckRequest) Reset() {
	*x = CheckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckRequest) ProtoMessage() {}

func (x *CheckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckRequest.ProtoReflect.Descriptor instead.
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{0}
}

func (x *CheckRequest) GetFileDescriptors() []*v1.FileDescriptor {
	if x != nil {
		return x.FileDescriptors
	}
	return nil
}

func (x *CheckRequest) GetAgainstFileDescriptors() []*v1.FileDescriptor {
	if x != nil {
		return x.AgainstFileDescriptors
	}
	return nil
}

func (x *CheckRequest) GetOptions() []*v11.Option {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *CheckRequest) GetRuleIds() []string {
	if x != nil {
		return x.RuleIds
	}
	return nil
}

// A response containing annotations that the check returned from failures.
type CheckResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotations produced from Rule failures.
	//
	// All Annotations must have IDs that match the IDs of the Rules returned by ListRules.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *CheckResponse) Reset() {
	*x = CheckResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse) ProtoMessage() {}

func (x *CheckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResponse.ProtoReflect.Descriptor instead.
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{1}
}

func (x *CheckResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// A request for the rules that the service implements.
type ListRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRulesRequest) Reset() {
	*x = ListRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesRequest) ProtoMessage() {}

func (x *ListRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRulesRequest.ProtoReflect.Descriptor instead.
func (*ListRulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListRulesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response containing the rules that the service implements.
type ListRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The rules that the service implements.
	//
	// The IDs of all Rules returned will be unique.
	// The IDs will also be unique relative to the Category IDs returned from ListCategories.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Rule within this list.
	Rules []*Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ListRulesResponse) Reset() {
	*x = ListRulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesResponse) ProtoMessage() {}

func (x *ListRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRulesResponse.ProtoReflect.Descriptor instead.
func (*ListRulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRulesResponse) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// A request for the categories that the service implements.
type ListCategoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCategoriesRequest) Reset() {
	*x = ListCategoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCategoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCategoriesRequest) ProtoMessage() {}

func (x *ListCategoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCategoriesRequest.ProtoReflect.Descriptor instead.
func (*ListCategoriesRequest) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListCategoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCategoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response containing the categories that the service implements.
type ListCategoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The categories that the service implements.
	//
	// The IDs of all Categories returned will be unique.
	// The IDs will also be unique relative to the Rule IDs returned from ListRules.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Category within this list.
	Categories []*Category `protobuf:"bytes,2,rep,name=categories,proto3" json:"categories,omitempty"`
}

func (x *ListCategoriesResponse) Reset() {
	*x = ListCategoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCategoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCategoriesResponse) ProtoMessage() {}

func (x *ListCategoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCategoriesResponse.ProtoReflect.Descriptor instead.
func (*ListCategoriesResponse) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_check_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListCategoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCategoriesResponse) GetCategories() []*Category {
	if x != nil {
		return x.Categories
	}
	return nil
}

var File_buf_plugin_check_v1_check_service_proto protoreflect.FileDescriptor

var file_buf_plugin_check_v1_check_service_proto_rawDesc = []byte{
	0x0a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x62, 0x75, 0x66, 0x2e, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x1a, 0x24,
	0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98, 0x06, 0x0a, 0x0c, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xbb, 0x02, 0x0a, 0x10, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x42, 0xe5,
	0x01, 0xba, 0x48, 0xe1, 0x01, 0xba, 0x01, 0xd8, 0x01, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x12, 0x23, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x1a, 0x92, 0x01, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x28, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2c, 0x20, 0x68, 0x61, 0x73, 0x28,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x29, 0x29, 0x2e, 0x6d, 0x61, 0x70, 0x28, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2c, 0x20, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x29, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x28,
	0x29, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xc5, 0x02, 0x0a, 0x18, 0x61, 0x67, 0x61, 0x69,
	0x6e, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x42, 0xe0, 0x01, 0xba, 0x48, 0xdc, 0x01, 0xba, 0x01, 0xd8, 0x01, 0x0a,
	0x1c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x12, 0x23, 0x46,
	0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x20, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x1a, 0x92, 0x01, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x28, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x2c, 0x20, 0x68, 0x61, 0x73, 0x28, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x29, 0x29, 0x2e, 0x6d, 0x61,
	0x70, 0x28, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x2c, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x29, 0x2e, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x28, 0x29, 0x52, 0x16, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x73, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0x36, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2f, 0xba, 0x48, 0x2c, 0x92, 0x01,
	0x29, 0x10, 0xfa, 0x01, 0x22, 0x24, 0x72, 0x22, 0x10, 0x03, 0x18, 0x40, 0x32, 0x1c, 0x5e, 0x5b,
	0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f, 0x5d,
	0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x07, 0x72, 0x75, 0x6c, 0x65,
	0x49, 0x64, 0x73, 0x22, 0x52, 0x0a, 0x0d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x62, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08,
	0xba, 0x48, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72,
	0x03, 0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x88, 0x01, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x57,
	0xba, 0x48, 0x54, 0xba, 0x01, 0x4c, 0x0a, 0x0f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x12, 0x17, 0x72, 0x75, 0x6c, 0x65, 0x20, 0x69, 0x64,
	0x73, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x1a, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x6d, 0x61, 0x70, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x29, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x28, 0x29, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x67,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xba, 0x48, 0x05, 0x2a,
	0x03, 0x18, 0xe8, 0x07, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x27,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xee, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05,
	0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0xa1, 0x01, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x62, 0xba, 0x48, 0x5f, 0xba, 0x01, 0x5c,
	0x0a, 0x13, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x12, 0x1b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x20,
	0x69, 0x64, 0x73, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x1a, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x6d, 0x61, 0x70, 0x28, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x2c, 0x20, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e,
	0x69, 0x64, 0x29, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x28, 0x29, 0x52, 0x0a, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x32, 0xb4, 0x02, 0x0a, 0x0c, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x05, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x12, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x5f,
	0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x25, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x6e, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42,
	0x54, 0x5a, 0x52, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e,
	0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62,
	0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_plugin_check_v1_check_service_proto_rawDescOnce sync.Once
	file_buf_plugin_check_v1_check_service_proto_rawDescData = file_buf_plugin_check_v1_check_service_proto_rawDesc
)

func file_buf_plugin_check_v1_check_service_proto_rawDescGZIP() []byte {
	file_buf_plugin_check_v1_check_service_proto_rawDescOnce.Do(func() {
		file_buf_plugin_check_v1_check_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_plugin_check_v1_check_service_proto_rawDescData)
	})
	return file_buf_plugin_check_v1_check_service_proto_rawDescData
}

var file_buf_plugin_check_v1_check_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_buf_plugin_check_v1_check_service_proto_goTypes = []any{
	(*CheckRequest)(nil),           // 0: buf.plugin.check.v1.CheckRequest
	(*CheckResponse)(nil),          // 1: buf.plugin.check.v1.CheckResponse
	(*ListRulesRequest)(nil),       // 2: buf.plugin.check.v1.ListRulesRequest
	(*ListRulesResponse)(nil),      // 3: buf.plugin.check.v1.ListRulesResponse
	(*ListCategoriesRequest)(nil),  // 4: buf.plugin.check.v1.ListCategoriesRequest
	(*ListCategoriesResponse)(nil), // 5: buf.plugin.check.v1.ListCategoriesResponse
	(*v1.FileDescriptor)(nil),      // 6: buf.plugin.descriptor.v1.FileDescriptor
	(*v11.Option)(nil),             // 7: buf.plugin.option.v1.Option
	(*Annotation)(nil),             // 8: buf.plugin.check.v1.Annotation
	(*Rule)(nil),                   // 9: buf.plugin.check.v1.Rule
	(*Category)(nil),               // 10: buf.plugin.check.v1.Category
}
var file_buf_plugin_check_v1_check_service_proto_depIdxs = []int32{
	6,  // 0: buf.plugin.check.v1.CheckRequest.file_descriptors:type_name -> buf.plugin.descriptor.v1.FileDescriptor
	6,  // 1: buf.plugin.check.v1.CheckRequest.against_file_descriptors:type_name -> buf.plugin.descriptor.v1.FileDescriptor
	7,  // 2: buf.plugin.check.v1.CheckRequest.options:type_name -> buf.plugin.option.v1.Option
	8,  // 3: buf.plugin.check.v1.CheckResponse.annotations:type_name -> buf.plugin.check.v1.Annotation
	9,  // 4: buf.plugin.check.v1.ListRulesResponse.rules:type_name -> buf.plugin.check.v1.Rule
	10, // 5: buf.plugin.check.v1.ListCategoriesResponse.categories:type_name -> buf.plugin.check.v1.Category
	0,  // 6: buf.plugin.check.v1.CheckService.Check:input_type -> buf.plugin.check.v1.CheckRequest
	2,  // 7: buf.plugin.check.v1.CheckService.ListRules:input_type -> buf.plugin.check.v1.ListRulesRequest
	4,  // 8: buf.plugin.check.v1.CheckService.ListCategories:input_type -> buf.plugin.check.v1.ListCategoriesRequest
	1,  // 9: buf.plugin.check.v1.CheckService.Check:output_type -> buf.plugin.check.v1.CheckResponse
	3,  // 10: buf.plugin.check.v1.CheckService.ListRules:output_type -> buf.plugin.check.v1.ListRulesResponse
	5,  // 11: buf.plugin.check.v1.CheckService.ListCategories:output_type -> buf.plugin.check.v1.ListCategoriesResponse
	9,  // [9:12] is the sub-list for method output_type
	6,  // [6:9] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_check_service_proto_init() }
func file_buf_plugin_check_v1_check_service_proto_init() {
	if File_buf_plugin_check_v1_check_service_proto != nil {
		return
	}
	file_buf_plugin_check_v1_annotation_proto_init()
	file_buf_plugin_check_v1_category_proto_init()
	file_buf_plugin_check_v1_rule_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_plugin_check_v1_check_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CheckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_plugin_check_v1_check_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CheckResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_plugin_check_v1_check_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_plugin_check_v1_check_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListRulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_plugin_check_v1_check_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ListCategoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_plugin_check_v1_check_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ListCategoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_plugin_check_v1_check_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_plugin_check_v1_check_service_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_check_service_proto_depIdxs,
		MessageInfos:      file_buf_plugin_check_v1_check_service_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_check_service_proto = out.File
	file_buf_plugin_check_v1_check_service_proto_rawDesc = nil
	file_buf_plugin_check_v1_check_service_proto_goTypes = nil
	file_buf_plugin_check_v1_check_service_proto_depIdxs = nil
}
