#include <unistd.h>
#include "outbuf.h"

static void print(const char *s)
{
  if (outbuf_puts(outbuf_1small,s) == -1) _exit(111);
}

int main(int argc,char **argv)
{
  char *name;
  char *value;
  unsigned char ch;
  char octal[4];

  name = argv[1];
  if (!name) _exit(100);
  value = argv[2];
  if (!value) _exit(100);

  print("const char ");
  print(name);
  print("[] = \"\\\n");

  while ((ch = *value++)) {
    print("\\");
    octal[3] = 0;
    octal[2] = '0' + (ch & 7); ch >>= 3;
    octal[1] = '0' + (ch & 7); ch >>= 3;
    octal[0] = '0' + (ch & 7);
    print(octal);
  }

  print("\\\n\";\n");
  if (outbuf_flush(outbuf_1small) == -1) _exit(111);
  _exit(0);
  return 0;
}
