Prerequisites:

* `python3` (for: build) (but you can skip this dependency by editing `conf-home` in other ways)
* `gcc` (for: build)

Make sure to [test](test.html) the compiled code.

### Installation scope {#scope}

The installation is of commands:
binaries
`cdbdump`, `cdbget`, `cdbmake`, `cdbstats`, `cdbtest`,
scripts
`cdbmake-12` and `cdbmake-sv`,
and the same for `cdb64`.

There is also a
[C API](cdb.html)
for reading databases,
but the library per se is not installed:
applications instead integrate the relevant C files
(currently
`cdb.h`,
`cdb.c`,
`cdb_hash.c`,
`byte.h`,
`byte_copy.c`,
`byte_diff.c`,
`inbuf.h`,
`inbuf_unixread.c`,
`seek.h`,
`seek_set.c`,
`num.h`).

### For sysadmins

To install in `/usr/local/bin`:

    make -j8 install

### For developers with an unprivileged account

Typically you'll already have

    export PATH="$HOME/bin:$PATH"

in `$HOME/.profile`. To install in `$HOME/bin`:

    ./configure --prefix=$HOME && make -j8 install

### For distributors creating a package

Run

    ./configure --prefix=/usr && make -j8

and then follow your usual packaging procedures
for the binaries and scripts.

### More options

You can edit the files `conf-cc` and `conf-ld`
to control the choices of compiler and linker.

For example,
`sed -i s/gcc/filcc/ conf-cc conf-ld`
switches from `gcc` to
[Fil-C](https://fil-c.org/).
Switching to Fil-C
is recommended for all applications
that (1) work with Fil-C and
(2) aren't a bottleneck for you.
This package works with Fil-C.
