#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "strerr.h"
#include "hier.h"

#define FATAL "instcheck: fatal: "
#define WARNING "instcheck: warning: "

static void perm(const char *prefix1,const char *prefix2,const char *prefix3,const char *file,num type,num mode)
{
  struct stat st;

  if (stat(file,&st) == -1) {
    if (errno == ENOENT)
      strerr_warn6(WARNING,prefix1,prefix2,prefix3,file," does not exist",0);
    else
      strerr_warn4(WARNING,"unable to stat .../",file,": ",&strerr_sys);
    return;
  }

  if ((st.st_mode & 07777) != mode)
    strerr_warn6(WARNING,prefix1,prefix2,prefix3,file," has wrong permissions",0);
  if ((st.st_mode & S_IFMT) != type)
    strerr_warn6(WARNING,prefix1,prefix2,prefix3,file," has wrong type",0);
}

void hier_h(const char *home,num mode)
{
  perm("","","",home,S_IFDIR,mode);
}

void hier_d(const char *home,const char *subdir,num mode)
{
  if (chdir(home) == -1)
    strerr_die4sys(111,FATAL,"unable to switch to ",home,": ");
  perm("",home,"/",subdir,S_IFDIR,mode);
}

void hier_c(const char *home,const char *subdir,const char *file,num mode)
{
  if (chdir(home) == -1)
    strerr_die4sys(111,FATAL,"unable to switch to ",home,": ");
  if (chdir(subdir) == -1)
    strerr_die6sys(111,FATAL,"unable to switch to ",home,"/",subdir,": ");
  perm(".../",subdir,"/",file,S_IFREG,mode);
}

int main(int argc,char **argv)
{
  hier();
  _exit(0);
  return 0;
}
