/*** DTB_USER_CODE_START vvv Add file header below vvv ***/
/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*** DTB_USER_CODE_END   ^^^ Add file header above ^^^ ***/

/*
 * File: color_chooser_stubs.c
 * Contains: Module callbacks and connection functions
 *
 * This file was generated by dtcodegen, from module color_chooser
 *
 * Any text may be added between the DTB_USER_CODE_START and
 * DTB_USER_CODE_END comments (even non-C code). Descriptive comments
 * are provided only as an aid.
 *
 *  ** EDIT ONLY WITHIN SECTIONS MARKED WITH DTB_USER_CODE COMMENTS.  **
 *  ** ALL OTHER MODIFICATIONS WILL BE OVERWRITTEN. DO NOT MODIFY OR  **
 *  ** DELETE THE GENERATED COMMENTS!                                 **
 */

#include <stdint.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include "dtb_utils.h"
#include "dtbuilder.h"
#include "color_chooser_ui.h"


/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All necessary header files have been included.
 ***
 *** Add include files, types, macros, externs, and user functions here.
 ***/

#include <math.h>
#include <Xm/DrawnB.h>
#include <ab_private/util.h>
#include "color_chooser_ui.h"

#include <Xm/Form.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>

/*
 * Declarations of global widgets used by callbacks.
 */
/*
 * End declarations of global widgets
 */

#define SWATCH_SZ	18
#define SHADOW_SZ	3
#include <Xm/Xm.h>
#include "dtbuilder.h"
#include "dtb_utils.h"
static int Answer;

Pixel objxm_name_to_pixel(Widget w, String color);
Pixel name_to_pixel(Widget w,String color);

static void 	swatchCB(
			Widget w,
			XtPointer clientdata,
			XtPointer calldata
		);

static void 	swatch_resizeCB(
			Widget w,
			XtPointer clientdata,
			XtPointer calldata
		);

static void 	helpCB(
			Widget w,
			XtPointer clientdata,
			XtPointer calldata
		);

static void	create_color_chooser();
static void	update_color_palette(Widget parent);

static void	create_color_palette(
		    	Widget parent
		);

char *display_color_chooser();

/* 
** The first two colors *MUST* be black and white so things work out
** O.K. on monochrome workstations.
*/
char *Color[] = {
        "Black", "White", "Dark Slate Gray", "Dim Gray", "Gray", 
	"Light Gray", "Yellow", "Gold", "Khaki", "Wheat", 
	"Tan", "Goldenrod", "Orange", "Coral", "Salmon", 
	"Red", "Orange Red", "Indian Red", "Firebrick", "Brown", 
	"Sienna", "Maroon", "Medium Violet Red", "Violet Red", "Pink", 
	"Green", "Spring Green", "Medium Spring Green", "Green Yellow", "Pale Green", 
	"Yellow Green", "Lime Green", "Medium Sea Green", "Sea Green", "Forest Green", 
	"Olive Drab", "Dark Olive Green", "Dark Green", "Cadet Blue", "Medium Aquamarine", 
	"Dark Turquoise", "Medium Turquoise","Turquoise", "Aquamarine", "Cyan",
        "Blue", "Medium Blue", "Medium Slate Blue", "Cornflower Blue", "Sky Blue",
	"Light Blue", "Light Steel Blue", "Steel Blue", "Dark Slate Blue", "Navy",
	"Navy Blue", "Midnight Blue", "Dark Orchid", "Medium Orchid", "Orchid", 
	"Magenta", "Violet", "Plum", "Thistle", "Blue Violet", 
	"Slate Blue",
	NULL
};

static int Num_colors = -1;	/* Number of colors in our standard set */
static int Shown_colors = -1;	/* Number of colors currently shown */
static int Rows = 0;		/* Number of rows of swatches to be displayed */
static int Cols = 0;		/* Number of columns of swatches to display */
static Widget Panel;		/* Swatch panel (parent) */
static Widget *Swatch;		/* Base for array of swatches */
static Widget CacheAnchor;	/* Dummy widget used to control caching of color 
				   name-to-pixel conversion as provided by
				   objxm_name_to_pixel (via XtConvertAndStore). */

char *
display_color_chooser(void)
{
    extern Widget 	AB_toplevel;
    static int 		first_time = 1;
    XtAppContext	app;
    XmString 		label;

    if(first_time) {
	create_color_chooser();
	first_time = 0;
    }
    else {
	/* If we didn't get all our colors last time, we need to retry */
	if(Shown_colors != Num_colors) {
            update_color_palette(dtb_color_chooser_dialog.swatch_panel);
	}
    }

    XtVaSetValues(dtb_color_chooser_dialog.dialog_shellform,
	XmNdialogStyle,		XmDIALOG_FULL_APPLICATION_MODAL,
	NULL);

    /* Clear out place-holder name in color_name field */
    label = XmStringCreateLocalized("");
    XtVaSetValues(dtb_color_chooser_dialog.color_name, XmNlabelString,label,
	NULL);
    XmStringFree(label);

    /* 
    ** When the user has made a selection from the dialog, Answer will
    ** either be the color number in the range (0,num_colors) or -1
    ** to indicate that they canceled color selection altogether.  We
    ** therefore use -2 to indicate that they user hasn't answered yet.
    */
    Answer = -2;

    XtManageChild(dtb_color_chooser_dialog.dialog_shellform);
    app = XtDisplayToApplicationContext(XtDisplay(AB_toplevel));
    while (Answer == -2) {
    	XtAppProcessEvent(app,XtIMAll);
    }
    if(Answer >= 0) return(Color[Answer]);
    else return("");
}

void
create_color_chooser(void)
{
    extern Widget 	AB_toplevel;
    XmString 		label;

    dtbColorChooserDialogInfo_clear(&dtb_color_chooser_dialog);
    dtb_color_chooser_dialog_initialize(&dtb_color_chooser_dialog, AB_toplevel);
    create_color_palette(dtb_color_chooser_dialog.swatch_panel);

    /* Clear out place-holder name in color_name field */
    label = XmStringCreateLocalized("");
    XtVaSetValues(dtb_color_chooser_dialog.color_name, XmNlabelString,label,
	NULL);
    XmStringFree(label);

}

void
create_color_palette(
	Widget parent
)
{
    extern Widget AB_toplevel;
    Widget	swatch;
    XmString 	label = XmStringCreateLocalized(" ");
    int 	i, r, c;
    Pixel 	color;
    Pixmap 	tile;
    int 	depth;
    XGCValues 	gcv;
    XtGCMask 	gcm;
    GC 		gc;

    /* Force color count if we're on a monochrome system */
    depth = DefaultDepthOfScreen(XtScreen(AB_toplevel));
    if(depth == 1) {
	Num_colors = 2;
	Rows = 1;
	Cols = 2;
    }
    else {
	/* Count the number of colors in our list */
	for(Num_colors=0;Color[Num_colors]!=(char *)NULL;Num_colors++);
	Rows = (int) (0.5 + sqrt(((double)(3*Num_colors))/4.0));
	Cols = (Num_colors+Rows-1)/Rows;
    }

    util_dprintf(2,"Color chooser: there are %d colors (%dx%d)\n",
		Num_colors,Rows,Cols);

    /* Create the swatch array */
    Swatch = (Widget *) XtMalloc(sizeof(Widget)*Num_colors);

    Panel = XtVaCreateWidget("color_panel",
	xmFormWidgetClass,
	parent,
	XmNfractionBase,Rows*Cols,
	XmNrightOffset, 10,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 10,
	XmNleftAttachment, XmATTACH_FORM,
	XmNtopOffset, 10,
	XmNtopAttachment, XmATTACH_FORM,
	XmNbottomOffset, 10,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);

    /* Create the dummy widget used to control color name-to-pixel caching */
    CacheAnchor = XtVaCreateWidget("CaChEaNcHoR",
	xmLabelWidgetClass,
	parent,
	XmNlabelString,label,
	NULL);

    for(i=0,Shown_colors=0;i<Num_colors;i++) {
	/* See if we can allocate a color */
	if( (color=name_to_pixel(CacheAnchor,Color[i])) == ((Pixel)-1) ) {
		continue;
	}
	/* The color is available, so create a swatch to show it */
	tile = XCreatePixmap(XtDisplay(AB_toplevel),
		XtWindow(AB_toplevel),SWATCH_SZ,SWATCH_SZ,depth);
	gcv.foreground = color;
	gcm = GCForeground;
	gc = XtGetGC(AB_toplevel, gcm, &gcv);
	XFillRectangle(XtDisplay(AB_toplevel),tile,gc,0,0,SWATCH_SZ,SWATCH_SZ);

	r = Shown_colors/Cols;
	c = Shown_colors%Cols;
	swatch = XtVaCreateWidget("swatch",
	xmDrawnButtonWidgetClass,
	    Panel,
	    XmNlabelType,XmPIXMAP,
	    XmNlabelPixmap,tile,
	    XmNforeground,color,
	    XmNshadowType,XmSHADOW_OUT,
	    XmNshadowThickness,SHADOW_SZ,
	    XmNleftAttachment,XmATTACH_POSITION,
	    XmNleftPosition,c*Rows,
	    XmNrightAttachment,XmATTACH_POSITION,
	    XmNrightPosition,(c+1)*Rows,
	    XmNtopAttachment,XmATTACH_POSITION,
	    XmNtopPosition,r*Cols,
	    XmNbottomAttachment,XmATTACH_POSITION,
	    XmNbottomPosition,(r+1)*Cols,
	    XmNuserData,i,		/* Save color index for later use */
	    NULL);
	XtAddCallback(swatch,XmNactivateCallback,swatchCB,(XtPointer)0);
	XtAddCallback(swatch,XmNresizeCallback,swatch_resizeCB,(XtPointer)0);
	XtManageChild(swatch);
	XtReleaseGC(parent,gc);

	/* Store successfully-allocated widget in Swatch table */
	Swatch[Shown_colors] = swatch;

	/* Increment count of shown colors */
	Shown_colors++;
    }
    util_dprintf(2,"Got %d out of %d colors\n",Shown_colors,Num_colors);
    /* Clear out the storage location we use to hold the current color */
    XtVaSetValues(dtb_color_chooser_dialog.color_name,XmNuserData,0,NULL);

    /* Make the swatch panel appear */
    XtManageChild(Panel);

    /* If we didn't get all the standard colors, explain it to the user */
    if(Shown_colors != Num_colors) {
	dtb_color_chooser_message_initialize(&dtb_color_chooser_message);
	dtb_show_message(parent,&dtb_color_chooser_message,NULL, NULL);
    }
}

static void
swatchCB(
	Widget w,
	XtPointer clientdata,
	XtPointer calldata
)
{
	int index;
	XmString label;
	Widget old_color;

	/* XtVaGetValues(w,XmNpositionIndex,&index,NULL); */
	XtVaGetValues(w,XmNuserData,&index,NULL);
	util_dprintf(2,"Selection is color #%d, <%s>\n",index,Color[index]);

	/*
	XmTextFieldSetString(dtb_color_chooser_dialog.color_name,Color[index]);
	*/
	label = XmStringCreateLocalized(Color[index]);
	XtVaSetValues(dtb_color_chooser_dialog.color_name,
		XmNlabelString,label,
		NULL);
	XmStringFree(label);

	/* Figure out which widget was the old color, and reset it */
	XtVaGetValues(dtb_color_chooser_dialog.color_name,XmNuserData,
		(XtPointer)&old_color,NULL);
	if(old_color != 0) {
	    XtVaSetValues(old_color,XmNshadowType,XmSHADOW_OUT,NULL);
	}

	/* Set the shadow on the new color choice */
	XtVaSetValues(w,XmNshadowType,XmSHADOW_IN,NULL);

	/* Save the new widget handle so we can reset it later */
	XtVaSetValues(dtb_color_chooser_dialog.color_name,XmNuserData,
		w,NULL);
}


void
swatch_resizeCB(
	Widget w,
	XtPointer clientdata,
	XtPointer calldata
)
{
    Pixmap tile;
    Dimension wid, ht;
    int depth;
    XGCValues gcv;
    XtGCMask gcm;
    GC gc;
    int col_index;
    Pixel 		color;
    extern Widget 	AB_toplevel;

    XtVaGetValues(w,
		XmNheight,&ht,
		XmNwidth,&wid,
		XmNlabelPixmap,&tile,
		XmNforeground,&color,
		NULL);

    XFreePixmap(XtDisplay(AB_toplevel),tile);

    /* allow for shadow thickness */
    wid -= 4*SHADOW_SZ;
    ht  -= 4*SHADOW_SZ;
    depth = DefaultDepthOfScreen(XtScreen(AB_toplevel));
    tile = XCreatePixmap(XtDisplay(AB_toplevel),
        XtWindow(AB_toplevel),wid,ht,depth);
    gcv.foreground = color;
    gcm = GCForeground;
    gc = XtGetGC(AB_toplevel, gcm, &gcv);
    XFillRectangle(XtDisplay(AB_toplevel),tile,gc,
		0,0,wid,ht);
    
    XtVaSetValues(w,
	XmNlabelPixmap,tile,
	NULL);
}

void
update_color_palette(
	Widget parent
)
{
    extern 	Widget AB_toplevel;
    Widget 	swatch;
    XmString 	label = XmStringCreateLocalized(" ");
    int 	old_shown_colors, i, r, c;
    Pixel 	color;
    Pixmap 	tile, oldtile;
    int 	depth;
    XGCValues 	gcv;
    XtGCMask 	gcm;
    GC 		gc;

    util_dprintf(2,"Updating color palette (%d/%d)\n",Shown_colors,Num_colors);

    /* Go back through and rebuild the palette */
    depth = DefaultDepthOfScreen(XtScreen(AB_toplevel));

    /* See how many colors we had up the last time out */
    old_shown_colors = Shown_colors;

    /* Destroy the old (dummy) cache anchor widget to free the cache */
    XtDestroyWidget(CacheAnchor);

    /* Create a new dummy widget used to control color name-to-pixel caching */
    CacheAnchor = XtVaCreateWidget("CaChEaNcHoR",
	xmLabelWidgetClass,
	parent,
	XmNlabelString,label,
	NULL);

    for(i=0,Shown_colors=0;i<Num_colors;i++) {
	/* See if we can allocate a color */
	if( (color=name_to_pixel(CacheAnchor,Color[i])) == ((Pixel)-1) ) {
		continue;
	}
	/* The color is available, so create a swatch to show it */
	tile = XCreatePixmap(XtDisplay(AB_toplevel),
		XtWindow(AB_toplevel),SWATCH_SZ,SWATCH_SZ,depth);
	gcv.foreground = color;
	gcm = GCForeground;
	gc = XtGetGC(AB_toplevel, gcm, &gcv);
	XFillRectangle(XtDisplay(AB_toplevel),tile,gc,0,0,SWATCH_SZ,SWATCH_SZ);

	r = Shown_colors/Cols;
	c = Shown_colors%Cols;
	if(Shown_colors < old_shown_colors) {
	    /* Reusing an existing swatch button */
	    swatch = Swatch[Shown_colors];
	    util_dprintf(2,"reusing swatch widget #%d for color #%d (%s)\n",
		Shown_colors,i,Color[i]);
	    /* Destroy old tile pixmap */
	    XtVaGetValues(swatch,
		XmNlabelPixmap,&oldtile,
		NULL);
    	    XFreePixmap(XtDisplay(AB_toplevel),oldtile);
	}
	else {
	    /* Need to create a new swatch button */
	    swatch = XtVaCreateWidget("swatch",
		xmDrawnButtonWidgetClass,
	    	Panel,
		NULL);
	    Swatch[Shown_colors] = swatch;
	    util_dprintf(2,"creating swatch widget #%d for color #%d (%s)\n",
		Shown_colors,i,Color[i]);
	}
	XtVaSetValues(swatch,
	    XmNlabelType,XmPIXMAP,
	    XmNlabelPixmap,tile,
	    XmNforeground,color,
	    XmNshadowType,XmSHADOW_OUT,
	    XmNshadowThickness,SHADOW_SZ,
	    XmNleftAttachment,XmATTACH_POSITION,
	    XmNleftPosition,c*Rows,
	    XmNrightAttachment,XmATTACH_POSITION,
	    XmNrightPosition,(c+1)*Rows,
	    XmNtopAttachment,XmATTACH_POSITION,
	    XmNtopPosition,r*Cols,
	    XmNbottomAttachment,XmATTACH_POSITION,
	    XmNbottomPosition,(r+1)*Cols,
	    XmNuserData,i,		/* Save color index for later use */
	    NULL);
	XtAddCallback(swatch,XmNactivateCallback,swatchCB,(XtPointer)0);
	XtAddCallback(swatch,XmNresizeCallback,swatch_resizeCB,(XtPointer)0);
	XtManageChild(swatch);
	XtReleaseGC(AB_toplevel,gc);

	/* Increment count of shown colors */
	Shown_colors++;
    }
    /* Clear out the storage location we use to hold the current color */
    XtVaSetValues(dtb_color_chooser_dialog.color_name,XmNuserData,0,NULL);

    /* Make the swatch panel appear */
    XtManageChild(Panel);

    /* If we didn't get all the standard colors, explain it to the user */
    if(Shown_colors != Num_colors) {
	dtb_show_message(parent,&dtb_color_chooser_message,NULL,NULL);
    }
}


/*
** REMIND:
**
** We'd like to use objxm_name_to_pixel() to convert color names to pixel
** values, as that'd give us identical functionality vs. libXt.  However,
** the XtConvertAndStore() function provides look-up caching, which is not
** how you'd want to handle translating colors given the dynamism of the
** colormap.  (E.g., if an app exits and frees up colors, the Xt converter
** doesn't realize it and continues to return values from a cache built prior
** to the app exit and increase in color availability).  You're supposed to be
** able to reset the cache, but so far attempts to do so herein have falied.
** This function is a workaround that uses XAllocNamedColor() to do the name-
** to-pixel conversion.
*/
Pixel
name_to_pixel(
	Widget w,
	String color
)
{
    extern Widget AB_toplevel;
    Display		*dpy;
    Colormap 		cmap;
    XColor		exact, actual;

    dpy = XtDisplay(AB_toplevel);
    cmap = XDefaultColormap(dpy,XDefaultScreen(dpy));
    if(XAllocNamedColor(XtDisplay(AB_toplevel),cmap,color,&exact,&actual) != 0) {
	return(actual.pixel);
    }
    else return((Pixel)-1);
}

/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/



void 
applyCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

	int index;
	Widget current_color;
	XmString label;

	/* Find out which color was chosen */
	XtVaGetValues(dtb_color_chooser_dialog.color_name,XmNuserData,
		(XtPointer)&current_color,NULL);

	if(current_color != 0) {
	    XtVaGetValues(current_color,XmNuserData,&index,NULL);
	    util_dprintf(2,"You picked \"%s\" (color #%d)\n",Color[index],index);
	    Answer = index;

	    /* Reset the shadow on the color choice */
	    XtVaSetValues(current_color,XmNshadowType,XmSHADOW_OUT,NULL);

	}
	else {
	    util_dprintf(2,"You didn't pick a color!\n");
	    Answer = -1;
	}

	/* Clear out color choice in chooser */
	XtVaSetValues(dtb_color_chooser_dialog.color_name,XmNuserData,0,NULL);

	label = XmStringCreateLocalized("None");
	XtVaSetValues(dtb_color_chooser_dialog.color_name,
		XmNlabelString,label,
		NULL);
	XmStringFree(label);
	XtUnmanageChild(dtb_color_chooser_dialog.dialog_shellform);

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
cancelCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

        short index;
        Widget current_color;
        XmString label;

        /* Find out which color was chosen (if any) */
        XtVaGetValues(dtb_color_chooser_dialog.color_name,XmNuserData,
                (XtPointer)&current_color,NULL);

        if(current_color != 0) {
            /* Reset the shadow on the color choice */
            XtVaSetValues(current_color,XmNshadowType,XmSHADOW_OUT,NULL);
        }
        util_dprintf(2,"Canceling color selection...\n");
        Answer = -1;
        label = XmStringCreateLocalized("None");
        XtVaSetValues(dtb_color_chooser_dialog.color_name,
                XmNlabelString,label,
                NULL);
        XmStringFree(label);
        XtUnmanageChild(dtb_color_chooser_dialog.dialog_shellform);

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}



/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All automatically-generated data and functions have been defined.
 ***
 *** Add new functions here, or at the top of the file.
 ***/
/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/


