/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*
 *	$XConsortium: bilP.h /main/3 1995/11/06 18:23:28 rswiston $
 *
 *	@(#)bilP.h	1.49 02 Apr 1995	cde_app_builder/src/libABil
 *
 * 	RESTRICTED CONFIDENTIAL INFORMATION:
 *	
 *	The information in this document is subject to special
 *	restrictions in a confidential disclosure agreement between
 *	HP, IBM, Sun, USL, SCO and Univel.  Do not distribute this
 *	document outside HP, IBM, Sun, USL, SCO, or Univel without
 *	Sun's specific written approval.  This document and all copies
 *	and derivative works thereof must be returned or destroyed at
 *	Sun's request.
 *
 *	Copyright 1993 Sun Microsystems, Inc.  All rights reserved.
 *
 */

/*
 * bilP.h - bil interface language "stuff"
 */
#ifndef _ABIL_BIL_P_H_
#define _ABIL_BIL_P_H_

#include <stdio.h>
#include <Dt/MsgCatP.h>
#include <bil_parse.h>
#include <ab/util_types.h>
#include <ab_private/obj.h>
#include "loadP.h"

typedef int BIL_TOKEN;
#define BIL_TOKEN_MIN_VALUE	((int)AB_BIL_MARKER_FIRST)
#define BIL_TOKEN_MAX_VALUE	((int)AB_BIL_MARKER_LAST)
#define BIL_TOKEN_NUM_VALUES	(BIL_TOKEN_MAX_VALUE \
					- BIL_TOKEN_MIN_VALUE + 1)
/* 
** I18N defines: Which message set are our messages in?  This must be in sync
** with the 'set N' definition in the libABil.msg message source text file.
** 
** And what global variable are we expecting as our opened catalog descriptor?
*/
#define ABIL_MESSAGE_CATD		Dtb_project_catd
#define ABIL_MESSAGE_SET		204
extern nl_catd		ABIL_MESSAGE_CATD;

typedef struct
{
    ISTRING     	fileName;
    ABObj      		project;
    ABObj      		module;
    ABObjList		compObjsRead;
    ABObj      		obj;
    AB_OBJECT_TYPE	objType;
    BIL_TOKEN		att;
} BIL_LOAD_INFO;
 
/*
 * Symbols generated by lex/yacc
 */
extern int      yyparse(void);
extern FILE     *yyin;
 
/*
 * module global vars
 */
extern 	BIL_LOAD_INFO 	bilP_load;

/*
 * Functions
 */
extern int 		bilP_load_set_current_att(BIL_TOKEN att);
extern STRING		bilP_token_to_string(BIL_TOKEN);
extern BIL_TOKEN	bilP_string_to_token(STRING);
extern BOOL		bilP_token_is_bool(BIL_TOKEN);
extern BOOL		bilP_token_is_string(BIL_TOKEN);

/*
 *  AppBuilder Symbols
 */
extern AB_ALIGNMENT		bilP_token_to_alignment(BIL_TOKEN);
extern BIL_TOKEN		bilP_alignment_to_token(AB_ALIGNMENT);
extern AB_ARG_CLASS		bilP_token_to_arg_class(BIL_TOKEN);
extern BIL_TOKEN		bilP_arg_class_to_token(AB_ARG_CLASS);
extern AB_ARG_TYPE		bilP_token_to_arg_type(BIL_TOKEN);
extern STRING			bilP_arg_class_to_string(AB_ARG_CLASS);
extern BIL_TOKEN		bilP_arg_type_to_token(AB_ARG_TYPE);
extern BOOL			bilP_token_to_bool(BIL_TOKEN);
extern BIL_TOKEN		bilP_bool_to_token(BOOL);
extern AB_BUILTIN_ACTION	bilP_token_to_builtin_action(BIL_TOKEN);
extern BIL_TOKEN		bilP_builtin_action_to_token(AB_BUILTIN_ACTION);
extern AB_BUTTON_TYPE		bilP_token_to_button_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_button_type_to_token(AB_BUTTON_TYPE);
extern AB_CHOICE_TYPE		bilP_token_to_choice_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_choice_type_to_token(AB_CHOICE_TYPE);
extern AB_COMPASS_POINT		bilP_token_to_compass_point(BIL_TOKEN);
extern BIL_TOKEN		bilP_compass_point_to_token(AB_COMPASS_POINT);
extern ABDndOpFlags		bilP_token_to_dnd_op_flag(BIL_TOKEN);
extern BIL_TOKEN		bilP_dnd_op_flag_to_token(BYTE);
extern ABDndTypeFlags		bilP_token_to_dnd_type_flag(BIL_TOKEN);
extern BIL_TOKEN		bilP_dnd_type_flag_to_token(BYTE);
extern AB_FUNC_TYPE		bilP_token_to_func_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_func_type_to_token(AB_FUNC_TYPE);
extern AB_DIRECTION		bilP_token_to_direction(BIL_TOKEN);
extern BIL_TOKEN                bilP_direction_to_token(AB_DIRECTION);
extern AB_LABEL_TYPE		bilP_token_to_label_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_label_type_to_token(AB_LABEL_TYPE);
extern AB_GROUP_TYPE		bilP_token_to_group_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_group_type_to_token(AB_GROUP_TYPE);
extern STRING			bilP_group_type_to_string(AB_GROUP_TYPE);
extern AB_OBJECT_TYPE		bilP_token_to_object_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_object_type_to_token(AB_OBJECT_TYPE);
extern AB_ORIENTATION		bilP_token_to_orientation(BIL_TOKEN);
extern BIL_TOKEN		bilP_orientation_to_token(AB_ORIENTATION);
extern AB_TEXT_TYPE		bilP_token_to_text_type(BIL_TOKEN);
extern BIL_TOKEN		bilP_text_type_to_token(AB_TEXT_TYPE);
extern AB_WHEN			bilP_token_to_when(BIL_TOKEN);
extern BIL_TOKEN		bilP_when_to_token(AB_WHEN);
extern STRING			bilP_compass_point_to_string(AB_COMPASS_POINT);
extern STRING			bilP_text_type_to_string(AB_TEXT_TYPE);
extern AB_CONTAINER_TYPE 	bilP_token_to_container_type(int);
extern BIL_TOKEN 		bilP_container_type_to_token(AB_CONTAINER_TYPE);
extern STRING 			bilP_container_type_to_string(AB_CONTAINER_TYPE);
extern AB_ITEM_TYPE 		bilP_token_to_item_type(int);
extern BIL_TOKEN 		bilP_item_type_to_token(AB_ITEM_TYPE);
extern STRING 			bilP_item_type_to_string(AB_ITEM_TYPE);
extern AB_PACKING 		bilP_token_to_packing(int);
extern BIL_TOKEN 		bilP_packing_to_token(AB_PACKING);
extern STRING 			bilP_packing_to_string(AB_PACKING);
extern STRING 			bilP_menu_type_to_string(AB_MENU_TYPE);
extern AB_LABEL_STYLE 		bilP_token_to_label_style(BIL_TOKEN);
extern BIL_TOKEN 		bilP_label_style_to_token(AB_LABEL_STYLE);
extern STRING 			bilP_label_style_to_string(AB_LABEL_STYLE);
extern STRING			bilP_func_type_to_string(AB_FUNC_TYPE);
extern STRING 			bilP_builtin_action_to_string(AB_BUILTIN_ACTION); 
extern STRING			bilP_when_to_string(AB_WHEN);
extern BIL_TOKEN		bilP_attachment_to_token(AB_ATTACH_TYPE);
extern AB_ATTACH_TYPE		bilP_token_to_attachment(int);
extern STRING			bilP_attachment_to_string(AB_ATTACH_TYPE);
extern STRING			bilP_alignment_to_string(AB_ALIGNMENT);
extern STRING			bilP_label_type_to_string(AB_LABEL_TYPE);
extern STRING			bilP_button_type_to_string(AB_BUTTON_TYPE);
extern STRING			bilP_orientation_to_string(AB_ORIENTATION);
extern STRING			bilP_direction_to_string(AB_DIRECTION);
extern STRING			bilP_choice_type_to_string(AB_CHOICE_TYPE);
extern STRING			bilP_arg_type_to_string(AB_ARG_TYPE);
extern BIL_TOKEN		bilP_initial_state_to_token(AB_OBJECT_STATE);
extern AB_OBJECT_STATE		bilP_token_to_initial_state(int);
extern STRING			bilP_initial_state_to_string(AB_OBJECT_STATE);
extern AB_LINE_TYPE		bilP_token_to_border_frame(int);
extern BIL_TOKEN		bilP_border_frame_to_token(AB_LINE_TYPE);
extern STRING			bilP_border_frame_to_string(AB_LINE_TYPE);
extern AB_LINE_TYPE		bilP_token_to_line_style(int);
extern BIL_TOKEN		bilP_line_style_to_token(AB_LINE_TYPE);
extern STRING			bilP_line_style_to_string(AB_LINE_TYPE);
extern BIL_TOKEN		bilP_selection_mode_to_token(AB_SELECT_TYPE);
extern STRING			bilP_selection_mode_to_string(AB_SELECT_TYPE);
extern AB_SELECT_TYPE		bilP_token_to_selection_mode(int);
extern AB_ARROW_STYLE		bilP_token_to_arrow_style(int);
extern BIL_TOKEN		bilP_arrow_style_to_token(AB_ARROW_STYLE);
extern STRING			bilP_arrow_style_to_string(AB_ARROW_STYLE);
extern BIL_TOKEN 		bilP_scrollbar_policy_to_token(AB_SCROLLBAR_POLICY);
extern AB_SCROLLBAR_POLICY   	bilP_token_to_scrollbar_policy(BIL_TOKEN);
extern STRING 			bilP_scrollbar_policy_to_string(AB_SCROLLBAR_POLICY);
extern BIL_TOKEN 		bilP_msg_type_to_token(AB_MESSAGE_TYPE);
extern AB_MESSAGE_TYPE 		bilP_token_to_msg_type(BIL_TOKEN);
extern STRING 			bilP_msg_type_to_string(AB_MESSAGE_TYPE);
extern BIL_TOKEN 		bilP_file_type_mask_to_token(AB_FILE_TYPE_MASK);
extern AB_FILE_TYPE_MASK 	bilP_token_to_file_type_mask(BIL_TOKEN);
extern STRING 			bilP_file_type_mask_to_string(AB_FILE_TYPE_MASK);
extern BIL_TOKEN 		bilP_sessioning_method_to_token(AB_SESSIONING_METHOD);
extern AB_SESSIONING_METHOD 	bilP_token_to_sessioning_method(BIL_TOKEN);
extern STRING 			bilP_sessioning_method_to_string(AB_SESSIONING_METHOD);
extern BIL_TOKEN 		bilP_tt_desktop_level_to_token(AB_TOOLTALK_LEVEL);
extern AB_TOOLTALK_LEVEL 	bilP_token_to_tt_desktop_level(BIL_TOKEN);
extern STRING 			bilP_tt_desktop_level_to_string(AB_TOOLTALK_LEVEL);
extern BIL_TOKEN 		bilP_default_button_to_token(AB_DEFAULT_BUTTON);
extern AB_DEFAULT_BUTTON 	bilP_token_to_default_button(BIL_TOKEN);
extern STRING 			bilP_default_button_to_string(AB_DEFAULT_BUTTON);

/*
 * Call bil_load_reset() before calling AByyparse
 */
extern int 	bilP_load_reset(void);
extern int 	bilP_load_get_token(void);
extern int 	bilP_load_get_length(void);
extern int 	bilP_load_get_line_number(void);
extern int 	bilP_load_set_line_number(int lineNumber);
extern int      bilP_load_get_value_type(void);
extern char *   bilP_load_get_value(void);

/*
 * load actions from BIL file
 */
extern STRING	bilP_load_att_from(BIL_TOKEN);
extern STRING	bilP_load_att_to(BIL_TOKEN);
extern STRING	bilP_load_att_when(BIL_TOKEN);
extern STRING	bilP_load_att_action_type(BIL_TOKEN);
extern STRING	bilP_load_att_action(BIL_TOKEN);
extern STRING	bilP_load_att_arg_type(BIL_TOKEN);
extern STRING 	bilP_load_att_arg_value(BIL_TOKEN);

/*
 * load object from BIL file
 */
extern STRING	bilP_load_end_of_obj(BIL_TOKEN objClass);
extern int 	bilP_load_end_of_file(void);
extern int 	bilP_load_end_of_data(void);

extern void	bilP_reset_token_text(void);


/*****************************************************************
**								**
**	Inline implementation					**
**								**
******************************************************************/

#define bilP_token_is_bool(t) \
	    ( ((t) == AB_BIL_TRUE) || ((t) == AB_BIL_FALSE) )

#define bilP_token_is_string(t) \
	    ( ((t) == AB_BIL_VALUE_STRING) || ((t) == AB_BIL_NIL) )

#endif /* _ABIL_BIL_P_H_ */
