XCOMM! /bin/sh
XCOMM $XConsortium: helptag.cpp /main/5 1996/04/23 11:26:23 drk $
XCOMM dthelptag 
XCOMM
XCOMM Info for 'what' strings ...
XCOMM
XCOMM @(#) (c) Copyright 1996 Digital Equipment Corporation.
XCOMM @(#) (c) Copyright 1986-1993,1996 Hewlett-Packard Company.
XCOMM @(#) (c) Copyright 1996 International Business Machines Corp.
XCOMM @(#) (c) Copyright 1996 Sun Microsystems, Inc.
XCOMM @(#) (c) Copyright 1996 Novell, Inc. 
XCOMM @(#) (c) Copyright 1996 FUJITSU LIMITED.
XCOMM @(#) (c) Copyright 1996 Hitachi.

#define HASH #

#ifndef ReleaseTree
USESYSTEMUTILS=${USESYSTEMUTILS:-"YES"}
if [ $USESYSTEMUTILS = "YES" ]
then
   HELPTAGPASS1=${HELPTAGPASS1:-dthelp_htag1}
   HELPTAGCANON1=${HELPTAGCANON1:-dthelp_ctag1}
   HELPTAGPASS2=${HELPTAGPASS2:-dthelp_htag2}
else
   HELPTAGPASS1=${ALT_HELPTAGPASS1:-dthelp_htag1}
   HELPTAGCANON1=${ALT_HELPTAGCANON1:-dthelp_ctag1}
   HELPTAGPASS2=${ALT_HELPTAGPASS2:-dthelp_htag2}
fi
#else
 HELPTAGPASS1=dthelp_htag1
 HELPTAGCANON1=dthelp_ctag1
 HELPTAGPASS2=dthelp_htag2
#endif

RM="rm -f "

directory=`pwd`
listfiles="no"
optimize="yes"
optlist=""

export optlist tagname extension
export directory statfile 

XCOMM clean up if the user interrupts this script
bailout(){
  HASH Remove the stat file ...
  rm $statfile 2> /dev/null
  HASH Remove the intermediate files if necessary...
  if [ "$save" != yes ]
  then
    $RM $workfile.'snb'
    $RM $workfile.'idx'
    $RM $workfile.'xrh'
  fi
  exit 2
  }
trap bailout 1 2 3 4 5 6 7 8 10 12 13 14 15 16 17

if [ -z "$1" ]
then
  echo "Usage:  dthelptag [options] <filename>"
  echo "        (For more information:  dthelptag -help)"
  exit 2
fi

XCOMM determine what behavior we have from basename(1).  On some systems,
XCOMM the second parameter to basename(1) is a simple string; on others,
XCOMM it's a regular expression.  Since we want to find out if our input
XCOMM file name ends in ".", we need to use either "\." or "." depending
XCOMM on whether the "." is taken as an RE or a string.
string=`basename string .`
if [ $string = string ]
then
  dotsuffix=.
else
  dotsuffix=\\.
fi

XCOMM function to return extension, if any of a file name.
XCOMM when called, the file name should already have been broken into parts
XCOMM at any periods.
split_name()
{
if [ $# -eq 0 ]
then
  extension=""
elif [ $# -eq 1 ]
then
  extension=""
else
  shift `expr $# - 1`
  extension=".$1"
fi
}


XCOMM function to return last part of a multi-part word.
XCOMM when called, the word should already have been broken into parts.
get_tail()
{
if [ $# -eq 0 ]
then
  tail=""
elif [ $# -eq 1 ]
then
  tail=$1
else
  shift `expr $# - 1`
  tail=$1
fi
}


XCOMM function used to simply return the positional parameters to their
XCOMM original state, i.e., what they were before calling "split_name"
XCOMM or "get_tail".
reset()
{
true
}


XCOMM function to parse a file name.
parse_name()
{
XCOMM don't try to get extension if file ends in period
remdot=`basename "$1" $dotsuffix`
predot=`basename "$1"`
if [ "$remdot" = "$predot" ]
then
  HASH save original parameters and field separators
  saveParm="$*"
  saveIFS="$IFS"

  HASH cause the file name to be split at slashes (remove directories)
  IFS=/
  p=$1
  get_tail $p

  HASH cause file name to be split at periods
  IFS=.
  q=$tail

  HASH get the extension, if any
  split_name $q

  HASH restore original field separators and file name
  IFS="$saveIFS"
  reset "$saveParm"
else
  extension="."
  tagname="$remdot"
fi

XCOMM get the directory, will be "." if none
directory=`dirname $1`

XCOMM get the file base name and remove trailing period, if any and no extension
tagname=`basename $1 $extension`
if [ "$extension" = "" ]
then
  tagname=`basename $tagname $dotsuffix`
fi
}


XCOMM Check command line for options:
gotfile=no
defaultextension=".htg"
compression="no"
decompression="no"
while [ $1 ]
do
  case $1 in
    -formal)
      HELPTAGPASS1=$HELPTAGCANON1
      if [ "$defaultextension" = ".htg" ]
      then
	defaultextension=".ctg"
      fi
      ;;
    -nooptimize)
      optimize="no"
      ;;
    -compress)
      compression="yes"
      defaultextension=".sdl"
      ;;
    -decompress)
      decompression="yes"
      defaultextension=".sdl"
      ;;
    -clean) shift
      if [ -z "$1" ]
      then
        echo "Delete all files generated by HelpTag"
        echo "Sorry, \007Please specify a file name (with no extension)"
        echo "For example:  $0 tagfilename"
        exit 1
      fi
      for commandline
      do 
        echo "Deleting HelpTag-generated files for $commandline"
        HASH check for .htg or .ctg extension
	saveCommandLine="$*"
	parse_name $commandline
	reset $saveCommandLine
	if [ \( "$extension" != ".htg" \) -a \( "$extension" != ".ctg" \) ]
	then
	  tagname=$tagname$extension
	fi
	if [ "$shortnames" = "yes" ]
	then
	  workfile=`echo $tagname | cut -c1-6`
	else
	  workfile=$tagname
	fi
	workfile=$directory/$workfile
        $RM $directory/filelist.err
        $RM $workfile.err
        $RM $workfile.sdl
        $RM $workfile.snb
        $RM $workfile.xrh
        $RM $workfile.idx
        $RM $directory/.$tagname.st
	$RM $workfile.'xrh'
      done
      exit 0
     ;;  
    -debug)
     save=yes
     optlist="$optlist onerror=go"
     ;;
    -files)
     listfiles="yes"
     ;;
    -help)
     echo "______________________________"
     echo "To create run-time help files:"
     echo ""
     echo "                dthelptag [options] <filename>"
     echo ""
     echo "... where the options are:" 
     echo ""
     echo "   -formal             Sets default extension to .ctg and uses"
     echo "                       the canonical SGML HelpTag parser."
     echo "   -nooptimize         Turns off all optimizations in the second pass."
     echo "   -compress           Compresses an SDL file.  No parsing of a"
     echo "                       HelpTag source file takes place."
     echo "   -decompress         Decompresses an SDL file.  No parsing of a"
     echo "                       HelpTag source file takes place."
     echo "   -memo               Includes writer's memos entered with <memo>."
     echo "   -verbose            Displays parser activity."
     echo "   -shortnames         Truncates all generated filenames for portability."
     echo "   -debug              Intermediate files (normally deleted) are saved."
     echo "                       Also, help topic (.sdl) files are not compressed."
     echo ""
     echo "_________________________________________"
     echo "To remove all files generated by HelpTag:"
     echo ""
     echo "                dthelptag -clean  <filename>"
     echo ""
     echo "_________________________________"
     echo "To list all of the file entities:"
     echo ""
     echo "                dthelptag -files  <filename>"
     echo ""
     exit 2
     ;;
    -memo)
     memo=yes
     ;;
    -nomemo)
     memo=no
     ;;
    -shortnames)
     shortnames=yes
     ;;
    -verbose) 
     background=no
     ;;
    @*) optlist="$optlist $1"
     ;;
    *) if [ "$gotfile" = no ]
        then
          tagname=$1
          gotfile=yes
        else
          optlist="$optlist $1"
        fi
     ;;
    esac
  shift
done


echo "Running HelpTag   Version B.00.00 ..."

if [ "$gotfile" = no ]
then
  echo You must specify an input filename.
  echo "A \"$defaultextension\" extension is assumed if you don't provide one."
  exit 2
fi

XCOMM Analyze file name:
XCOMM   if no extension -> append .htg or .ctg
XCOMM   if extension -> use as is
XCOMM   if trailing . -> use without extension
parse_name $tagname
if [ "$extension" = "" ]
then
  extension="$defaultextension"
fi

XCOMM see if tag file exists
if [ ! -r $directory/$tagname$extension ]
then
  echo File $directory/$tagname$extension not found or not readable.
  exit 2
fi


XCOMM Remove old status file, if any.
statfile="$directory/.$tagname.st"
$RM $statfile


XCOMM Do we want a list of the files declared through entities?
if [ "$listfiles" = yes ]
then
  echo ""
  echo "Preparing to list files entered as entity declartions ..."
  echo ""
  $HELPTAGPASS1 $directory/$tagname$extension f $optlist
  exit 2
fi


XCOMM Check write access to current directory
(echo "testing" > $statfile)
if [ $? -gt 0 ]
then
  echo Job not accepted.
  echo You may lack write permission in the current directory.
  exit 2
fi


XCOMM Should the parser ignore writer memos?
if [ "$memo" = yes ]
then
  optlist="$optlist memo"
elif [ "$memo" = no ]
then
  optlist="$optlist nomemo"
fi


XCOMM Does the user wish to truncate file names for portability?
if [ "$shortnames" = "yes" ]
then
  optlist="$optlist short"
  workfile=`echo $tagname | cut -c1-6`
else
  workfile=$tagname
fi
workfile=$directory/$workfile

XCOMM Remove the error file, if any
$RM ${workfile}.err

if [ "$background" = "no" ]
then
    moreinfo=""
else
    moreinfo="  See file ${workfile}.err for more information."
fi

XCOMM Write the header (time stamp, etc.) to the status file.
echo "HelpTag Version B.00.00"  > $statfile
echo `date` >> $statfile
if [ "$background" = no ]
then
  echo Verbose mode started.
fi

if [ \( "$compression" = "no" \) -a \( "$decompression" = "no" \) ]
then
  HASH Call the parser with the appropriate options.  
  echo "Starting HelpTag parser ($HELPTAGPASS1)." >> $statfile
  if [ "$background" = no ]
  then
    echo "Starting HelpTag parser ($HELPTAGPASS1)."
    $HELPTAGPASS1 $directory/$tagname$extension - $optlist
    trouble=$?
    if [ \( $trouble -eq 77 \) -o \( $trouble -eq 66 \) ]
    then
      echo "Re-running parser to resolve xrefs" >> $statfile
      echo "Re-running parser to resolve xrefs"
      $HELPTAGPASS1 $directory/$tagname$extension - $optlist
      trouble=$?
    fi
    if [ \( "$save" != "yes" \) -a \
	 \( $trouble -ne 0 \) -a \( $trouble -ne 2 \) -a \( $trouble -ne 66 \) ]
    then
      echo "Error(s) in run of $HELPTAGPASS1 -- exiting dthelptag."
      if [ "$save" != "yes" ]
      then
	$RM $workfile.'xrh'
	$RM $workfile.'snb'
	$RM $workfile.'idx'
      fi
      HASH Remove the stat file ...
      rm $statfile 2> /dev/null
      exit 1
    fi
  else
    $HELPTAGPASS1 $directory/$tagname$extension - $optlist 1>/dev/null 2>&1
    trouble=$?
    if [ \( $trouble -eq 77 \) -o \( $trouble -eq 66 \) ]
    then
      echo "Re-running parser to resolve xrefs" >> $statfile
      $HELPTAGPASS1 $directory/$tagname$extension - $optlist 1>/dev/null 2>&1
      trouble=$?
    fi
    if [ \( "$save" != "yes" \) -a \
	 \( $trouble -ne 0 \) -a \( $trouble -ne 2 \) -a \( $trouble -ne 66 \) ]
    then
      echo "Parser errors occurred!$moreinfo"
      if [ "$save" != yes ]
      then
	$RM $workfile.'xrh'
	$RM $workfile.'snb'
	$RM $workfile.'idx'
      fi
      HASH Remove the stat file ...
      rm $statfile 2> /dev/null
      exit 1
    fi
  fi

  HASH If there were parser errors, report them to the status file, and stdout.
  echo "Parser done. \c" >> $statfile
  if [ $trouble -gt 0 ]
  then
    echo "Parser errors occurred!$moreinfo"  >> $statfile
    if [ "$save" = yes ]
    then
      echo "Continuing due to a -debug option" >> $statfile
    else
      echo "Continuing due to an onerror=go option" >> $statfile
    fi
    echo "Parser errors occurred!$moreinfo"
    if [ "$save" = yes ]
    then
      echo "Continuing due to a -debug option"
    else
      echo "Continuing due to an onerror=go option"
    fi
  else
    echo No parser errors. >> $statfile
  fi
fi


XCOMM Run the pass2 utility to create the <loids>, <index>, and <snb>
echo "Running $HELPTAGPASS2 to create the generated elements." >> $statfile
if [ "$background" = "no" ]
then
  echo "Running $HELPTAGPASS2 to create the generated elements."
fi

if [ \( "$compression" = "yes" \) -o \( "$decompression" = "yes" \) ]
then
  cflag="t"
  if [ "$compression" = "yes" ]
  then
    cflag="c$cflag"
  fi
  if [ "$decompression" = "yes" ]
  then
    cflag="d$cflag"
  fi
  if [ "$optimize" = "yes" ]
  then
    cflag="o$cflag"
  fi
  if [ "$cflag" != "" ]
  then
    cflag="-$cflag"
  fi
else
  if [ "$optimize" = "yes" ]
  then
    cflag="-cot"
    if [ "$save" = "yes" ]
    then
      cflag="-ot"
    fi
  else
    cflag="-ct"
    if [ "$save" = "yes" ]
    then
      cflag="-t"
    fi
  fi
fi

if [ "$background" = "no" ]
then
  $HELPTAGPASS2 $cflag $workfile.sdl
else
  $HELPTAGPASS2 $cflag $workfile.sdl 1> /dev/null 2>&1
fi
if [ $? -ne 0 ]
then
  echo "Error in run of $HELPTAGPASS2." >> $statfile
  echo "Error in run of $HELPTAGPASS2 -- exiting dthelptag."
  if [ "$save" != yes ]
  then
    $RM $workfile.'xrh'
    $RM $workfile.'snb'
    $RM $workfile.'idx'
  fi
  HASH Remove the stat file ...
  rm $statfile 2> /dev/null
  exit 1
fi

echo "$HELPTAGPASS2 complete." >> $statfile
if [ "$background" = "no" ]
then
  echo "$HELPTAGPASS2 complete."
fi


XCOMM Remove the intermediate files ...
XCOMM Note: currently the save option is set to save no intermediate files ...
if [ "$background" = "no" ]
then
  echo "Removing intermediate files."
fi

if [ "$save" != yes ]
then
  $RM $workfile.'snb'
  $RM $workfile.'idx'
  $RM $workfile.'xrh'
fi


XCOMM All done ...
echo DONE >> $statfile
echo "Done."
