/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/move.c,v $
 * $Id: move.c,v 3.19 1999/07/20 21:05:27 heiner Exp $
 *
 *	execute moves and undo them
 *
 * FFS: not yet changed/set all the figure counts and sets.
 */


#if USE_XATT
# include "xatt.c"	/*! MUST be the first inclusion !*/
#endif


#include "types.h"
#include "board.h"
#include "trace.h"
#include "output.h"
#include "stats.h"
#include <stdio.h>
#include "move.h"


#if PROD_LEV
# define MOVE_STATS	0
#else	/* !PROD_LEV */
# ifndef MOVE_STATS
#  define MOVE_STATS	1		/*CF*/
# endif
#endif	/* !PROD_LEV */

#undef  THIS_STATS
#define THIS_STATS	MOVE_STATS
#include "statsupp.h"

Eximpl Counter	sc_move_exec	= 0;

#if MOVE_STATS
static Counter	sc_x_idx[32];			/* move exec [piece index] */
static Counter	sc_x_cf[2][MAX_FIGURES];	/* move exec [Colour][Figure] */
#endif	/* ! MOVE_STATS */

    Eximpl void		/*ARGSUSED*/
move_stats( Bool print )
{
#if MOVE_STATS
    register int	i;
    register int	c;

    if( print && (f_stats >= 2) ) {
	for( i=0 ; i<32 ; i+=4 ) {
	    if( sc_x_idx[i+0] || sc_x_idx[i+1]
	     || sc_x_idx[i+2] || sc_x_idx[i+3] ) {
		printf("mvx idx:");
		for( c=0 ; c<4 ; ++c ) {
		    show_sc(1,9, sc_x_idx[i+c]); printf("/%02d", i+c);
		}
		printf("\n");
	    }
	}
	for( c=0 ; c<2 ; ++c ) {
	    printf("mvx %c:", chr_Colour((Colour)c));
	    for( i=0 ; i<MAX_FIGURES ; ++i ) {
		show_sc(1,9, sc_x_cf[c][i]);
		printf(" %c", chr_Figure((Figure)i));
	    }
	    printf("\n");
	}
    }
    /*
     * Reset to zeroes:
     */
    for( i=0 ; i<32 ; ++i ) {
	sc_x_idx[i] = 0;
    }
    for( c=0 ; c<2 ; ++c ) {
	for( i=0 ; i<MAX_FIGURES ; ++i ) {
	    sc_x_cf[c][i] = 0;
	}
    }
#endif	/* MOVE_STATS */
    /*
     * According to statistics, "xatt" is a submodule of "move".
     */
    XATT_stats(print);
}


#if USE_XATT
# define add_att(bp, fp)	xatt_add(bp, fp)
#else /* ! USE_XATT */
/*
 * There is a figure just set on an empty field.
 * Change the attack information accordingly (nothing else).
 * For this:
 *	- additional direct and perhaps indirect attacks are to be added
 *	- existing direct and indirect attacks through this position
 *	  are to be cutted.
 */
    Eximpl void
add_att( Board* bp, register Field* fp )
{
    register Field*	tp;
    register rAddrDelta	delta;
    register rPieceSet	mask;
    register rPieceSet	atts;
    register int	shift;
    register int	i;
    register rPosition	pos;
    register int	imax;
    register int	dir;

    pos = pos64_pos[fp->f_pos64];
    mask = SET1(fp->f_idx);
		/* Add new direct attacks, and for LTD also indirect attacks: */
    switch( fp->f_f ) {
     case bauer:
	tp = fp + bau_left[fp->f_c];
	if( tp->f_c != border )
	    F_DATTwr(bp,tp) |= mask;
	tp = fp + bau_right[fp->f_c];
	if( tp->f_c != border )
	    F_DATTwr(bp,tp) |= mask;
	break;
     case springer:
	i = 7;
	do {
	    tp = fp + spr_mov[i];
	    if( tp->f_c != border )
		F_DATTwr(bp,tp) |= mask;
	}while( --i >= 0 );
	break;
     case laeufer:
	i    = MIN_L_DIR;
	imax = MAX_L_DIR;
	goto ltd;
     case turm:
	i    = MIN_T_DIR;
	imax = MAX_T_DIR;
	goto ltd;
     case dame:
	i    = MIN_D_DIR;
	imax = MAX_D_DIR;
ltd:
	do {
	    delta = dam_fmov[i]; /* scaled for (char*) address arithmetic */
	    tp = fp;
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_dir;
		F_DATTwr(bp,tp) |= mask;
	    }while( tp->f_c == empty );
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_dir;
		F_IATTwr(bp,tp) |= mask;
	    }while( tp->f_c == empty );
next_dir:   ;
	}while( ++i < imax );
	break;
     case koenig:
	i = MAX_D_DIR - 1;
	do {
	    tp = fp + dam_mov[i];
	    if( tp->f_c != border )
		F_DATTwr(bp,tp) |= mask;
	}while( --i >= MIN_D_DIR );
	break;
    }
			/* Cut down attacks which go through this position: */
    atts = F_IATTrd(bp,fp);
    i = 0;
    while( atts ) {			/* enumerate indirect attacks */
	while( ! (atts & 01) ) {
	    shift = MIN_LOW_ZERO(atts);
	    i += shift; atts >>= shift;
	}
	mask = SET1(i);
	delta = dam_fmov[att_dir(bp->b_piece[i], pos)];
	tp = MK_AddrStep(fp, delta);
	while( F_IATTrd(bp,tp) & mask ) {
	    F_IATTwr(bp,tp) &= ~mask;
	    tp = MK_AddrStep(tp, delta);
	}
	++i; atts >>= 1;
    }
    atts = F_DATTrd(bp,fp);
    i = 0;
    while( atts ) {			/* enumerate direct attacks */
	while( ! (atts & 01) ) {
	    shift = MIN_LOW_ZERO(atts);
	    i += shift; atts >>= shift;
	}
	dir = att_dir(bp->b_piece[i], pos);
	if( dam_dir(dir) ) {
	    mask = SET1(i);
	    delta = dam_fmov[dir];
	    tp = MK_AddrStep(fp, delta);
					/* change direct into indirect ... */
	    while( F_DATTrd(bp,tp) & mask ) {
		F_DATTwr(bp,tp) &= ~mask;
		F_IATTwr(bp,tp) |= mask;
		tp = MK_AddrStep(tp, delta);
	    }
					/* ... then remove further indirect */
	    while( F_IATTrd(bp,tp) & mask ) {
		F_IATTwr(bp,tp) &= ~mask;
		tp = MK_AddrStep(tp, delta);
	    }
	}
	++i; atts >>= 1;
    }
}
#endif /* ! USE_XATT */


#if USE_XATT
# define del_att(bp, fp)	xatt_del(bp, fp)
#else /* ! USE_XATT */
/*
 * There is a figure to be deleted, producing an empty field,
 * (is still in the board).
 * Change the attack information accordingly (nothing else).
 * For this:
 *	- direct and perhaps indirect attacks are to be deleted.
 *	- existing direct and indirect attacks to this position
 *	  are to be propagated.
 * Note, that all border fields have empty attack sets.
 */
    static void
del_att( Board* bp, register Field* fp )
{
    register Field*	tp;
    register rAddrDelta	delta;
    register rPieceSet	mask;
    register rPieceSet	atts;
    register int	shift;
    register int	i;
    register rPosition	pos;
    register int	imax;
    register int	dir;

    pos = pos64_pos[fp->f_pos64];
    mask = ~ SET1(fp->f_idx);				/* negated (!) */
    switch( fp->f_f ) {
     case bauer:
	F_DATTwr(bp,&(fp[bau_left [fp->f_c]])) &= mask;
	F_DATTwr(bp,&(fp[bau_right[fp->f_c]])) &= mask;
	break;
     case springer:
	i = 7;
	do {
	    F_DATTwr(bp,&(fp[spr_mov[i]])) &= mask;
	}while( --i >= 0 );
	break;
     case laeufer:
	i    = MIN_L_DIR;
	imax = MAX_L_DIR;
	goto ltd;
     case turm:
	i    = MIN_T_DIR;
	imax = MAX_T_DIR;
	goto ltd;
     case dame:
	i    = MIN_D_DIR;
	imax = MAX_D_DIR;
ltd:
	do {
	    delta = dam_fmov[i];
	    tp = fp;
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_dir;
		F_DATTwr(bp,tp) &= mask;
	    }while( tp->f_c == empty );
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_dir;
		F_IATTwr(bp,tp) &= mask;
	    }while( tp->f_c == empty );
next_dir:   ;
	}while( ++i < imax );
	break;
     case koenig:
	i = MAX_D_DIR - 1;
	do {
	    F_DATTwr(bp,&(fp[dam_mov[i]])) &= mask;
	}while( --i >= MIN_D_DIR );
	break;
    }
			/* Propagate attacks which go to this position: */
    atts = F_IATTrd(bp,fp);
    i = 0;
    while( atts ) {			/* enumerate indirect attacks */
	while( ! (atts & 01) ) {
	    shift = MIN_LOW_ZERO(atts);
	    i += shift; atts >>= shift;
	}
	mask = SET1(i);
	delta = dam_fmov[att_dir(bp->b_piece[i], pos)];
	tp = fp;
	do {
	    tp = MK_AddrStep(tp, delta);
	    if( tp->f_c == border )
		break;
	    F_IATTwr(bp,tp) |= mask;		/* more indirect attacks */
	}while( tp->f_c == empty );
	++i; atts >>= 1;
    }
    atts = F_DATTrd(bp,fp);
    i = 0;
    while( atts ) {			/* enumerate direct attacks */
	while( ! (atts & 01) ) {
	    shift = MIN_LOW_ZERO(atts);
	    i += shift; atts >>= shift;
	}
	dir = att_dir(bp->b_piece[i], pos);
	if( dam_dir(dir) ) {
	    mask = SET1(i);
	    delta = dam_fmov[dir];
	    tp = MK_AddrStep(fp, delta);
	    if( F_IATTrd(bp,tp) & mask ) {
		do {			/* former indirect now direct */
		    F_IATTwr(bp,tp) &= ~mask;
		    F_DATTwr(bp,tp) |=  mask;
		    tp = MK_AddrStep(tp, delta);
		}while( F_IATTrd(bp,tp) & mask );
		while( tp->f_c != border ) {
		    F_IATTwr(bp,tp) |= mask;  /* add further indirect attacks */
		    if( tp->f_c != empty )
			break;
		    tp = MK_AddrStep(tp, delta);
		}
	    }
	}
	++i; atts >>= 1;
    }
}
#endif /* ! USE_XATT */


#if USE_XATT
# define rep_att(bp,fp,nidx,ncolour,nfig) xatt_rep(bp, fp, nidx, ncolour, nfig)
#else /* ! USE_XATT */
# define rep_att(bp,fp,nidx,ncolour,nfig) rep___att(fp, nidx, ncolour, nfig)

/*
 * There is a figure replacing another one.
 * The old contents are still in the board.
 * Change the attack information accordingly (nothing else).
 * For this:
 *	- direct and perhaps indirect attacks of the old are to be deleted.
 *	- direct and perhaps indirect attacks of the new are to be added.
 * Note: neither propagation nor cutting is necessary.
 */
    static void
rep___att( register Field* fp, int8 nidx, Colour ncolour, Figure nfig )
{
    register Field*	tp;
    register rPieceSet	mask;
    register rAddrDelta	delta;
    register int	i;
    register int	imax;

    mask = SET1(fp->f_idx);
    switch( fp->f_f ) {
     case bauer:
	F_DATTwr(0,&(fp[bau_left [fp->f_c]])) &= ~mask;
	F_DATTwr(0,&(fp[bau_right[fp->f_c]])) &= ~mask;
	break;
     case springer:
	i = 7;
	do {
	    F_DATTwr(0,&(fp[spr_mov[i]])) &= ~mask;
	}while( --i >= 0 );
	break;
     case laeufer:
	i    = MIN_L_DIR;
	imax = MAX_L_DIR;
	goto ltd_sub;
     case turm:
	i    = MIN_T_DIR;
	imax = MAX_T_DIR;
	goto ltd_sub;
     case dame:
	i    = MIN_D_DIR;
	imax = MAX_D_DIR;
ltd_sub:
	do {
	    delta = dam_fmov[i];
	    tp = fp;
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_sub_dir;
		F_DATTwr(0,tp) &= ~mask;
	    }while( tp->f_c == empty );
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_sub_dir;
		F_IATTwr(0,tp) &= ~mask;
	    }while( tp->f_c == empty );
next_sub_dir:	;
	}while( ++i < imax );
	break;
     case koenig:				/* happens for move_undo */
	i = MAX_D_DIR - 1;
	do {
	    F_DATTwr(0,&(fp[dam_mov[i]])) &= ~mask;
	}while( --i >= MIN_D_DIR );
	break;
    }
    mask = SET1(nidx);
    switch( nfig ) {
     case bauer:
	tp = fp + bau_left[ncolour];
	if( tp->f_c != border )
	    F_DATTwr(0,tp) |= mask;
	tp = fp + bau_right[ncolour];
	if( tp->f_c != border )
	    F_DATTwr(0,tp) |= mask;
	break;
     case springer:
	i = 7;
	do {
	    tp = fp + spr_mov[i];
	    if( tp->f_c != border )
		F_DATTwr(0,tp) |= mask;
	}while( --i >= 0 );
	break;
     case laeufer:
	i    = MIN_L_DIR;
	imax = MAX_L_DIR;
	goto ltd_add;
     case turm:
	i    = MIN_T_DIR;
	imax = MAX_T_DIR;
	goto ltd_add;
     case dame:
	i    = MIN_D_DIR;
	imax = MAX_D_DIR;
ltd_add:
	do {
	    delta = dam_fmov[i];
	    tp = fp;
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_add_dir;
		F_DATTwr(0,tp) |= mask;
	    }while( tp->f_c == empty );
	    do {
		tp = MK_AddrStep(tp, delta);
		if( tp->f_c == border )
		    goto next_add_dir;
		F_IATTwr(0,tp) |= mask;
	    }while( tp->f_c == empty );
next_add_dir:	;
	}while( ++i < imax );
	break;
     case koenig:
	i = MAX_D_DIR - 1;
	do {
	    tp = fp + dam_mov[i];
	    if( tp->f_c != border )
		F_DATTwr(0,tp) |= mask;
	}while( --i >= MIN_D_DIR );
	break;
    }
}
#endif /* ! USE_XATT */


/*
 * pacb_sync()
 *	Synchronize the nibble in the packed board according to a field.
 */
    Eximpl void
pacb_sync( PackedBoard* pbp, register const Field* fp )
{
    register int	n;
    register PbUnit*	q;

    n = fp->f_pos64;
    q = PB_64_P(pbp, n);
    n = PB_64_shift(n);
    if( fp->f_c == empty ) {
	*q &= ~PB_sh_mask(n);
    }else {
	*q = (*q & ~PB_sh_mask(n))  |  (PB_fp_val(fp) << n);
    }
}


/*

Up-/Down-date of Boards
~~~~~~~~~~~~~~~~~~~~~~~

There are three major operations to be performed:
- take away a piece
- set a piece
- change additional information
    + castling rights
    + e.p. info
    + tomove

Attacks & piecelist must be updated also.

The most simple move M = (f, t, F, x) == (F f-t)
does not beat nor change special info (except tomove), and is done by

		DO				UNDO
(a) eliminate F at f:
    (a1)	del_att(F@f), propagate(f)	add_att(F@f), cutdown(f)
    (a2)	B[f].f_c = empty		B[f].f_c = tomove
    (a3)	B[f].f_f = no_figure		B[f].f_f = F
    (a4)	B.piece[x] = NO_POS		B.piece[x] = f
						B[f].f_idx = x
(b) set F at t:
    (b1)	B.piece[x] = t			B.piece[x] = NO_POS
		B[t].f_idx = x
    (b2)	B[t].f_f = F			B[t].f_f = NO_POS
    (b3)	B[t].f_c = tomove		B[t].f_c = empty
    (b4)	add_att(F@t), cutdown(t)	del_att(F@t), cutdown(t)
(c) change colour to move:
    (c1)	B.b_tomove ^= (w^b)		B.b_tomove ^= (w^b)

Thus the undo operation needs to know:
    t, x, f, F

To be complete, the following must be considered:
 - beating pieces
 - promotion changes figure
 - most moves null ep-info
 - some moves set ep-info
 - ep beats another B, too
 - castling moves a T, too
 - moving the K destroys both castlings
 - moving a T may destroy a castling
 - beating a T may destroy a castling of the opponent


Thus, execute M = (f, t, F, x) on board B:

(A) take away @ f, push a set operation for undo:
    PUSH		set(f, x, B.tomove, B[f].f_f)
    del_att(B,f)
    B[f].f_c = empty
    B[f].f_f = no_figure
    B.piece[x] = NO_POS
(B) consider destruction of ep-info
    if( B.ep != NO_POS ) {
	PUSH		ep(B.ep)
	b.ep = NO_POS
    }
    Note: B.ep now guaranteed to be NO_POS
(C) consider destruction of own castlings
    if B[f].f_f was == K {
	PUSH		mycastle(B.castle[B.tomove])
	B.castle[B.tomove] = 0
    }
    if B[f].f_f was == T, and @ self 0-0 or 0-0-0 position {
	PUSH		mycastle(B.castle[B.tomove])
	B.castle[B.tomove] &= ~destroyed one
    }

==>	Now the first part is ready.
	Here might be the sync-point for lazy up/downdate

(D) Handle beating specially:
    if B[t].f_c == empty	--> (Dmove)
    else			--> (Dbeat)

(Dmove)	Special here: castling moves T too, e.p., B-dopp (provide e.p.)
    PUSH		clr(t)
    B.piece[x] = t
    B[t].f_x = x
    B[t].f_f = F
    B[t].f_c = B.tomove
    add_att(t)
    if F == K {
	ff = NO_POS
	if t == f + 2*right {			0-0
	    ff = f + 3*right;
	}else if t == f + 2*left {		0-0-0
	    ff = f + 4*left;
	}
	if( ff != NO_POS ) {
	    tt = f + (t-f)/2
	    xx = B[ff].f_x
	    PUSH	set(ff, xx, B.tomove, turm)
	    del_att(B,ff)
	    B[ff].f_c = empty
	    B[ff].f_f = no_figure
	    B.piece[xx] = NO_POS
	    PUSH	clr(tt)
	    B.piece[xx] = tt
	    B[tt].f_x = xx
	    B[tt].f_f = turm
	    B[tt].f_c = B.tomove
	    add_att(tt)
	}
    }else if F == B {
	if( (t-f) == 2*bau_mov[B.tomove] ) {
	    PUSH	ep(NO_POS)
	    B.ep = t
	}else if lfr_dir(f -> t) {		is e.p.
	    tt = t - bau_mov[B.tomove]
	    PUSH		set(tt, B[tt].f_x, B[tt].f_c, bauer)
	    del_att(B,tt)
	    B[tt].f_c = empty
	    B[tt].f_f = no_figure
	    B.piece[B[tt].f_x] = NO_POS
	}
    }

(Dbeat)	Special here: replace someone, destroy castling by T-beat
    if B[t].f_f == T, and @ his 0-0 or 0-0-0 position {
	PUSH		hiscastle(B.castle[B[t].f_c])
	B.castle[B[t].f_c] &= ~destroyed one
    }
    PUSH		rep(t, B[t].f_x, B[t].f_c, B[t].f_f)
    rep_att(f, x, B.tomove, F)
    B.piece[B[t].f_x] = NO_POS
    B.piece[x] = t
    B[t].f_x = x
    B[t].f_f = F
    B[t].f_c = B.tomove

(E)	Change tomove
    PUSH		change_tomove
    B.tomove ^= (w^b)

(F)	Close the pushing
    PUSH		marker, e.g. length of pushing


Pushed down-date operations are implemented (popped) such:

    change_tomove
		B.tomove ^= (w^b)

    ep(p)
		B.ep = p

    mycastle(v)
		B.castle[B.tomove] = v

    hiscastle(v)
		B.castle[opp_colour(B.tomove)] = v

    clr(p)
		del_att(B,p)
		B[p].f_c = empty
		B[p].f_f = no_figure
		B.piece[B[p].f_x] = NO_POS

    set(p, x, c, F)
		B.piece[x] = p
		B[p].f_x = x
		B[p].f_f = F
		B[p].f_c = c
		add_att(p)

    rep(p, x, c, F)
		rep_att(p, x, c, F)
		B.piece[B[p].f_x] = NO_POS
		B.piece[x] = p
		B[p].f_x = x
		B[p].f_f = F
		B[p].f_c = c

*/


#define DD_CHGTOM	1	/* toggle between white and black */
#define DD_CLREP	2	/* define b_ep as NO_POS */
#define DD_SETEP	3	/* (val): define b_ep */
#define DD_MYCASTLE	4	/* (val): define mine castle rights */
#define DD_HISCASTLE	5	/* (val): define his castle rights */
#define DD_CLR		6	/* (pos): make field empty */
#define DD_SET		7	/* (pos, idx, col, fig): set onto empty */
#define DD_REP		8	/* (pos, idx, col, fig): set onto non-empty */

#if MAX_DD_PER_MOVE < (5+2+2 + 2+5+2 + 1+1 +6)
# include "/// >>>>> MAX_DD_PER_MOVE inconsistently configured <<<<< ///"
#endif

/*
 * The down-date stack grows downwards (i.e. from index N to 0),
 * with the stack pointer at the last used element.
 * Each segment is closed with a length (inclusive itself).
 */
#ifndef  IMPL_CHGTOM
# define IMPL_CHGTOM	1		/*CF: DD_CHGTOM is always last cmd */
#endif


/*
 * move_undo()
 *	Undo the last move by interpretation of the down date stack.
 */
    Eximpl void
move_undo( register Board* bp )
{
    register DDelem*	p;
    register DDelem*	endp;		/* end of segment (first behind) */
    register Field*	fp;
    register rColour	c;
    register rFigure	fig;
    register unsigned	n;
    register int	idx;

    CHK_BOARD(bp);
    trc_move_undo();			/* 127625 */
    p = bp->b_ddstk.dds_ptr;		/* cache stackpointer */
    endp = p + p[0]; ++p;		/* fetch length -> end of segment */
    bp->b_ddstk.dds_ptr = endp;		/* towards there we will go */
#if IMPL_CHGTOM
    bp->b_tomove = opp_colour(bp->b_tomove);
#endif
    do {				/* undo segments cannot be empty */
	switch( *p ) {			/* 383250 */
	 default:
	    panic("move_undo: DDcmd %d", *p);
	    /*NOTREACHED*/
#if ! IMPL_CHGTOM
	 case DD_CHGTOM:		/* 127625 */
	    bp->b_tomove = opp_colour(bp->b_tomove);
	    p += 1;
	    break;
#endif
	 case DD_CLREP:			/*    289 */
	    bp->b_ep = NO_POS;
	    p += 1;
	    break;
	 case DD_SETEP:			/*     86 */
	    bp->b_ep = p[1];
	    p += 2;
	    break;
	 case DD_MYCASTLE:
	    bp->b_castle[bp->b_tomove] = p[1];
	    p += 2;
	    break;
	 case DD_HISCASTLE:
	    bp->b_castle[opp_colour(bp->b_tomove)] = p[1];
	    p += 2;
	    break;
	 case DD_CLR:				/* (pos) */
	    fp = &(bp->b_f[ p[1] ]);	/*  96407 */
	    c   = fp->f_c;
	    fig = fp->f_f;
	    bp->b_cur_piece[c] -= 1;
	    bp->b_fig_cnt[c][fig] -= 1;
	    del_att(bp, fp);
	    n = fp->f_pos64;
	    ZH_UPD(bp->b_zhash, c, fig, n);
	    bp->b_fig.fs_line[LIN64(n)] &= ~ (1 << COL64(n));
	    if( fig == bauer ) {	/*   2913 */
		bp->b_bau[c].fs_line[LIN64(n)] &= ~ (1 << COL64(n));
	    }
			/*	pacb_sync(&(bp->b_packed), fp);		*/
	    PB_64_Clr(&bp->b_packed, n);
	    fp->f_c = empty;
	    fp->f_f = no_figure;
	    bp->b_piece[fp->f_idx] = NO_POS;
	    p += 2;
	    break;
	 case DD_SET:				/* (pos, idx, col, fig) */
	    fp = &(bp->b_f[ p[1] ]);	/* 127625 */
	    bp->b_piece[n = p[2]] = p[1];
	    fp->f_idx = n;
	    fp->f_c = c   = p[3];
	    fp->f_f = fig = p[4];
	    n = fp->f_pos64;
	    ZH_UPD(bp->b_zhash, c, fig, n);
	    bp->b_fig.fs_line[LIN64(n)] |= (1 << COL64(n));
	    if( fig == bauer ) {	/*   5868 */
		bp->b_bau[c].fs_line[LIN64(n)] |= (1 << COL64(n));
	    }
	    bp->b_cur_piece[c] += 1;
	    bp->b_fig_cnt[c][fig] += 1;
			/*	pacb_sync(&(bp->b_packed), fp);		*/
	    *PB_64_P(&bp->b_packed, n) |= (PB_cf_val(c,fig) << PB_64_shift(n));
	    add_att(bp, fp);
	    p += 5;
	    break;
	 case DD_REP:				/* (pos, idx, col, fig) */
	    fp = &(bp->b_f[ p[1] ]);	/*  31218 */
	    c   = fp->f_c;
	    fig = fp->f_f;
	    bp->b_cur_piece[c] -= 1;
	    bp->b_fig_cnt[c][fig] -= 1;
	    n = fp->f_pos64;
	    ZH_UPD(bp->b_zhash, c, fig, n);
	    /*	bp->b_fig.fs_line[LIN64(n)] &= ~ (1 << COL64(n)); */
	    if( fig == bauer ) {	/*   2955 */
		bp->b_bau[c].fs_line[LIN64(n)] &= ~ (1 << COL64(n));
	    }
	    c   = p[3];
	    fig = p[4];
	    idx = p[2];
	    rep_att(bp, fp, idx, c, fig);
	    bp->b_piece[fp->f_idx] = NO_POS;
	    bp->b_piece[idx] = p[1];
	    fp->f_idx = idx;
	    fp->f_c   = c;
	    fp->f_f   = fig;
	    ZH_UPD(bp->b_zhash, c, fig, n);
	    /*	bp->b_fig.fs_line[LIN64(n)] |= (1 << COL64(n)); */
	    if( fig == bauer ) {
		bp->b_bau[c].fs_line[LIN64(n)] |= (1 << COL64(n));
	    }
	    bp->b_cur_piece[c] += 1;
	    bp->b_fig_cnt[c][fig] += 1;
		/*	pacb_sync(&(bp->b_packed), fp);		*/
	    {		PbUnit	*q;
		q = PB_64_P(&bp->b_packed, n);
		n = PB_64_shift(n);
		*q = (*q & ~PB_sh_mask(n))  |  (PB_cf_val(c,fig) << n);
	    }
	    p += 5;
	    break;
	}
    }while( p < endp );
#if 1
    if( p != endp ) {
	panic("move_undo: size error, %x %x", p, endp);
    }
#endif
    CHK_BOARD(bp);
}


/*
 * move_execute()
 *	Execute a move.
 *	Push instructions for undo onto down-date stack.
 */
    Eximpl void
move_execute( register Board* bp, register const Move* mp )
{
    register DDelem*	p;
    register Field*	fp;
    register Field*	tp;
    register rColour	self;
    register rFigure	fig;
    register int	idx;
    register unsigned	n;

    CHK_BOARD(bp);
    ++sc_move_exec;
    trc_move_exec(bp, mp);

    p = bp->b_ddstk.dds_ptr;
    self = bp->b_tomove;
    fp = &(bp->b_f[ mp->m_from ]);
    tp = &(bp->b_f[ mp->m_to   ]);
    fig = fp->f_f;			/* such it is before the move */
    idx = fp->f_idx;
    scinc(sc_x_cf[self][fig]);
    scinc(sc_x_idx[idx]);
					/* (A) remove figure */
					/* push	set(f, x, c, F) */
    p -= 5;
	p[0] = DD_SET;
	p[1] = mp->m_from;
	p[2] = idx;
	p[3] = self;
	p[4] = fig;
    del_att(bp, fp);
    fp->f_c = empty;
    fp->f_f = no_figure;
    bp->b_piece[idx] = NO_POS;
    bp->b_cur_piece[self] -= 1;
    bp->b_fig_cnt[self][fig] -= 1;
    n = fp->f_pos64;
    ZH_UPD(bp->b_zhash, self, fig, n);
    bp->b_fig.fs_line[LIN64(n)] &= ~ (1 << COL64(n));
    if( fig == bauer ) {
	bp->b_bau[self].fs_line[LIN64(n)] &= ~ (1 << COL64(n));
    }
	/*	pacb_sync(&(bp->b_packed), fp);		*/
    PB_64_Clr(&bp->b_packed, n);
					/* (B) note destruction of ep-info */
    if( ! no_pos(bp->b_ep) ) {
	p -= 2;
	    p[0] = DD_SETEP;
	    p[1] = bp->b_ep;
	bp->b_ep = NO_POS;
    }
    /* "b_ep" must be NO_POS, now */
					/* (C) note change of own castlings */
    if( bp->b_castle[self] ) {
	switch( fig ) {
	 case koenig:
	    p -= 2;
		p[0] = DD_MYCASTLE;
		p[1] = bp->b_castle[self];
	    bp->b_castle[self] = 0;	/* both destroyed */
	    break;
	 case turm:
	    if( mp->m_from == trm_00[self] ) {
		p -= 2;
		    p[0] = DD_MYCASTLE;
		    p[1] = bp->b_castle[self];
		bp->b_castle[self] &= ~castle00;
	    }else if( mp->m_from == trm_000[self] ) {
		p -= 2;
		    p[0] = DD_MYCASTLE;
		    p[1] = bp->b_castle[self];
		bp->b_castle[self] &= ~castle000;
	    }
	    break;
	}
    }
    /*
     * Here is the sync-point for lazy up/downdate.
     */
					/* (D) Discriminate beating */
    if( tp->f_c == empty ) {		/* (Dmove) */
	p -= 2;
	    p[0] = DD_CLR;
	    p[1] = mp->m_to;
	bp->b_piece[idx] = mp->m_to;
	tp->f_idx = idx;
	tp->f_f = mp->m_fig;		/* take from move for promotion */
	tp->f_c = self;
	add_att(bp, tp);
	bp->b_cur_piece[self] += 1;
	bp->b_fig_cnt[self][tp->f_f] += 1;
	n = tp->f_pos64;
	ZH_UPD(bp->b_zhash, self, tp->f_f, n);
	bp->b_fig.fs_line[LIN64(n)] |= (1 << COL64(n));
	if( tp->f_f == bauer ) {		/* FFS: can be done below */
	    bp->b_bau[self].fs_line[LIN64(n)] |= (1 << COL64(n));
	}
		/*	pacb_sync(&(bp->b_packed), tp);		*/
	*PB_64_P(&bp->b_packed, n) |=
			(PB_cf_val(self, tp->f_f) << PB_64_shift(n));
	/*
	 * Special here: castling moves T too, e.p., B-dopp (provide e.p.)
	 */
	switch( fig ) {
	 case koenig:
	    switch( mp->m_to - mp->m_from ) {
	     case MK_DELTA( 2,0):			/* is 0-0 */
		fp = tp + MK_DELTA(1,0);		/* source of T */
		tp = tp - MK_DELTA(1,0);		/* destination */
		goto L_00_000;
	     case MK_DELTA(-2,0):			/* is 0-0-0 */
		fp = tp - MK_DELTA(2,0);		/* source of T */
		tp = tp + MK_DELTA(1,0);		/* destination */
	     L_00_000:
		idx = fp->f_idx;
		p -= 5;
		    p[0] = DD_SET;
		    p[1] = fp - bp->b_f;
		    p[2] = idx;
		    p[3] = self;
		    p[4] = turm;
		del_att(bp, fp);
		fp->f_c = empty;
		fp->f_f = no_figure;
		bp->b_piece[idx] = NO_POS;
		n = fp->f_pos64;
		ZH_UPD(bp->b_zhash, self, turm, n);
		bp->b_fig.fs_line[LIN64(n)] &= ~ (1 << COL64(n));
		pacb_sync(&(bp->b_packed), fp);
		p -= 2;
		    p[0] = DD_CLR;
		    p[1] = tp - bp->b_f;
		bp->b_piece[idx] = tp - bp->b_f;
		tp->f_idx = idx;
		tp->f_f = turm;
		tp->f_c = self;
		add_att(bp, tp);
		n = tp->f_pos64;
		ZH_UPD(bp->b_zhash, self, turm, n);
		bp->b_fig.fs_line[LIN64(n)] |= (1 << COL64(n));
		pacb_sync(&(bp->b_packed), tp);
		break;
	    }
	    break;
	 case bauer:
	    switch( mp->m_to - mp->m_from ) {
	     case MK_DELTA(0, 2):
	     case MK_DELTA(0,-2):
		if( (   (tp[MK_DELTA( 1,0)].f_f == bauer)
		     && (tp[MK_DELTA( 1,0)].f_c == opp_colour(self)) )
		 || (   (tp[MK_DELTA(-1,0)].f_f == bauer)
		     && (tp[MK_DELTA(-1,0)].f_c == opp_colour(self)) ) ) {
		    p -= 1;
			p[0] = DD_CLREP;
		    bp->b_ep = mp->m_to;	/* enable e.p. of this one */
		}
		break;
	     case MK_DELTA( 1, 1):
	     case MK_DELTA( 1,-1):
	     case MK_DELTA(-1, 1):
	     case MK_DELTA(-1,-1):		/* beat e.p. */
		tp -= bau_mov[self];
		idx = tp->f_idx;
		p -= 5;
		    p[0] = DD_SET;
		    p[1] = mp->m_to - bau_mov[self];
		    p[2] = idx;
		    p[3] = opp_colour(self);
		    p[4] = bauer;
		del_att(bp, tp);
		tp->f_c = empty;
		tp->f_f = no_figure;
		bp->b_piece[idx] = NO_POS;
		bp->b_cur_piece[opp_colour(self)] -= 1;
		bp->b_fig_cnt[opp_colour(self)][bauer] -= 1;
		n = tp->f_pos64;
		ZH_UPD(bp->b_zhash, opp_colour(self), bauer, n);
		bp->b_fig.fs_line[LIN64(n)] &= ~ (1 << COL64(n));
		bp->b_bau[opp_colour(self)].fs_line[LIN64(n)]
							&= ~ (1 << COL64(n));
		pacb_sync(&(bp->b_packed), tp);
		break;
	    }
	    break;
	}
    }else {	/* ( tp->f_c != empty ) */		/* (Dbeat) */
	/*
	 * Special here: replace someone, destroy castling by T-beat
	 */
	if( bp->b_castle[opp_colour(self)] && (tp->f_f == turm) ) {
	    if( mp->m_to == trm_00[opp_colour(self)] ) {
		p -= 2;
		    p[0] = DD_HISCASTLE;
		    p[1] = bp->b_castle[opp_colour(self)];
		bp->b_castle[opp_colour(self)] &= ~castle00;
	    }else if( mp->m_to == trm_000[opp_colour(self)] ) {
		p -= 2;
		    p[0] = DD_HISCASTLE;
		    p[1] = bp->b_castle[opp_colour(self)];
		bp->b_castle[opp_colour(self)] &= ~castle000;
	    }
	}
	p -= 5;
	    p[0] = DD_REP;
	    p[1] = mp->m_to;
	    p[2] = tp->f_idx;
	    p[3] = tp->f_c;
	    p[4] = tp->f_f;
	n = tp->f_pos64;
	if( tp->f_f == bauer ) {
	    bp->b_bau[tp->f_c].fs_line[LIN64(n)] &= ~ (1 << COL64(n));
	}
	bp->b_cur_piece[opp_colour(self)] -= 1;
	bp->b_fig_cnt[opp_colour(self)][tp->f_f] -= 1;
	ZH_UPD(bp->b_zhash, opp_colour(self), tp->f_f, n);
	rep_att(bp, tp, idx, self, mp->m_fig);
	bp->b_piece[tp->f_idx] = NO_POS;
	bp->b_piece[idx] = mp->m_to;
	tp->f_idx = idx;
	tp->f_f = mp->m_fig;		/* take from move for promotion */
	tp->f_c = self;
	bp->b_cur_piece[self] += 1;
	bp->b_fig_cnt[self][tp->f_f] += 1;
	/*	"bp->b_fig" does not change here	*/
	ZH_UPD(bp->b_zhash, self, tp->f_f, n);
	if( tp->f_f == bauer ) {
	    bp->b_bau[self].fs_line[LIN64(n)] |= (1 << COL64(n));
	}
		/*	pacb_sync(&(bp->b_packed), tp);		*/
	{	PbUnit	*q;
	    q = PB_64_P(&bp->b_packed, n);
	    n = PB_64_shift(n);
	    *q = (*q & ~PB_sh_mask(n))  |  (PB_cf_val(self, tp->f_f) << n);
	}
    }
    /*
     * "idx", "fp" and "tp" may be invalid, by now.
     */
					/* (E) change colour to move */
    bp->b_tomove = opp_colour(self);
#if ! IMPL_CHGTOM
    *--p = DD_CHGTOM;
#endif
					/* (F) push total size of pushing */
    --p;
    p[0] = (bp->b_ddstk.dds_ptr - p);
					/* wind up */
    bp->b_ddstk.dds_ptr = p;
    CHK_BOARD(bp);
}


/*
 * move_snoop()
 *	Tell the main effects that would result from executing a move.
 *	- fill a packed board
 *	- fill updated ep-info
 *	- fill updated castling info
 */
    Eximpl Zhash
move_snoop(
    register const Board*	bp,
    register const Move*	mp,
    register uint32		pkarr[8],
    Position*			epp,
    Castle			castle[2])
{
    Zhash			zhash;

    CHK_BOARD(bp);
    {					/* copy packed board */
	register const uint32*	ip;

	ip = &(bp->b_packed.pb_long[0]);
	pkarr[0] = ip[0]; pkarr[1] = ip[1];
	pkarr[2] = ip[2]; pkarr[3] = ip[3];
	pkarr[4] = ip[4]; pkarr[5] = ip[5];
	pkarr[6] = ip[6]; pkarr[7] = ip[7];
    }
    /*	*epp = bp->b_ep;	*/	/* see below */
    castle[0] = bp->b_castle[0];
    castle[1] = bp->b_castle[1];
#if WITH_ZHASH
    zhash     = bp->b_zhash;
#else
    zhash     = 0;
#endif
    {
	    register const Field*	fp;
	    register const Field*	tp;
	    register rColour		self;
	    register rFigure		fig;
	    register unsigned		n;
	self = bp->b_tomove;
	fp = &(bp->b_f[ mp->m_from ]);
	tp = &(bp->b_f[ mp->m_to   ]);
	fig = fp->f_f;			/* such it is before the move */
					/* (A) remove figure */
	n = fp->f_pos64;
	((PbUnit*)pkarr)[PB_64_inx(n)] &= ~PB_64_mask(n);
	ZH_UPD(zhash, self, fig, n);
					/* (B) note destruction of ep-info */
	*epp = NO_POS;
					/* (C) note change of own castlings */
	if( castle[self] ) {
	    switch( fig ) {
	     case koenig:
		castle[self] = 0;		/* both destroyed */
		break;
	     case turm:
		if( mp->m_from == trm_00[self] ) {
		    castle[self] &= ~castle00;
		}else if( mp->m_from == trm_000[self] ) {
		    castle[self] &= ~castle000;
		}
		break;
	    }
	}
					/* (D) Discriminate beating */
	n = tp->f_pos64;
	ZH_UPD(zhash, self, mp->m_fig, n);
	if( tp->f_c == empty ) {		/* (Dmove) */
	    ((PbUnit*)pkarr)[PB_64_inx(n)] |=
			(PB_cf_val(self, mp->m_fig) << PB_64_shift(n));
	    /*
	     * Special here: castling moves T too, e.p., B-dopp (provide e.p.)
	     */
	    switch( fig ) {
	     case koenig:
		switch( mp->m_to - mp->m_from ) {
		 case MK_DELTA( 2,0):			/* is 0-0 */
		    fp = tp + MK_DELTA(1,0);		/* source of T */
		    tp = tp - MK_DELTA(1,0);		/* destination */
		    goto L_00_000;
		 case MK_DELTA(-2,0):			/* is 0-0-0 */
		    fp = tp - MK_DELTA(2,0);		/* source of T */
		    tp = tp + MK_DELTA(1,0);		/* destination */
		 L_00_000:
		    n = fp->f_pos64;
		    ((PbUnit*)pkarr)[PB_64_inx(n)] &= ~PB_64_mask(n);
		    ZH_UPD(zhash, self, turm, n);
		    n = tp->f_pos64;
		    ((PbUnit*)pkarr)[PB_64_inx(n)] |=
			(PB_cf_val(self, turm) << PB_64_shift(n));
		    ZH_UPD(zhash, self, turm, n);
		    break;
		}
		break;
	     case bauer:
		switch( mp->m_to - mp->m_from ) {
		 case MK_DELTA(0, 2):
		 case MK_DELTA(0,-2):
		    *epp = mp->m_to;		/* enable e.p. of this one */
		    break;
		 case MK_DELTA( 1, 1):
		 case MK_DELTA( 1,-1):
		 case MK_DELTA(-1, 1):
		 case MK_DELTA(-1,-1):		/* beat e.p. */
		    tp -= bau_mov[self];
		    n = tp->f_pos64;
		    ((PbUnit*)pkarr)[PB_64_inx(n)] &= ~PB_64_mask(n);
		    ZH_UPD(zhash, opp_colour(self), bauer, n);
		    break;
		}
		break;
	    }
	}else {	/* ( tp->f_c != empty ) */		/* (Dbeat) */
	    /*
	     * Special here: replace someone, destroy castling by T-beat
	     */
	    if( castle[opp_colour(self)] && (tp->f_f == turm) ) {
		if( mp->m_to == trm_00[opp_colour(self)] ) {
		    castle[opp_colour(self)] &= ~castle00;
		}else if( mp->m_to == trm_000[opp_colour(self)] ) {
		    castle[opp_colour(self)] &= ~castle000;
		}
	    }
	    /* n = tp->f_pos64; */
	    ZH_UPD(zhash, opp_colour(self), tp->f_f, n);
	    {	    PbUnit	*q;
		q = &( ((PbUnit*)pkarr)[PB_64_inx(n)] );
		n = PB_64_shift(n);
		*q = (*q & ~PB_sh_mask(n)) | (PB_cf_val(self, mp->m_fig) << n);
	    }
	}
    }
    CHK_BOARD(bp);
    return zhash;
}
