/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/cnt.h,v $
 * $Id: cnt.h,v 3.3 1999/07/20 21:30:30 heiner Exp $
 *
 *	support profiling counters
 */

#ifndef CHEST_cnt_h_INCLUDED
#define CHEST_cnt_h_INCLUDED

#include "bastyp.h"

/*
 * WARNING: From "allchest.c" this will work with maximally one XX_FILE.
 *	    Since 1 file will work, we still provide this service.
 */
#define XX_FILE(f)	static char	XX__file_[] ={ f }

typedef struct XX__obj	XX__obj;

struct XX__obj
{
    unsigned long	XX__cnt;	/* the counter itself */
    char*		XX__name;	/* refers to filename */
    int			XX__num;	/* identifies this object */
    XX__obj*		XX__nxt;	/* list linkage */
};

Extern void	XX__note (XX__obj*);
Extern void	XX__dump (void);

#define XX(n)	{	static XX__obj xx__ ={ 0, XX__file_, n, 0};	\
		    if( xx__.XX__cnt == 0 ) XX__note(&xx__);		\
		    ++(xx__.XX__cnt);					\
		}

#endif	/* ndef CHEST_cnt_h_INCLUDED */
